/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.LambertMaterial;
import com.aspose.threed.Material;
import com.aspose.threed.MathUtils;
import com.aspose.threed.PbrMaterial;
import com.aspose.threed.PhongMaterial;
import com.aspose.threed.Struct;
import com.aspose.threed.TextureBase;
import com.aspose.threed.TextureSlot;
import com.aspose.threed.Vector3;
import java.util.ArrayList;

public class PbrSpecularMaterial
extends Material {
    public static final String MAP_SPECULAR_GLOSSINESS = "SpecularGlossiness";
    private double glossinessFactor;
    private Vector3 specular = new Vector3();
    private Vector3 diffuse = new Vector3();
    private Vector3 emissiveColor = new Vector3();

    public double getTransparency() {
        return this._transparencyFactor;
    }

    /*
     * WARNING - void declaration
     */
    public void setTransparency(double value) {
        void var1_1;
        this._transparencyFactor = MathUtils.clamp((double)var1_1, 0.0, 1.0);
    }

    public TextureBase getNormalTexture() {
        return this.getTexture("NormalMap");
    }

    /*
     * WARNING - void declaration
     */
    public void setNormalTexture(TextureBase value) {
        void var1_1;
        this.setTexture("NormalMap", (TextureBase)var1_1);
    }

    public TextureBase getSpecularGlossinessTexture() {
        return this.getTexture(MAP_SPECULAR_GLOSSINESS);
    }

    /*
     * WARNING - void declaration
     */
    public void setSpecularGlossinessTexture(TextureBase value) {
        void var1_1;
        this.setTexture(MAP_SPECULAR_GLOSSINESS, (TextureBase)var1_1);
    }

    public double getGlossinessFactor() {
        return this.glossinessFactor;
    }

    /*
     * WARNING - void declaration
     */
    public void setGlossinessFactor(double value) {
        void var1_1;
        this.glossinessFactor = var1_1;
    }

    public Vector3 getSpecular() {
        return Struct.byVal(this.specular);
    }

    /*
     * WARNING - void declaration
     */
    public void setSpecular(Vector3 value) {
        void var1_1;
        this.specular.copyFrom((Vector3)var1_1);
    }

    public TextureBase getDiffuseTexture() {
        return this.getTexture("DiffuseColor");
    }

    /*
     * WARNING - void declaration
     */
    public void setDiffuseTexture(TextureBase value) {
        void var1_1;
        this.setTexture("DiffuseColor", (TextureBase)var1_1);
    }

    public Vector3 getDiffuse() {
        return Struct.byVal(this.diffuse);
    }

    /*
     * WARNING - void declaration
     */
    public void setDiffuse(Vector3 value) {
        void var1_1;
        this.diffuse.copyFrom((Vector3)var1_1);
    }

    public TextureBase getEmissiveTexture() {
        return this.getTexture("EmissiveColor");
    }

    /*
     * WARNING - void declaration
     */
    public void setEmissiveTexture(TextureBase value) {
        void var1_1;
        this.setTexture("EmissiveColor", (TextureBase)var1_1);
    }

    public Vector3 getEmissiveColor() {
        return Struct.byVal(this.emissiveColor);
    }

    /*
     * WARNING - void declaration
     */
    public void setEmissiveColor(Vector3 value) {
        void var1_1;
        this.emissiveColor.copyFrom((Vector3)var1_1);
    }

    public PbrSpecularMaterial() {
        this.setSpecular(new Vector3(1.0, 1.0, 1.0));
        this.setDiffuse(new Vector3(1.0, 1.0, 1.0));
        this.shadingModel = "Pbr-Specular";
    }

    static PbrSpecularMaterial a(Material material) {
        Material material2;
        if (material == null) {
            return null;
        }
        PbrSpecularMaterial pbrSpecularMaterial = new PbrSpecularMaterial();
        new PbrSpecularMaterial().name = material.getName();
        pbrSpecularMaterial.culling = material.culling;
        if (material.textureSlots != null) {
            pbrSpecularMaterial.textureSlots = new ArrayList<TextureSlot>(material.textureSlots);
        }
        pbrSpecularMaterial._transparencyFactor = material._transparencyFactor;
        if (material instanceof LambertMaterial) {
            material2 = (LambertMaterial)material;
            pbrSpecularMaterial.setDiffuse(((LambertMaterial)material2).diffuse);
            pbrSpecularMaterial.setEmissiveColor(((LambertMaterial)material2).emissive);
        }
        if (material instanceof PhongMaterial) {
            material2 = (PhongMaterial)material;
            pbrSpecularMaterial.setSpecular(((PhongMaterial)material2).specular);
            pbrSpecularMaterial.setGlossinessFactor(((PhongMaterial)material2).getSpecularFactor());
            pbrSpecularMaterial.setEmissiveColor(((PhongMaterial)material2).emissive);
        }
        if (material instanceof PbrMaterial) {
            material2 = (PbrMaterial)material;
            pbrSpecularMaterial.setDiffuse(((PbrMaterial)material2).getAlbedo());
            pbrSpecularMaterial.setEmissiveColor(((PbrMaterial)material2).getEmissiveColor());
        }
        return pbrSpecularMaterial;
    }
}

