/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.Entity;
import com.aspose.threed.FileContentType;
import com.aspose.threed.FileFormat;
import com.aspose.threed.FileFormatType;
import com.aspose.threed.FileStream;
import com.aspose.threed.Geometry;
import com.aspose.threed.IMeshConvertible;
import com.aspose.threed.LoadOptions;
import com.aspose.threed.PlyLoadOptions;
import com.aspose.threed.PlySaveOptions;
import com.aspose.threed.PointCloud;
import com.aspose.threed.Stream;
import com.aspose.threed.Version;
import com.aspose.threed.mt;
import com.aspose.threed.mu;
import com.aspose.threed.qo;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;

public class PlyFormat
extends FileFormat {
    PlyFormat() {
        super(FileFormatType.PLY, new Version(1, 0), FileContentType.ASCII);
    }

    /*
     * WARNING - void declaration
     */
    public void encode(Entity entity, Stream stream) throws IOException {
        void var2_2;
        void var1_1;
        this.encode((Entity)var1_1, (Stream)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public void encode(Entity entity, Stream stream, PlySaveOptions opt) throws IOException {
        if (entity == null) {
            throw new IllegalArgumentException("Argument entity cannot be null");
        }
        if (stream == null) {
            throw new IllegalArgumentException("Argument stream cannot be null");
        }
        if (entity instanceof IMeshConvertible) {
            if ((entity = (IMeshConvertible)entity) == null) {
                throw new IllegalArgumentException("Argument mesh cannot be null");
            }
            if (stream == null) {
                throw new IllegalArgumentException("Argument stream cannot be null");
            }
            mt mt2 = new mt();
            entity = entity.toMesh();
            mt2.a((Geometry)entity, (Stream)new qo(stream), opt != null ? opt : new PlySaveOptions());
            return;
        }
        if (entity instanceof PointCloud) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (opt == null) {
                opt = new PlySaveOptions();
            }
            opt.setPointCloud(true);
            mt mt3 = new mt();
            mt3.a((Entity)var1_1, (Stream)new qo((Stream)var2_2), (PlySaveOptions)var3_3);
            return;
        }
        throw new IllegalStateException("Unsupported entity to encode");
    }

    /*
     * WARNING - void declaration
     */
    public void encode(Entity entity, String fileName) throws IOException {
        void var2_2;
        void var1_1;
        this.encode((Entity)var1_1, (String)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public void encode(Entity entity, String fileName, PlySaveOptions opt) throws IOException {
        FileStream fileStream;
        if (fileName == null || fileName.length() == 0) {
            throw new IllegalArgumentException("Invalid file name");
        }
        fileStream = new FileStream((String)((Object)fileStream), 0, 2);
        try {
            void var3_5;
            void var1_1;
            this.encode((Entity)var1_1, fileStream, (PlySaveOptions)var3_5);
            return;
        }
        finally {
            ((Stream)fileStream).close();
        }
    }

    /*
     * WARNING - void declaration
     */
    public Geometry decode(String fileName) throws IOException {
        void var1_1;
        return this.decode((String)var1_1, null);
    }

    public Geometry decode(String fileName, PlyLoadOptions opt) throws IOException {
        FileStream fileStream;
        if (fileName == null || fileName.length() == 0) {
            throw new IllegalArgumentException("Invalid file name");
        }
        if (!Files.exists(Paths.get(fileName, new String[0]), new LinkOption[0])) {
            throw new FileNotFoundException("Cannot find the specified ply file.");
        }
        fileStream = new FileStream((String)((Object)fileStream), 1, 1);
        try {
            Geometry geometry;
            geometry = this.decode(fileStream, (PlyLoadOptions)((Object)geometry));
            return geometry;
        }
        finally {
            ((Stream)fileStream).close();
        }
    }

    /*
     * WARNING - void declaration
     */
    public Geometry decode(Stream stream) throws IOException {
        void var1_1;
        return this.decode((Stream)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public Geometry decode(Stream stream, PlyLoadOptions opt) throws IOException {
        void var2_2;
        void var1_1;
        mu mu2 = new mu();
        return mu2.a((Stream)var1_1, (LoadOptions)var2_2);
    }
}

