/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.Entity;
import com.aspose.threed.FMatrix4;
import com.aspose.threed.IOrientable;
import com.aspose.threed.Node;
import com.aspose.threed.Quaternion;
import com.aspose.threed.RotationMode;
import com.aspose.threed.Struct;
import com.aspose.threed.Vector2;
import com.aspose.threed.Vector3;
import com.aspose.threed.Viewport;
import com.aspose.threed.qb;

public abstract class Frustum
extends Entity
implements IOrientable {
    private double nearPlane = 10.0;
    private double farPlane = 4000.0;
    private double aspect;
    private double orthoHeight;
    private Vector2 frustumOffset = new Vector2();
    private double focalLength;
    private FMatrix4 viewMatrix = new FMatrix4();
    private boolean viewMatrixDirty = true;
    boolean projectionDirty = true;
    private Vector3 position = new Vector3();
    private Vector3 up = new Vector3();
    private Vector3 lookAt = new Vector3();
    Vector3 direction = new Vector3();
    Node target;
    private RotationMode rotationMode = RotationMode.FIXED_TARGET;

    public RotationMode getRotationMode() {
        return this.rotationMode;
    }

    /*
     * WARNING - void declaration
     */
    public void setRotationMode(RotationMode value) {
        void var1_1;
        this.rotationMode = var1_1;
    }

    public double getNearPlane() {
        return this.nearPlane;
    }

    /*
     * WARNING - void declaration
     */
    public void setNearPlane(double value) {
        void var1_1;
        this.nearPlane = var1_1;
        this.projectionDirty = true;
    }

    public double getFarPlane() {
        return this.farPlane;
    }

    /*
     * WARNING - void declaration
     */
    public void setFarPlane(double value) {
        void var1_1;
        this.farPlane = var1_1;
        this.projectionDirty = true;
    }

    public double getAspect() {
        return this.aspect;
    }

    /*
     * WARNING - void declaration
     */
    public void setAspect(double value) {
        void var1_1;
        this.aspect = var1_1;
    }

    public double getOrthoHeight() {
        return this.orthoHeight;
    }

    /*
     * WARNING - void declaration
     */
    public void setOrthoHeight(double value) {
        void var1_1;
        this.orthoHeight = var1_1;
    }

    final double e() {
        return this.focalLength;
    }

    final void a(double d2) {
        this.focalLength = d2;
    }

    final Vector3 f() {
        return Struct.byVal(this.position);
    }

    final void a(Vector3 vector3) {
        this.position.copyFrom(vector3);
        this.viewMatrixDirty = true;
    }

    public Vector3 getUp() {
        return Struct.byVal(this.up);
    }

    /*
     * WARNING - void declaration
     */
    public void setUp(Vector3 value) {
        void var1_1;
        this.up.copyFrom((Vector3)var1_1);
        this.viewMatrixDirty = true;
    }

    public Vector3 getLookAt() {
        if (this.getRotationMode() == RotationMode.FIXED_TARGET) {
            return Struct.byVal(this.lookAt);
        }
        return Vector3.add(this.g(), this.direction);
    }

    /*
     * WARNING - void declaration
     */
    public void setLookAt(Vector3 value) {
        void var1_1;
        this.lookAt.copyFrom(value);
        this.direction.copyFrom(Vector3.sub((Vector3)var1_1, this.g()).normalize());
        this.viewMatrixDirty = true;
    }

    @Override
    public Vector3 getDirection() {
        if (this.target == null && this.getRotationMode() == RotationMode.FIXED_DIRECTION) {
            return Struct.byVal(this.direction);
        }
        Vector3 vector3 = Struct.byVal(this.lookAt);
        if (this.target != null) {
            vector3.copyFrom(this.target.getGlobalTransform().getTranslation());
        }
        Vector3 vector32 = this.g();
        vector3 = Vector3.sub(vector3, vector32).normalize();
        return vector3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setDirection(Vector3 value) {
        this.direction.copyFrom(value);
        this.lookAt.copyFrom(Vector3.add(this.position, value));
        if (this.target != null) {
            void var1_1;
            this.target.getTransform().setTranslation(Vector3.add(this.g(), (Vector3)var1_1));
        }
        this.viewMatrixDirty = true;
    }

    @Override
    public Node getTarget() {
        return this.target;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setTarget(Node value) {
        void var1_1;
        this.target = var1_1;
        this.viewMatrixDirty = true;
    }

    Frustum(String name) {
        super((String)((Object)frustum));
        Frustum frustum;
        frustum = this;
        try {
            frustum.up = new Vector3(0.0, 1.0, 0.0);
            frustum.direction = new Vector3(1.0, 0.0, 0.0);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        this.setAspect(1.0);
        this.features = 1;
    }

    final Vector3 g() {
        Node node = this.getParentNode();
        if (node == null) {
            return this.f();
        }
        return node.getGlobalTransform().getTranslation();
    }

    @Override
    final void d() {
        this.viewMatrixDirty = true;
    }

    final FMatrix4 h() {
        if (this.viewMatrixDirty) {
            Frustum frustum = this;
            if (frustum.viewMatrixDirty) {
                Object object = frustum.getParentNode();
                if (object == null) {
                    throw new IllegalStateException("Camera is not attached to any node.");
                }
                object = frustum.g();
                Vector3 vector3 = frustum.getDirection();
                if (frustum.getParentNode() != null) {
                    vector3.copyFrom(Quaternion.mul(frustum.getParentNode().getGlobalTransform().getRotation(), vector3));
                }
                vector3 = Vector3.add((Vector3)object, vector3);
                frustum.viewMatrix.copyFrom(new FMatrix4(qb.a((Vector3)object, vector3, frustum.up)));
                frustum.viewMatrixDirty = false;
            }
        }
        return Struct.byVal(this.viewMatrix);
    }

    abstract FMatrix4 a(Viewport var1);
}

