/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.BoundingBox;
import com.aspose.threed.FVector3;
import com.aspose.threed.MappingMode;
import com.aspose.threed.Matrix4;
import com.aspose.threed.Mesh;
import com.aspose.threed.Primitive;
import com.aspose.threed.ReferenceMode;
import com.aspose.threed.Vector3;
import com.aspose.threed.Vector4;
import com.aspose.threed.VertexElementNormal;
import com.aspose.threed.VertexElementType;
import com.aspose.threed.kF;

public class RectangularTorus
extends Primitive {
    private double innerRadius;
    private double outerRadius;
    private double height;
    private double arc;
    private double angleStart;
    private int radialSegments;

    public double getInnerRadius() {
        return this.innerRadius;
    }

    /*
     * WARNING - void declaration
     */
    public void setInnerRadius(double value) {
        void var1_1;
        this.innerRadius = var1_1;
    }

    public double getOuterRadius() {
        return this.outerRadius;
    }

    /*
     * WARNING - void declaration
     */
    public void setOuterRadius(double value) {
        void var1_1;
        this.outerRadius = var1_1;
    }

    public double getHeight() {
        return this.height;
    }

    /*
     * WARNING - void declaration
     */
    public void setHeight(double value) {
        void var1_1;
        this.height = var1_1;
    }

    public double getArc() {
        return this.arc;
    }

    /*
     * WARNING - void declaration
     */
    public void setArc(double value) {
        void var1_1;
        this.arc = var1_1;
    }

    public double getAngleStart() {
        return this.angleStart;
    }

    /*
     * WARNING - void declaration
     */
    public void setAngleStart(double value) {
        void var1_1;
        this.angleStart = var1_1;
    }

    public int getRadialSegments() {
        return this.radialSegments;
    }

    /*
     * WARNING - void declaration
     */
    public void setRadialSegments(int value) {
        void var1_1;
        this.radialSegments = var1_1;
    }

    public RectangularTorus() {
        this("");
    }

    /*
     * WARNING - void declaration
     */
    private RectangularTorus(String name) {
        super((String)var1_1);
        void var1_1;
        this.setRadialSegments(10);
        this.setAngleStart(0.0);
        this.setArc(Math.PI);
        this.setInnerRadius(17.0);
        this.setOuterRadius(20.0);
        this.setHeight(20.0);
    }

    @Override
    final BoundingBox a(Matrix4 matrix4) {
        double d2 = this.getHeight() * 0.5;
        double d3 = Math.max(this.getInnerRadius(), this.getOuterRadius());
        int n2 = this.getRadialSegments() + 1;
        double d4 = 1.0 / (double)this.getRadialSegments();
        boolean bl2 = matrix4.b();
        BoundingBox boundingBox = new BoundingBox();
        for (int i2 = 0; i2 < n2; ++i2) {
            double d5 = (double)i2 * d4 * this.getArc() + this.getAngleStart();
            double d6 = Math.cos(d5);
            double d7 = Math.sin(d5);
            if (bl2) {
                boundingBox.merge(d6 * d3, d2, d7 * d3);
                boundingBox.merge(d6 * d3, -d2, d7 * d3);
                continue;
            }
            boundingBox.merge(Matrix4.mul(matrix4, new Vector4(d6 * d3, d2, d7 * d3, 1.0)));
            boundingBox.merge(Matrix4.mul(matrix4, new Vector4(d6 * d3, -d2, d7 * d3, 1.0)));
        }
        return boundingBox;
    }

    @Override
    public Mesh toMesh() {
        int n2;
        int n3;
        Mesh mesh = this.b();
        if (this.getRadialSegments() <= 0) {
            return mesh;
        }
        int n4 = this.getRadialSegments() + 1;
        int n5 = n4 << 1 << 1;
        Vector4[] vector4Array = (Vector4[])kF.b.a(n5);
        FVector3[] fVector3Array = (FVector3[])kF.c.a((n4 << 1) + 4);
        float f2 = 1.0f / (float)this.getRadialSegments();
        int n6 = 0;
        int n7 = 0;
        float f3 = (float)(this.getHeight() * 0.5);
        float f4 = (float)this.getInnerRadius();
        float f5 = (float)this.getOuterRadius();
        for (n3 = 0; n3 < n4; ++n3) {
            float f6 = (float)((double)((float)n3 * f2) * this.getArc() + this.getAngleStart());
            float f7 = (float)Math.cos(f6);
            float f8 = (float)Math.sin(f6);
            fVector3Array[n6++] = new FVector3(-f7, 0.0f, -f8);
            fVector3Array[n6++] = new FVector3(f7, 0.0f, f8);
            vector4Array[n7++] = new Vector4(f7 * f4, f3, f8 * f4);
            vector4Array[n7++] = new Vector4(f7 * f4, -f3, f8 * f4);
            vector4Array[n7++] = new Vector4(f7 * f5, f3, f8 * f5);
            vector4Array[n7++] = new Vector4(f7 * f5, -f3, f8 * f5);
        }
        fVector3Array[n6] = new FVector3(0.0f, 1.0f, 0.0f);
        fVector3Array[n6 + 1] = new FVector3(0.0f, -1.0f, 0.0f);
        fVector3Array[n6 + 2] = RectangularTorus.a(vector4Array, 0, 2, 3);
        n3 = this.getRadialSegments() << 2;
        fVector3Array[n6 + 3] = RectangularTorus.a(vector4Array, n3, n3 + 1, n3 + 3);
        mesh.controlPoints.a(vector4Array);
        VertexElementNormal vertexElementNormal = (VertexElementNormal)mesh.createElement(VertexElementType.NORMAL, MappingMode.POLYGON_VERTEX, ReferenceMode.INDEX_TO_DIRECT);
        vertexElementNormal.h.a(fVector3Array);
        for (n2 = 0; n2 < this.getRadialSegments(); ++n2) {
            int n8 = n2 << 2;
            int n9 = n2 + 1 << 2;
            n4 = n2 << 1;
            int n10 = n8;
            mesh.createPolygon(n10, n10 + 1, n9 + 1, n9);
            int n11 = n4;
            vertexElementNormal.g.a(n11, n11, n4 + 2, n4 + 2);
            int n12 = n9 += 2;
            mesh.createPolygon(n8 += 2, n12, n12 + 1, n8 + 1);
            vertexElementNormal.g.a(n4 + 1, n4 + 3, n4 + 3, n4 + 1);
            int n13 = n8 = n2 << 2;
            mesh.createPolygon(n13, n13 + 4, n8 + 6, n8 + 2);
            int n14 = n6;
            int n15 = n6;
            vertexElementNormal.g.a(n14, n14, n15, n15);
            int n16 = ++n8;
            mesh.createPolygon(n16, n16 + 2, n8 + 6, n8 + 4);
            vertexElementNormal.g.a(n6 + 1, n6 + 1, n6 + 1, n6 + 1);
        }
        mesh.createPolygon(0, 2, 3, 1);
        vertexElementNormal.g.a(n6 + 2, n6 + 2, n6 + 2, n6 + 2);
        int n17 = n2 = this.getRadialSegments() << 2;
        mesh.createPolygon(n17, n17 + 1, n2 + 3, n2 + 2);
        vertexElementNormal.g.a(n6 + 3, n6 + 3, n6 + 3, n6 + 3);
        return mesh;
    }

    private static FVector3 a(Vector4[] object, int n2, int n3, int n4) {
        Vector3 vector3 = new Vector3(Vector4.sub(object[n2], object[n3]));
        object = new Vector3(Vector4.sub(object[n4], object[n3]));
        object = object.cross(vector3).normalize();
        return new FVector3((Vector3)object);
    }
}

