/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.BoundingBox;
import com.aspose.threed.FVector2;
import com.aspose.threed.FVector3;
import com.aspose.threed.Matrix4;
import com.aspose.threed.Mesh;
import com.aspose.threed.Primitive;
import com.aspose.threed.Vector3;
import com.aspose.threed.Vector4;
import com.aspose.threed.kF;

public class Sphere
extends Primitive {
    private double radius;
    private int widthSegments;
    private int heightSegments;
    private double phiStart;
    private double phiLength;
    private double thetaStart;
    private double thetaLength;

    public Sphere() {
        this(1.0);
    }

    /*
     * WARNING - void declaration
     */
    public Sphere(double radius) {
        this((double)var1_1, 12, 8);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Sphere(double radius, int widthSegments, int heightSegments) {
        this("", (double)var1_1, 12, 8, 0.0, Math.PI * 2, 0.0, Math.PI);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Sphere(String name, double radius, int widthSegments, int heightSegments, double phiStart, double phiLength, double thetaStart, double thetaLength) {
        super((String)var1_1);
        void var2_2;
        void var1_1;
        this.radius = var2_2;
        this.setWidthSegments(widthSegments);
        this.setHeightSegments(heightSegments);
        this.phiStart = 0.0;
        this.phiLength = Math.PI * 2;
        this.thetaStart = 0.0;
        this.thetaLength = Math.PI;
    }

    public int getWidthSegments() {
        return this.widthSegments;
    }

    /*
     * WARNING - void declaration
     */
    public void setWidthSegments(int value) {
        void var1_1;
        this.widthSegments = Math.max(3, (int)var1_1);
    }

    public int getHeightSegments() {
        return this.heightSegments;
    }

    /*
     * WARNING - void declaration
     */
    public void setHeightSegments(int value) {
        void var1_1;
        this.heightSegments = Math.max(2, (int)var1_1);
    }

    public double getPhiStart() {
        return this.phiStart;
    }

    /*
     * WARNING - void declaration
     */
    public void setPhiStart(double value) {
        void var1_1;
        this.phiStart = var1_1;
    }

    public double getPhiLength() {
        return this.phiLength;
    }

    /*
     * WARNING - void declaration
     */
    public void setPhiLength(double value) {
        void var1_1;
        this.phiLength = var1_1;
    }

    public double getThetaStart() {
        return this.thetaStart;
    }

    /*
     * WARNING - void declaration
     */
    public void setThetaStart(double value) {
        void var1_1;
        this.thetaStart = var1_1;
    }

    public double getThetaLength() {
        return this.thetaLength;
    }

    /*
     * WARNING - void declaration
     */
    public void setThetaLength(double value) {
        void var1_1;
        this.thetaLength = var1_1;
    }

    public double getRadius() {
        return this.radius;
    }

    /*
     * WARNING - void declaration
     */
    public void setRadius(double value) {
        void var1_1;
        this.radius = var1_1;
    }

    @Override
    final BoundingBox a(Matrix4 matrix4) {
        double d2 = this.radius;
        BoundingBox boundingBox = new BoundingBox();
        boundingBox.merge(Matrix4.mul(matrix4, new Vector3(0.0, 0.0, d2)));
        boundingBox.merge(Matrix4.mul(matrix4, new Vector3(0.0, 0.0, -d2)));
        boundingBox.merge(Matrix4.mul(matrix4, new Vector3(0.0, d2, 0.0)));
        boundingBox.merge(Matrix4.mul(matrix4, new Vector3(0.0, -d2, 0.0)));
        boundingBox.merge(Matrix4.mul(matrix4, new Vector3(d2, 0.0, 0.0)));
        boundingBox.merge(Matrix4.mul(matrix4, new Vector3(-d2, 0.0, 0.0)));
        return boundingBox;
    }

    @Override
    public Mesh toMesh() {
        int n2;
        int n3;
        Mesh mesh = this.b();
        if (this.widthSegments <= 1 || this.heightSegments <= 1) {
            return mesh;
        }
        int n4 = (this.widthSegments + 1) * (this.heightSegments + 1);
        Vector4[] vector4Array = (Vector4[])kF.b.a(n4);
        FVector3[] fVector3Array = (FVector3[])kF.c.a(n4);
        FVector2[] fVector2Array = (FVector2[])kF.d.a(n4);
        int n5 = 0;
        float f2 = (float)this.radius;
        float f3 = (float)this.thetaStart;
        float f4 = (float)this.thetaLength;
        float f5 = (float)this.phiLength;
        float f6 = (float)this.phiStart;
        float f7 = f3 + f4;
        int[][] nArrayArray = new int[this.heightSegments + 1][];
        for (n3 = 0; n3 <= this.heightSegments; ++n3) {
            int[] nArray = new int[this.widthSegments + 1];
            float f8 = 1.0f * (float)n3 / (float)this.heightSegments;
            for (n2 = 0; n2 <= this.widthSegments; ++n2) {
                float f9 = 1.0f * (float)n2 / (float)this.widthSegments;
                float f10 = -f2 * (float)Math.cos(f6 + f9 * f5) * (float)Math.sin(f3 + f8 * f4);
                float f11 = f2 * (float)Math.cos(f3 + f8 * f4);
                float f12 = f2 * (float)Math.sin(f6 + f9 * f5) * (float)Math.sin(f3 + f8 * f4);
                vector4Array[n5] = new Vector4(f10, f11, f12, 1.0);
                fVector3Array[n5] = new FVector3(f10, f11, f12).normalize();
                fVector2Array[n5] = new FVector2(f9, 1.0f - f8);
                nArray[n2] = n5++;
            }
            nArrayArray[n3] = nArray;
        }
        for (n3 = 0; n3 < this.heightSegments; ++n3) {
            for (int i2 = 0; i2 < this.widthSegments; ++i2) {
                boolean bl2;
                int n6 = nArrayArray[n3][i2 + 1];
                n2 = nArrayArray[n3][i2];
                int n7 = nArrayArray[n3 + 1][i2];
                int n8 = nArrayArray[n3 + 1][i2 + 1];
                boolean bl3 = n3 != 0 || f3 > 0.0f;
                boolean bl4 = bl2 = n3 != this.heightSegments - 1 || (double)f7 < Math.PI;
                if (bl3 && bl2) {
                    mesh.createPolygon(n6, n2, n7, n8);
                    continue;
                }
                if (bl3) {
                    mesh.createPolygon(n6, n2, n8);
                    continue;
                }
                if (!bl2) continue;
                mesh.createPolygon(n2, n7, n8);
            }
        }
        Primitive.a(mesh, vector4Array, fVector3Array, fVector2Array);
        return mesh;
    }
}

