/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.C;
import com.aspose.threed.ITextureCodec;
import com.aspose.threed.ITextureDecoder;
import com.aspose.threed.ITextureEncoder;
import com.aspose.threed.JavaXImageCodec;
import com.aspose.threed.Stream;
import com.aspose.threed.TextureData;
import com.aspose.threed.p;
import com.aspose.threed.pE;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;

public class TextureCodec {
    private static final ArrayList<ITextureDecoder> a = new ArrayList();
    private static final HashMap<String, ITextureEncoder> b = new HashMap();

    public static String[] getSupportedEncoderFormats() {
        Set<String> set = b.keySet();
        return set.toArray(new String[set.size()]);
    }

    public static void registerCodec(ITextureCodec codec) {
        ITextureEncoder[] iTextureEncoderArray;
        p.a(codec);
        ITextureDecoder[] iTextureDecoderArray = codec.getDecoders();
        iTextureEncoderArray = iTextureEncoderArray.getEncoders();
        if (iTextureDecoderArray != null && iTextureDecoderArray.length > 0) {
            a.addAll(Arrays.asList(iTextureDecoderArray));
        }
        if (iTextureEncoderArray != null && iTextureEncoderArray.length > 0) {
            for (ITextureEncoder iTextureEncoder : iTextureEncoderArray) {
                String string = iTextureEncoder.getFileExtension();
                if (string != null && string.length() > 0 && string.charAt(0) == '.') {
                    string = string.substring(1);
                }
                if (string == null || string.length() == 0) {
                    throw new IllegalStateException("File extension in texture encoder cannot be empty.");
                }
                b.put(string.toLowerCase(), iTextureEncoder);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void encode(TextureData texture, Stream stream, String format) {
        try {
            void var1_1;
            TextureData textureData;
            ITextureEncoder iTextureEncoder;
            ITextureEncoder[] iTextureEncoderArray = new ITextureEncoder[1];
            p.a((Object)texture);
            p.a(stream);
            p.a((Object)format);
            if (format.startsWith(".")) {
                format = format.substring(1);
            }
            if (!C.a(b, format, iTextureEncoderArray)) {
                throw new UnsupportedOperationException("Unsupported texture encoder " + (String)((Object)iTextureEncoder));
            }
            iTextureEncoder = iTextureEncoderArray[0];
            iTextureEncoder.encode(textureData, (Stream)var1_1);
            return;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static TextureData decode(Stream stream, boolean reverseY) {
        for (int i2 = 0; i2 < a.size(); ++i2) {
            try {
                stream.seek(0L, 0);
                TextureData textureData = a.get(i2).decode(stream, reverseY);
                if (textureData == null) continue;
                return textureData;
            }
            catch (Exception exception) {
                System.out.println("TextureData.Decode:" + exception.toString());
            }
        }
        return null;
    }

    static {
        TextureCodec.registerCodec(new pE());
        TextureCodec.registerCodec(new JavaXImageCodec());
    }
}

