/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.A3DObject;
import com.aspose.threed.C;
import com.aspose.threed.FileStream;
import com.aspose.threed.PixelFormat;
import com.aspose.threed.PixelMapMode;
import com.aspose.threed.PixelMapping;
import com.aspose.threed.Rect;
import com.aspose.threed.Stream;
import com.aspose.threed.TextureCodec;
import java.io.IOException;

public class TextureData
extends A3DObject {
    byte[] data;
    int width;
    int height;
    int stride;
    int bytesPerPixel;
    PixelFormat pixelFormat;
    private static final byte[] LAYOUT_A8 = new byte[]{2};
    private static final byte[] LAYOUT_L8 = new byte[]{1};
    private static final byte[] LAYOUT_R8 = new byte[]{3};
    private static final byte[] LAYOUT_G8 = new byte[]{4};
    private static final byte[] LAYOUT_B8 = new byte[]{5};
    private static final byte[] LAYOUT_R8G8B8 = new byte[]{3, 4, 5};
    private static final byte[] LAYOUT_B8G8R8 = new byte[]{5, 4, 3};
    private static final byte[] LAYOUT_A8R8G8B8 = new byte[]{2, 3, 4, 5};
    private static final byte[] LAYOUT_A8B8G8R8 = new byte[]{2, 5, 4, 3};
    private static final byte[] LAYOUT_B8G8R8A8 = new byte[]{5, 4, 3, 2};
    private static final byte[] LAYOUT_R8G8B8A8 = new byte[]{3, 4, 5, 2};
    private static final byte[] LAYOUT_X8B8G8R8 = new byte[]{6, 5, 4, 3};
    private static final byte[] LAYOUT_X8R8G8B8 = new byte[]{6, 3, 4, 5};

    public byte[] getData() {
        return this.data;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getStride() {
        return this.stride;
    }

    public int getBytesPerPixel() {
        return this.bytesPerPixel;
    }

    public PixelFormat getPixelFormat() {
        return this.pixelFormat;
    }

    /*
     * WARNING - void declaration
     */
    public TextureData(int width, int height, int stride, int bytesPerPixel, PixelFormat pixelFormat, byte[] data) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.width = var1_1;
        this.height = var2_2;
        this.stride = var3_3;
        this.bytesPerPixel = 4;
        this.pixelFormat = pixelFormat;
        this.data = data;
    }

    /*
     * WARNING - void declaration
     */
    TextureData(int width, int height, int stride, int bytesPerPixel, PixelFormat pixelFormat) {
        void var2_2;
        void var3_3;
        void var1_1;
        this.width = var1_1;
        this.height = height;
        this.stride = stride;
        this.bytesPerPixel = bytesPerPixel;
        this.pixelFormat = pixelFormat;
        this.data = new byte[var3_3 * var2_2];
    }

    /*
     * WARNING - void declaration
     */
    public TextureData(int width, int height, PixelFormat pixelFormat) {
        void var2_2;
        void var1_1;
        int n2;
        void var3_3;
        this.width = width;
        this.height = height;
        this.pixelFormat = pixelFormat;
        switch (1.a[var3_3.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 1;
                break;
            }
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 4;
                break;
            }
            case 14: {
                n2 = 4;
                break;
            }
            case 15: {
                n2 = 2;
                break;
            }
            case 16: {
                n2 = 6;
                break;
            }
            case 17: {
                n2 = 8;
                break;
            }
            case 18: {
                n2 = 8;
                break;
            }
            case 19: {
                n2 = 4;
                break;
            }
            case 20: {
                n2 = 12;
                break;
            }
            case 21: {
                n2 = 16;
                break;
            }
            case 22: {
                n2 = 2;
                break;
            }
            case 23: 
            case 24: {
                n2 = 4;
                break;
            }
            case 25: {
                n2 = 1;
                break;
            }
            case 26: {
                n2 = 2;
                break;
            }
            case 27: {
                n2 = 2;
                break;
            }
            case 28: {
                n2 = 2;
                break;
            }
            case 29: {
                n2 = 16;
                break;
            }
            case 30: {
                n2 = 8;
                break;
            }
            case 31: {
                n2 = 4;
                break;
            }
            case 32: {
                n2 = 1;
                break;
            }
            case 33: {
                n2 = 2;
                break;
            }
            case 34: {
                n2 = 4;
                break;
            }
            case 35: {
                n2 = 6;
                break;
            }
            case 36: {
                n2 = 8;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported pixel format");
            }
        }
        this.bytesPerPixel = n2;
        this.stride = this.bytesPerPixel * var1_1;
        this.data = new byte[this.stride * var2_2];
    }

    public TextureData() {
    }

    static byte[] a(PixelFormat pixelFormat) {
        switch (pixelFormat) {
            case A8: {
                return LAYOUT_A8;
            }
            case L8: {
                return LAYOUT_L8;
            }
            case R8: {
                return LAYOUT_R8;
            }
            case G8: {
                return LAYOUT_G8;
            }
            case B8: {
                return LAYOUT_B8;
            }
            case R8G8B8: {
                return LAYOUT_R8G8B8;
            }
            case B8G8R8: {
                return LAYOUT_B8G8R8;
            }
            case A8R8G8B8: {
                return LAYOUT_A8R8G8B8;
            }
            case A8B8G8R8: {
                return LAYOUT_A8B8G8R8;
            }
            case B8G8R8A8: {
                return LAYOUT_B8G8R8A8;
            }
            case R8G8B8A8: {
                return LAYOUT_R8G8B8A8;
            }
            case X8B8G8R8: {
                return LAYOUT_X8B8G8R8;
            }
            case X8R8G8B8: {
                return LAYOUT_X8R8G8B8;
            }
        }
        return null;
    }

    public static TextureData fromStream(Stream stream) {
        return TextureCodec.decode(stream, true);
    }

    public static TextureData fromFile(String fileName) throws IOException {
        return TextureData.a(fileName, true);
    }

    static TextureData a(String object, boolean bl2) throws IOException {
        object = new FileStream((String)object, 1, 1);
        try {
            TextureData textureData = TextureCodec.decode((Stream)object, bl2);
            return textureData;
        }
        finally {
            ((Stream)object).close();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void save(Stream stream, String format) {
        void var2_2;
        void var1_1;
        TextureCodec.encode(this, (Stream)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void save(String fileName) throws IOException {
        void var1_1;
        String string = C.a(fileName);
        if (string == null || string.length() == 0) {
            throw new IllegalStateException();
        }
        this.save((String)var1_1, string.substring(1));
    }

    /*
     * WARNING - void declaration
     */
    public void save(String fileName, String format) throws IOException {
        FileStream fileStream;
        fileStream = new FileStream((String)((Object)fileStream), 0);
        try {
            void var2_3;
            this.save(fileStream, (String)var2_3);
            return;
        }
        finally {
            fileStream.close();
        }
    }

    final void b() {
        TextureData textureData = this;
        int n2 = this.height;
        int n3 = this.stride;
        byte[] byArray = textureData.data;
        byte[] byArray2 = new byte[textureData.data.length];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = n2 - i2 - 1;
            int n5 = i2 * n3;
            System.arraycopy(byArray, n5, byArray2, n4 *= n3, n3);
        }
        textureData.data = byArray2;
    }

    static void c() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    public PixelMapping mapPixels(PixelMapMode mapMode) {
        void var1_1;
        return this.mapPixels((PixelMapMode)var1_1, this.getPixelFormat());
    }

    /*
     * WARNING - void declaration
     */
    public PixelMapping mapPixels(PixelMapMode mapMode, PixelFormat format) {
        void var2_2;
        void var1_1;
        Rect rect = new Rect(0, 0, this.getWidth(), this.getHeight());
        return this.mapPixels(rect, (PixelMapMode)var1_1, (PixelFormat)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public PixelMapping mapPixels(Rect rect, PixelMapMode mapMode, PixelFormat format) {
        void var2_2;
        void var3_3;
        void var1_1;
        byte[] byArray = TextureData.a(this.getPixelFormat());
        byte[] byArray2 = TextureData.a(format);
        if (byArray == null) {
            throw new UnsupportedOperationException("Unsupported source pixel layout to map");
        }
        if (byArray2 == null) {
            throw new UnsupportedOperationException("Unsupported destination pixel layout to map");
        }
        int n2 = byArray2.length * rect.getWidth();
        byte[] byArray3 = new byte[n2 * rect.getHeight()];
        if (mapMode == PixelMapMode.READ_ONLY || mapMode == PixelMapMode.READ_WRITE) {
            if (byArray3.length == this.data.length && this.getPixelFormat() == format) {
                System.arraycopy(this.data, 0, byArray3, 0, byArray3.length);
            } else {
                int n3 = this.stride * rect.getY() + rect.getX() * this.bytesPerPixel;
                TextureData.a(byArray, this.data, n3, this.stride, byArray2, byArray3, 0, n2, rect.getWidth(), rect.getHeight());
            }
        }
        return new PixelMapping(this, (Rect)var1_1, (PixelFormat)var3_3, n2, byArray3, (PixelMapMode)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void transformPixelFormat(PixelFormat pixelFormat) {
        void var1_1;
        if (pixelFormat == this.getPixelFormat()) {
            return;
        }
        byte[] byArray = TextureData.a(this.getPixelFormat());
        if (byArray == null) {
            throw new UnsupportedOperationException("Unsupported source pixel format");
        }
        byte[] byArray2 = TextureData.a(pixelFormat);
        if (byArray2 == null) {
            throw new UnsupportedOperationException("Unsupported destination pixel format");
        }
        byte[] byArray3 = new byte[this.data.length];
        int n2 = byArray.length * this.getWidth();
        int n3 = byArray2.length * this.getWidth();
        TextureData.a(byArray, this.data, 0, n2, byArray2, byArray3, 0, n3, this.getWidth(), this.getHeight());
        this.data = byArray3;
        this.pixelFormat = var1_1;
    }

    static void a(byte[] byArray, byte[] byArray2, int n2, int n3, byte[] byArray3, byte[] byArray4, int n4, int n5, int n6, int n7) {
        byte[] byArray5 = new byte[10];
        byte[] byArray6 = byArray5;
        byArray5[2] = -1;
        for (int i2 = 0; i2 < n7; ++i2) {
            int n8 = n2 + i2 * n3;
            int n9 = n4 + i2 * n5;
            for (int i3 = 0; i3 < n6; ++i3) {
                int n10;
                for (n10 = 0; n10 < byArray.length; ++n10) {
                    byArray6[0xFF & byArray[n10]] = byArray2[n8++];
                }
                for (n10 = 0; n10 < byArray3.length; ++n10) {
                    byArray4[n9++] = byArray6[0xFF & byArray3[n10]];
                }
            }
        }
    }
}

