/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.BoundingBoxExtent;
import com.aspose.threed.Geometry;
import com.aspose.threed.Matrix4;
import com.aspose.threed.Struct;
import com.aspose.threed.Vector3;
import com.aspose.threed.Vector4;
import com.aspose.threed.pt;
import com.aspose.threed.rt;
import java.io.Serializable;

public final class BoundingBox
implements Struct<BoundingBox>,
Serializable {
    private Vector3 a = new Vector3();
    private Vector3 b = new Vector3();
    private BoundingBoxExtent c;
    static final long serialVersionUID = 1598360694L;

    public static BoundingBox getNull() {
        return new BoundingBox(BoundingBoxExtent.NULL);
    }

    public static BoundingBox getInfinite() {
        return new BoundingBox(BoundingBoxExtent.INFINITE);
    }

    public final BoundingBoxExtent getExtent() {
        return this.c;
    }

    public final Vector3 getMinimum() {
        return Struct.byVal(this.a);
    }

    public final Vector3 getMaximum() {
        return Struct.byVal(this.b);
    }

    public final double scale() {
        double d2 = Math.abs(this.a.x);
        double d3 = Math.abs(this.a.y);
        double d4 = Math.abs(this.a.z);
        double d5 = Math.abs(this.b.x);
        double d6 = Math.abs(this.b.y);
        double d7 = Math.abs(this.b.z);
        double d8 = Math.max(Math.max(d2, d3), d4);
        double d9 = Math.max(Math.max(d5, d6), d7);
        return Math.max(d8, d9);
    }

    public final Vector3 getSize() {
        double d2 = this.b.x - this.a.x;
        double d3 = this.b.y - this.a.y;
        double d4 = this.b.z - this.a.z;
        return new Vector3(Math.abs(d2), Math.abs(d3), Math.abs(d4));
    }

    public final Vector3 getCenter() {
        return Vector3.add(this.a, Vector3.mul(Vector3.sub(this.b, this.a), 0.5));
    }

    /*
     * WARNING - void declaration
     */
    private BoundingBox(BoundingBoxExtent extent) {
        void var1_1;
        pt.e(this.a);
        pt.f(this.b);
        this.c = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public BoundingBox(Vector3 minimum, Vector3 maximum) {
        void var2_2;
        void var1_1;
        this.a.copyFrom(new Vector3(Math.min(minimum.x, maximum.x), Math.min(minimum.y, maximum.y), Math.min(minimum.z, maximum.z)));
        this.b.copyFrom(new Vector3(Math.max(minimum.x, maximum.x), Math.max(minimum.y, maximum.y), Math.max(var1_1.z, var2_2.z)));
        this.c = BoundingBoxExtent.FINITE;
    }

    /*
     * WARNING - void declaration
     */
    public BoundingBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this(new Vector3((double)var1_1, (double)var3_2, minZ), new Vector3(maxX, maxY, maxZ));
        void var3_2;
        void var1_1;
    }

    public static BoundingBox fromGeometry(Geometry geometry) {
        BoundingBox boundingBox = BoundingBox.a(geometry.controlPoints);
        return boundingBox;
    }

    static BoundingBox a(Geometry object, Matrix4 matrix4) {
        object = BoundingBox.a(((Geometry)object).controlPoints, matrix4);
        return object;
    }

    static BoundingBox a(rt rt2, Matrix4 matrix4) {
        if (rt2 == null || rt2.b == 0) {
            return BoundingBox.getNull();
        }
        if (matrix4.b()) {
            return BoundingBox.a(rt2);
        }
        Vector3 vector3 = new Vector3();
        Vector3 vector32 = new Vector3();
        Vector3 vector33 = new Vector3(Matrix4.mul(matrix4, rt2.b(0)));
        vector32.copyFrom(vector33);
        vector3.copyFrom(vector33);
        for (int i2 = 1; i2 < rt2.b; ++i2) {
            Vector4 vector4 = Matrix4.mul(matrix4, rt2.b(i2));
            vector3.x = Math.max(vector4.x, vector3.x);
            vector3.y = Math.max(vector4.y, vector3.y);
            vector3.z = Math.max(vector4.z, vector3.z);
            vector32.x = Math.min(vector4.x, vector32.x);
            vector32.y = Math.min(vector4.y, vector32.y);
            vector32.z = Math.min(vector4.z, vector32.z);
        }
        return new BoundingBox(vector32, vector3);
    }

    static BoundingBox a(rt rt2) {
        if (rt2 == null || rt2.b == 0) {
            return BoundingBox.getNull();
        }
        Vector3 vector3 = new Vector3();
        Vector3 vector32 = new Vector3();
        Vector3 vector33 = new Vector3(rt2.b(0));
        vector32.copyFrom(vector33);
        vector3.copyFrom(vector33);
        for (int i2 = 0; i2 < rt2.b; ++i2) {
            Vector4 vector4 = rt2.b(i2);
            vector3.x = Math.max(vector4.x, vector3.x);
            vector3.y = Math.max(vector4.y, vector3.y);
            vector3.z = Math.max(vector4.z, vector3.z);
            vector32.x = Math.min(vector4.x, vector32.x);
            vector32.y = Math.min(vector4.y, vector32.y);
            vector32.z = Math.min(vector4.z, vector32.z);
        }
        return new BoundingBox(vector32, vector3);
    }

    /*
     * WARNING - void declaration
     */
    public final void merge(Vector4 pt2) {
        void var1_1;
        this.merge(pt2.x, pt2.y, var1_1.z);
    }

    /*
     * WARNING - void declaration
     */
    public final void merge(Vector3 pt2) {
        void var1_1;
        this.merge(pt2.x, pt2.y, var1_1.z);
    }

    /*
     * WARNING - void declaration
     */
    public final void merge(double x2, double y2, double z2) {
        if (this.c == BoundingBoxExtent.INFINITE) {
            return;
        }
        if (this.c == BoundingBoxExtent.NULL) {
            Vector3 vector3 = new Vector3(x2, y2, z2);
            this.a.copyFrom(vector3);
            this.b.copyFrom(vector3);
        } else {
            void var3_3;
            void var1_1;
            double d2 = z2;
            double d3 = y2;
            void var9_7 = var1_1;
            Vector3 vector3 = this.b;
            if (var9_7 > vector3.x) {
                vector3.x = var9_7;
            }
            if (d3 > vector3.y) {
                vector3.y = d3;
            }
            if (d2 > vector3.z) {
                vector3.z = d2;
            }
            d2 = z2;
            d3 = var3_3;
            var9_7 = var1_1;
            vector3 = this.a;
            if (var9_7 < vector3.x) {
                vector3.x = var9_7;
            }
            if (d3 < vector3.y) {
                vector3.y = d3;
            }
            if (d2 < vector3.z) {
                vector3.z = d2;
            }
        }
        this.c = BoundingBoxExtent.FINITE;
    }

    /*
     * WARNING - void declaration
     */
    public final void merge(BoundingBox bb2) {
        void var1_1;
        if (bb2.c == BoundingBoxExtent.NULL || this.c == BoundingBoxExtent.INFINITE) {
            return;
        }
        if (bb2.c == BoundingBoxExtent.INFINITE) {
            this.c = BoundingBoxExtent.INFINITE;
            return;
        }
        if (this.c == BoundingBoxExtent.NULL) {
            this.a(bb2.a, bb2.b);
            return;
        }
        Vector3 vector3 = Struct.byVal(this.a);
        Vector3 vector32 = Struct.byVal(this.b);
        vector32.b(bb2.b);
        vector32.b(bb2.a);
        vector3.a(bb2.a);
        vector3.a(var1_1.b);
        this.a(vector3, vector32);
    }

    private void a(Vector3 vector3, Vector3 vector32) {
        this.c = BoundingBoxExtent.FINITE;
        this.a.copyFrom(vector3);
        this.b.copyFrom(vector32);
    }

    /*
     * WARNING - void declaration
     */
    public static BoundingBox mul(BoundingBox bbox, Matrix4 mat) {
        Struct<BoundingBox> struct;
        void var1_1;
        if (bbox.c != BoundingBoxExtent.FINITE) {
            return Struct.byVal(bbox);
        }
        Vector3 vector3 = Matrix4.mul(mat, bbox.a);
        struct = Matrix4.mul((Matrix4)var1_1, struct.b);
        return new BoundingBox(vector3, (Vector3)struct);
    }

    public final String toString() {
        if (this.c == BoundingBoxExtent.NULL) {
            return "null";
        }
        if (this.c == BoundingBoxExtent.INFINITE) {
            return "infinite";
        }
        return String.format("%s~%s", this.a, this.b);
    }

    public final boolean equals(Object obj) {
        BoundingBox boundingBox;
        if (!(obj instanceof BoundingBox)) {
            return false;
        }
        boundingBox = Struct.byVal((BoundingBox)boundingBox);
        if (this.c != boundingBox.c) {
            return false;
        }
        return this.a.c(boundingBox.a) && this.b.c(boundingBox.b);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean overlapsWith(BoundingBox box) {
        void var1_1;
        if (this.c == BoundingBoxExtent.INFINITE || box.c == BoundingBoxExtent.INFINITE) {
            return true;
        }
        if (this.c == BoundingBoxExtent.NULL || box.c == BoundingBoxExtent.NULL) {
            return false;
        }
        return this.a.x <= box.b.x && this.a.y <= box.b.y && this.a.z <= box.b.z && this.b.x >= box.a.x && this.b.y >= box.a.y && this.b.z >= var1_1.a.z;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean contains(Vector3 p2) {
        void var1_1;
        if (this.c == BoundingBoxExtent.INFINITE) {
            return true;
        }
        if (this.c == BoundingBoxExtent.NULL) {
            return false;
        }
        Vector3 vector3 = Struct.byVal(this.b);
        Vector3 vector32 = Struct.byVal(this.a);
        return p2.x <= vector3.x && p2.x >= vector32.x && p2.y <= vector3.y && p2.y >= vector32.y && p2.z <= vector3.z && var1_1.z >= vector32.z;
    }

    public final boolean contains(BoundingBox bbox) {
        Vector3 vector3;
        if (this.c == BoundingBoxExtent.INFINITE || bbox.c == BoundingBoxExtent.NULL) {
            return true;
        }
        if (this.c == BoundingBoxExtent.NULL || bbox.c == BoundingBoxExtent.INFINITE) {
            return false;
        }
        Vector3 vector32 = Struct.byVal(bbox.b);
        vector3 = Struct.byVal(((BoundingBox)((Object)vector3)).a);
        Vector3 vector33 = Struct.byVal(this.b);
        Vector3 vector34 = Struct.byVal(this.a);
        return vector32.x <= vector33.x && vector3.x >= vector34.x && vector32.y <= vector33.y && vector3.y >= vector34.y && vector32.z <= vector33.z && vector3.z >= vector34.z;
    }

    final boolean a(Vector3 vector3) {
        return vector3.x <= this.b.x && vector3.x >= this.a.x && vector3.y <= this.b.y && vector3.y >= this.a.y;
    }

    public BoundingBox() {
    }

    /*
     * WARNING - void declaration
     */
    private BoundingBox(BoundingBox other) {
        void var1_1;
        this.a = Struct.byVal(other.a);
        this.b = Struct.byVal(other.b);
        this.c = var1_1.c;
    }

    @Override
    public final BoundingBox clone() {
        return new BoundingBox(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void copyFrom(BoundingBox src) {
        void var1_1;
        if (src == null) {
            return;
        }
        this.a = Struct.byVal(src.a);
        this.b = Struct.byVal(src.b);
        this.c = var1_1.c;
    }

    public final int hashCode() {
        return this.a.hashCode() ^ this.b.hashCode() ^ this.c.hashCode();
    }
}

