/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.DracoSaveOptions;
import com.aspose.threed.Entity;
import com.aspose.threed.FileContentType;
import com.aspose.threed.FileFormat;
import com.aspose.threed.FileFormatType;
import com.aspose.threed.Geometry;
import com.aspose.threed.IMeshConvertible;
import com.aspose.threed.ImportException;
import com.aspose.threed.MappingMode;
import com.aspose.threed.Mesh;
import com.aspose.threed.PointCloud;
import com.aspose.threed.PolygonModifier;
import com.aspose.threed.ReferenceMode;
import com.aspose.threed.Scene;
import com.aspose.threed.Stream;
import com.aspose.threed.Version;
import com.aspose.threed.VertexElement;
import com.aspose.threed.VertexElementType;
import com.aspose.threed.VertexElementUV;
import com.aspose.threed.VertexElementVector4;
import com.aspose.threed.cI;
import com.aspose.threed.cL;
import com.aspose.threed.cR;
import com.aspose.threed.dk;
import com.aspose.threed.dm;
import com.aspose.threed.do;
import com.aspose.threed.dq;
import com.aspose.threed.ha;
import com.aspose.threed.mH;
import com.aspose.threed.mq;
import com.aspose.threed.p;
import com.aspose.threed.rt;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;

public class DracoFormat
extends FileFormat {
    DracoFormat() {
        super(FileFormatType.DRACO, new Version(1, 0), FileContentType.BINARY);
    }

    public Geometry decode(String fileName) throws IOException {
        byte[] byArray;
        p.b(fileName);
        byArray = Files.readAllBytes(Paths.get((String)byArray, new String[0]));
        return this.decode(byArray);
    }

    public Geometry decode(byte[] data) throws ImportException {
        Object object;
        try {
            if (data == null) {
                throw new IllegalArgumentException("Argument data cannot be null");
            }
            object = new cR((byte[])object);
            if ((object = dm.a((cR)object, true)) == null) {
                throw new ImportException("Cannot import this Draco file");
            }
            return dk.a((do)object, null);
        }
        catch (ImportException importException) {
            object = importException;
            throw importException;
        }
        catch (dq dq2) {
            throw new ImportException(dq2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void encode(Entity entity, Stream stream, DracoSaveOptions options) throws IOException {
        Object object;
        try {
            void var2_3;
            void var3_4;
            if (stream == null) {
                throw new IllegalArgumentException("Argument stream cannot be null");
            }
            object = this.encode((Entity)object, (DracoSaveOptions)var3_4);
            var2_3.write((byte[])object, 0, ((Object)object).length);
            return;
        }
        catch (IOException iOException) {
            object = iOException;
            throw iOException;
        }
        catch (dq dq2) {
            throw new IOException(dq2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void encode(Entity entity, Stream stream) throws IOException {
        void var2_2;
        void var1_1;
        this.encode((Entity)var1_1, (Stream)var2_2, (DracoSaveOptions)null);
    }

    /*
     * WARNING - void declaration
     */
    public void encode(Entity entity, String fileName, DracoSaveOptions options) throws IOException {
        Object object;
        try {
            void var2_3;
            void var3_4;
            if (fileName == null) {
                throw new IllegalArgumentException("Argument fileName cannot be null");
            }
            object = this.encode((Entity)object, (DracoSaveOptions)var3_4);
            Files.write(Paths.get((String)var2_3, new String[0]), (byte[])object, StandardOpenOption.CREATE);
            return;
        }
        catch (IOException iOException) {
            object = iOException;
            throw iOException;
        }
        catch (dq dq2) {
            throw new IOException(dq2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void encode(Entity entity, String fileName) throws IOException {
        void var2_2;
        void var1_1;
        this.encode((Entity)var1_1, (String)var2_2, (DracoSaveOptions)null);
    }

    public byte[] encode(Entity entity, DracoSaveOptions options) throws dq {
        if (entity instanceof PointCloud) {
            DracoSaveOptions dracoSaveOptions = options;
            options = (PointCloud)entity;
            entity = this;
            if (dracoSaveOptions == null) {
                dracoSaveOptions = new DracoSaveOptions();
            }
            dracoSaveOptions.setPointCloud(true);
            p.a(options);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            options = ((DracoFormat)entity).a((Geometry)options, arrayList, 1.0);
            return DracoFormat.a((do)options, dracoSaveOptions);
        }
        if (entity instanceof IMeshConvertible) {
            Object object;
            IMeshConvertible iMeshConvertible;
            DracoSaveOptions dracoSaveOptions = iMeshConvertible;
            iMeshConvertible = (IMeshConvertible)object;
            object = this;
            if (dracoSaveOptions == null) {
                dracoSaveOptions = new DracoSaveOptions();
            }
            p.a(iMeshConvertible);
            Mesh mesh = iMeshConvertible.toMesh();
            String string = "Argument cannot be converted to a correct mesh";
            boolean bl2 = mesh != null;
            if (!bl2) {
                throw new IllegalArgumentException(string);
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            object = (dm)((DracoFormat)object).a(mesh, arrayList, 1.0);
            return DracoFormat.a((do)object, dracoSaveOptions);
        }
        throw new IllegalStateException("Specified geometry is not supported by Draco encoder");
    }

    /*
     * WARNING - void declaration
     */
    public byte[] encode(Entity entity) throws dq {
        void var1_1;
        return this.encode((Entity)var1_1, (DracoSaveOptions)null);
    }

    static byte[] a(do do_, DracoSaveOptions dracoSaveOptions) throws dq {
        return p.a(do_, dracoSaveOptions.a());
    }

    final do a(Scene sceneObject, boolean bl2, double d2) {
        sceneObject = this.a((Scene)sceneObject, bl2);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        return this.a((Geometry)sceneObject, arrayList, d2);
    }

    private Geometry a(Scene scene, boolean bl2) {
        while (true) {
            if (bl2) {
                if (scene.getRootNode().getChildNodes().size() == 1) {
                    Entity entity = scene.getRootNode().getChildNodes().get(0).getEntity();
                    if (entity instanceof IMeshConvertible) {
                        return PointCloud.fromGeometry(((IMeshConvertible)((Object)entity)).toMesh());
                    }
                    if (entity instanceof PointCloud) {
                        return (PointCloud)entity;
                    }
                }
                return PolygonModifier.a(scene);
            }
            if (scene.getRootNode().getChildNodes().size() != 1) break;
            Entity entity = scene.getRootNode().getChildNodes().get(0).getEntity();
            if (entity instanceof IMeshConvertible) {
                return ((IMeshConvertible)((Object)entity)).toMesh();
            }
            if (!(entity instanceof PointCloud)) break;
            bl2 = true;
        }
        return PolygonModifier.mergeMesh(scene);
    }

    final do a(Geometry geometry, ArrayList<Object> arrayList, double d2) {
        if (geometry instanceof Mesh && !((Mesh)geometry).c()) {
            geometry = PolygonModifier.triangulate((Mesh)geometry);
        }
        do do_ = geometry instanceof PointCloud ? new do() : new dm();
        VertexElementType[] vertexElementTypeArray = new VertexElementType[]{VertexElementType.UV, VertexElementType.NORMAL, VertexElementType.VERTEX_COLOR};
        this.a(do_, geometry, arrayList, d2);
        return do_;
    }

    private void a(do do_, Geometry geometry, ArrayList<Object> arrayList, double d2) {
        Object i2;
        Object i3;
        if (geometry instanceof Mesh) {
            do_.g(((Mesh)geometry).getPolygonCount() * 3);
        }
        this.a(do_, geometry, 0, 9, 3, geometry.controlPoints, null, MappingMode.CONTROL_POINT, false, d2);
        arrayList.add(null);
        if (do_ instanceof dm) {
            for (VertexElement object3 : geometry.vertexElements) {
                if (object3.c != VertexElementType.UV || !this.a(do_, geometry, 3, 9, 2, (rt)(i3 = ((VertexElementUV)object3).i), (ha)(i2 = object3.e == ReferenceMode.INDEX_TO_DIRECT ? object3.g : null), object3.d, false, 1.0)) continue;
                arrayList.add((Object)VertexElementType.UV);
            }
        }
        this.a(do_, geometry, 1, 9, 3, VertexElementType.NORMAL, false, arrayList);
        this.a(do_, geometry, 4, 9, 3, VertexElementType.TANGENT, false, arrayList);
        this.a(do_, geometry, 4, 9, 3, VertexElementType.BINORMAL, false, arrayList);
        this.a(do_, geometry, 4, 9, 3, VertexElementType.SPECULAR, false, arrayList);
        this.a(do_, geometry, 2, 9, 3, VertexElementType.VERTEX_COLOR, false, arrayList);
        if (geometry instanceof Mesh) {
            Mesh mesh = (Mesh)geometry;
            dm dm2 = (dm)do_;
            i2 = mesh.polygons.iterator();
            while (i2.hasNext()) {
                i3 = (int[])i2.next();
                dm2.a((int[])i3);
            }
            for (int i4 = 0; i4 < dm2.b(); ++i4) {
                for (int i5 = 0; i5 < 3; ++i5) {
                    dm2.a(i4 * 3 + i5, i4 * 3 + i5);
                }
            }
            do_.d();
            do_.e();
            return;
        }
        do_.g(geometry.controlPoints.b);
    }

    private boolean a(do do_, Geometry geometry, int n2, int n3, int n4, VertexElementType vertexElementType, boolean bl2, ArrayList<Object> arrayList) {
        ha ha2;
        VertexElement vertexElement = geometry.getElement(vertexElementType);
        vertexElement = vertexElement instanceof VertexElementVector4 ? (VertexElementVector4)vertexElement : null;
        if (vertexElement == null) {
            return false;
        }
        ha ha3 = ha2 = ((VertexElementVector4)vertexElement).e == ReferenceMode.INDEX_TO_DIRECT ? ((VertexElementVector4)vertexElement).g : null;
        if (this.a(do_, geometry, n2, 9, 3, ((VertexElementVector4)vertexElement).i, ha2, ((VertexElementVector4)vertexElement).d, false, 1.0)) {
            arrayList.add((Object)vertexElementType);
            return true;
        }
        return false;
    }

    private boolean a(do object, Geometry geometry, int n2, int n3, int n4, rt rt2, ha ha2, MappingMode object2, boolean n5, double d2) {
        if (rt2.size() == 0) {
            return false;
        }
        mq mq2 = new mq(n2, n3, n4, false);
        if (n4 == 3) {
            ((do)object).a(mq2, false, rt2.size());
            rt rt3 = rt2;
            this.a(mq2.h(), rt3, rt3.b, d2);
        } else if (n4 == 2) {
            ((do)object).a(mq2, false, rt2.size());
            rt rt4 = rt2;
            this.a(mq2.h(), rt4, rt4.b);
        } else {
            return false;
        }
        if ((object = geometry instanceof Mesh ? (Mesh)geometry : null) == null || n5 != 0) {
            mq2.b(true);
            return true;
        }
        boolean bl2 = ha2 != null && ha2.size() > 0;
        switch (object2) {
            case CONTROL_POINT: {
                n2 = 0;
                n4 = ((Mesh)object).polygons.size();
                object = ((Mesh)object).polygons;
                for (int i2 = 0; i2 < n4; ++i2) {
                    object2 = ((mH)object).b(i2);
                    for (n5 = 0; n5 < 3; ++n5) {
                        Object object3 = object2[n5];
                        if (bl2) {
                            object3 = ha2.a[object3];
                        }
                        mq2.a(n2, (int)object3);
                        ++n2;
                    }
                }
                break;
            }
            case POLYGON: {
                n2 = 0;
                for (n4 = 0; n4 < ((Mesh)object).polygons.size(); ++n4) {
                    ((Mesh)object).polygons.b(n4);
                    for (int i3 = 0; i3 < 3; ++i3) {
                        int n6 = n4;
                        if (bl2) {
                            n6 = ha2.a[n6];
                        }
                        mq2.a(n2, n6);
                        ++n2;
                    }
                }
                break;
            }
            case POLYGON_VERTEX: {
                n2 = 0;
                n4 = ((Mesh)object).polygons.size();
                object = ((Mesh)object).polygons;
                for (int i4 = 0; i4 < n4; ++i4) {
                    ((mH)object).b(i4);
                    for (n5 = 0; n5 < 3; ++n5) {
                        int n7 = n2;
                        if (bl2) {
                            n7 = ha2.a[n7];
                        }
                        mq2.a(n2, n7);
                        ++n2;
                    }
                }
                break;
            }
            case ALL_SAME: {
                n2 = 0;
                n4 = ((Mesh)object).polygons.size();
                for (int i5 = 0; i5 < n4; ++i5) {
                    for (int i6 = 0; i6 < 3; ++i6) {
                        mq2.a(n2, 0);
                        ++n2;
                    }
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported mapping mode for attribute " + n2);
            }
        }
        return true;
    }

    private void a(cL cL2, rt rt2, int n2) {
        byte[] byArray = cL2.b();
        cL2.d(n2 * 8);
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            float f2 = (float)rt2.b((int)i2).x;
            float f3 = (float)rt2.b((int)i2).y;
            n3 = DracoFormat.a(f2, byArray, n3);
            n3 = DracoFormat.a(f3, byArray, n3);
        }
    }

    private void a(cL cL2, rt rt2, int n2, double d2) {
        byte[] byArray = cL2.b();
        cL2.d(n2 * 12);
        int n3 = 0;
        if (d2 != 1.0) {
            float f2 = (float)d2;
            for (int i2 = 0; i2 < n2; ++i2) {
                n3 = DracoFormat.a((float)rt2.b((int)i2).x * f2, byArray, n3);
                n3 = DracoFormat.a((float)rt2.b((int)i2).y * f2, byArray, n3);
                n3 = DracoFormat.a((float)rt2.b((int)i2).z * f2, byArray, n3);
            }
            return;
        }
        for (int i3 = 0; i3 < n2; ++i3) {
            n3 = DracoFormat.a((float)rt2.b((int)i3).x, byArray, n3);
            n3 = DracoFormat.a((float)rt2.b((int)i3).y, byArray, n3);
            n3 = DracoFormat.a((float)rt2.b((int)i3).z, byArray, n3);
        }
    }

    private static int a(float f2, byte[] byArray, int n2) {
        int n3 = Float.floatToIntBits(f2);
        cI.a.a(byArray, n2, n3);
        return n2 + 4;
    }
}

