/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.Vector2;
import com.aspose.threed.Vector3;

public class MathUtils {
    private MathUtils() {
    }

    /*
     * WARNING - void declaration
     */
    public static double clamp(double val, double min, double max) {
        double d2;
        if (val < min) {
            void var2_2;
            return (double)var2_2;
        }
        if (val > max) {
            return max;
        }
        return d2;
    }

    public static Vector3 toDegree(Vector3 radian) {
        Vector3 vector3;
        return new Vector3(MathUtils.toDegree(radian.x), MathUtils.toDegree(radian.y), MathUtils.toDegree(vector3.z));
    }

    public static Vector3 toRadian(Vector3 degree) {
        Vector3 vector3;
        return new Vector3(MathUtils.toRadian(degree.x), MathUtils.toRadian(degree.y), MathUtils.toRadian(vector3.z));
    }

    public static float toDegree(float radian) {
        return radian / (float)Math.PI * 180.0f;
    }

    public static double toDegree(double radian) {
        return radian / Math.PI * 180.0;
    }

    static double a(Vector3 vector3, Vector3 vector32, Vector3 vector33) {
        double d2 = Vector3.sub(vector3, vector32).getLength();
        double d3 = Vector3.sub(vector32, vector33).getLength();
        double d4 = Vector3.sub(vector33, vector3).getLength();
        double d5 = (d2 + d3 + d4) * 0.5;
        return Math.sqrt(d5 * (d5 - d2) * (d5 - d3) * (d5 - d4));
    }

    /*
     * WARNING - void declaration
     */
    public static Vector3 toDegree(double x2, double y2, double z2) {
        void var2_2;
        double d2;
        return new Vector3(MathUtils.toDegree(d2), MathUtils.toDegree((double)var2_2), MathUtils.toDegree(z2));
    }

    public static float toRadian(float degree) {
        return degree / 180.0f * (float)Math.PI;
    }

    public static double toRadian(double degree) {
        return degree / 180.0 * Math.PI;
    }

    /*
     * WARNING - void declaration
     */
    public static Vector3 toRadian(double x2, double y2, double z2) {
        void var2_2;
        double d2;
        return new Vector3(MathUtils.toRadian(d2), MathUtils.toRadian((double)var2_2), MathUtils.toRadian(z2));
    }

    static float a(float f2) {
        return (float)Math.sqrt(f2);
    }

    static double a(Vector2 vector2, Vector2 vector22, Vector2 vector23) {
        double d2 = vector2.x - vector23.x;
        double d3 = vector22.x - vector23.x;
        double d4 = vector2.y - vector23.y;
        double d5 = vector22.y - vector23.y;
        return d2 * d5 - d4 * d3;
    }

    static boolean a(Vector2 vector2, Vector2 vector22, Vector2 vector23, Vector2 vector24) {
        double d2;
        double d3;
        double d4 = MathUtils.a(vector23, vector24, vector2);
        if (d4 * (d3 = MathUtils.a(vector23, vector24, vector22)) > 0.0) {
            return false;
        }
        double d5 = MathUtils.a(vector2, vector22, vector23);
        return !(d5 * (d2 = MathUtils.a(vector2, vector22, vector24)) > 0.0);
    }

    static boolean b(Vector2 vector2, Vector2 vector22, Vector2 vector23, Vector2 vector24) {
        boolean bl2 = vector2.compareTo(vector23) < 0 ? MathUtils.a(vector22, vector2, vector23) <= 0.0 : MathUtils.a(vector22, vector23, vector2) > 0.0;
        double d2 = MathUtils.a(vector22, vector2, vector24);
        double d3 = MathUtils.a(vector22, vector23, vector24);
        if (bl2) {
            return d2 > 0.0 || d3 <= 0.0;
        }
        return d2 > 0.0 && d3 < 0.0;
    }

    static boolean b(float f2) {
        return !Double.isNaN(f2) && !Double.isInfinite(f2);
    }

    static boolean a(double d2) {
        return !Double.isNaN(d2) && !Double.isInfinite(d2);
    }

    public static Vector3 calcNormal(Vector3[] points) {
        Vector3 vector3 = Vector3.getZero();
        for (int i2 = 0; i2 < points.length; ++i2) {
            int n2 = (i2 + 1) % points.length;
            vector3.x += (points[i2].y - points[n2].y) * (points[i2].z + points[n2].z);
            vector3.y += (points[i2].z - points[n2].z) * (points[i2].x + points[n2].x);
            vector3.z += (points[i2].x - points[n2].x) * (points[i2].y + points[n2].y);
        }
        return vector3;
    }

    /*
     * WARNING - void declaration
     */
    public static int findIntersection(Vector2 p0, Vector2 d0, Vector2 p1, Vector2 d1, Vector2[] results) {
        void var3_3;
        double d2;
        Vector2 vector2 = Vector2.sub(p1, p0);
        double d3 = d0.cross(d1);
        double d4 = d3 * d3;
        Vector2 vector22 = d0;
        double d5 = vector22.dot(vector22);
        Vector2 vector23 = d1;
        double d6 = vector23.dot(vector23);
        if (d4 > d5 * 1.0E-10 * d6) {
            double d7 = vector2.cross(d1) / d3;
            if (d7 < 0.0 || d7 > 1.0) {
                return 0;
            }
            double d8 = vector2.cross(d0) / d3;
            if (d8 < 0.0 || d8 > 1.0) {
                return 0;
            }
            if (results != null) {
                results[0] = Vector2.add(p0, Vector2.mul(d7, d0));
            }
            return 1;
        }
        Vector2 vector24 = vector2;
        double d9 = vector24.dot(vector24);
        d3 = vector2.cross(d0);
        d4 = d3 * d3;
        if (d2 > d5 * 1.0E-10 * d9) {
            return 0;
        }
        double d10 = d0.dot(vector2) / d5;
        double d11 = d10 + d0.dot((Vector2)var3_3) / d5;
        double d12 = Math.min(d10, d11);
        double d13 = Math.max(d10, d11);
        if (d12 > 1.0 || d13 < 0.0) {
            return 0;
        }
        double d14 = 0.0;
        if (1.0 > d12) {
            if (0.0 < d13) {
                if (results != null) {
                    double d15 = Math.max(0.0, d12);
                    double d16 = Math.min(1.0, d13);
                    results[0] = Vector2.add(p0, Vector2.mul(d15, d0));
                    results[1] = Vector2.add(p0, Vector2.mul(d16, d0));
                }
                return 2;
            }
        } else {
            d14 = 1.0;
        }
        if (results != null) {
            void var1_1;
            Vector2 vector25;
            results[0] = Vector2.add(vector25, Vector2.mul(d14, (Vector2)var1_1));
        }
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean pointInsideTriangle(Vector2 p2, Vector2 p0, Vector2 p1, Vector2 p22) {
        Vector2 vector2;
        void var1_1;
        void var2_2;
        void var3_3;
        double d2 = 0.5 * (-p1.y * p22.x + p0.y * (-p1.x + p22.x) + p0.x * (p1.y - p22.y) + p1.x * p22.y);
        double d3 = 1.0 / (d2 * 2.0) * (p0.y * p22.x - p0.x * p22.y + (p22.y - p0.y) * p2.x + (p0.x - var3_3.x) * p2.y);
        double d4 = 1.0 / (d2 * 2.0) * (p0.x * p1.y - p0.y * p1.x + (p0.y - p1.y) * p2.x + (var2_2.x - var1_1.x) * vector2.y);
        return d3 > 0.0 && d4 > 0.0 && 1.0 - d3 - d4 > 0.0;
    }

    /*
     * WARNING - void declaration
     */
    public static Vector2 rayIntersect(Vector2 origin, Vector2 dir, Vector2 a2, Vector2 b2) {
        void var2_2;
        Vector2 vector2 = Vector2.sub(b2, a2);
        double d2 = (-dir.y * (origin.x - a2.x) + dir.x * (origin.y - a2.y)) / (-vector2.x * dir.y + dir.x * vector2.y);
        double d3 = (vector2.x * (origin.y - a2.y) - vector2.y * (origin.x - var2_2.x)) / (-vector2.x * dir.y + dir.x * vector2.y);
        if (d2 >= 0.0 && d2 <= 1.0 && d3 >= 0.0) {
            void var1_1;
            Vector2 vector22;
            return new Vector2(origin.x + d3 * dir.x, vector22.y + d3 * var1_1.y);
        }
        return null;
    }
}

