/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.FVector2;
import com.aspose.threed.Struct;
import com.aspose.threed.Vector3;
import com.aspose.threed.p;
import java.io.Serializable;

public final class Vector2
implements Struct<Vector2>,
Serializable,
Comparable<Vector2> {
    public double x;
    public double y;
    static final long serialVersionUID = 250747573L;

    public Vector2(double s2) {
        this.x = Double.NaN;
        this.y = Double.NaN;
    }

    /*
     * WARNING - void declaration
     */
    public Vector2(Vector3 s2) {
        void var1_1;
        this.x = s2.x;
        this.y = var1_1.y;
    }

    /*
     * WARNING - void declaration
     */
    public Vector2(FVector2 vec) {
        void var1_1;
        this.x = vec.x;
        this.y = var1_1.y;
    }

    public static FVector2 create(Vector2 v2) {
        Vector2 vector2;
        return new FVector2((float)v2.x, (float)vector2.y);
    }

    public final double getU() {
        return this.x;
    }

    /*
     * WARNING - void declaration
     */
    public final void setU(double value) {
        void var1_1;
        this.x = var1_1;
    }

    public final double getV() {
        return this.y;
    }

    /*
     * WARNING - void declaration
     */
    public final void setV(double value) {
        void var1_1;
        this.y = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Vector2(double x2, double y2) {
        void var3_2;
        void var1_1;
        this.x = var1_1;
        this.y = var3_2;
    }

    /*
     * WARNING - void declaration
     */
    public final double dot(Vector2 rhs) {
        void var1_1;
        return this.x * rhs.x + this.y * var1_1.y;
    }

    public final double getLength() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    final double a() {
        return this.x * this.x + this.y * this.y;
    }

    final double b() {
        return this.x * this.x + this.y * this.y;
    }

    final boolean c() {
        return this.x == 0.0 && this.y == 0.0;
    }

    /*
     * WARNING - void declaration
     */
    public static Vector2 add(Vector2 lhs, Vector2 rhs) {
        void var1_1;
        Vector2 vector2;
        return new Vector2(lhs.x + rhs.x, vector2.y + var1_1.y);
    }

    /*
     * WARNING - void declaration
     */
    public static Vector2 sub(Vector2 lhs, Vector2 rhs) {
        void var1_1;
        Vector2 vector2;
        return new Vector2(lhs.x - rhs.x, vector2.y - var1_1.y);
    }

    /*
     * WARNING - void declaration
     */
    public static Vector2 div(Vector2 lhs, double rhs) {
        void var1_1;
        Vector2 vector2;
        return new Vector2(lhs.x / rhs, vector2.y / var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Vector2 mul(Vector2 lhs, double rhs) {
        void var1_1;
        Vector2 vector2;
        return new Vector2(lhs.x * rhs, vector2.y * var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Vector2 mul(double lhs, Vector2 rhs) {
        void var2_1;
        double d2;
        return new Vector2(lhs * rhs.x, d2 * var2_1.y);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean op_eq(Vector2 lhs, Vector2 rhs) {
        void var1_1;
        return lhs.equals((Vector2)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean op_ne(Vector2 lhs, Vector2 rhs) {
        void var1_1;
        return !lhs.equals((Vector2)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Vector2 rhs) {
        void var1_1;
        return this.x == rhs.x && this.y == var1_1.y;
    }

    public final boolean equals(Object obj) {
        Vector2 vector2;
        if (!(obj instanceof Vector2)) {
            return false;
        }
        vector2 = Struct.byVal((Vector2)vector2);
        return this.x == vector2.x && this.y == vector2.y;
    }

    final void a(Vector2 vector2) {
        if (vector2.x < this.x) {
            this.x = vector2.x;
        }
        if (vector2.y < this.y) {
            this.y = vector2.y;
        }
    }

    final void b(Vector2 vector2) {
        if (vector2.x > this.x) {
            this.x = vector2.x;
        }
        if (vector2.y > this.y) {
            this.y = vector2.y;
        }
    }

    public final String toString() {
        return String.format("(%.0f %.0f)", this.x, this.y);
    }

    /*
     * WARNING - void declaration
     */
    public final double cross(Vector2 v2) {
        void var1_1;
        return this.x * v2.y - this.y * var1_1.x;
    }

    public final Vector2 normalize() {
        double d2 = 1.0 / this.getLength();
        return new Vector2(this.x * d2, this.y * d2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int compareTo(Vector2 other) {
        void var1_1;
        int n2 = Double.compare(this.x, other.x);
        if (n2 != 0) {
            return n2;
        }
        n2 = Double.compare(this.y, var1_1.y);
        return n2;
    }

    public Vector2() {
    }

    /*
     * WARNING - void declaration
     */
    private Vector2(Vector2 other) {
        void var1_1;
        this.x = other.x;
        this.y = var1_1.y;
    }

    @Override
    public final Vector2 clone() {
        return new Vector2(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void copyFrom(Vector2 src) {
        void var1_1;
        if (src == null) {
            return;
        }
        this.x = src.x;
        this.y = var1_1.y;
    }

    public final int hashCode() {
        return p.a(this.x) ^ p.a(this.y);
    }

    static {
        new Vector2(0.0, 0.0);
    }
}

