/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.A3DObject;
import com.aspose.threed.AssetInfo;
import com.aspose.threed.BoundingBox;
import com.aspose.threed.C;
import com.aspose.threed.CustomObject;
import com.aspose.threed.Entity;
import com.aspose.threed.GlobalTransform;
import com.aspose.threed.Material;
import com.aspose.threed.Matrix4;
import com.aspose.threed.NodeVisitor;
import com.aspose.threed.ParseException;
import com.aspose.threed.Scene;
import com.aspose.threed.SceneObject;
import com.aspose.threed.Struct;
import com.aspose.threed.Transform;
import com.aspose.threed.dJ;
import com.aspose.threed.kY;
import com.aspose.threed.kw;
import com.aspose.threed.lu;
import com.aspose.threed.lv;
import com.aspose.threed.oH;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Node
extends SceneObject {
    private boolean visible;
    Node parentNode;
    A3DObject upVectorProperty;
    A3DObject lookAtProperty;
    oH shadingMode;
    boolean excluded = false;
    private lv<Node> childNodes;
    private List<Material> materials;
    private dJ entities;
    private List<CustomObject> metaDatas;
    private Transform transform;
    private GlobalTransform globalTransform;
    private boolean transformDirty = true;
    int defaultAttributeIndex = 0;
    private AssetInfo assetInfo;
    int features;

    public AssetInfo getAssetInfo() {
        return this.assetInfo;
    }

    /*
     * WARNING - void declaration
     */
    public void setAssetInfo(AssetInfo value) {
        void var1_1;
        this.assetInfo = var1_1;
    }

    public Node() {
        this("");
    }

    /*
     * WARNING - void declaration
     */
    public Node(String name, Entity entity) {
        this((String)var1_1);
        void var2_2;
        void var1_1;
        this.setEntity((Entity)var2_2);
    }

    public Node(String name) {
        super((String)((Object)node));
        Node node;
        node = this;
        try {
            node.features = 0;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        this.childNodes = new kY(this);
        this.entities = new dJ(this);
        this.transform = new Transform(this);
        this.shadingMode = oH.a;
        this.visible = true;
    }

    public boolean getVisible() {
        return this.visible;
    }

    /*
     * WARNING - void declaration
     */
    public void setVisible(boolean value) {
        void var1_1;
        this.visible = var1_1;
    }

    public List<Node> getChildNodes() {
        return this.childNodes;
    }

    public Node createChildNode() {
        return this.createChildNode("", null);
    }

    /*
     * WARNING - void declaration
     */
    public void merge(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument node cannot be null");
        }
        if (node == this.parentNode) {
            throw new IllegalArgumentException("Cannot merge parent node to current node");
        }
        if (node == this) {
            return;
        }
        if (node.childNodes.size() > 0) {
            this.childNodes.a(node.childNodes);
        }
        if (node.entities.size() > 0) {
            this.entities.a(node.entities);
        }
        if (node.materials != null && !node.materials.isEmpty()) {
            void var1_1;
            ((ArrayList)this.getMaterials()).addAll(node.materials);
            var1_1.materials.clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    public Node createChildNode(String nodeName) {
        void var1_1;
        return this.createChildNode((String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public Node createChildNode(Entity entity) {
        void var1_1;
        return this.createChildNode("", (Entity)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Node createChildNode(String nodeName, Entity entity) {
        void var2_2;
        void var1_1;
        return this.createChildNode((String)var1_1, (Entity)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public Node createChildNode(String nodeName, Entity entity, Material material) {
        Node node;
        node = new Node((String)((Object)node));
        this.childNodes.add(node);
        if (entity != null) {
            void var2_2;
            node.setEntity((Entity)var2_2);
        }
        if (material != null) {
            void var3_3;
            node.setMaterial((Material)var3_3);
        }
        return node;
    }

    public Entity getEntity() {
        if (this.entities.size() > 0) {
            return (Entity)this.entities.get(0);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void setEntity(Entity value) {
        void var1_1;
        this.entities.clear();
        this.entities.add(var1_1);
    }

    public boolean getExcluded() {
        return this.excluded;
    }

    /*
     * WARNING - void declaration
     */
    public void setExcluded(boolean value) {
        void var1_1;
        this.excluded = var1_1;
    }

    public List<Entity> getEntities() {
        return this.entities;
    }

    public List<CustomObject> getMetaDatas() {
        if (this.metaDatas == null) {
            this.metaDatas = new ArrayList<CustomObject>(1);
        }
        return this.metaDatas;
    }

    public List<Material> getMaterials() {
        if (this.materials == null) {
            this.materials = new ArrayList<Material>(1);
        }
        return this.materials;
    }

    final boolean b() {
        return this.materials != null && !this.materials.isEmpty();
    }

    public Material getMaterial() {
        if (this.materials != null && !this.materials.isEmpty()) {
            return this.materials.get(0);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaterial(Material value) {
        if (this.materials == null) {
            this.materials = new ArrayList<Material>(1);
        }
        this.materials.clear();
        if (value != null) {
            void var1_1;
            this.materials.add((Material)var1_1);
        }
    }

    public Node getParentNode() {
        return this.parentNode;
    }

    /*
     * WARNING - void declaration
     */
    public void setParentNode(Node value) {
        void var1_1;
        if (this.parentNode == value) {
            return;
        }
        if (this.parentNode != null) {
            this.parentNode.childNodes.remove(this);
        }
        if (value != null) {
            value.childNodes.add(this);
        }
        this.parentNode = var1_1;
    }

    public Transform getTransform() {
        return this.transform;
    }

    public Matrix4 evaluateGlobalTransform(boolean withGeometricTransform) {
        if (!withGeometricTransform) {
            return this.d().getTransformMatrix();
        }
        return Matrix4.mul(this.d().getTransformMatrix(), this.transform.b());
    }

    private GlobalTransform d() {
        if (this.transformDirty) {
            Object object = this.getParentNode();
            Matrix4 matrix4 = new Matrix4();
            Matrix4 matrix42 = this.transform.b();
            if (object != null) {
                Object object2 = object = Struct.byVal(((Node)object).getGlobalTransform().a);
                object = this.transform;
                matrix4.copyFrom(Matrix4.mul((Matrix4)object2, ((Transform)object).impl.l()));
            } else {
                object = this.transform;
                matrix4.copyFrom(((Transform)object).impl.l());
            }
            if (this.globalTransform == null) {
                this.globalTransform = new GlobalTransform();
            }
            this.globalTransform.a(matrix4, matrix42);
            this.transformDirty = false;
        }
        return this.globalTransform;
    }

    public GlobalTransform getGlobalTransform() {
        return this.d();
    }

    final void c() {
        this.e();
    }

    private void e() {
        if (this.transformDirty) {
            return;
        }
        this.transformDirty = true;
        if (this.entities.size() > 0) {
            for (Entity sceneObject : this.entities) {
                if ((sceneObject.features & 1) != 1) continue;
                sceneObject.d();
            }
        }
        for (Node node : this.childNodes) {
            node.e();
        }
    }

    /*
     * WARNING - void declaration
     */
    public Node getChild(int index) {
        void var1_1;
        if (index < 0 || index >= this.childNodes.size()) {
            return null;
        }
        return this.childNodes.get((int)var1_1);
    }

    public Node getChild(String nodeName) {
        if (nodeName == null || nodeName.length() == 0) {
            return null;
        }
        for (Node node : this.childNodes) {
            if (!nodeName.equals(node.getName())) continue;
            return node;
        }
        return null;
    }

    final <T extends Entity> T a(kw<T> kw2) {
        int n2 = this.entities.a.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Entity entity = (Entity)this.entities.a.get(i2);
            entity = entity != null && kw2.a(entity.getClass()) ? entity : null;
            if (entity == null) continue;
            return (T)entity;
        }
        return null;
    }

    final void a(Scene scene) {
        this.scene = scene;
        for (SceneObject sceneObject : this.childNodes) {
            var2_2.next().scene = scene;
        }
        for (SceneObject sceneObject : this.entities) {
            ((Entity)((Object)var2_2.next())).scene = scene;
        }
    }

    public boolean accept(NodeVisitor visitor) {
        boolean bl2 = visitor.call(this);
        if (!bl2) {
            return false;
        }
        this.childNodes.size();
        for (int i2 = 0; i2 < this.childNodes.size(); ++i2) {
            Node node = this.childNodes.get(i2);
            bl2 = node.accept(visitor);
            if (bl2) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<<");
        if (this.getName() != null) {
            stringBuilder.append(this.getName());
        }
        stringBuilder.append(">>");
        if (this.entities.size() > 0) {
            stringBuilder.append(" : ");
            for (Entity entity : this.entities) {
                stringBuilder.append(entity.getClass().getSimpleName());
            }
        }
        return stringBuilder.toString();
    }

    public BoundingBox getBoundingBox() {
        Object object;
        int n2;
        BoundingBox boundingBox = new BoundingBox();
        Matrix4 matrix4 = this.evaluateGlobalTransform(true);
        for (n2 = 0; n2 < this.entities.size(); ++n2) {
            object = (Entity)this.entities.get(n2);
            object = ((Entity)object).a(matrix4);
            boundingBox.merge((BoundingBox)object);
        }
        for (n2 = 0; n2 < this.childNodes.size(); ++n2) {
            object = this.childNodes.get(n2);
            boundingBox.merge(((Node)object).getBoundingBox());
        }
        return boundingBox;
    }

    /*
     * WARNING - void declaration
     */
    public void addEntity(Entity entity) {
        void var1_1;
        if (entity == null) {
            throw new IllegalArgumentException("Argument entity cannot be null");
        }
        if (entity.a(this)) {
            return;
        }
        this.entities.add(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addChildNode(Node node) {
        void var1_1;
        if (node == null) {
            throw new IllegalArgumentException("Argument node cannot be null");
        }
        this.getChildNodes().add((Node)var1_1);
    }

    final Node a(String string) {
        for (int i2 = 0; i2 < this.getChildNodes().size(); ++i2) {
            Node node = this.getChildNodes().get(i2);
            if (!C.a((Object)node.getName(), (Object)string)) continue;
            return node;
        }
        return null;
    }

    public Object selectSingleObject(String path) throws ParseException {
        Object object;
        try {
            if (path == null) {
                throw new IllegalArgumentException("Argument path cannot be null");
            }
            object = lu.a((String)object);
            return ((lu)object).b(this);
        }
        catch (ParseException parseException) {
            object = parseException;
            throw parseException;
        }
        catch (IOException iOException) {
            throw new ParseException(iOException);
        }
    }

    public ArrayList<Object> selectObjects(String path) throws ParseException {
        Object object;
        try {
            if (path == null) {
                throw new IllegalArgumentException("Argument path cannot be null");
            }
            object = lu.a((String)object);
            return ((lu)object).a(this);
        }
        catch (ParseException parseException) {
            object = parseException;
            throw parseException;
        }
        catch (IOException iOException) {
            throw new ParseException(iOException);
        }
    }
}

