/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.Geometry;
import com.aspose.threed.IMeshConvertible;
import com.aspose.threed.MappingMode;
import com.aspose.threed.Mesh;
import com.aspose.threed.NurbsDirection;
import com.aspose.threed.NurbsType;
import com.aspose.threed.PolygonModifier;
import com.aspose.threed.Q;
import com.aspose.threed.ReferenceMode;
import com.aspose.threed.TextureMapping;
import com.aspose.threed.Vector4;
import com.aspose.threed.VertexElementNormal;
import com.aspose.threed.VertexElementUV;

public class NurbsSurface
extends Geometry
implements IMeshConvertible {
    boolean applyFlipUV = false;
    boolean applyFlipLinks = false;
    boolean flipNormals;
    final NurbsDirection u = new NurbsDirection();
    final NurbsDirection v = new NurbsDirection();

    public NurbsSurface() {
        this("");
    }

    /*
     * WARNING - void declaration
     */
    public NurbsSurface(String name) {
        super((String)var1_1);
        void var1_1;
    }

    public NurbsDirection getU() {
        return this.u;
    }

    public NurbsDirection getV() {
        return this.v;
    }

    private static int a(NurbsDirection nurbsDirection, int n2) {
        if (n2 >= nurbsDirection.getCount()) {
            NurbsType nurbsType = nurbsDirection.getType();
            if (nurbsType == NurbsType.CLOSED) {
                n2 = 0;
            } else if (nurbsType == NurbsType.PERIODIC) {
                n2 %= nurbsDirection.getCount();
            } else if (nurbsType == NurbsType.OPEN) {
                n2 = nurbsDirection.getCount() - 1;
            }
        }
        return n2;
    }

    @Override
    public Mesh toMesh() {
        int n2;
        if (this.controlPoints.size() == 0 || this.u.a.size() == 0 || this.v.getKnotVectors().isEmpty()) {
            return null;
        }
        Mesh mesh = new Mesh();
        double d2 = Math.floor(10.0);
        double d3 = Math.floor(10.0);
        Object object = this.u.a();
        Object object2 = this.v.a();
        object2 = new Q(this.v.getOrder(), (double[])object2);
        object = new Q(this.u.getOrder(), (double[])object);
        VertexElementUV vertexElementUV = mesh.createElementUV(TextureMapping.DIFFUSE, MappingMode.CONTROL_POINT, ReferenceMode.DIRECT);
        this.v.getCount();
        this.v.getCount();
        int n3 = 0;
        while ((double)n3 <= d3) {
            double d4 = (double)n3 / d3;
            n2 = this.v.a(d4);
            double[] dArray = ((Q)object2).a(n2, d4);
            int n4 = 0;
            while ((double)n4 <= d2) {
                double d5 = (double)n4 / d2;
                int n5 = this.u.a(d5);
                double[] dArray2 = ((Q)object).a(n5, d5);
                n5 = n5 - this.u.getOrder() + 1;
                Vector4 vector4 = new Vector4();
                for (int i2 = 0; i2 < this.v.getOrder(); ++i2) {
                    Vector4 vector42 = new Vector4();
                    int n6 = n2 - this.v.getOrder() + 1 + i2;
                    for (int i3 = 0; i3 < this.u.getOrder(); ++i3) {
                        Vector4 vector43 = vector42;
                        int n7 = n6;
                        int n8 = n5 + i3;
                        NurbsSurface nurbsSurface = this;
                        n8 = NurbsSurface.a(nurbsSurface.u, n8);
                        n7 = NurbsSurface.a(nurbsSurface.v, n7);
                        n8 = n8 * nurbsSurface.v.getCount() + n7;
                        vector43.copyFrom(Vector4.add(vector43, Vector4.mul(nurbsSurface.controlPoints.b(n8), dArray2[i3])));
                    }
                    Vector4 vector44 = vector4;
                    vector44.copyFrom(Vector4.add(vector44, Vector4.mul(vector42, dArray[i2])));
                }
                mesh.controlPoints.a(vector4);
                vertexElementUV.i.a(new Vector4(d5, d4, 0.0, 0.0));
                ++n4;
            }
            ++n3;
        }
        n3 = (int)d2 + 1;
        int[] nArray = new int[4];
        int n9 = 0;
        while ((double)n9 < d3) {
            n2 = 0;
            while ((double)n2 < d2) {
                if (this.flipNormals) {
                    nArray[0] = n9 * n3 + n2;
                    nArray[1] = n9 * n3 + n2 + 1;
                    nArray[2] = (n9 + 1) * n3 + n2 + 1;
                    nArray[3] = (n9 + 1) * n3 + n2;
                } else {
                    nArray[3] = n9 * n3 + n2;
                    nArray[2] = n9 * n3 + n2 + 1;
                    nArray[1] = (n9 + 1) * n3 + n2 + 1;
                    nArray[0] = (n9 + 1) * n3 + n2;
                }
                mesh.a(nArray);
                ++n2;
            }
            ++n9;
        }
        VertexElementNormal vertexElementNormal = PolygonModifier.generateNormal(mesh);
        mesh.vertexElements.add(vertexElementNormal);
        return mesh;
    }
}

