/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.BoundingBox;
import com.aspose.threed.MappingMode;
import com.aspose.threed.Matrix4;
import com.aspose.threed.Mesh;
import com.aspose.threed.Primitive;
import com.aspose.threed.Quaternion;
import com.aspose.threed.ReferenceMode;
import com.aspose.threed.Struct;
import com.aspose.threed.TextureMapping;
import com.aspose.threed.Vector3;
import com.aspose.threed.Vector4;
import com.aspose.threed.VertexElementNormal;
import com.aspose.threed.VertexElementType;
import com.aspose.threed.VertexElementUV;
import com.aspose.threed.rS;

public class Plane
extends Primitive {
    private double length;
    private double width;
    private int lengthSegments;
    private int widthSegments;
    private Vector3 up = new Vector3();

    public Plane() {
        this(1.0, 1.0);
    }

    public Vector3 getUp() {
        return Struct.byVal(this.up);
    }

    /*
     * WARNING - void declaration
     */
    public void setUp(Vector3 value) {
        void var1_1;
        this.up.copyFrom((Vector3)var1_1);
    }

    private Plane(double length, double width) {
        this("", 1.0, 1.0, 1, 1);
    }

    /*
     * WARNING - void declaration
     */
    private Plane(String name, double length, double width, int lengthSegments, int widthSegments) {
        super((String)((Object)plane));
        void var2_3;
        Plane plane;
        plane = this;
        try {
            plane.up = Vector3.getUnitY();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        this.length = var2_3;
        this.width = width;
        this.lengthSegments = 1;
        this.widthSegments = 1;
    }

    public double getLength() {
        return this.length;
    }

    /*
     * WARNING - void declaration
     */
    public void setLength(double value) {
        void var1_1;
        this.length = var1_1;
    }

    public double getWidth() {
        return this.width;
    }

    /*
     * WARNING - void declaration
     */
    public void setWidth(double value) {
        void var1_1;
        this.width = var1_1;
    }

    public int getLengthSegments() {
        return this.lengthSegments;
    }

    /*
     * WARNING - void declaration
     */
    public void setLengthSegments(int value) {
        void var1_1;
        this.lengthSegments = Math.max(1, (int)var1_1);
    }

    public int getWidthSegments() {
        return this.widthSegments;
    }

    /*
     * WARNING - void declaration
     */
    public void setWidthSegments(int value) {
        void var1_1;
        this.widthSegments = Math.max(1, (int)var1_1);
    }

    @Override
    final BoundingBox a(Matrix4 matrix4) {
        double d2 = this.width * 0.5;
        double d3 = this.length * 0.5;
        return BoundingBox.mul(new BoundingBox(-d2, 0.0, -d3, d2, 0.0, d3), matrix4);
    }

    @Override
    public Mesh toMesh() {
        Mesh mesh = this.b();
        if (this.getLengthSegments() <= 0 || this.widthSegments <= 0) {
            return mesh;
        }
        Object object = mesh.createElementUV(TextureMapping.DIFFUSE);
        mesh.createElementUV(TextureMapping.DIFFUSE).e = ReferenceMode.DIRECT;
        ((VertexElementUV)object).d = MappingMode.CONTROL_POINT;
        VertexElementNormal vertexElementNormal = (VertexElementNormal)mesh.createElement(VertexElementType.NORMAL);
        ((VertexElementNormal)mesh.createElement(VertexElementType.NORMAL)).d = MappingMode.ALL_SAME;
        vertexElementNormal.e = ReferenceMode.DIRECT;
        double d2 = this.length / (double)this.lengthSegments;
        double d3 = this.width / (double)this.widthSegments;
        double d4 = this.length * 0.5;
        double d5 = this.width * 0.5;
        for (int i2 = 0; i2 <= this.lengthSegments; ++i2) {
            double d6 = (double)i2 * d2 - d4;
            for (int i3 = 0; i3 <= this.widthSegments; ++i3) {
                double d7 = (double)i3 * d3 - d5;
                mesh.controlPoints.a(new Vector4(d7, 0.0, d6, 1.0));
                ((VertexElementUV)object).i.a(new Vector4((double)i2 / (double)this.getLengthSegments(), (double)i3 / (double)this.getWidthSegments(), 1.0, 0.0));
                if (i2 <= 0 || i3 <= 0) continue;
                mesh.createPolygon(i2 * (this.lengthSegments + 1) + i3 - 1, i2 * (this.lengthSegments + 1) + i3, (i2 - 1) * (this.lengthSegments + 1) + i3, (i2 - 1) * (this.lengthSegments + 1) + i3 - 1);
            }
        }
        if (!this.up.c(Vector3.getUnitY())) {
            Quaternion quaternion = Quaternion.fromRotation(Vector3.getUnitY(), this.up.normalize());
            for (int i4 = 0; i4 < mesh.controlPoints.b; ++i4) {
                Struct<Quaternion> struct = quaternion;
                int n2 = i4;
                object = mesh.controlPoints;
                Vector4 vector4 = ((rS)object).b(n2);
                Vector3 vector3 = new Vector3(struct.x, struct.y, struct.z);
                Vector3 vector32 = vector3.b(vector4.x, vector4.y, vector4.z);
                vector3 = vector3.cross(vector32);
                struct = Vector3.mul(Vector3.add(Vector3.mul(vector32, struct.w), vector3), 2.0);
                ((rS)object).a[n2 <<= 2] = vector4.x + ((Vector3)struct).x;
                ((rS)object).a[n2 + 1] = vector4.y + ((Vector3)struct).y;
                ((rS)object).a[n2 + 2] = vector4.z + ((Vector3)struct).z;
            }
            vertexElementNormal.i.a(Quaternion.mul(quaternion, new Vector4(0.0, 1.0, 0.0)));
        } else {
            vertexElementNormal.i.a(new Vector4(0.0, 1.0, 0.0));
        }
        return mesh;
    }
}

