/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.FMatrix4;
import com.aspose.threed.MathUtils;
import com.aspose.threed.Matrix4;
import com.aspose.threed.Struct;
import com.aspose.threed.Vector3;
import com.aspose.threed.Vector4;
import com.aspose.threed.a;
import com.aspose.threed.p;
import java.io.Serializable;

public final class Quaternion
implements Struct<Quaternion>,
Serializable {
    public static final Quaternion IDENTITY = new Quaternion(1.0, 0.0, 0.0, 0.0);
    public double w;
    public double x;
    public double y;
    public double z;
    static final long serialVersionUID = 1835321467L;

    /*
     * WARNING - void declaration
     */
    public Quaternion(double w2, double x2, double y2, double z2) {
        void var3_2;
        void var1_1;
        this.w = var1_1;
        this.x = var3_2;
        this.y = y2;
        this.z = z2;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object obj) {
        void var1_1;
        if (!(obj instanceof Quaternion)) {
            return false;
        }
        return Quaternion.op_eq(this, (Quaternion)var1_1);
    }

    public final Quaternion conjugate() {
        return new Quaternion(this.w, -this.x, -this.y, -this.z);
    }

    public final Quaternion inverse() {
        Quaternion quaternion = this;
        return Quaternion.div(this.conjugate(), quaternion.dot(quaternion));
    }

    /*
     * WARNING - void declaration
     */
    public final double dot(Quaternion q2) {
        void var1_1;
        return this.x * q2.x + this.y * q2.y + this.z * q2.z + this.w * var1_1.w;
    }

    final Vector3 a() {
        Vector3 vector3 = new Vector3();
        Quaternion quaternion = this;
        double d2 = 2.0 * (quaternion.y * quaternion.z + quaternion.w * quaternion.x);
        double d3 = quaternion.w * quaternion.w - quaternion.x * quaternion.x - quaternion.y * quaternion.y + quaternion.z * quaternion.z;
        boolean bl2 = a.a(d3);
        new Vector3().x = bl2 && a.a(d2) ? 2.0 * Math.atan2(quaternion.x, quaternion.w) : Math.atan2(d2, d3);
        quaternion = this;
        vector3.y = Math.asin(MathUtils.clamp(-2.0 * (quaternion.x * quaternion.z - quaternion.w * quaternion.y), -1.0, 1.0));
        quaternion = this;
        d2 = 2.0 * (quaternion.x * quaternion.y + quaternion.w * quaternion.z);
        d3 = quaternion.w * quaternion.w + quaternion.x * quaternion.x - quaternion.y * quaternion.y - quaternion.z * quaternion.z;
        bl2 = a.a(d3);
        vector3.z = bl2 && a.a(d2) ? 0.0 : Math.atan2(d2, d3);
        return vector3;
    }

    public final Vector3 eulerAngles() {
        double d2;
        double d3;
        double d4;
        double d5;
        Quaternion quaternion = this.normalize();
        double d6 = (0.5 - quaternion.y * quaternion.y - quaternion.z * quaternion.z) * 2.0;
        double d7 = (quaternion.z * quaternion.w + quaternion.x * quaternion.y) * 2.0;
        double d8 = (quaternion.x * quaternion.z - quaternion.y * quaternion.w) * 2.0;
        Quaternion quaternion2 = new Quaternion(d6 + 1.0, 0.0, -d8, d7);
        double d9 = quaternion2.getLength();
        if (d5 <= 0.0) {
            double d10 = 2.0 * (quaternion.w * quaternion.x + quaternion.y * quaternion.z);
            double d11 = 1.0 - 2.0 * (quaternion.x * quaternion.x + quaternion.y * quaternion.y);
            d4 = Math.atan2(d10, d11);
            double d12 = Math.sqrt(1.0 + 2.0 * (quaternion.w * quaternion.y - quaternion.x * quaternion.z));
            double d13 = Math.sqrt(1.0 - 2.0 * (quaternion.w * quaternion.y - quaternion.x * quaternion.z));
            d3 = 2.0 * Math.atan2(d12, d13) - 1.5707963267948966;
            double d14 = 2.0 * (quaternion.w * quaternion.z + quaternion.x * quaternion.y);
            double d15 = 1.0 - 2.0 * (quaternion.y * quaternion.y + quaternion.z * quaternion.z);
            d2 = Math.atan2(d14, d15);
        } else {
            double d16 = 1.0 / d9;
            quaternion2.x *= d16;
            quaternion2.y *= d16;
            quaternion2.z *= d16;
            quaternion2.w *= d16;
            double d17 = quaternion2.z * quaternion2.y * quaternion2.y * quaternion2.z;
            double d18 = 1.0;
            if (d17 > (double)1.0E-6f) {
                double d19 = Math.max(d17 * -4.0 + 1.0, 0.0);
                double d20 = Math.sqrt(d19);
                d18 = Math.sqrt((1.0 - d20) * (0.5 / d17));
            }
            d4 = Math.PI;
            if (Math.abs(quaternion.w) > (double)1.0E-6f) {
                d4 = Math.atan(quaternion.x / quaternion.w) * 2.0;
            }
            d3 = Math.asin(quaternion2.y * d18) * 2.0;
            d2 = Math.asin(quaternion2.z * d18) * 2.0;
        }
        return new Vector3(d4, d3, d2);
    }

    public final double getLength() {
        Quaternion quaternion = this;
        return Math.sqrt(quaternion.dot(quaternion));
    }

    public final Quaternion normalize() {
        double d2;
        double d3 = this.getLength();
        if (d2 < 0.0) {
            return new Quaternion(1.0, 0.0, 0.0, 0.0);
        }
        double d4 = 1.0 / d3;
        return new Quaternion(this.w * d4, this.x * d4, this.y * d4, this.z * d4);
    }

    /*
     * WARNING - void declaration
     */
    public final void toAngleAxis(double[] angle, Vector3 axis) {
        void var2_2;
        double d2;
        double d3;
        double d4;
        double d5;
        Quaternion quaternion;
        Quaternion quaternion2 = Struct.byVal(this);
        if (quaternion.w > 1.0) {
            Quaternion quaternion3 = quaternion2;
            quaternion3.copyFrom(quaternion3.normalize());
        }
        var1_1[0] = 2.0 * Math.acos(quaternion2.w);
        double d6 = Math.sqrt(1.0 - quaternion2.w * quaternion2.w);
        if (d5 < 0.001) {
            d4 = quaternion2.x;
            d3 = quaternion2.y;
            d2 = quaternion2.z;
        } else {
            d4 = quaternion2.x / d6;
            d3 = quaternion2.y / d6;
            d2 = quaternion2.z / d6;
        }
        var2_2.copyFrom(new Vector3(d4, d3, d2));
    }

    /*
     * WARNING - void declaration
     */
    public final Quaternion concat(Quaternion rhs) {
        void var1_1;
        double d2 = this.w * rhs.w - this.x * rhs.x - this.y * rhs.y - this.z * rhs.z;
        double d3 = this.w * rhs.x + this.x * rhs.w + this.y * rhs.z - this.z * rhs.y;
        double d4 = this.w * rhs.y + this.y * rhs.w + this.z * rhs.x - this.x * rhs.z;
        double d5 = this.w * rhs.z + this.z * rhs.w + this.x * rhs.y - this.y * var1_1.x;
        return new Quaternion(d2, d3, d4, d5);
    }

    /*
     * WARNING - void declaration
     */
    public static Quaternion fromAngleAxis(double a2, Vector3 axis) {
        void var2_1;
        double d2;
        double d3 = Math.sin(a2 * 0.5);
        return new Quaternion(Math.cos(d2 * 0.5), axis.x * d3, axis.y * d3, var2_1.z * d3);
    }

    /*
     * WARNING - void declaration
     */
    public static Quaternion fromRotation(Vector3 orig, Vector3 dest) {
        void var1_1;
        Vector3 vector3;
        double d2 = orig.dot(dest);
        Vector3 vector32 = new Vector3();
        if (d2 < (double)-0.9999f) {
            vector32.copyFrom(new Vector3(0.0, 0.0, 1.0).cross(orig));
            if (vector32.getLength2() < (double)1.0E-4f) {
                vector32.copyFrom(new Vector3(1.0, 0.0, 0.0).cross(orig));
            }
            Vector3 vector33 = vector32;
            vector33.copyFrom(vector33.normalize());
            return Quaternion.fromAngleAxis(Math.PI, vector32);
        }
        vector32.copyFrom(vector3.cross((Vector3)var1_1));
        double d3 = Math.sqrt((d2 + 1.0) * 2.0);
        double d4 = 1.0 / d3;
        return new Quaternion(d3 * 0.5, vector32.x * d4, vector32.y * d4, vector32.z * d4);
    }

    /*
     * WARNING - void declaration
     */
    public static Quaternion fromEulerAngle(double pitch, double yaw, double roll) {
        void var2_2;
        double d2;
        return Quaternion.fromEulerAngle(new Vector3(d2, (double)var2_2, roll));
    }

    public static Quaternion fromEulerAngle(Vector3 eulerAngle) {
        Struct<Vector3> struct;
        double d2 = 0.5 * eulerAngle.x;
        double d3 = Math.cos(d2);
        double d4 = Math.sin(d2);
        double d5 = 0.5 * eulerAngle.y;
        double d6 = Math.cos(d5);
        double d7 = Math.sin(d5);
        double d8 = 0.5 * ((Vector3)struct).z;
        double d9 = Math.cos(d8);
        double d10 = Math.sin(d8);
        struct = new Quaternion();
        new Quaternion().x = d9 * (d6 * d4);
        ((Quaternion)struct).y = d10 * d4 + d3 * d7;
        ((Quaternion)struct).z = d3 * d10 - d7 * d4;
        ((Quaternion)struct).w = d9 * (d3 * d6);
        return ((Quaternion)struct).normalize();
    }

    public final Matrix4 toMatrix() {
        Matrix4 matrix4 = new Matrix4();
        this.a(matrix4);
        return matrix4;
    }

    /*
     * WARNING - void declaration
     */
    public final Matrix4 toMatrix(Vector3 translation) {
        void var1_1;
        Matrix4 matrix4 = new Matrix4();
        this.a(matrix4);
        matrix4.m30 = translation.x;
        matrix4.m31 = translation.y;
        matrix4.m32 = var1_1.z;
        return matrix4;
    }

    final void a(Matrix4 matrix4) {
        double d2 = this.x * this.x;
        double d3 = this.x * this.y;
        double d4 = this.x * this.z;
        double d5 = this.x * this.w;
        double d6 = this.y * this.y;
        double d7 = this.y * this.z;
        double d8 = this.y * this.w;
        double d9 = this.z * this.z;
        double d10 = this.z * this.w;
        matrix4.copyFrom(new Matrix4(1.0 - 2.0 * (d6 + d9), 2.0 * (d3 + d10), 2.0 * (d4 - d8), 0.0, 2.0 * (d3 - d10), 1.0 - 2.0 * (d2 + d9), 2.0 * (d7 + d5), 0.0, 2.0 * (d4 + d8), 2.0 * (d7 - d5), 1.0 - 2.0 * (d2 + d6), 0.0, 0.0, 0.0, 0.0, 1.0));
    }

    final void a(FMatrix4 fMatrix4) {
        float f2 = (float)(this.x * this.x);
        float f3 = (float)(this.x * this.y);
        float f4 = (float)(this.x * this.z);
        float f5 = (float)(this.x * this.w);
        float f6 = (float)(this.y * this.y);
        float f7 = (float)(this.y * this.z);
        float f8 = (float)(this.y * this.w);
        float f9 = (float)(this.z * this.z);
        float f10 = (float)(this.z * this.w);
        fMatrix4.copyFrom(new FMatrix4(1.0f - 2.0f * (f6 + f9), 2.0f * (f3 + f10), 2.0f * (f4 - f8), 0.0f, 2.0f * (f3 - f10), 1.0f - 2.0f * (f2 + f9), 2.0f * (f7 + f5), 0.0f, 2.0f * (f4 + f8), 2.0f * (f7 - f5), 1.0f - 2.0f * (f2 + f6), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f));
    }

    /*
     * WARNING - void declaration
     */
    public static Quaternion add(Quaternion lhs, Quaternion rhs) {
        void var1_1;
        Quaternion quaternion;
        return new Quaternion(lhs.w + rhs.w, lhs.x + rhs.x, lhs.y + rhs.y, quaternion.z + var1_1.z);
    }

    /*
     * WARNING - void declaration
     */
    public static Quaternion div(Quaternion lhs, double rhs) {
        Quaternion quaternion;
        void var1_1;
        double d2 = 1.0 / var1_1;
        return new Quaternion(lhs.w * d2, lhs.x * d2, lhs.y * d2, quaternion.z * d2);
    }

    /*
     * WARNING - void declaration
     */
    public static Quaternion mul(Quaternion lhs, double rhs) {
        void var1_1;
        Quaternion quaternion;
        return new Quaternion(lhs.w * rhs, lhs.x * rhs, lhs.y * rhs, quaternion.z * var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Quaternion mul(Quaternion lhs, Quaternion rhs) {
        void var1_1;
        Quaternion quaternion;
        return new Quaternion(lhs.w * rhs.w, lhs.x * rhs.x, lhs.y * rhs.y, quaternion.z * var1_1.z);
    }

    /*
     * WARNING - void declaration
     */
    public static Vector3 mul(Quaternion q2, Vector3 v2) {
        Quaternion quaternion;
        void var1_1;
        Vector3 vector3 = new Vector3(q2.x, q2.y, q2.z);
        Vector3 vector32 = vector3.cross(v2);
        vector3 = vector3.cross(vector32);
        return Vector3.add((Vector3)var1_1, Vector3.mul(Vector3.add(Vector3.mul(vector32, quaternion.w), vector3), 2.0));
    }

    /*
     * WARNING - void declaration
     */
    public static Vector4 mul(Quaternion q2, Vector4 v2) {
        void var1_1;
        Struct<Quaternion> struct;
        Vector3 vector3 = new Vector3(q2.x, q2.y, q2.z);
        Vector3 vector32 = vector3.b(v2.x, v2.y, v2.z);
        vector3 = vector3.cross(vector32);
        struct = Vector3.mul(Vector3.add(Vector3.mul(vector32, struct.w), vector3), 2.0);
        return new Vector4(v2.x + ((Vector3)struct).x, v2.y + ((Vector3)struct).y, v2.z + ((Vector3)struct).z, var1_1.w);
    }

    public final String toString() {
        return String.format("(%.3f %.3f %.3f %.3f)", this.w, this.x, this.y, this.z);
    }

    public static Vector3 mul(Vector3 v2, Quaternion q2) {
        Vector3 vector3;
        return Quaternion.mul(q2.inverse(), vector3);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean op_eq(Quaternion lhs, Quaternion rhs) {
        void var1_1;
        Quaternion quaternion;
        return lhs.x == rhs.x && lhs.y == rhs.y && lhs.z == rhs.z && quaternion.w == var1_1.w;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean op_ne(Quaternion lhs, Quaternion rhs) {
        void var1_1;
        Quaternion quaternion;
        return lhs.x != rhs.x || lhs.y != rhs.y || lhs.z != rhs.z || quaternion.w != var1_1.w;
    }

    /*
     * WARNING - void declaration
     */
    public static Quaternion interpolate(float t2, Quaternion from, Quaternion to2) {
        void var1_2;
        float f2;
        double d2;
        Quaternion quaternion = new Quaternion();
        double d3 = from.w * to2.w + from.x * to2.x + from.y * to2.y + from.z * to2.z;
        if (d2 < 0.0) {
            quaternion.w = -to2.x;
            quaternion.x = -to2.y;
            quaternion.y = -to2.z;
            quaternion.z = -to2.w;
        } else {
            void var2_3;
            quaternion.w = to2.x;
            quaternion.x = to2.y;
            quaternion.y = to2.z;
            quaternion.z = var2_3.w;
        }
        double d4 = 1.0f - t2;
        double d5 = f2;
        Quaternion quaternion2 = new Quaternion();
        new Quaternion().x = d4 * from.x + d5 * quaternion.w;
        quaternion2.y = d4 * from.y + d5 * quaternion.x;
        quaternion2.z = d4 * from.z + d5 * quaternion.y;
        quaternion2.w = d4 * var1_2.w + d5 * quaternion.z;
        return quaternion2;
    }

    /*
     * WARNING - void declaration
     */
    public static Quaternion slerp(double t2, Quaternion v1, Quaternion v2) {
        void var3_2;
        void var2_1;
        double d2;
        double d3 = v1.dot(v2);
        double d4 = Math.acos(Math.abs(d3));
        if (Double.isNaN(d4)) {
            return Struct.byVal(v1);
        }
        int n2 = (int)Math.signum(d4);
        double d5 = Math.sin(d4);
        double d6 = Math.sin(d4 * (1.0 - t2)) / d5;
        double d7 = (double)n2 * Math.sin(d4 * d2) / d5;
        return new Quaternion(d6 * v1.w + d7 * v2.w, d6 * v1.x + d7 * v2.x, d6 * v1.y + d7 * v2.y, d6 * var2_1.z + d7 * var3_2.z);
    }

    public Quaternion() {
    }

    /*
     * WARNING - void declaration
     */
    private Quaternion(Quaternion other) {
        void var1_1;
        this.w = other.w;
        this.x = other.x;
        this.y = other.y;
        this.z = var1_1.z;
    }

    @Override
    public final Quaternion clone() {
        return new Quaternion(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void copyFrom(Quaternion src) {
        void var1_1;
        if (src == null) {
            return;
        }
        this.w = src.w;
        this.x = src.x;
        this.y = src.y;
        this.z = var1_1.z;
    }

    public final int hashCode() {
        return p.a(this.x) ^ p.a(this.y) ^ p.a(this.z) ^ p.a(this.w);
    }
}

