/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.barcode.complexbarcode;

import com.aspose.barcode.BarCodeException;
import com.aspose.barcode.complexbarcode.HIBCLICCombinedCodetext;
import com.aspose.barcode.complexbarcode.HIBCLICPrimaryDataCodetext;
import com.aspose.barcode.complexbarcode.HIBCLICSecondaryAndAdditionalDataCodetext;
import com.aspose.barcode.complexbarcode.IComplexCodetext;
import com.aspose.barcode.generation.BaseEncodeType;
import com.aspose.barcode.generation.EncodeTypes;
import com.aspose.barcode.internal.yyt.qqd;
import com.aspose.barcode.internal.yyt.ttr;

public abstract class HIBCLICComplexCodetext
implements IComplexCodetext {
    private BaseEncodeType a = EncodeTypes.HIBC_CODE_39_LIC;

    @Override
    public abstract String getConstructedCodetext();

    @Override
    public abstract void initFromString(String var1);

    public void setBarcodeType(BaseEncodeType value) {
        if (value != EncodeTypes.HIBC_CODE_39_LIC && value != EncodeTypes.HIBC_CODE_128_LIC && value != EncodeTypes.HIBC_AZTEC_LIC && value != EncodeTypes.HIBC_DATA_MATRIX_LIC && value != EncodeTypes.HIBCQRLIC) {
            throw new BarCodeException("Encode type is not supported.");
        }
        this.a = value;
    }

    @Override
    public BaseEncodeType getBarcodeType() {
        return this.a;
    }

    static HIBCLICComplexCodetext a(String string) {
        HIBCLICComplexCodetext hIBCLICComplexCodetext;
        if (ttr.b(string) || string.length() < 2) {
            throw new BarCodeException("Codetext is too short");
        }
        int n = ttr.d(string, '/');
        if (qqd.e(string.charAt(1)) || string.charAt(1) == '$') {
            hIBCLICComplexCodetext = new HIBCLICSecondaryAndAdditionalDataCodetext();
        } else if (qqd.p(string.charAt(1)) && (n == -1 || n == string.length() - 1)) {
            hIBCLICComplexCodetext = new HIBCLICPrimaryDataCodetext();
        } else if (qqd.p(string.charAt(1)) && n != -1 && n != string.length() - 1) {
            hIBCLICComplexCodetext = new HIBCLICCombinedCodetext();
        } else {
            throw new BarCodeException("Codetext is not HIBC LIC codetext");
        }
        return hIBCLICComplexCodetext;
    }
}

