/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.barcode.complexbarcode;

import com.aspose.barcode.BarCodeException;
import com.aspose.barcode.complexbarcode.HIBCLICComplexCodetext;
import com.aspose.barcode.complexbarcode.PrimaryData;
import com.aspose.barcode.internal.wwe.vv;
import com.aspose.barcode.internal.wwx.tt;
import com.aspose.barcode.internal.yyt.ttr;

public class HIBCLICPrimaryDataCodetext
extends HIBCLICComplexCodetext {
    private PrimaryData a = new PrimaryData();

    public PrimaryData getData() {
        return this.a;
    }

    public void setData(PrimaryData value) {
        this.a = value;
    }

    @Override
    public String getConstructedCodetext() {
        String string = "+" + this.getData().toString();
        String string2 = new vv(string).a();
        if (string2 == null) {
            throw new BarCodeException("Can not calculcate checkchar. Only numbers, capital letters and '-', '.', ' ', '$', '/', '+', '%' symbols are allowed in HIBC LIC.");
        }
        string = string + string2;
        return string;
    }

    @Override
    public void initFromString(String constructedCodetext) {
        if (ttr.b(constructedCodetext)) {
            throw new BarCodeException("Codetext is empty.");
        }
        if (constructedCodetext.length() < 2) {
            throw new BarCodeException("Codetext is too short.");
        }
        if (constructedCodetext.charAt(0) != '+') {
            throw new BarCodeException("Incorrectly encoded HIBC Supplier Labeling Flag Character '+'.");
        }
        String string = new vv(ttr.b(constructedCodetext, 0, constructedCodetext.length() - 1)).a();
        if (string == null || constructedCodetext.charAt(constructedCodetext.length() - 1) != string.charAt(0)) {
            throw new BarCodeException("Incorrect check char");
        }
        this.setData(new PrimaryData());
        this.getData().parseFromString(ttr.b(constructedCodetext, 1, constructedCodetext.length() - 2));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!tt.b(obj, HIBCLICPrimaryDataCodetext.class)) {
            return false;
        }
        HIBCLICPrimaryDataCodetext hIBCLICPrimaryDataCodetext = (HIBCLICPrimaryDataCodetext)obj;
        return this.getData().equals(hIBCLICPrimaryDataCodetext.getData());
    }

    public int hashCode() {
        int n = -318392964;
        n = n * -1521134295 + this.getBarcodeType().hashCode();
        n = n * -1521134295 + this.getData().hashCode();
        return n;
    }
}

