/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.barcode.complexbarcode;

import com.aspose.barcode.BarCodeException;
import com.aspose.barcode.internal.qqr.rr;
import com.aspose.barcode.internal.wwx.tt;
import com.aspose.barcode.internal.yyt.eee;
import com.aspose.barcode.internal.yyt.qqd;
import com.aspose.barcode.internal.yyt.ttr;

public class PrimaryData {
    private String a;
    private String b;
    private int c = -1;

    public String getLabelerIdentificationCode() {
        return this.a;
    }

    public void setLabelerIdentificationCode(String value) {
        if (ttr.b(value)) {
            throw new BarCodeException("Labeler identification code cannot be null or empty.");
        }
        if (value.length() != 4) {
            throw new BarCodeException("Labeler identification code's length must be equal to 4.");
        }
        if (!qqd.p(value.charAt(0))) {
            throw new BarCodeException("First character of labeler identification code must be uppercase letter.");
        }
        if (!rr.b(value, true)) {
            throw new BarCodeException("Labeler identification code must be alphanumeric string.");
        }
        this.a = value;
    }

    public String getProductOrCatalogNumber() {
        return this.b;
    }

    public void setProductOrCatalogNumber(String value) {
        if (ttr.b(value)) {
            throw new BarCodeException("Product or catalog number cannot be null or empty.");
        }
        if (!rr.b(value, true)) {
            throw new BarCodeException("Product or catalog number must be alphanumeric string.");
        }
        if (value.length() > 18) {
            throw new BarCodeException("Product or catalog number's length must be up to 18 symbols.");
        }
        this.b = value;
    }

    public int getUnitOfMeasureID() {
        return this.c;
    }

    public void setUnitOfMeasureID(int value) {
        if (value < 0 || value > 9) {
            throw new BarCodeException("Unit of measure ID must be an integer value between 0 and 9.");
        }
        this.c = value;
    }

    public String toString() {
        if (ttr.b(this.getLabelerIdentificationCode())) {
            throw new BarCodeException("Labeler identification code cannot be null or empty.");
        }
        if (ttr.b(this.getProductOrCatalogNumber())) {
            throw new BarCodeException("Product or catalog number cannot be null or empty.");
        }
        if (this.getUnitOfMeasureID() < 0) {
            throw new BarCodeException("Unit of measure must be an integer value between 0 and 9.");
        }
        String string = ttr.a(new String[]{this.getLabelerIdentificationCode(), this.getProductOrCatalogNumber(), eee.b(this.getUnitOfMeasureID())});
        return string;
    }

    public void parseFromString(String primaryDataCodetext) {
        if (primaryDataCodetext.length() < 6) {
            throw new BarCodeException("Primary data codetext is too short.");
        }
        this.setLabelerIdentificationCode(ttr.b(primaryDataCodetext, 0, 4));
        this.setProductOrCatalogNumber(ttr.b(primaryDataCodetext, 4, primaryDataCodetext.length() - 5));
        int[] nArray = new int[]{this.c};
        boolean bl = !eee.a(ttr.b(primaryDataCodetext, primaryDataCodetext.length() - 1, 1), nArray);
        this.c = nArray[0];
        if (bl) {
            throw new BarCodeException("Incorrectly encoded unit of measure ID");
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!tt.b(obj, PrimaryData.class)) {
            return false;
        }
        PrimaryData primaryData = (PrimaryData)obj;
        return this.getUnitOfMeasureID() == primaryData.getUnitOfMeasureID() && (ttr.e(this.getLabelerIdentificationCode(), primaryData.getLabelerIdentificationCode()) || ttr.b(this.getLabelerIdentificationCode()) && ttr.b(primaryData.getLabelerIdentificationCode())) && (ttr.e(this.getProductOrCatalogNumber(), primaryData.getProductOrCatalogNumber()) || ttr.b(this.getProductOrCatalogNumber()) && ttr.b(primaryData.getProductOrCatalogNumber()));
    }

    public int hashCode() {
        int n = -402159212;
        n = n * -1521134295 + this.a.hashCode();
        n = n * -1521134295 + this.b.hashCode();
        n = n * -1521134295 + eee.a(this.c);
        return n;
    }
}

