/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.barcode.generation;

import com.aspose.barcode.InvalidCodeException;
import com.aspose.barcode.barcoderecognition.CustomerInformationInterpretingType;
import com.aspose.barcode.generation.AutoSizeMode;
import com.aspose.barcode.generation.AztecEncodeMode;
import com.aspose.barcode.generation.AztecSymbolMode;
import com.aspose.barcode.generation.BarCodeImageFormat;
import com.aspose.barcode.generation.BaseEncodeType;
import com.aspose.barcode.generation.BaseGenerationParameters;
import com.aspose.barcode.generation.BorderDashStyle;
import com.aspose.barcode.generation.CodabarChecksumMode;
import com.aspose.barcode.generation.CodeLocation;
import com.aspose.barcode.generation.DataMatrixEccType;
import com.aspose.barcode.generation.DataMatrixEncodeMode;
import com.aspose.barcode.generation.DataMatrixVersion;
import com.aspose.barcode.generation.DotCodeEncodeMode;
import com.aspose.barcode.generation.EnableChecksum;
import com.aspose.barcode.generation.EncodeTypes;
import com.aspose.barcode.generation.FontMode;
import com.aspose.barcode.generation.FontUnit;
import com.aspose.barcode.generation.GraphicsUnit;
import com.aspose.barcode.generation.HanXinEncodeMode;
import com.aspose.barcode.generation.HanXinErrorLevel;
import com.aspose.barcode.generation.HanXinVersion;
import com.aspose.barcode.generation.ITF14BorderType;
import com.aspose.barcode.generation.MacroCharacter;
import com.aspose.barcode.generation.MaxiCodeEncodeMode;
import com.aspose.barcode.generation.MicroQRVersion;
import com.aspose.barcode.generation.Pdf417CompactionMode;
import com.aspose.barcode.generation.Pdf417ErrorLevel;
import com.aspose.barcode.generation.Pdf417MacroTerminator;
import com.aspose.barcode.generation.QREncodeMode;
import com.aspose.barcode.generation.QREncodeType;
import com.aspose.barcode.generation.QRErrorLevel;
import com.aspose.barcode.generation.QRVersion;
import com.aspose.barcode.generation.RectMicroQRVersion;
import com.aspose.barcode.generation.TextAlignment;
import com.aspose.barcode.generation.TwoDComponentType;
import com.aspose.barcode.generation.Unit;
import com.aspose.barcode.generation.qqd;
import com.aspose.barcode.generation.ww;
import com.aspose.barcode.internal.bbr.aa;
import com.aspose.barcode.internal.eex.dd;
import com.aspose.barcode.internal.ffr.ddq;
import com.aspose.barcode.internal.jjr.ii;
import com.aspose.barcode.internal.kke.qq;
import com.aspose.barcode.internal.ms.System.Text.bbd;
import com.aspose.barcode.internal.ms.System.Text.jj;
import com.aspose.barcode.internal.ms.System.Text.ll;
import com.aspose.barcode.internal.ms.System.Text.vv;
import com.aspose.barcode.internal.nnt.uud;
import com.aspose.barcode.internal.nnt.xx;
import com.aspose.barcode.internal.oox.ee;
import com.aspose.barcode.internal.uux.yy;
import com.aspose.barcode.internal.wwx.tt;
import com.aspose.barcode.internal.yyt.ttr;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.time.Instant;
import java.time.ZoneId;

public final class BarcodeGenerator {
    private BaseGenerationParameters a = new BaseGenerationParameters();
    private aa b;
    private boolean c;

    public BaseGenerationParameters getParameters() {
        return this.a;
    }

    public BaseEncodeType getBarcodeType() {
        return this.getParameters().getBarcode().getBarcodeType();
    }

    public void setBarcodeType(BaseEncodeType value) {
        if (this.getParameters().getBarcode().getBarcodeType() != value) {
            this.getParameters().getBarcode().a(value);
            com.aspose.barcode.internal.ffr.bbd bbd2 = ddq.a(this.getParameters().getBarcode().getBarcodeType());
            bbd2.a(this.getParameters());
        }
    }

    public String getCodeText() {
        return this.getParameters().getBarcode().getCodeText();
    }

    public void setCodeText(String value) {
        this.getParameters().getBarcode().setCodeText(value);
    }

    public BarcodeGenerator(BaseEncodeType type) {
        this.getParameters().getBarcode().a(type);
        this.b();
    }

    BarcodeGenerator() {
        this.b();
    }

    public BarcodeGenerator(BaseEncodeType type, String codeText) {
        this(type);
        this.getParameters().getBarcode().setCodeText(codeText);
    }

    public void setCodeText(byte[] codeBytes) {
        bbd bbd2 = new bbd();
        for (byte by : codeBytes) {
            bbd2.a(tt.l(by, 6));
        }
        this.setCodeText(bbd2.toString());
    }

    public void setCodeText(String codeText, Charset encoding) {
        this.setCodeText(codeText, encoding, true);
    }

    public void setCodeText(String codeText, Charset encoding, boolean insertBOM) {
        byte[] byArray;
        vv vv2 = vv.getEncoding(vv.fromJava(encoding).getCodePage(), jj.d(), com.aspose.barcode.internal.ms.System.Text.ii.d());
        try {
            byArray = vv2.getBytes(codeText);
        }
        catch (ll ll2) {
            throw new InvalidCodeException(ttr.a("String \"{0}\" cannot be encoded with selected {1} encoding.", new Object[]{codeText, vv.fromJava(encoding).getBodyName()}));
        }
        bbd bbd2 = new bbd();
        if (insertBOM) {
            for (byte by : vv2.getPreamble()) {
                bbd2.a(tt.l(by, 6));
            }
        }
        for (byte by : byArray) {
            bbd2.a(tt.l(by, 6));
        }
        this.setCodeText(bbd2.toString());
    }

    public BufferedImage generateBarCodeImage() {
        ww ww2 = this.a(this.getParameters());
        com.aspose.barcode.internal.fft.ww ww3 = ww2.a();
        com.aspose.barcode.internal.eex.yy yy2 = new com.aspose.barcode.internal.eex.yy(ww3);
        yy2.a();
        return ww3.e();
    }

    public void save(OutputStream stream, BarCodeImageFormat format) throws IOException {
        ww ww2 = this.a(this.getParameters());
        xx xx2 = new xx();
        dd dd2 = new dd(xx2);
        ((uud)xx2).a(0L);
        ww2.a(xx2, format);
        ((uud)xx2).a(0L);
        byte[] byArray = new byte[(int)((uud)xx2).f()];
        ((uud)xx2).a(byArray, 0, byArray.length);
        stream.write(byArray, 0, byArray.length);
        stream.flush();
        stream.close();
        dd2.a();
    }

    public void save(String filename, BarCodeImageFormat format) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(filename);
        this.save(fileOutputStream, format);
    }

    public void save(String filename) throws IOException {
        this.save(filename, com.aspose.barcode.internal.kke.ww.a(com.aspose.barcode.internal.nnt.qqd.e(filename)));
    }

    public boolean exportToXml(String xmlFile) {
        com.aspose.barcode.internal.ttx.ee ee2 = new com.aspose.barcode.internal.ttx.ee(this);
        return ee2.a(xmlFile);
    }

    public boolean exportToXml(OutputStream xml) throws IOException {
        com.aspose.barcode.internal.ttx.ee ee2 = new com.aspose.barcode.internal.ttx.ee(this);
        xx xx2 = new xx();
        boolean bl = ee2.a(xx2);
        xml.write(xx2.j());
        return bl;
    }

    public static BarcodeGenerator importFromXml(String xmlFile) {
        BarcodeGenerator barcodeGenerator = new BarcodeGenerator(EncodeTypes.CODE_39);
        com.aspose.barcode.internal.ttx.ee ee2 = new com.aspose.barcode.internal.ttx.ee(barcodeGenerator);
        ee2.b(xmlFile);
        return barcodeGenerator;
    }

    public static BarcodeGenerator importFromXml(InputStream xml) {
        BarcodeGenerator barcodeGenerator = new BarcodeGenerator(EncodeTypes.CODE_39);
        com.aspose.barcode.internal.ttx.ee ee2 = new com.aspose.barcode.internal.ttx.ee(barcodeGenerator);
        ee2.b(uud.b(xml));
        return barcodeGenerator;
    }

    private ww a(BaseGenerationParameters baseGenerationParameters) {
        this.b(baseGenerationParameters);
        this.b = new aa(baseGenerationParameters.getResolution(), new qq(baseGenerationParameters.getUseAntiAlias()));
        return new ww(baseGenerationParameters, new com.aspose.barcode.internal.nnr.qq(this.b, baseGenerationParameters.getCaptionAbove()), new com.aspose.barcode.internal.nnr.qq(this.b, baseGenerationParameters.getCaptionBelow()), ii.a(baseGenerationParameters.getBarcode(), this.b));
    }

    private void b(BaseGenerationParameters baseGenerationParameters) {
        com.aspose.barcode.internal.gge.ww<yy> ww2 = new com.aspose.barcode.internal.gge.ww<yy>(yy.c);
        com.aspose.barcode.internal.gge.ww<Object> ww3 = new com.aspose.barcode.internal.gge.ww<Object>(null);
        baseGenerationParameters.c().a(new com.aspose.barcode.internal.gge.ww<String>(ee.a(baseGenerationParameters.getBarcode().getBarcodeType())), ww2, ww3);
        if (yy.b != ww2.a) {
            baseGenerationParameters.a((com.aspose.barcode.internal.oox.ii)ww3.a);
        }
    }

    private void b() {
        this.getParameters().setBackColor(Color.WHITE);
        this.getParameters().setRotationAngle(0.0f);
        this.getParameters().setUseAntiAlias(true);
        this.getParameters().setImageWidth(new Unit(100.0f, GraphicsUnit.POINT));
        this.getParameters().setImageHeight(new Unit(60.0f, GraphicsUnit.POINT));
        this.getParameters().getBarcode().setBarHeight(new Unit(15.0f, GraphicsUnit.POINT));
        this.getParameters().getBarcode().setXDimension(new Unit(1.0f, GraphicsUnit.POINT));
        this.getParameters().getBarcode().setThrowExceptionWhenCodeTextIncorrect(false);
        this.getParameters().getBorder().setWidth(qqd.a(0.0f, GraphicsUnit.POINT));
        this.getParameters().getBorder().setColor(Color.BLACK);
        this.getParameters().getBorder().setDashStyle(BorderDashStyle.SOLID);
        this.getParameters().getBorder().setVisible(false);
        this.getParameters().getBarcode().setChecksumEnabled(EnableChecksum.DEFAULT);
        this.getParameters().getBarcode().setEnableEscape(false);
        this.getParameters().getBarcode().setChecksumAlwaysShow(false);
        this.getParameters().getCaptionAbove().setTextColor(Color.BLACK);
        this.getParameters().getCaptionAbove().setText("");
        this.getParameters().getCaptionAbove().setAlignment(TextAlignment.CENTER);
        this.getParameters().getCaptionAbove().setVisible(false);
        this.getParameters().getCaptionAbove().a(new FontUnit("Arial", 8.0f, GraphicsUnit.POINT, 96.0f, 0));
        this.getParameters().getCaptionAbove().getPadding().setTop(qqd.a(5.0f, GraphicsUnit.POINT));
        this.getParameters().getCaptionAbove().getPadding().setBottom(qqd.a(0.0f, GraphicsUnit.POINT));
        this.getParameters().getCaptionAbove().getPadding().setLeft(qqd.a(5.0f, GraphicsUnit.POINT));
        this.getParameters().getCaptionAbove().getPadding().setRight(qqd.a(5.0f, GraphicsUnit.POINT));
        this.getParameters().getCaptionBelow().setTextColor(Color.BLACK);
        this.getParameters().getCaptionBelow().setText("");
        this.getParameters().getCaptionBelow().setAlignment(TextAlignment.CENTER);
        this.getParameters().getCaptionBelow().setVisible(false);
        this.getParameters().getCaptionBelow().a(new FontUnit("Arial", 8.0f, GraphicsUnit.POINT, 96.0f, 0));
        this.getParameters().getCaptionBelow().getPadding().setTop(qqd.a(0.0f, GraphicsUnit.POINT));
        this.getParameters().getCaptionBelow().getPadding().setBottom(qqd.a(5.0f, GraphicsUnit.POINT));
        this.getParameters().getCaptionBelow().getPadding().setLeft(qqd.a(5.0f, GraphicsUnit.POINT));
        this.getParameters().getCaptionBelow().getPadding().setRight(qqd.a(5.0f, GraphicsUnit.POINT));
        this.getParameters().getBarcode().setCodeText("0123456789");
        this.getParameters().getBarcode().getCodeTextParameters().setLocation(CodeLocation.BELOW);
        this.getParameters().getBarcode().getCodeTextParameters().setFontMode(FontMode.AUTO);
        this.getParameters().getBarcode().getCodeTextParameters().setSpace(new Unit(2.0f, GraphicsUnit.POINT));
        this.getParameters().getBarcode().setBarColor(Color.BLACK);
        this.getParameters().getBarcode().setBarWidthReduction(qqd.a(0.0f, GraphicsUnit.POINT));
        this.getParameters().getBarcode().getPadding().setLeft(qqd.a(5.0f, GraphicsUnit.POINT));
        this.getParameters().getBarcode().getPadding().setRight(qqd.a(5.0f, GraphicsUnit.POINT));
        this.getParameters().getBarcode().getPadding().setTop(qqd.a(5.0f, GraphicsUnit.POINT));
        this.getParameters().getBarcode().getPadding().setBottom(qqd.a(5.0f, GraphicsUnit.POINT));
        this.getParameters().getBarcode().getITF().setItfBorderThickness(qqd.a(12.0f, GraphicsUnit.POINT));
        this.getParameters().getBarcode().getITF().setItfBorderType(ITF14BorderType.BAR);
        this.getParameters().getBarcode().getITF().setQuietZoneCoef(10);
        this.getParameters().getBarcode().getCode16K().setQuietZoneLeftCoef(10);
        this.getParameters().getBarcode().getCode16K().setQuietZoneRightCoef(1);
        this.getParameters().getBarcode().getCode16K().setAspectRatio(8.0f);
        this.getParameters().getBarcode().getCoupon().setSupplementSpace(qqd.a(10.0f, GraphicsUnit.POINT));
        this.getParameters().getBarcode().getSupplement().a(qqd.a(10.0f, GraphicsUnit.POINT));
        this.getParameters().getBarcode().getAustralianPost().setAustralianPostShortBarHeight(new Unit(0.0f, GraphicsUnit.POINT));
        this.getParameters().getBarcode().getPostal().setPostalShortBarHeight(new Unit(0.0f, GraphicsUnit.POINT));
        this.getParameters().getBarcode().getAztec().setAspectRatio(1.0f);
        this.getParameters().getBarcode().getMaxiCode().setAspectRatio(0.8660258f);
        this.getParameters().getBarcode().getQR().setAspectRatio(1.0f);
        this.getParameters().getBarcode().getDotCode().setAspectRatio(1.0f);
        this.getParameters().getBarcode().getDataMatrix().setAspectRatio(1.0f);
        this.getParameters().getBarcode().getCodablock().setAspectRatio(1.0f);
        this.getParameters().getBarcode().getDataBar().setAspectRatio(1.0f);
        this.getParameters().setResolution(qqd.a);
        this.getParameters().getBarcode().getSupplement().setSupplementData("");
        this.getParameters().getBarcode().getMaxiCode().setMaxiCodeMode(4);
        this.getParameters().getBarcode().getMaxiCode().setMaxiCodeStructuredAppendModeBarcodeId(0);
        this.getParameters().getBarcode().getMaxiCode().setMaxiCodeStructuredAppendModeBarcodesCount(-1);
        this.getParameters().getBarcode().getMaxiCode().setMaxiCodeEncodeMode(MaxiCodeEncodeMode.AUTO);
        this.getParameters().getBarcode().getMaxiCode().setECIEncoding(26);
        this.getParameters().getBarcode().getPdf417().setPdf417CompactionMode(Pdf417CompactionMode.AUTO);
        this.getParameters().getBarcode().getPdf417().setPdf417MacroFileName("");
        this.getParameters().getBarcode().getPdf417().setPdf417MacroTimeStamp(Instant.EPOCH.atZone(ZoneId.of("UTC")).toLocalDateTime());
        this.getParameters().getBarcode().getPdf417().setPdf417MacroSender("");
        this.getParameters().getBarcode().getPdf417().setPdf417MacroAddressee("");
        this.getParameters().getBarcode().getPdf417().setPdf417MacroFileID(-1);
        this.getParameters().getBarcode().getPdf417().setPdf417MacroSegmentID(0);
        this.getParameters().getBarcode().getPdf417().setPdf417MacroSegmentsCount(0);
        this.getParameters().getBarcode().getPdf417().setPdf417MacroTerminator(Pdf417MacroTerminator.AUTO);
        this.getParameters().getBarcode().getPdf417().setPdf417ErrorLevel(Pdf417ErrorLevel.LEVEL_2);
        this.getParameters().getBarcode().getPdf417().setPdf417Truncate(false);
        this.getParameters().getBarcode().getPdf417().setAspectRatio(3.0f);
        this.getParameters().getBarcode().getPdf417().setColumns(0);
        this.getParameters().getBarcode().getPdf417().setRows(0);
        this.getParameters().getBarcode().getPdf417().setPdf417MacroChecksum(0);
        this.getParameters().getBarcode().getPdf417().setPdf417ECIEncoding(26);
        this.getParameters().getBarcode().getPdf417().setPdf417MacroECIEncoding(26);
        this.getParameters().getBarcode().getPdf417().setReaderInitialization(false);
        this.getParameters().getBarcode().getPdf417().setMacroCharacters(MacroCharacter.NONE);
        this.getParameters().getBarcode().getPdf417().setLinked(false);
        this.getParameters().getBarcode().getPdf417().setCode128Emulation(false);
        this.getParameters().getBarcode().getGS1CompositeBar().setLinearComponentType(EncodeTypes.EAN_8);
        this.getParameters().getBarcode().getGS1CompositeBar().setTwoDComponentType(TwoDComponentType.AUTO);
        this.getParameters().getBarcode().getGS1CompositeBar().setAllowOnlyGS1Encoding(true);
        this.getParameters().getBarcode().setWideNarrowRatio(3.0f);
        this.getParameters().getBarcode().setFilledBars(true);
        this.getParameters().setAutoSizeMode(AutoSizeMode.NONE);
        this.getParameters().getBarcode().getAustralianPost().setAustralianPostEncodingTable(CustomerInformationInterpretingType.C_TABLE);
        this.getParameters().getBarcode().getAztec().setAztecSymbolMode(AztecSymbolMode.AUTO);
        this.getParameters().getBarcode().getAztec().setAztecErrorLevel(23);
        this.getParameters().getBarcode().getAztec().setAztecEncodeMode(AztecEncodeMode.AUTO);
        this.getParameters().getBarcode().getAztec().setECIEncoding(26);
        this.getParameters().getBarcode().getAztec().setStructuredAppendBarcodeId(0);
        this.getParameters().getBarcode().getAztec().setStructuredAppendBarcodesCount(0);
        this.getParameters().getBarcode().getAztec().setStructuredAppendFileId(ttr.a);
        this.getParameters().getBarcode().getAztec().setReaderInitialization(false);
        this.getParameters().getBarcode().getAztec().setLayersCount(0);
        this.getParameters().getBarcode().getCodabar().setCodabarChecksumMode(CodabarChecksumMode.MOD_16);
        this.getParameters().getBarcode().getCodabar().setCodabarStartSymbol((short)65);
        this.getParameters().getBarcode().getCodabar().setCodabarStopSymbol((short)65);
        this.getParameters().getBarcode().getDotCode().setDotCodeStructuredAppendModeBarcodeId(-1);
        this.getParameters().getBarcode().getDotCode().setDotCodeStructuredAppendModeBarcodesCount(-1);
        this.getParameters().getBarcode().getDotCode().setDotCodeEncodeMode(DotCodeEncodeMode.AUTO);
        this.getParameters().getBarcode().getDotCode().setECIEncoding(26);
        this.getParameters().getBarcode().getDotCode().setReaderInitialization(false);
        this.getParameters().getBarcode().getDotCode().setRows(-1);
        this.getParameters().getBarcode().getDotCode().setColumns(-1);
        this.getParameters().getBarcode().getDataMatrix().setDataMatrixEcc(DataMatrixEccType.ECC_200);
        this.getParameters().getBarcode().getDataMatrix().setDataMatrixEncodeMode(DataMatrixEncodeMode.AUTO);
        this.getParameters().getBarcode().getDataMatrix().setStructuredAppendBarcodeId(0);
        this.getParameters().getBarcode().getDataMatrix().setStructuredAppendBarcodesCount(0);
        this.getParameters().getBarcode().getDataMatrix().setStructuredAppendFileId(0);
        this.getParameters().getBarcode().getDataMatrix().setECIEncoding(26);
        this.getParameters().getBarcode().getDataMatrix().setDataMatrixVersion(DataMatrixVersion.AUTO);
        this.getParameters().getBarcode().getDataMatrix().setReaderProgramming(false);
        this.getParameters().getBarcode().getQR().setQrEncodeMode(QREncodeMode.AUTO);
        this.getParameters().getBarcode().getQR().setQrVersion(QRVersion.AUTO);
        this.getParameters().getBarcode().getQR().setMicroQRVersion(MicroQRVersion.AUTO);
        this.getParameters().getBarcode().getQR().setRectMicroQrVersion(RectMicroQRVersion.AUTO);
        this.getParameters().getBarcode().getQR().setQrEncodeType(QREncodeType.FORCE_QR);
        this.getParameters().getBarcode().getQR().setQrECIEncoding(26);
        this.getParameters().getBarcode().getQR().setQrErrorLevel(this.getParameters().getBarcode().getBarcodeType() == EncodeTypes.RECT_MICRO_QR ? QRErrorLevel.LEVEL_M : QRErrorLevel.LEVEL_L);
        this.getParameters().getBarcode().getHanXin().setHanXinErrorLevel(HanXinErrorLevel.L1);
        this.getParameters().getBarcode().getHanXin().setHanXinVersion(HanXinVersion.AUTO);
        this.getParameters().getBarcode().getHanXin().setHanXinEncodeMode(HanXinEncodeMode.AUTO);
        this.getParameters().getBarcode().getHanXin().setHanXinECIEncoding(26);
        com.aspose.barcode.internal.ffr.bbd bbd2 = ddq.a(this.getParameters().getBarcode().getBarcodeType());
        bbd2.a(this.getParameters());
        this.getParameters().getCaptionAbove().getPadding().getTop().a(new com.aspose.barcode.internal.ggr.qq("CaptionAbove.Padding.Top"));
        this.getParameters().getCaptionAbove().getPadding().getRight().a(new com.aspose.barcode.internal.ggr.qq("CaptionAbove.Padding.Right"));
        this.getParameters().getCaptionAbove().getPadding().getLeft().a(new com.aspose.barcode.internal.ggr.qq("CaptionAbove.Padding.Left"));
        this.getParameters().getCaptionAbove().getPadding().getBottom().a(new com.aspose.barcode.internal.ggr.qq("CaptionAbove.Padding.Bottom"));
        this.getParameters().getCaptionBelow().getPadding().getTop().a(new com.aspose.barcode.internal.ggr.qq("CaptionBelow.Padding.Top"));
        this.getParameters().getCaptionBelow().getPadding().getRight().a(new com.aspose.barcode.internal.ggr.qq("CaptionBelow.Padding.Right"));
        this.getParameters().getCaptionBelow().getPadding().getLeft().a(new com.aspose.barcode.internal.ggr.qq("CaptionBelow.Padding.Left"));
        this.getParameters().getCaptionBelow().getPadding().getBottom().a(new com.aspose.barcode.internal.ggr.qq("CaptionBelow.Padding.Bottom"));
        this.getParameters().getBorder().getWidth().a(new com.aspose.barcode.internal.ggr.qq("Border.Width"));
        this.getParameters().getBarcode().getBarHeight().a(new com.aspose.barcode.internal.ggr.ww("BarHeight"));
        this.getParameters().getBarcode().getXDimension().a(new com.aspose.barcode.internal.ggr.ww("XDimension"));
        this.getParameters().getImageWidth().a(new com.aspose.barcode.internal.ggr.ww("BarCodeWidth"));
        this.getParameters().getImageHeight().a(new com.aspose.barcode.internal.ggr.ww("BarCodeHeight"));
        this.getParameters().getBarcode().getPostal().getPostalShortBarHeight().a(new com.aspose.barcode.internal.ggr.qq("PostalShortBarHeight"));
        this.getParameters().getBarcode().getAustralianPost().getAustralianPostShortBarHeight().a(new com.aspose.barcode.internal.ggr.qq("PostalShortBarHeight"));
        this.getParameters().getBarcode().getBarWidthReduction().a(new com.aspose.barcode.internal.ggr.qq("BarWidthReduction"));
        this.getParameters().getBarcode().getITF().getItfBorderThickness().a(new com.aspose.barcode.internal.ggr.ww("BarCodeWidth"));
    }

    public void dispose() {
        this.c();
    }

    private void c() {
        if (this.b != null) {
            this.b.c();
        }
    }

    boolean a() {
        return this.c;
    }

    void a(boolean bl) {
        this.c = bl;
    }
}

