/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.barcode.generation;

import com.aspose.barcode.BarCodeException;
import com.aspose.barcode.generation.BarcodeClassifications;
import com.aspose.barcode.generation.EncodeTypes;
import com.aspose.barcode.generation.SymbologyEncodeType;
import com.aspose.barcode.internal.mmt.pp;
import com.aspose.barcode.internal.yyt.ttr;
import com.aspose.barcode.internal.yyt.zze;

@zze
public class BaseEncodeType {
    private short a;
    private String b;
    private final BarcodeClassifications c;

    protected BaseEncodeType(short typeIndex, String typeName, BarcodeClassifications classification) {
        this.a = typeIndex;
        this.b = typeName;
        this.c = classification;
    }

    private BaseEncodeType() {
        this.c = BarcodeClassifications.NONE;
    }

    public short getTypeIndex() {
        return this.a;
    }

    public String getTypeName() {
        return this.b;
    }

    public BarcodeClassifications getClassification() {
        return this.c;
    }

    public String toString() {
        return this.b;
    }

    public String getString() {
        return ttr.a(pp.d(), "Index:{0}; Name:{1}", this.a, this.b);
    }

    public static String getString(BaseEncodeType instance) {
        if (instance != null) {
            return instance.getString();
        }
        return ttr.a;
    }

    public static boolean tryParse(String parsingType, BaseEncodeType[] result) {
        if (EncodeTypes.parse(parsingType, result)) {
            return true;
        }
        boolean bl = EncodeTypes.tryParse(parsingType, result);
        return bl;
    }

    public static boolean tryParse(String parsingType, SymbologyEncodeType[] result) {
        BaseEncodeType baseEncodeType = null;
        BaseEncodeType[] baseEncodeTypeArray = new BaseEncodeType[]{baseEncodeType};
        boolean bl = EncodeTypes.tryParse(parsingType, baseEncodeTypeArray);
        baseEncodeType = baseEncodeTypeArray[0];
        result[0] = (SymbologyEncodeType)baseEncodeType;
        return bl;
    }

    public boolean equals(Object other) {
        if (!(other instanceof BaseEncodeType)) {
            return false;
        }
        BaseEncodeType baseEncodeType = (BaseEncodeType)other;
        return this.getTypeIndex() == baseEncodeType.getTypeIndex() && ttr.e(this.getTypeName(), baseEncodeType.getTypeName());
    }

    public int hashCode() {
        return this.getTypeIndex() ^ 0x25 ^ this.getTypeName().hashCode();
    }

    public static BaseEncodeType parse(String stringEncodeType) {
        if (stringEncodeType == null || stringEncodeType.length() < 1) {
            throw new BarCodeException("Encode type cannot be empty");
        }
        BaseEncodeType baseEncodeType = null;
        BaseEncodeType[] baseEncodeTypeArray = new BaseEncodeType[]{baseEncodeType};
        EncodeTypes.parse(stringEncodeType, baseEncodeTypeArray);
        baseEncodeType = baseEncodeTypeArray[0];
        return baseEncodeType;
    }
}

