package com.aspose.barcode.examples;

import com.aspose.barcode.*;
import com.aspose.barcode.generation.*;

import java.awt.*;
import java.io.IOException;

import static com.aspose.barcode.examples.ExamplesAssist.assertEquals;

public class GenerationExamples
{
    private String resourcesRoot;

    public GenerationExamples() throws Exception
    {
        resourcesRoot = ExamplesAssist.prepareGenerationExamples();
    }

    public static void main(String[] args)
    {
        try
        {
            GenerationExamples generationExamples = new GenerationExamples();
            generationExamples.launch();
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }
    }

    public void launch() throws Exception
    {
        if (resourcesRoot == null)
        {
            System.out.println("Resources folder path is not defined. Examples cannot be launched");
            return;
        }
        howToDefaultBorderColor();
        howToGenerateOneD();
        howToGenerateTwoD();
        howToGetBarcodeTypeAndCodeText();
        howToGetCodeText();
        howToGetDefaultBackColor();
        howToGetDefaultDashStyle();
        howToGetDefaultBarColor();
        howToSave();
        howToSetBackColor();
        howToSetBarcodeType();
        howToSetBorderColor();
        howToSetCodeText();
        howToSetFont();
        howToSetBarColor();
    }

    public void howToSave() throws Exception
    {
        SymbologyEncodeType type = EncodeTypes.CODE_39;
        String codeText = "123678943";
        BarcodeGenerator generator = new BarcodeGenerator(type, codeText);
        generator.save(resourcesRoot + "howToSave.png");
    }

    public void howToSetBarcodeType() throws Exception
    {
        ExamplesAssist.printMethodName();
        BarcodeGenerator generator = new BarcodeGenerator(EncodeTypes.CODE_128, "12367891011");
        SymbologyEncodeType type_expected = EncodeTypes.CODABAR;
        generator.setBarcodeType(type_expected);
        generator.save(this.resourcesRoot + "testSetBarcodeType.png");
        BaseEncodeType type_actual = generator.getBarcodeType();
        generator.save(this.resourcesRoot + "howToSetBarcodeType.png");
        System.out.println("type_expected = " + type_expected + "\n");
        System.out.println("type_actual = " + type_actual + "\n");
        assertEquals(type_expected, type_actual);
    }

    public void howToGetCodeText() throws Exception
    {
        ExamplesAssist.printMethodName();
        String expected = "1234567890DCBV";
        BarcodeGenerator generator = new BarcodeGenerator(EncodeTypes.CODE_128, expected);
        generator.save(this.resourcesRoot + "howToGetCodeText.png");
        System.out.println("CodeText = " + generator.getCodeText());
    }

    public void howToGenerateOneD() throws Exception
    {
        ExamplesAssist.printMethodName();
        String codeText = "01234567";
        SymbologyEncodeType encodeType = EncodeTypes.CODE_39;
        BarcodeGenerator generator = new BarcodeGenerator(encodeType, codeText);
        String fullPath = this.resourcesRoot + "howToGenerateOneD.png";
        generator.save(fullPath);
        System.out.println("File was saved to " + fullPath);
    }

    public void howToGenerateTwoD() throws Exception
    {
        ExamplesAssist.printMethodName();
        String codeText = "01234567";
        SymbologyEncodeType encodeType = EncodeTypes.QR;
        BarcodeGenerator generator = new BarcodeGenerator(encodeType, codeText);
        String fullPath = this.resourcesRoot + "howToGenerateTwoD.png";
        generator.save(fullPath);
        System.out.println("File was saved to " + fullPath);
    }

    public void howToSetBackColor() throws Exception
    {
        ExamplesAssist.printMethodName();
        Color color_expected = Color.RED;
        BarcodeGenerator generator = new BarcodeGenerator(EncodeTypes.CODE_39, "01234567");
        generator.getParameters().setBackColor(color_expected);
        Color color_actual = generator.getParameters().getBackColor();
        generator.save(this.resourcesRoot + "howToSetBackColor.png");
        System.out.println("color_expected = " + color_expected + "\n");
        System.out.println("color_actual = " + color_actual + "\n");
        assertEquals(color_expected, color_actual);
    }

    public void howToGetDefaultBackColor() throws Exception
    {
        ExamplesAssist.printMethodName();
        Color color_expected = Color.WHITE;
        BarcodeGenerator generator = new BarcodeGenerator(EncodeTypes.CODE_39, "01234567");
        Color color_actual = generator.getParameters().getBackColor();
        generator.save(this.resourcesRoot + "howToGetDefaultBackColor.png");
        System.out.println("color_expected = " + color_expected + "\n");
        System.out.println("color_actual = " + color_actual + "\n");
        assertEquals(color_expected, color_actual);
    }

    public void howToGetDefaultBarColor() throws Exception
    {
        ExamplesAssist.printMethodName();
        Color color_expected = Color.BLACK;
        BarcodeGenerator generator = new BarcodeGenerator(EncodeTypes.CODE_39, "01234567");
        Color color_actual = generator.getParameters().getBarcode().getBarColor();
        generator.save(this.resourcesRoot + "howToGetDefaultForeColor.png");
        System.out.println("Color expected = " + color_expected + "\n");
        System.out.println("Color actual = " + color_actual + "\n");
        assertEquals(color_expected, color_actual);
    }

    public void howToSetBarColor() throws Exception
    {
        ExamplesAssist.printMethodName();
        Color color_expected = new Color(250, 0, 170);
        BarcodeGenerator generator = new BarcodeGenerator(EncodeTypes.CODE_39, "01234567");
        generator.getParameters().getBarcode().setBarColor(color_expected);
        Color color_actual = generator.getParameters().getBarcode().getBarColor();
        generator.save(this.resourcesRoot + "howToSetForeColor.png");
        System.out.println("ColgetBackColoror expected = " + color_expected + "\n");
        System.out.println("Color actual = " + color_actual + "\n");
        assertEquals(color_expected, color_actual);
    }


    public void howToSetCodeText() throws Exception
    {
        ExamplesAssist.printMethodName();
        SymbologyEncodeType encode_type = EncodeTypes.CODE_128;
        BarcodeGenerator generator = new BarcodeGenerator(encode_type, null);
        String expected = "555777";
        generator.setCodeText(expected);
        String actual = generator.getCodeText();
        generator.save(this.resourcesRoot + "howToSetCodeText.png");
        System.out.println("CodeText actual = " + actual + "\n");
        System.out.println("CodeText expected = " + expected + "\n");
        assertEquals(expected, actual);
    }


    public void howToGetBarcodeTypeAndCodeText() throws Exception
    {
        ExamplesAssist.printMethodName();
        SymbologyEncodeType encode_type_expected = EncodeTypes.AZTEC;
        String code_text_expected = "444555777665";
        BarcodeGenerator generator = new BarcodeGenerator(encode_type_expected, code_text_expected);
        BaseEncodeType encode_type_actual = generator.getBarcodeType();
        String code_text_actual = generator.getCodeText();
        generator.save(this.resourcesRoot + "howToGetBarcodeTypeAndCodeText.png");
        System.out.println("code text actual = " + code_text_actual + "\n");
        System.out.println("code text expected = " + code_text_expected + "\n");
        System.out.println("encode type actual = " + encode_type_actual + "\n");
        System.out.println("encode type expected = " + encode_type_expected + "\n");
        assertEquals(code_text_expected, code_text_actual);
        assertEquals(encode_type_expected, encode_type_actual);
    }

    public void howToGetDefaultDashStyle() throws Exception
    {
        ExamplesAssist.printMethodName();
        BorderDashStyle dash_style_expected = BorderDashStyle.SOLID;
        BarcodeGenerator generator = new BarcodeGenerator(EncodeTypes.CODE_39, "01234567");
        BorderDashStyle dash_style_actual = generator.getParameters().getBorder().getDashStyle();
        generator.save(this.resourcesRoot + "howToGetDefaultDashStyle.png");
        System.out.println("dash_style_actual = " + dash_style_actual + "\n");
        System.out.println("dash_style_expected" + dash_style_expected + "\n");
        assertEquals(dash_style_expected, dash_style_actual);
    }

    public void howToDefaultBorderColor() throws Exception
    {
        ExamplesAssist.printMethodName();
        Color border_color_expected = Color.BLACK;
        BarcodeGenerator generator = new BarcodeGenerator(EncodeTypes.CODE_39, "01234567");
        Color border_color_actual = generator.getParameters().getBorder().getColor();
        String fullPath = this.resourcesRoot + "howToDefaultBorderColor.png";
        generator.save(fullPath);
        System.out.println("border_color_expected = " + border_color_expected + "\n");
        System.out.println("border_color_actual = " + border_color_actual + "\n");
        assertEquals(border_color_expected, border_color_actual);
    }

    public void howToSetBorderColor() throws Exception
    {
        ExamplesAssist.printMethodName();
        Color border_color_expected = Color.MAGENTA;
        BarcodeGenerator generator = new BarcodeGenerator(EncodeTypes.CODE_39, "01234567");
        generator.getParameters().getBorder().setColor(border_color_expected);
        Color border_color_actual = generator.getParameters().getBorder().getColor();
        generator.save(this.resourcesRoot + "howToSetBorderColor.png");
        System.out.println("border_color_expected = " + border_color_expected + "\n");
        System.out.println("border_color_actual = " + border_color_actual + "\n");
        assertEquals(border_color_expected, border_color_actual);
    }

    public void howToSetFont() throws Exception
    {
        ExamplesAssist.printMethodName();
        BarcodeGenerator generator = new BarcodeGenerator(EncodeTypes.CODE_128);
        generator.getParameters().getCaptionAbove().setText("CAPTION ABOOVE");
        generator.getParameters().getCaptionAbove().setVisible(true);
        generator.getParameters().getCaptionAbove().getFont().setStyle(FontStyle.ITALIC);
        generator.getParameters().getCaptionAbove().getFont().getSize().setPoint(5);
        String save_path = this.resourcesRoot + "howToSetFont.bmp";
        generator.save(save_path);
        System.out.println("File was saved to " + save_path);
    }


}
