/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.barcode.complexbarcode;

import com.aspose.barcode.complexbarcode.IComplexCodetext;
import com.aspose.barcode.complexbarcode.Mailmark2DCodetext;
import com.aspose.barcode.complexbarcode.Mailmark2DType;
import com.aspose.barcode.complexbarcode.MaxiCodeCodetext;
import com.aspose.barcode.complexbarcode.SwissQRCodetext;
import com.aspose.barcode.complexbarcode.USADriveIdCodetext;
import com.aspose.barcode.generation.BarCodeImageFormat;
import com.aspose.barcode.generation.BarcodeGenerator;
import com.aspose.barcode.generation.BarcodeParameters;
import com.aspose.barcode.generation.BaseGenerationParameters;
import com.aspose.barcode.generation.CodeLocation;
import com.aspose.barcode.generation.DataMatrixEncodeMode;
import com.aspose.barcode.generation.DataMatrixVersion;
import com.aspose.barcode.generation.MaxiCodeEncodeMode;
import com.aspose.barcode.generation.Pdf417ErrorLevel;
import com.aspose.barcode.generation.QRErrorLevel;
import com.aspose.barcode.generation.qq;
import com.aspose.barcode.internal.llr.tte;
import com.aspose.barcode.internal.mmr.gg;
import com.aspose.barcode.internal.wwx.tt;
import com.aspose.barcode.internal.yyt.xxt;
import com.aspose.barcode.internal.yyt.yyr;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;

public final class ComplexBarcodeGenerator {
    private final BarcodeGenerator a;

    public BaseGenerationParameters getParameters() {
        return this.a.getParameters();
    }

    public ComplexBarcodeGenerator(IComplexCodetext complexCodetext) {
        String string = complexCodetext.getConstructedCodetext();
        this.a = new BarcodeGenerator(complexCodetext.getBarcodeType(), string);
        if (tt.b((Object)complexCodetext, SwissQRCodetext.class)) {
            this.a(string);
        } else if (complexCodetext instanceof Mailmark2DCodetext) {
            Mailmark2DCodetext mailmark2DCodetext = (Mailmark2DCodetext)complexCodetext;
            this.a(string, mailmark2DCodetext.a());
        } else if (complexCodetext instanceof MaxiCodeCodetext) {
            MaxiCodeCodetext maxiCodeCodetext = (MaxiCodeCodetext)complexCodetext;
            this.a(maxiCodeCodetext.getMode(), maxiCodeCodetext.getMaxiCodeEncodeMode(), maxiCodeCodetext.getECIEncoding());
        } else if (complexCodetext instanceof USADriveIdCodetext) {
            USADriveIdCodetext uSADriveIdCodetext = (USADriveIdCodetext)complexCodetext;
            this.b(string);
        }
    }

    public BufferedImage generateBarCodeImage() {
        return this.a.generateBarCodeImage();
    }

    public void save(OutputStream stream, BarCodeImageFormat format) throws IOException {
        this.a.save(stream, format);
    }

    public void save(String filename, BarCodeImageFormat format) throws IOException {
        this.a.save(filename, format);
    }

    public void save(String filename) throws IOException {
        this.a.save(filename);
    }

    public void dispose() {
        this.a();
    }

    private void a() {
        if (this.a != null) {
            this.a.dispose();
        }
    }

    private void a(String string) {
        this.a.getParameters().getBarcode().getQR().setQrErrorLevel(QRErrorLevel.LEVEL_M);
        this.a.getParameters().getBarcode().getCodeTextParameters().setLocation(CodeLocation.NONE);
        qq.e(this.a.getParameters().getBarcode()).a(true);
        BarcodeParameters barcodeParameters = this.a.getParameters().getBarcode();
        tte tte2 = new tte(new gg(barcodeParameters.getBarcodeType(), barcodeParameters.getThrowExceptionWhenCodeTextIncorrect(), barcodeParameters.getChecksumAlwaysShow(), barcodeParameters.isChecksumEnabled(), barcodeParameters.getQR().getQrECIEncoding(), barcodeParameters.getQR().getQrEncodeMode(), barcodeParameters.getQR().getQrEncodeType(), barcodeParameters.getQR().getQrErrorLevel(), barcodeParameters.getQR().getQrVersion(), barcodeParameters.getQR().getStructuredAppend()));
        String string2 = tte2.a(string);
        int n = yyr.a(string2, '\n')[0].length();
        this.a.getParameters().getBarcode().getXDimension().setMillimeters(xxt.a(46.0f / (float)n, 0.4f));
        this.a.getParameters().getImageHeight().setMillimeters(46.0f);
        this.a.getParameters().getImageWidth().setMillimeters(46.0f);
        float f = xxt.a(138.0f / (float)n, 1.6f);
        this.a.getParameters().getBarcode().getPadding().getBottom().setMillimeters(f);
        this.a.getParameters().getBarcode().getPadding().getTop().setMillimeters(f);
        this.a.getParameters().getBarcode().getPadding().getLeft().setMillimeters(f);
        this.a.getParameters().getBarcode().getPadding().getRight().setMillimeters(f);
    }

    private void a(String string, Mailmark2DType mailmark2DType) {
        switch (mailmark2DType) {
            case TYPE_7: {
                this.a.getParameters().getBarcode().getDataMatrix().setDataMatrixVersion(DataMatrixVersion.ECC200_24x24);
                break;
            }
            case TYPE_9: {
                this.a.getParameters().getBarcode().getDataMatrix().setDataMatrixVersion(DataMatrixVersion.ECC200_32x32);
                break;
            }
            case TYPE_29: {
                this.a.getParameters().getBarcode().getDataMatrix().setDataMatrixVersion(DataMatrixVersion.ECC200_16x48);
            }
        }
        this.a.getParameters().getBarcode().getDataMatrix().setDataMatrixEncodeMode(DataMatrixEncodeMode.EXTENDED_CODETEXT);
        this.a.getParameters().getBarcode().getCodeTextParameters().setLocation(CodeLocation.NONE);
    }

    private void a(int n, MaxiCodeEncodeMode maxiCodeEncodeMode, int n2) {
        this.a.getParameters().getBarcode().getMaxiCode().setMaxiCodeMode(n);
        this.a.getParameters().getBarcode().getMaxiCode().setMaxiCodeEncodeMode(maxiCodeEncodeMode);
        this.a.getParameters().getBarcode().getMaxiCode().setECIEncoding(n2);
    }

    private void b(String string) {
        this.a.getParameters().getBarcode().getPdf417().setPdf417ErrorLevel(Pdf417ErrorLevel.LEVEL_5);
        this.a.getParameters().getBarcode().getPdf417().setColumns(17);
    }
}

