/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.barcode.complexbarcode;

import com.aspose.barcode.BarCodeException;
import com.aspose.barcode.complexbarcode.HIBCLICDateFormat;
import com.aspose.barcode.internal.qqr.rr;
import com.aspose.barcode.internal.wwx.tt;
import com.aspose.barcode.internal.yyt.rre;
import com.aspose.barcode.internal.yyt.yyr;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public class SecondaryAndAdditionalData {
    private HIBCLICDateFormat a = HIBCLICDateFormat.YYYYMMDD;
    private LocalDateTime b = Instant.EPOCH.atZone(ZoneId.of("UTC")).toLocalDateTime();
    private String c;
    private String d;
    private LocalDateTime e = Instant.EPOCH.atZone(ZoneId.of("UTC")).toLocalDateTime();
    private int f = -1;

    public HIBCLICDateFormat getExpiryDateFormat() {
        return this.a;
    }

    public void setExpiryDateFormat(HIBCLICDateFormat value) {
        this.a = value;
    }

    public LocalDateTime getExpiryDate() {
        return this.b;
    }

    public void setExpiryDate(LocalDateTime value) {
        this.b = value;
    }

    public String getLotNumber() {
        return this.c;
    }

    public void setLotNumber(String value) {
        if (yyr.b(value)) {
            this.c = value;
            return;
        }
        if (value.length() > 18) {
            throw new BarCodeException("Lot/batch number must be up to 18 sybmols length.");
        }
        if (!rr.b(value, true)) {
            throw new BarCodeException("Lot/batch number must be alphanumeric string.");
        }
        this.c = value;
    }

    public String getSerialNumber() {
        return this.d;
    }

    public void setSerialNumber(String value) {
        if (yyr.b(value)) {
            this.d = value;
            return;
        }
        if (value.length() > 18) {
            throw new BarCodeException("Lot/batch number must be up to 18 sybmols length.");
        }
        if (!rr.b(value, true)) {
            throw new BarCodeException("Lot/batch number must be alphanumeric string.");
        }
        this.d = value;
    }

    public LocalDateTime getDateOfManufacture() {
        return this.e;
    }

    public void setDateOfManufacture(LocalDateTime value) {
        this.e = value;
    }

    public int getQuantity() {
        return this.f;
    }

    public void setQuantity(int value) {
        if (value < -1 || value > 500) {
            throw new BarCodeException("Quantity must be integer value from 0 to 500. Also it can be set to -1 in order not to use this field.");
        }
        this.f = value;
    }

    public String toString() {
        if (yyr.b(this.getLotNumber()) && yyr.b(this.getSerialNumber())) {
            throw new BarCodeException("Lot/batch or serial number must be provided.");
        }
        String string = "$$";
        if (yyr.b(this.getLotNumber())) {
            string = yyr.a(string, "+");
        }
        string = yyr.a(string, this.a());
        string = yyr.b(this.getLotNumber()) ? yyr.a(string, this.getSerialNumber()) : yyr.a(string, this.getLotNumber());
        if (!yyr.b(this.getLotNumber()) && !yyr.b(this.getSerialNumber())) {
            string = yyr.a(string, yyr.a(new String[]{"/S", this.getSerialNumber()}));
        }
        if (this.getExpiryDateFormat() == HIBCLICDateFormat.YYYYMMDD) {
            string = yyr.a(string, yyr.a(new String[]{"/14D", this.getExpiryDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"))}));
        }
        if (!this.getDateOfManufacture().equals(Instant.EPOCH.atZone(ZoneId.of("UTC")).toLocalDateTime())) {
            string = yyr.a(string, yyr.a(new String[]{"/16D", this.getDateOfManufacture().format(DateTimeFormatter.ofPattern("yyyyMMdd"))}));
        }
        if (this.getQuantity() >= 0) {
            string = yyr.a(string, yyr.a(new String[]{"/Q", rre.b(this.getQuantity())}));
        }
        return string;
    }

    private String a() {
        String[] stringArray = new String[]{"yyyyMMdd", "MMyy", "MMddyy", "yyMMdd", "yyMMddHH"};
        String string = rre.b(this.getExpiryDateFormat().getValue());
        switch (this.getExpiryDateFormat()) {
            case MMYY: {
                return this.getExpiryDate().format(DateTimeFormatter.ofPattern("MMyy"));
            }
            case NONE: {
                return string;
            }
            case YYJJJ: {
                return yyr.a(new String[]{string, this.getExpiryDate().format(DateTimeFormatter.ofPattern("yy")), rre.a(this.getExpiryDate().getDayOfYear(), "000")});
            }
            case YYJJJHH: {
                return yyr.a(string, this.getExpiryDate().format(DateTimeFormatter.ofPattern("yy")), rre.a(this.getExpiryDate().getDayOfYear(), "000"), this.getExpiryDate().format(DateTimeFormatter.ofPattern("HH")));
            }
            case MMDDYY: 
            case YYMMDD: 
            case YYMMDDHH: {
                return yyr.a(new String[]{string, this.getExpiryDate().format(DateTimeFormatter.ofPattern(stringArray[this.getExpiryDateFormat().getValue()]))});
            }
            case YYYYMMDD: {
                return rre.b(HIBCLICDateFormat.NONE.getValue());
            }
        }
        throw new BarCodeException("Unknown date format");
    }

    public void parseFromString(String secondaryDataCodetext) {
        String[] stringArray = yyr.a(secondaryDataCodetext, '/');
        this.a(stringArray[0]);
        this.a(stringArray);
    }

    private void a(String string) {
        int n;
        if (yyr.b(string) || string.length() < 2) {
            throw new BarCodeException("Incorrectly encoded secondary data.");
        }
        if (yyr.b(string, "$+")) {
            this.setExpiryDateFormat(HIBCLICDateFormat.NONE);
            if (string.length() < 3) {
                throw new BarCodeException("Incorrectly encoded serial number.");
            }
            this.setSerialNumber(yyr.b(string, 2, string.length() - 2));
            return;
        }
        if (yyr.b(string, "$") && (rr.a(string.charAt(1)) || rr.b(string.charAt(1)))) {
            this.setExpiryDateFormat(HIBCLICDateFormat.NONE);
            if (string.length() < 2) {
                throw new BarCodeException("Incorrectly encoded lot/batch number.");
            }
            this.setLotNumber(yyr.b(string, 1, string.length() - 1));
            return;
        }
        if (string.charAt(0) != '$') {
            this.setExpiryDateFormat(HIBCLICDateFormat.YYJJJ);
            this.setExpiryDate(this.a(string, 1, this.getExpiryDateFormat()));
            if (string.length() > 5) {
                this.setLotNumber(yyr.b(string, 5, string.length() - 5));
            }
            return;
        }
        if (string.length() < 4) {
            throw new BarCodeException("Incorrectly encoded secondary data.");
        }
        int n2 = string.charAt(2) == '+' ? 3 : 2;
        this.setExpiryDateFormat(this.a(string, n2));
        int n3 = this.getExpiryDateFormat() == HIBCLICDateFormat.MMYY ? n2 : n2 + 1;
        this.setExpiryDate(this.a(string, n3, this.getExpiryDateFormat()));
        int n4 = n = this.getExpiryDateFormat() == HIBCLICDateFormat.NONE ? n3 : n3 + this.getExpiryDateFormat().name().length();
        if (string.length() < n) {
            throw new BarCodeException("Incorrectly encoded serial or lot/batch number.");
        }
        String string2 = yyr.e(string, n);
        if (string.charAt(2) == '+') {
            this.setSerialNumber(string2);
        } else {
            this.setLotNumber(string2);
        }
    }

    private void a(String[] stringArray) {
        for (int i = 1; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.length() == 0) {
                throw new BarCodeException("Incorrectly encoded additional data.");
            }
            if (string.charAt(0) == 'Q') {
                this.setQuantity(rre.a(yyr.e(string, 1)));
                continue;
            }
            if (string.charAt(0) == 'S') {
                this.setSerialNumber(yyr.e(string, 1));
                continue;
            }
            if (yyr.b(string, "16D")) {
                this.setDateOfManufacture(this.a(string, 3, HIBCLICDateFormat.YYYYMMDD));
                continue;
            }
            if (yyr.b(string, "14D")) {
                this.setExpiryDateFormat(HIBCLICDateFormat.YYYYMMDD);
                this.setExpiryDate(this.a(string, 3, HIBCLICDateFormat.YYYYMMDD));
                continue;
            }
            throw new BarCodeException("Unknown additional supplemental data format");
        }
    }

    private HIBCLICDateFormat a(String string, int n) {
        if (string.charAt(n) == '0' || string.charAt(n) == '1') {
            return HIBCLICDateFormat.MMYY;
        }
        int n2 = 0;
        int[] nArray = new int[]{0};
        boolean bl = !rre.a(yyr.b(string, n, 1), nArray);
        n2 = nArray[0];
        if (bl) {
            throw new BarCodeException("Incorrectly encoded date format");
        }
        return HIBCLICDateFormat.values()[n2];
    }

    private LocalDateTime a(String string, int n, HIBCLICDateFormat hIBCLICDateFormat) {
        String[] stringArray = new String[]{"yyyyMMdd", "MMyy", "MMddyy", "yyMMdd", "yyMMddHH"};
        if (hIBCLICDateFormat == HIBCLICDateFormat.NONE) {
            return Instant.EPOCH.atZone(ZoneId.of("UTC")).toLocalDateTime();
        }
        if (string.length() - n < hIBCLICDateFormat.toString().length()) {
            throw new BarCodeException("Incorrectly encoded date.");
        }
        if (hIBCLICDateFormat == HIBCLICDateFormat.YYJJJ) {
            int n2 = 0;
            int[] nArray = new int[]{0};
            boolean bl = !rre.a(yyr.b(string, n, 2), nArray);
            n2 = nArray[0];
            if (bl) {
                throw new BarCodeException("Incorrectly encoded date.");
            }
            int n3 = 0;
            int[] nArray2 = new int[]{0};
            boolean bl2 = !rre.a(yyr.b(string, n + 2, 3), nArray2);
            n3 = nArray2[0];
            if (bl2) {
                throw new BarCodeException("Incorrectly encoded date.");
            }
            return LocalDateTime.of(2000 + n2, 1, 1, 0, 0).plusDays(n3 - 1);
        }
        if (hIBCLICDateFormat == HIBCLICDateFormat.YYJJJHH) {
            int n4 = 0;
            int[] nArray = new int[]{0};
            boolean bl = !rre.a(yyr.b(string, n, 2), nArray);
            n4 = nArray[0];
            if (bl) {
                throw new BarCodeException("Incorrectly encoded date.");
            }
            int n5 = 0;
            int[] nArray3 = new int[]{0};
            boolean bl3 = !rre.a(yyr.b(string, n + 2, 3), nArray3);
            n5 = nArray3[0];
            if (bl3) {
                throw new BarCodeException("Incorrectly encoded date.");
            }
            int n6 = 0;
            int[] nArray4 = new int[]{0};
            boolean bl4 = !rre.a(yyr.b(string, n + 5, 2), nArray4);
            n6 = nArray4[0];
            if (bl4) {
                throw new BarCodeException("Incorrectly encoded date.");
            }
            return LocalDateTime.of(2000 + n4, 1, 1, 0, 0).plusDays(n5 - 1).plusHours(n6);
        }
        LocalDateTime localDateTime = null;
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(stringArray[hIBCLICDateFormat.getValue()]);
        try {
            String string2 = yyr.b(string, n, stringArray[hIBCLICDateFormat.getValue()].length());
            if (stringArray[hIBCLICDateFormat.getValue()].equals(stringArray[4])) {
                localDateTime = LocalDateTime.parse(string, dateTimeFormatter);
            } else {
                LocalDate localDate = LocalDate.parse(string2, dateTimeFormatter);
                localDateTime = localDate.atStartOfDay();
            }
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new BarCodeException("Incorrectly encoded date.");
        }
        return localDateTime;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!tt.b(obj, SecondaryAndAdditionalData.class)) {
            return false;
        }
        SecondaryAndAdditionalData secondaryAndAdditionalData = (SecondaryAndAdditionalData)obj;
        return this.getQuantity() == secondaryAndAdditionalData.getQuantity() && yyr.e(this.a(), secondaryAndAdditionalData.a()) && (yyr.e(this.getSerialNumber(), secondaryAndAdditionalData.getSerialNumber()) || yyr.b(this.getSerialNumber()) && yyr.b(secondaryAndAdditionalData.getSerialNumber())) && (yyr.e(this.getLotNumber(), secondaryAndAdditionalData.getLotNumber()) || yyr.b(this.getLotNumber()) && yyr.b(secondaryAndAdditionalData.getLotNumber())) && yyr.e(this.getDateOfManufacture().format(DateTimeFormatter.ofPattern("yyyyMMdd")), secondaryAndAdditionalData.getDateOfManufacture().format(DateTimeFormatter.ofPattern("yyyyMMdd"))) && this.getExpiryDateFormat() == secondaryAndAdditionalData.getExpiryDateFormat();
    }

    public int hashCode() {
        int n = -1570462163;
        n = n * -1521134295 + this.getExpiryDateFormat().hashCode();
        n = n * -1521134295 + this.getExpiryDate().hashCode();
        n = n * -1521134295 + this.getLotNumber().hashCode();
        n = n * -1521134295 + this.getSerialNumber().hashCode();
        n = n * -1521134295 + this.getDateOfManufacture().hashCode();
        n = n * -1521134295 + rre.a(this.getQuantity());
        return n;
    }
}

