package com.aspose.barcode.examples;

import com.aspose.barcode.barcoderecognition.BarCodeReader;
import com.aspose.barcode.barcoderecognition.BarCodeResult;
import com.aspose.barcode.barcoderecognition.DecodeType;
import com.aspose.barcode.generation.BarCodeImageFormat;
import com.aspose.barcode.generation.BarcodeGenerator;
import com.aspose.barcode.generation.EncodeTypes;

import java.io.IOException;

public class DataBarStacked
{
    private String resourcesRoot;

    public DataBarStacked()
    {
        try
        {
            resourcesRoot = ExamplesAssist.prepareGenerationExamples();
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }
    }

    public static void main(String[] args)
    {
        new DataBarStacked().generateAndRead();
    }

    public void generateAndRead()
    {
        String filePath = resourcesRoot + "DataBarTruncated.png";//"path/to/image.png";
        //generate
        BarcodeGenerator bg = new BarcodeGenerator(EncodeTypes.DATABAR_TRUNCATED, "(01)12345678901231");
        {
            bg.getParameters().getBarcode().getXDimension().setPixels(2);
            //minimum of 13X high
            bg.getParameters().getBarcode().getBarHeight().setPixels(26);
            try
            {
                bg.save(filePath, BarCodeImageFormat.PNG);
            }
            catch (IOException e)
            {
                e.printStackTrace();
            }
        }

        //recognize
        BarCodeReader br = new BarCodeReader(filePath, DecodeType.DATABAR_TRUNCATED,DecodeType.DATABAR_STACKED);
        BarCodeResult[] barCodeResults = br.readBarCodes();
        for (BarCodeResult result : barCodeResults)
        {
            System.out.println("CodeType: " + result.getCodeTypeName());
            System.out.println("CodeText: " + result.getCodeText());
        }
    }
}
