package com.aspose.barcode.examples;

import com.aspose.barcode.License;
import com.aspose.barcode.generation.BaseEncodeType;
import com.aspose.barcode.generation.BorderDashStyle;

import java.awt.*;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public class ExamplesAssist
{
    public static String checkResourcesFolder(String resourcesFolder) throws Exception
    {
        Path subfolderPath = Paths.get(resourcesFolder);
        if (Files.exists(subfolderPath))
        {
            return resourcesFolder;
        }
        return null;
    }

    public static String obtainResourcesFolder() throws Exception
    {
        Path currentRelativePath = Paths.get("");
        String currentRelativePathString = currentRelativePath.toAbsolutePath().toString();
        System.out.println("Current relative path is: " + currentRelativePathString);
        String resourcesFolder = currentRelativePathString + "/resources/";
        System.out.println("resourcesFolder is: " + resourcesFolder);
        if (checkResourcesFolder(resourcesFolder) != null)
        {
            return resourcesFolder;
        }
        resourcesFolder = currentRelativePathString + "/src/examples/resources/";
        if (checkResourcesFolder(resourcesFolder) != null)
        {
            return resourcesFolder;
        }
        resourcesFolder = "barcode_java/java_external_tester/src/examples/resources/";
        if (checkResourcesFolder(resourcesFolder) != null)
        {
            return resourcesFolder;
        }
        throw new Exception("Cannot obtain resources folder's path");
    }

    public static boolean installLicense() throws Exception
    {
        String resourcesFolder = obtainResourcesFolder();
        if (!Files.exists(Paths.get(resourcesFolder)))
        {
            System.out.println("Resource folder absent. License was not installed");
            return false;
        }
        String licenseFullPath = resourcesFolder + "license/Aspose.BarCode.Java.lic";

        Path path = Paths.get(licenseFullPath);
        if (Files.exists(path))
        {
            System.out.println("License '" + licenseFullPath + "' will be installed");
            License license = new License();
            license.setLicense(licenseFullPath);
            return true;
        }
        else
        {
            System.out.println("License was not installed");
            return false;
        }
    }

    public static void printMethodName()
    {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        System.out.println("\n------------\nmethod : " + stackTrace[2].getMethodName() + "\n");
    }

    public static void assertEquals(String expected, String actual) throws Exception
    {
        if (!expected.equals(actual))
        {
            throw new Exception("expected  '" + expected + "' and actual '" + actual + "' are not equal");

        }
        System.out.println("expected and actual are equal");
    }

    public static void assertEquals(Color expected, Color actual) throws Exception
    {
        if (!expected.equals(actual))
        {
            throw new Exception("expected  '" + expected.toString() + "' and actual '" + actual.toString() + "' are not equal");
        }
        System.out.println("expected and actual are equal");
    }

    public static void assertEquals(BaseEncodeType expected, BaseEncodeType actual) throws Exception
    {
        if (!expected.equals(actual))
        {
            throw new Exception("expected  '" + expected.getString() + "' and actual '" + actual.getString() + "' are not equal");
        }
        System.out.println("expected and actual are equal");
    }

   public static void assertEquals(BorderDashStyle expected, BorderDashStyle actual) throws Exception
    {
        if (!expected.equals(actual))
        {
            throw new Exception("expected  '" + expected.toString() + "' and actual '" + actual.toString() + "' are not equal");
        }
        System.out.println("expected and actual are equal");
    }

    public static String prepareGenerationExamples() throws Exception
    {
        installLicense();
        String resourcesFolder = obtainResourcesFolder();
        return resourcesFolder + "/generating/";
    }
}
