/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.barcode.complexbarcode;

import com.aspose.barcode.BarCodeException;
import com.aspose.barcode.complexbarcode.HIBCLICComplexCodetext;
import com.aspose.barcode.complexbarcode.SecondaryAndAdditionalData;
import com.aspose.barcode.internal.wwe.vv;
import com.aspose.barcode.internal.wwx.tt;
import com.aspose.barcode.internal.yyt.qqd;
import com.aspose.barcode.internal.yyt.yyr;

public class HIBCLICSecondaryAndAdditionalDataCodetext
extends HIBCLICComplexCodetext {
    private SecondaryAndAdditionalData a = new SecondaryAndAdditionalData();
    private char b = '\u0001';

    public SecondaryAndAdditionalData getData() {
        return this.a;
    }

    public void setData(SecondaryAndAdditionalData value) {
        this.a = value;
    }

    public char getLinkCharacter() {
        return this.b;
    }

    public void setLinkCharacter(char value) {
        this.b = value;
    }

    @Override
    public String getConstructedCodetext() {
        String string = "+" + this.getData().toString();
        if (this.getLinkCharacter() == '\u0001') {
            throw new BarCodeException("Link character is not specified. Link character for secondary data must be equal to check character for primary data.");
        }
        String string2 = new vv(string = string + this.getLinkCharacter()).a();
        if (string2 == null) {
            throw new BarCodeException("Can not calculcate checkchar. Only numbers, capital letters and '-', '.', ' ', '$', '/', '+', '%' symbols are allowed in HIBC LIC.");
        }
        string = string + string2;
        return string;
    }

    @Override
    public void initFromString(String constructedCodetext) {
        if (yyr.b(constructedCodetext)) {
            throw new BarCodeException("Codetext is empty.");
        }
        if (constructedCodetext.length() < 3) {
            throw new BarCodeException("Codetext is too short.");
        }
        if (constructedCodetext.charAt(0) != '+') {
            throw new BarCodeException("Incorrectly encoded HIBC Supplier Labeling Flag Character '+'.");
        }
        String string = new vv(yyr.b(constructedCodetext, 0, constructedCodetext.length() - 1)).a();
        if (string == null || constructedCodetext.charAt(constructedCodetext.length() - 1) != string.charAt(0)) {
            throw new BarCodeException("Incorrect check char");
        }
        this.setLinkCharacter(constructedCodetext.charAt(constructedCodetext.length() - 2));
        this.setData(new SecondaryAndAdditionalData());
        this.getData().parseFromString(yyr.b(constructedCodetext, 1, constructedCodetext.length() - 3));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!tt.b(obj, HIBCLICSecondaryAndAdditionalDataCodetext.class)) {
            return false;
        }
        HIBCLICSecondaryAndAdditionalDataCodetext hIBCLICSecondaryAndAdditionalDataCodetext = (HIBCLICSecondaryAndAdditionalDataCodetext)obj;
        return this.getData().equals(hIBCLICSecondaryAndAdditionalDataCodetext.getData()) && this.getLinkCharacter() == hIBCLICSecondaryAndAdditionalDataCodetext.getLinkCharacter();
    }

    public int hashCode() {
        int n = -349306120;
        n = n * -1521134295 + this.getBarcodeType().hashCode();
        n = n * -1521134295 + this.getData().hashCode();
        n = n * -1521134295 + qqd.a(this.getLinkCharacter());
        return n;
    }
}

