package com.aspose.barcode.examples;

import com.aspose.barcode.generation.EncodeTypes;
import com.aspose.barcode.barcoderecognition.*;
import com.aspose.barcode.generation.BarcodeGenerator;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class RecognitionExamples
{
    private String resourcesRoot;

    private boolean licenseInstalled;

    public RecognitionExamples() throws Exception
    {
        String resourcesFolder = ExamplesAssist.obtainResourcesFolder();
        if (resourcesFolder == null)
        {
            resourcesRoot = null;
            return;
        }
        resourcesRoot = resourcesFolder + "/recognition/";
        licenseInstalled = ExamplesAssist.installLicense();
    }

    public static void main(String[] args)
    {
        try
        {
            RecognitionExamples recognitionExamples = new RecognitionExamples();
            recognitionExamples.launch();
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }
    }

    public void launch() throws Exception
    {
        if (resourcesRoot == null)
        {
            System.out.println("Resources folder path is not defined. Examples cannot be launched");
            return;
        }
        howToDetectEncodingEnabled();
        howToGetCodeBytes();
        howToMacroPdf417();
        howToReadFromFile();
        howToRecognitionCode11();
        howToRecognitionCode128();
        howToRecognitionCodeAllSupportedTypes();
        howToRecognitionCodeAllSupportedTypes2();
        howToRecognitionSetBarCodeImage();
        howToSetQualitySettings();
        howToCustomerInformationInterpretingType1();
        howToCustomerInformationInterpretingType2();
    }


    public void howToReadFromFile()
    {
        ExamplesAssist.printMethodName();
        String file_name = "code11.png";
        String full_path = this.resourcesRoot + file_name;
        BarCodeReader reader = new BarCodeReader(full_path);
        for (BarCodeResult barCodeResult : reader.readBarCodes())
        {
            System.out.println("Code Text : " + barCodeResult.getCodeText());
            System.out.println();
            System.out.println("CodeType : " + barCodeResult.getCodeTypeName());
        }

    }

    public void howToSetQualitySettings()
    {
        ExamplesAssist.printMethodName();
        String file_name = "code11.png";
        String full_path = this.resourcesRoot + file_name;
        BarCodeReader reader = new BarCodeReader(full_path);
        reader.setQualitySettings(QualitySettings.getHighPerformance());
        reader.getQualitySettings().setDeconvolution(DeconvolutionMode.SLOW);

        for (BarCodeResult barCodeResult : reader.readBarCodes())
        {
            System.out.println("Code Text : " + barCodeResult.getCodeText());
            System.out.println();
            System.out.println("CodeType : " + barCodeResult.getCodeTypeName());
        }

    }


    public void howToGetCodeBytes() throws IOException
    {
        ExamplesAssist.printMethodName();
        byte[] expectedCodeBytes = new byte[]{105, 99, 70, 1, 61, 0, 0, 2, 70, 10, 82, 20, 40, 0, 97, 106};
        String fileName = "example2.jpg";
        BarCodeReader reader = new BarCodeReader(ImageIO.read(new File(this.resourcesRoot + fileName)));
        for (BarCodeResult barCodeResult : reader.readBarCodes())
        {
            byte[] actualCodeBytes = barCodeResult.getCodeBytes();
            System.out.println("expected code bytes  : " + expectedCodeBytes.length);
            System.out.println();
            System.out.println("actual code bytes  : " + actualCodeBytes.length);
        }
    }

    public void howToRecognitionCode128() throws IOException
    {
        ExamplesAssist.printMethodName();
        String fileName = "code128.jpg";
        BarCodeReader reader = new BarCodeReader(ImageIO.read(new File(this.resourcesRoot + fileName)), DecodeType.CODE_128);
        for (BarCodeResult barCodeResult : reader.readBarCodes())
        {
            System.out.println("Code Text : " + barCodeResult.getCodeTypeName());
            System.out.println();
            System.out.println("Code Type : " + barCodeResult.getCodeText());
        }

    }

    public void howToRecognitionCode11() throws IOException
    {
        ExamplesAssist.printMethodName();
        String fileName = "code11.png";
        BarCodeReader reader = new BarCodeReader(ImageIO.read(new File(this.resourcesRoot + fileName)), DecodeType.CODE_11);
        for (BarCodeResult barCodeResult : reader.readBarCodes())
        {
            System.out.println("Code Text : " + barCodeResult.getCodeTypeName());
            System.out.println();
            System.out.println("Code Type : " + barCodeResult.getCodeText());
        }

    }

    public void howToRecognitionCodeAllSupportedTypes() throws IOException
    {
        ExamplesAssist.printMethodName();
        String fileName = "example2.jpg";
        BarCodeReader reader = new BarCodeReader(ImageIO.read(new File(this.resourcesRoot + fileName)), DecodeType.ALL_SUPPORTED_TYPES);
        for (BarCodeResult barCodeResult : reader.readBarCodes())
        {
            System.out.println("Code Text : " + barCodeResult.getCodeTypeName());
            System.out.println();
            System.out.println("Code Type : " + barCodeResult.getCodeText());
        }

    }

    public void howToRecognitionCodeAllSupportedTypes2() throws IOException
    {
        ExamplesAssist.printMethodName();
        String fileName = "example1.png";
        BarCodeReader reader = new BarCodeReader(ImageIO.read(new File(this.resourcesRoot + fileName)), DecodeType.ALL_SUPPORTED_TYPES);
        for (BarCodeResult barCodeResult : reader.readBarCodes())
        {
            System.out.println("Code Text : " + barCodeResult.getCodeTypeName());
            System.out.println();
            System.out.println("Code Type : " + barCodeResult.getCodeText());
        }

    }

    public void howToRecognitionSetBarCodeImage() throws IOException
    {
        ExamplesAssist.printMethodName();
        String fileName = "code128.jpg";
        BarCodeReader reader = new BarCodeReader(ImageIO.read(new File(this.resourcesRoot + fileName)), DecodeType.ALL_SUPPORTED_TYPES);
        reader.setBarCodeImage(this.resourcesRoot + "code11.png");

        for (BarCodeResult barCodeResult : reader.readBarCodes())
        {
            System.out.println("Code Text : " + barCodeResult.getCodeTypeName());
            System.out.println();
            System.out.println("Code Type : " + barCodeResult.getCodeText());
        }

    }

    public void howToMacroPdf417()
    {
        ExamplesAssist.printMethodName();
        BarcodeGenerator gen = new BarcodeGenerator(EncodeTypes.MACRO_PDF_417, null);
        gen.setCodeText("codeSomecode");
        gen.getParameters().getBarcode().getPdf417().setPdf417MacroFileID(15900);
        gen.getParameters().getBarcode().getPdf417().setPdf417MacroSegmentID(2);
        gen.getParameters().getBarcode().getPdf417().setPdf417MacroSegmentsCount(3);
        BufferedImage image = gen.generateBarCodeImage();
        BarCodeReader reader = new BarCodeReader((image), DecodeType.MACRO_PDF_417);
        for (BarCodeResult barCodeResult : reader.readBarCodes())
        {
            System.out.println("CodeText : " + barCodeResult.getCodeText());
        }

    }


    public void howToDetectEncodingEnabled()
    {
        ExamplesAssist.printMethodName();
        BarcodeGenerator gen = new BarcodeGenerator(EncodeTypes.QR, null);
        gen.setCodeText("Слово");
        gen.setCodeText("Слово", StandardCharsets.UTF_8);
        BufferedImage image = gen.generateBarCodeImage();

        BarCodeReader reader = new BarCodeReader(image, DecodeType.QR);
        reader.getBarcodeSettings().setDetectEncoding(true);
        for (BarCodeResult barCodeResult : reader.readBarCodes())
        {
            System.out.println("CodeText : " + barCodeResult.getCodeText());
            System.out.println();
            System.out.println("CodeType : " + barCodeResult.getCodeTypeName());
        }
    }

    public void howToCustomerInformationInterpretingType1()
    {
        ExamplesAssist.printMethodName();
        if (!licenseInstalled)
        {
            System.out.println("For recognition EncodeTypes.AUSTRALIA_POST please install license. Only Code39Standard can be recognized without restrictions");
            return;
        }
        BarcodeGenerator generator = new BarcodeGenerator(EncodeTypes.AUSTRALIA_POST, "1234567890");
        generator.setCodeText("59123456781234567");
        generator.getParameters().getBarcode().getAustralianPost().setAustralianPostEncodingTable(CustomerInformationInterpretingType.N_TABLE);
        BufferedImage image = generator.generateBarCodeImage();
        BarCodeReader reader = new BarCodeReader((image), DecodeType.AUSTRALIA_POST);
        reader.getBarcodeSettings().getAustraliaPost().setCustomerInformationInterpretingType(CustomerInformationInterpretingType.N_TABLE);
        BarCodeResult[] results = reader.readBarCodes();
        System.out.println("Found " + results.length + " barcodes");
        for (BarCodeResult barCodeResult : reader.readBarCodes())
        {
            System.out.println("CodeText : " + barCodeResult.getCodeText());
            System.out.println();
            System.out.println("CodeType : " + barCodeResult.getCodeTypeName());
        }
    }

    public void howToCustomerInformationInterpretingType2()
    {
        ExamplesAssist.printMethodName();
        if (!licenseInstalled)
        {
            System.out.println("For recognition EncodeTypes.AUSTRALIA_POST please install license. Only Code39Standard can be recognized without restrictions");
            return;
        }
        BarcodeGenerator generator = new BarcodeGenerator(EncodeTypes.AUSTRALIA_POST, null);
        generator.setCodeText("6212345678ABCdef123#");
        generator.getParameters().getBarcode().getAustralianPost().setAustralianPostEncodingTable(CustomerInformationInterpretingType.C_TABLE);
        BufferedImage image = generator.generateBarCodeImage();
        BarCodeReader reader = new BarCodeReader((image), DecodeType.AUSTRALIA_POST);
        reader.getBarcodeSettings().getAustraliaPost().setCustomerInformationInterpretingType(CustomerInformationInterpretingType.C_TABLE);
        BarCodeResult[] results = reader.readBarCodes();
        System.out.println("Found " + results.length + " barcodes");
        for (BarCodeResult barCodeResult : results)
        {
            System.out.println("CodeText : " + barCodeResult.getCodeText());
            System.out.println();
            System.out.println("CodeType : " + barCodeResult.getCodeTypeName());
        }
    }


}