package com.aspose.barcode.examples;

import com.aspose.barcode.auxiliary.Global;
import com.aspose.barcode.barcoderecognition.BarCodeReader;
import com.aspose.barcode.barcoderecognition.BarCodeResult;
import com.aspose.barcode.barcoderecognition.DecodeType;
import com.aspose.barcode.complexbarcode.*;
import com.aspose.barcode.generation.ECIEncodings;
import com.aspose.barcode.generation.QREncodeMode;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class SwissQRCode
{
    private String resourcesRoot;

    public SwissQRCode()
    {
        try
        {
            resourcesRoot = ExamplesAssist.prepareGenerationExamples();
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }
    }

    public static void main(String[] args)
    {
        new SwissQRCode().generateAndRead();
    }

    public void generateAndRead()
    {
        String filePath = resourcesRoot + "SwissQRCode.png";//"path/to/image.png";
        //create Swiss QR Bill
        SwissQRCodetext qrCode = new SwissQRCodetext();
        qrCode.getBill().setVersion(QrBillStandardVersion.V2_0);
        qrCode.getBill().setAccount("CH4431999123000889012");
        qrCode.getBill().setAmount(1000.25);
        qrCode.getBill().setCurrency("CHF");
        qrCode.getBill().setReference("210000000003139471430009017");
        Address creditor = new Address();
        creditor.setName("Muster & Söhne");
        creditor.setStreet("Musterstrasse");
        creditor.setHouseNo("12b");
        creditor.setPostalCode("8200");
        creditor.setTown("Zürich");
        creditor.setCountryCode("CH");
        qrCode.getBill().setCreditor(creditor);

        Address debtor = new Address();
        debtor.setName("Muster AG");
        debtor.setStreet("Musterstrasse");
        debtor.setHouseNo("1");
        debtor.setPostalCode("3030");
        debtor.setTown("Bern");
        debtor.setCountryCode("CH");
        qrCode.getBill().setDebtor(debtor);

        ComplexBarcodeGenerator generator = new ComplexBarcodeGenerator(qrCode);

        generator.getParameters().getBarcode().getXDimension().setPixels(4);
        generator.getParameters().getBarcode().getQR().setEncodeMode(QREncodeMode.ECI_ENCODING);
        generator.getParameters().getBarcode().getQR().setECIEncoding(ECIEncodings.UTF8);

        generator.getParameters().getBarcode().getPadding().getBottom().setMillimeters(0);
        generator.getParameters().getBarcode().getPadding().getTop().setMillimeters(0);
        generator.getParameters().getBarcode().getPadding().getLeft().setMillimeters(0);
        generator.getParameters().getBarcode().getPadding().getRight().setMillimeters(0);
        generator.getParameters().getImageWidth().setMillimeters(46);
        try
        {
            generator.save(filePath);
        }
        catch (IOException e)
        {
            e.printStackTrace();
        }

        BarCodeReader reader = new BarCodeReader(generator.generateBarCodeImage(), DecodeType.QR);
        BarCodeResult[] results = reader.readBarCodes();
        for(BarCodeResult result:results)
        {
            SwissQRCodetext swissResult = ComplexCodetextReader.tryDecodeSwissQR(result.getCodeText());
            if (null == swissResult) continue;
            System.out.println("Version: "+swissResult.getBill().getVersion());
            System.out.println("Account: "+swissResult.getBill().getAccount());
            System.out.println("Amount: "+swissResult.getBill().getAmount());
            System.out.println("Currency: "+swissResult.getBill().getCurrency());
            System.out.println("Reference: "+swissResult.getBill().getReference());
            System.out.println("Creditor: "+swissResult.getBill().getCreditor().getName());
            System.out.println("Debtor: "+swissResult.getBill().getDebtor().getName());
        }
    }
}
