/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.barcode.barcodecontrol;

import com.aspose.barcode.BarCodeException;
import com.aspose.barcode.barcodecontrol.CaptionUI;
import com.aspose.barcode.barcodecontrol.CodetextParametersUI;
import com.aspose.barcode.barcodecontrol.IBarCodeGeneratorControl;
import com.aspose.barcode.barcodecontrol.SpecificParametersUI;
import com.aspose.barcode.generation.AutoSizeMode;
import com.aspose.barcode.generation.BarcodeGenerator;
import com.aspose.barcode.generation.BaseEncodeType;
import com.aspose.barcode.generation.BorderParameters;
import com.aspose.barcode.generation.EnableChecksum;
import com.aspose.barcode.generation.EncodeTypes;
import com.aspose.barcode.generation.Padding;
import com.aspose.barcode.generation.Unit;
import com.aspose.barcode.generation.qqd;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class BarCodeGeneratorControl
extends JLabel
implements IBarCodeGeneratorControl {
    private BarcodeGenerator a;
    private CaptionUI b;
    private CaptionUI c;
    private SpecificParametersUI d;
    private CodetextParametersUI e;
    private boolean f = false;
    private float g = qqd.a;

    public BarCodeGeneratorControl() {
        this.a();
        BufferedImage bufferedImage = this.a.generateBarCodeImage();
        super.setSize(bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    protected void a(boolean bl) {
        if (bl && this.a != null) {
            this.a.dispose();
        }
    }

    private void a() {
        this.a = new BarcodeGenerator(EncodeTypes.CODE_128);
        this.a.getParameters().setAutoSizeMode(AutoSizeMode.NEAREST);
        this.b = new CaptionUI(this.a.getParameters().getCaptionAbove(), this);
        this.c = new CaptionUI(this.a.getParameters().getCaptionBelow(), this);
        this.d = new SpecificParametersUI(this.a.getParameters(), this);
        this.e = new CodetextParametersUI(this.a.getParameters().getBarcode().getCodeTextParameters(), this);
        this.setIcon(new ImageIcon(this.a.generateBarCodeImage()));
    }

    private void b() {
        if (this.f) {
            this.invalidate();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        try {
            this.f = false;
            if (this.a.getParameters().getAutoSizeMode() != AutoSizeMode.NONE) {
                this.a.getParameters().getImageWidth().setPixels((float)this.getWidth() * this.a.getParameters().getResolution() / this.g);
                this.a.getParameters().getImageHeight().setPixels((float)this.getHeight() * this.a.getParameters().getResolution() / this.g);
            }
            this.setIcon(new ImageIcon(this.a.generateBarCodeImage()));
        }
        catch (BarCodeException barCodeException) {
            g.drawString(barCodeException.getMessage(), 0, 0);
        }
        finally {
            this.f = true;
        }
    }

    public String getCodeText() {
        return this.a.getCodeText();
    }

    public void setCodeText(String value) {
        if (value == null) {
            return;
        }
        if (value.length() > 0) {
            this.a.setCodeText(value);
            this.b();
        }
        this.repaint();
    }

    @Override
    public BaseEncodeType getEncodeType() {
        return this.a.getBarcodeType();
    }

    @Override
    public void setEncodeType(BaseEncodeType value) {
        this.setBarcodeType(value.getTypeName());
        this.repaint();
    }

    public String getBarcodeType() {
        return this.a.getBarcodeType().getTypeName();
    }

    public void setBarcodeType(String value) {
        BaseEncodeType[] baseEncodeTypeArray = new BaseEncodeType[1];
        if (EncodeTypes.parse(value, baseEncodeTypeArray)) {
            this.a.setBarcodeType(baseEncodeTypeArray[0]);
            this.b();
        }
        this.repaint();
    }

    private boolean c() {
        return this.a.getBarcodeType() != EncodeTypes.CODE_128;
    }

    public AutoSizeMode getAutoSizeMode() {
        return this.a.getParameters().getAutoSizeMode();
    }

    public void setAutoSizeMode(AutoSizeMode value) {
        this.a.getParameters().setAutoSizeMode(value);
        this.b();
    }

    public CaptionUI getCaptionAbove() {
        return this.b;
    }

    public CaptionUI getCaptionBelow() {
        return this.c;
    }

    public Unit getXDimension() {
        return this.a.getParameters().getBarcode().getXDimension();
    }

    public Unit getBarHeight() {
        return this.a.getParameters().getBarcode().getBarHeight();
    }

    public Unit getBarCodeHeight() {
        return this.a.getParameters().getImageHeight();
    }

    public Unit getBarCodeWidth() {
        return this.a.getParameters().getImageWidth();
    }

    public Color getBarColor() {
        return this.a.getParameters().getBarcode().getBarColor();
    }

    public void setBarColor(Color value) {
        this.a.getParameters().getBarcode().setBarColor(value);
        this.b();
        this.repaint();
    }

    public Padding getBarcodePaddings() {
        return this.a.getParameters().getBarcode().getPadding();
    }

    public boolean getChecksumAlwaysShow() {
        return this.a.getParameters().getBarcode().getChecksumAlwaysShow();
    }

    public void setChecksumAlwaysShow(boolean value) {
        this.a.getParameters().getBarcode().setChecksumAlwaysShow(value);
        this.b();
        this.repaint();
    }

    public EnableChecksum isChecksumEnabled() {
        return this.a.getParameters().getBarcode().isChecksumEnabled();
    }

    public void setChecksumEnabled(EnableChecksum value) {
        this.a.getParameters().getBarcode().setChecksumEnabled(value);
        this.b();
        this.repaint();
    }

    public boolean getEnableEscape() {
        return false;
    }

    public void setEnableEscape(boolean value) {
        this.a.getParameters().getBarcode().setEnableEscape(value);
        this.b();
        this.repaint();
    }

    public boolean getThrowExceptionWhenCodeTextIncorrect() {
        return this.a.getParameters().getBarcode().getThrowExceptionWhenCodeTextIncorrect();
    }

    public void setThrowExceptionWhenCodeTextIncorrect(boolean value) {
        this.a.getParameters().getBarcode().setThrowExceptionWhenCodeTextIncorrect(value);
        this.b();
        this.repaint();
    }

    public float getWideNarrowRatio() {
        return this.a.getParameters().getBarcode().getWideNarrowRatio();
    }

    public void setWideNarrowRatio(float value) {
        this.a.getParameters().getBarcode().setWideNarrowRatio(value);
        this.b();
        this.repaint();
    }

    public CodetextParametersUI getCodeTextParameters() {
        return this.e;
    }

    public boolean getFilledBars() {
        return this.a.getParameters().getBarcode().getFilledBars();
    }

    public void setFilledBars(boolean value) {
        this.a.getParameters().getBarcode().setFilledBars(value);
        this.b();
        this.repaint();
    }

    public SpecificParametersUI getSpecific() {
        return this.d;
    }

    public Color getBackgroundColor() {
        return this.a.getParameters().getBackColor();
    }

    public void setBackgroundColor(Color value) {
        this.a.getParameters().setBackColor(value);
        this.b();
        this.repaint();
    }

    public float getResolution() {
        return this.a.getParameters().getResolution();
    }

    public void setResolution(float value) {
        this.a.getParameters().setResolution(value);
        this.b();
        this.repaint();
    }

    public boolean isUseAntiAlias() {
        return this.a.getParameters().getUseAntiAlias();
    }

    public void setUseAntiAlias(boolean value) {
        this.a.getParameters().setUseAntiAlias(value);
        this.b();
        this.repaint();
    }

    public BorderParameters getBorderParameters() {
        return this.a.getParameters().getBorder();
    }

    @Override
    public float getRotationAngle() {
        return this.a.getParameters().getRotationAngle();
    }

    @Override
    public void setRotationAngle(float value) {
        this.a.getParameters().setRotationAngle(value);
        this.b();
        this.repaint();
    }
}

