/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.barcode.barcoderecognition;

import com.aspose.barcode.barcoderecognition.BaseDecodeType;
import com.aspose.barcode.barcoderecognition.MultiDecodeType;
import com.aspose.barcode.barcoderecognition.SingleDecodeType;
import com.aspose.barcode.internal.bb.kk;
import com.aspose.barcode.internal.bbr.uu;
import com.aspose.barcode.internal.yyt.yyr;
import java.util.Objects;

public class DecodeType {
    public static final SingleDecodeType NONE = new SingleDecodeType(-1, "NONE");
    public static final SingleDecodeType CODABAR = new SingleDecodeType(0, "Codabar");
    public static final SingleDecodeType CODE_11 = new SingleDecodeType(1, "Code11");
    public static final SingleDecodeType CODE_39 = new SingleDecodeType(2, "Code39");
    public static final SingleDecodeType CODE_39_FULL_ASCII = new SingleDecodeType(3, "Code39FullASCII");
    public static final SingleDecodeType CODE_93 = new SingleDecodeType(5, "Code93");
    public static final SingleDecodeType CODE_128 = new SingleDecodeType(6, "Code128");
    public static final SingleDecodeType GS_1_CODE_128 = new SingleDecodeType(7, "GS1Code128");
    public static final SingleDecodeType EAN_8 = new SingleDecodeType(8, "EAN8");
    public static final SingleDecodeType EAN_13 = new SingleDecodeType(9, "EAN13");
    public static final SingleDecodeType EAN_14 = new SingleDecodeType(10, "EAN14");
    public static final SingleDecodeType SCC_14 = new SingleDecodeType(11, "SCC14");
    public static final SingleDecodeType SSCC_18 = new SingleDecodeType(12, "SSCC18");
    public static final SingleDecodeType UPCA = new SingleDecodeType(13, "UPCA");
    public static final SingleDecodeType UPCE = new SingleDecodeType(14, "UPCE");
    public static final SingleDecodeType ISBN = new SingleDecodeType(15, "ISBN");
    public static final SingleDecodeType STANDARD_2_OF_5 = new SingleDecodeType(16, "Standard2of5");
    public static final SingleDecodeType INTERLEAVED_2_OF_5 = new SingleDecodeType(17, "Interleaved2of5");
    public static final SingleDecodeType MATRIX_2_OF_5 = new SingleDecodeType(18, "Matrix2of5");
    public static final SingleDecodeType ITALIAN_POST_25 = new SingleDecodeType(19, "ItalianPost25");
    public static final SingleDecodeType IATA_2_OF_5 = new SingleDecodeType(20, "IATA2of5");
    public static final SingleDecodeType ITF_14 = new SingleDecodeType(21, "ITF14");
    public static final SingleDecodeType ITF_6 = new SingleDecodeType(22, "ITF6");
    public static final SingleDecodeType MSI = new SingleDecodeType(23, "MSI");
    public static final SingleDecodeType VIN = new SingleDecodeType(24, "VIN");
    public static final SingleDecodeType DEUTSCHE_POST_IDENTCODE = new SingleDecodeType(25, "DeutschePostIdentcode");
    public static final SingleDecodeType DEUTSCHE_POST_LEITCODE = new SingleDecodeType(26, "DeutschePostLeitcode");
    public static final SingleDecodeType OPC = new SingleDecodeType(27, "OPC");
    public static final SingleDecodeType PZN = new SingleDecodeType(28, "PZN");
    public static final SingleDecodeType PHARMACODE = new SingleDecodeType(29, "Pharmacode");
    public static final SingleDecodeType DATA_MATRIX = new SingleDecodeType(30, "DataMatrix");
    public static final SingleDecodeType GS_1_DATA_MATRIX = new SingleDecodeType(31, "GS1DataMatrix");
    public static final SingleDecodeType QR = new SingleDecodeType(32, "QR");
    public static final SingleDecodeType AZTEC = new SingleDecodeType(33, "Aztec");
    public static final SingleDecodeType GS_1_AZTEC = new SingleDecodeType(81, "GS1Aztec");
    public static final SingleDecodeType PDF_417 = new SingleDecodeType(34, "Pdf417");
    public static final SingleDecodeType MACRO_PDF_417 = new SingleDecodeType(35, "MacroPdf417");
    public static final SingleDecodeType MICRO_PDF_417 = new SingleDecodeType(36, "MicroPdf417");
    public static final SingleDecodeType GS_1_MICRO_PDF_417 = new SingleDecodeType(82, "GS1MicroPdf417");
    public static final SingleDecodeType CODABLOCK_F = new SingleDecodeType(65, "CodablockF");
    public static final SingleDecodeType AUSTRALIA_POST = new SingleDecodeType(37, "AustraliaPost");
    public static final SingleDecodeType POSTNET = new SingleDecodeType(38, "Postnet");
    public static final SingleDecodeType PLANET = new SingleDecodeType(39, "Planet");
    public static final SingleDecodeType ONE_CODE = new SingleDecodeType(40, "OneCode");
    public static final SingleDecodeType RM_4_SCC = new SingleDecodeType(41, "RM4SCC");
    public static final SingleDecodeType MAILMARK = new SingleDecodeType(66, "Mailmark");
    public static final SingleDecodeType DATABAR_OMNI_DIRECTIONAL = new SingleDecodeType(42, "DatabarOmniDirectional");
    public static final SingleDecodeType DATABAR_TRUNCATED = new SingleDecodeType(43, "DatabarTruncated");
    public static final SingleDecodeType DATABAR_LIMITED = new SingleDecodeType(44, "DatabarLimited");
    public static final SingleDecodeType DATABAR_EXPANDED = new SingleDecodeType(45, "DatabarExpanded");
    public static final SingleDecodeType DATABAR_STACKED_OMNI_DIRECTIONAL = new SingleDecodeType(53, "DatabarStackedOmniDirectional");
    public static final SingleDecodeType DATABAR_STACKED = new SingleDecodeType(54, "DatabarStacked");
    public static final SingleDecodeType DATABAR_EXPANDED_STACKED = new SingleDecodeType(55, "DatabarExpandedStacked");
    public static final SingleDecodeType PATCH_CODE = new SingleDecodeType(46, "PatchCode");
    public static final SingleDecodeType ISSN = new SingleDecodeType(47, "ISSN");
    public static final SingleDecodeType ISMN = new SingleDecodeType(48, "ISMN");
    public static final SingleDecodeType SUPPLEMENT = new SingleDecodeType(49, "Supplement");
    public static final SingleDecodeType AUSTRALIAN_POSTE_PARCEL = new SingleDecodeType(50, "AustralianPosteParcel");
    public static final SingleDecodeType SWISS_POST_PARCEL = new SingleDecodeType(51, "SwissPostParcel");
    public static final SingleDecodeType CODE_16_K = new SingleDecodeType(52, "Code16K");
    public static final SingleDecodeType MICRO_QR = new SingleDecodeType(56, "MicroQR");
    public static final SingleDecodeType COMPACT_PDF_417 = new SingleDecodeType(57, "CompactPdf417");
    public static final SingleDecodeType GS_1_QR = new SingleDecodeType(58, "GS1QR");
    public static final SingleDecodeType MAXI_CODE = new SingleDecodeType(59, "MaxiCode");
    public static final SingleDecodeType MICR_E_13_B = new SingleDecodeType(60, "MicrE13B");
    public static final SingleDecodeType CODE_32 = new SingleDecodeType(61, "Code32");
    public static final SingleDecodeType DATA_LOGIC_2_OF_5 = new SingleDecodeType(62, "DataLogic2of5");
    public static final SingleDecodeType DOT_CODE = new SingleDecodeType(63, "DotCode");
    public static final SingleDecodeType GS_1_DOT_CODE;
    public static final SingleDecodeType DUTCH_KIX;
    public static final SingleDecodeType HIBC_CODE_39_LIC;
    public static final SingleDecodeType HIBC_CODE_128_LIC;
    public static final SingleDecodeType HIBC_AZTEC_LIC;
    public static final SingleDecodeType HIBC_DATA_MATRIX_LIC;
    public static final SingleDecodeType HIBCQRLIC;
    public static final SingleDecodeType HIBC_CODE_39_PAS;
    public static final SingleDecodeType HIBC_CODE_128_PAS;
    public static final SingleDecodeType HIBC_AZTEC_PAS;
    public static final SingleDecodeType HIBC_DATA_MATRIX_PAS;
    public static final SingleDecodeType HIBCQRPAS;
    public static final SingleDecodeType HAN_XIN;
    public static final SingleDecodeType GS_1_HAN_XIN;
    public static final SingleDecodeType GS_1_COMPOSITE_BAR;
    public static final SingleDecodeType RECT_MICRO_QR;
    public static final MultiDecodeType ALL_SUPPORTED_TYPES;
    public static final MultiDecodeType TYPES_1D;
    public static final MultiDecodeType TYPES_2D;
    public static final MultiDecodeType POSTAL_TYPES;
    public static final MultiDecodeType MOST_COMMON_TYPES;

    public static String[] getNames() {
        String[] stringArray = new String[kk.a.length];
        for (int i = 0; i < kk.a.length; ++i) {
            stringArray[i] = kk.a[i].toString();
        }
        return stringArray;
    }

    public static SingleDecodeType tryParseSingleDecodeType(String parsingType) {
        SingleDecodeType[] singleDecodeTypeArray = new SingleDecodeType[]{NONE};
        if (yyr.b(parsingType)) {
            return singleDecodeTypeArray[0];
        }
        String[] stringArray = yyr.f(yyr.c(parsingType), ',');
        if (1 <= stringArray.length && !DecodeType.parse(stringArray[0], singleDecodeTypeArray)) {
            singleDecodeTypeArray[0] = NONE;
        }
        return singleDecodeTypeArray[0];
    }

    public static MultiDecodeType tryParseMultiDecodeType(String parsingType) {
        String[] stringArray;
        if (yyr.e(parsingType = yyr.c(parsingType), "AllSupportedTypes") || yyr.i(parsingType, "AllSupportedTypes")) {
            return ALL_SUPPORTED_TYPES;
        }
        MultiDecodeType multiDecodeType = null;
        for (String string : stringArray = yyr.f(parsingType, ',')) {
            SingleDecodeType singleDecodeType = DecodeType.parse(string);
            if (singleDecodeType.equals(NONE)) continue;
            if (multiDecodeType == null) {
                multiDecodeType = new MultiDecodeType(singleDecodeType);
                continue;
            }
            multiDecodeType.add(singleDecodeType);
        }
        return multiDecodeType;
    }

    public static boolean is1D(BaseDecodeType symbology) {
        return symbology.containsAny(kk.b);
    }

    public static boolean isPostal(BaseDecodeType symbology) {
        return symbology.containsAny(kk.d);
    }

    public static boolean is2D(BaseDecodeType symbology) {
        return symbology.containsAny(kk.c);
    }

    public static SingleDecodeType[] getAllSupportedTypesArray() {
        return kk.a;
    }

    public static BaseDecodeType scanSets(BaseDecodeType ... barcodeTypes) {
        MultiDecodeType multiDecodeType = new MultiDecodeType(barcodeTypes);
        return multiDecodeType;
    }

    public static SingleDecodeType parse(String parsingType) {
        int n = -1;
        parsingType = yyr.c(parsingType);
        for (int i = 0; i < kk.a.length; ++i) {
            if (!yyr.e(kk.a[i].getTypeName(), parsingType) && !yyr.e(uu.a(kk.a[i].getTypeName()), parsingType)) continue;
            n = i;
            break;
        }
        if (yyr.e(parsingType, NONE.getTypeName())) {
            return NONE;
        }
        if (n > -1) {
            return kk.a[n];
        }
        return NONE;
    }

    public static boolean parse(String parsingType, SingleDecodeType[] result) {
        int n = -1;
        parsingType = parsingType.trim();
        for (int i = 0; i < kk.a.length; ++i) {
            String string = kk.a[i].getTypeName();
            String string2 = String.join((CharSequence)"_", string.split("(?=\\p{Upper})")).toUpperCase();
            if (!Objects.equals(string, parsingType) && !Objects.equals(string2, parsingType)) continue;
            n = i;
            break;
        }
        if (parsingType.equals(NONE.getTypeName())) {
            result[0] = NONE;
            return true;
        }
        if (n > -1) {
            result[0] = kk.a[n];
            return true;
        }
        result[0] = NONE;
        return false;
    }

    static {
        DUTCH_KIX = new SingleDecodeType(64, "DutchKIX");
        HIBC_CODE_39_LIC = new SingleDecodeType(67, "HIBCCode39LIC");
        HIBC_CODE_128_LIC = new SingleDecodeType(68, "HIBCCode128LIC");
        HIBC_AZTEC_LIC = new SingleDecodeType(69, "HIBCAztecLIC");
        HIBC_DATA_MATRIX_LIC = new SingleDecodeType(70, "HIBCDataMatrixLIC");
        HIBCQRLIC = new SingleDecodeType(71, "HIBCQRLIC");
        HIBC_CODE_39_PAS = new SingleDecodeType(72, "HIBCCode39PAS");
        HIBC_CODE_128_PAS = new SingleDecodeType(73, "HIBCCode128PAS");
        HIBC_AZTEC_PAS = new SingleDecodeType(74, "HIBCAztecPAS");
        HIBC_DATA_MATRIX_PAS = new SingleDecodeType(75, "HIBCDataMatrixPAS");
        HIBCQRPAS = new SingleDecodeType(76, "HIBCQRPAS");
        GS_1_DOT_CODE = new SingleDecodeType(77, "GS1DotCode");
        HAN_XIN = new SingleDecodeType(78, "HanXin");
        GS_1_HAN_XIN = new SingleDecodeType(79, "GS1HanXin");
        GS_1_COMPOSITE_BAR = new SingleDecodeType(80, "GS1CompositeBar");
        RECT_MICRO_QR = new SingleDecodeType(83, "RectMicroQR");
        TYPES_1D = new MultiDecodeType(kk.b);
        TYPES_2D = new MultiDecodeType(kk.c);
        POSTAL_TYPES = new MultiDecodeType(kk.d);
        MOST_COMMON_TYPES = new MultiDecodeType(kk.e);
        ALL_SUPPORTED_TYPES = new MultiDecodeType(kk.a);
    }
}

