package com.aspose.barcode.examples;

import com.aspose.barcode.License;
import com.aspose.barcode.auxiliary.Global;
import com.aspose.barcode.barcoderecognition.BarCodeReader;
import com.aspose.barcode.barcoderecognition.BarCodeResult;
import com.aspose.barcode.barcoderecognition.DecodeType;
import com.aspose.barcode.complexbarcode.ComplexBarcodeGenerator;
import com.aspose.barcode.complexbarcode.ComplexCodetextReader;
import com.aspose.barcode.complexbarcode.Mailmark2DCodetext;
import com.aspose.barcode.complexbarcode.Mailmark2DType;
import com.aspose.barcode.generation.BarcodeGenerator;
import com.aspose.barcode.generation.EncodeTypes;
import com.aspose.barcode.generation.SymbologyEncodeType;
import org.testng.annotations.Test;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class QuickStart
{
    public String folder = Global.getTestDataFolder("QuickStart");

    @Test
    public void recognitionExample1() throws Exception
    {
        String fileName = folder + "code_128.gif";
        String licensePath = Global.getTestDataFolder("License/sha256/Aspose/Java/Aspose.BarCode.Java.256.lic");
        License license = new License();
        license.setLicense(licensePath);
        BarCodeReader reader = new BarCodeReader(fileName, DecodeType.CODE_128);
        BarCodeResult[] barCodeResults = reader.readBarCodes();
        for (BarCodeResult barCodeResult : barCodeResults)
        {
            System.out.println("Code Type : " + barCodeResult.getCodeTypeName());
            System.out.println("Code Text : " + barCodeResult.getCodeText());
        }
    }

//  @Test
//    public void recognitionExample2() throws Exception
//    {
//        String fileName = folder + "code_128.gif";
//        String licensePath =  "Aspose.BarCode.Java.lic";
//        License license = new License();
//        license.setLicense(licensePath);
//        try (FileInputStream fileStream = new FileInputStream(fileName))
//        {
//            BarCodeReader reader = new BarCodeReader(fileStream);
//            for (BarCodeResult result : reader.readBarCodes())
//            {
//                System.out.printf("Symbology Type: %s%n", result.getCodeType());
//                System.out.printf("CodeText: %s%n", result.getCodeText());
//            }
//        }
//        catch (IOException e)
//        {
//            e.printStackTrace();
//        }
//    }

    @Test
    public void generationExample() throws Exception
    {
        String licensePath = Global.getTestDataFolder("License/sha256/Aspose/Java/Aspose.BarCode.Java.256.lic");
        License license = new License();
        license.setLicense(licensePath);
        String codeText = "01234567";
        SymbologyEncodeType encodeType = EncodeTypes.QR;
        BarcodeGenerator generator = new BarcodeGenerator(encodeType, codeText);
        String pathToFile = folder + "qr.png";
        generator.save(pathToFile);
        BarCodeReader reader = new BarCodeReader(pathToFile, DecodeType.QR);
        BarCodeResult[] barCodeResults = reader.readBarCodes();
        for (BarCodeResult barCodeResult : barCodeResults)
        {
            System.out.println("Code Type : " + barCodeResult.getCodeTypeName());
            System.out.println("Code Text : " + barCodeResult.getCodeText());
        }
    }

    @Test
    public void generationAndReadComplexBarcodeExample() throws Exception
    {
        String licensePath = Global.getTestDataFolder("License/sha256/Aspose/Java/Aspose.BarCode.Java.256.lic");
        License license = new License();
        license.setLicense(licensePath);
        Mailmark2DCodetext mailmark2DCodetext = new Mailmark2DCodetext();
        mailmark2DCodetext.setUPUCountryID("JGB ");
        mailmark2DCodetext.setInformationTypeID("0");
        mailmark2DCodetext.setVersionID("1");
        mailmark2DCodetext.setclass("1");
        mailmark2DCodetext.setSupplyChainID(123);
        mailmark2DCodetext.setItemID(1234);
        mailmark2DCodetext.setDestinationPostCodeAndDPS("QWE1");
        mailmark2DCodetext.setRTSFlag("0");
        mailmark2DCodetext.setReturnToSenderPostCode("QWE2");
        mailmark2DCodetext.setDataMatrixType(Mailmark2DType.TYPE_29);
        mailmark2DCodetext.setCustomerContent("CUSTOM_DATA");
        ComplexBarcodeGenerator cg = new ComplexBarcodeGenerator(mailmark2DCodetext);
        BufferedImage res = cg.generateBarCodeImage();
        BarCodeReader barCodeReader = new BarCodeReader(res, DecodeType.DATA_MATRIX);
        {
            System.out.println("Found barcodes: " + barCodeReader.readBarCodes().length);
            Mailmark2DCodetext mailmark2DCodetextActual = ComplexCodetextReader.tryDecodeMailmark2D(barCodeReader.getFoundBarCodes()[0].getCodeText());
            System.out.println("Codetext: " + mailmark2DCodetextActual.getConstructedCodetext());
        }
    }
}
