/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.gridjs;

import com.aspose.gridjs.CoWorkUserProvider;
import com.aspose.gridjs.Config;
import com.aspose.gridjs.GridJsPermissionException;
import com.aspose.gridjs.IGridJsService;
import com.aspose.gridjs.OprMessage;
import com.aspose.gridjs.OprMessageDto;
import com.aspose.gridjs.OprMessageRepository;
import com.aspose.gridjs.OprMessageService;
import com.aspose.gridjs.a18;
import com.aspose.gridjs.w7v;
import com.aspose.gridjs.x1n;
import com.aspose.release.ObfuscationSpec;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@ObfuscationSpec(value="2")
@Service
@ConditionalOnProperty(prefix="gridjs", name={"iscollabrative"}, havingValue="true")
public class GridJsCoService {
    private final CoWorkUserProvider currentUserProvider;
    @Autowired
    private OprMessageService oprMessageService;
    @Autowired
    private OprMessageRepository oprMessageRepo;
    @Autowired
    private IGridJsService gridJsService;
    @Autowired
    private SimpMessagingTemplate messagingTemplate;
    ThreadPoolTaskExecutor executor;

    public GridJsCoService(CoWorkUserProvider currentUserProvider) {
        this.currentUserProvider = currentUserProvider;
        this.executor = new ThreadPoolTaskExecutor();
        this.executor.setCorePoolSize(10);
        this.executor.setMaxPoolSize(50);
        this.executor.setQueueCapacity(100);
        this.executor.setThreadNamePrefix("Async-");
        this.executor.initialize();
    }

    public void checkAndSyncForCollaborative(String uid) throws Exception {
        boolean bl = this.gridJsService.checkInCacheForCollaborative(uid);
        if (!bl) {
            this.oprMessageService.syncHistory(this.gridJsService, uid);
        }
    }

    public List<OprMessage> getFileHistory(String fileId, int limit) {
        return this.oprMessageService.getFileHistory(fileId, limit);
    }

    public void handleMessage(String uid, OprMessageDto dto) {
        String string = uid;
        String string2 = this.currentUserProvider.getCurrentUserName();
        Long l = this.currentUserProvider.getCurrentUserId();
        int n = this.currentUserProvider.getPermission();
        String string3 = Config.getMessageTopic().split("/")[1];
        String string4 = "/" + string3;
        try {
            x1n.a(n, 6, "Collaborative operation: updateCell ");
        }
        catch (GridJsPermissionException gridJsPermissionException) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("Error", "insufficent permission: " + gridJsPermissionException.getMessage());
            hashMap.put("requestId", dto.getRequestId());
            hashMap.put("type", "permission");
            hashMap.put("clientId", dto.getClientId());
            hashMap.put("userName", string2);
            this.messagingTemplate.convertAndSend((Object)(string4 + "/errors/" + string), hashMap);
            return;
        }
        OprMessage oprMessage = new OprMessage();
        oprMessage.setFileId(string);
        oprMessage.setContent(dto.getContent());
        oprMessage.setOperationType(String.valueOf(dto.getOperationType()));
        oprMessage.setUserId(l);
        oprMessage.setUserName(string2);
        String string5 = w7v.f(dto.getContent());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("status", "PROCESSING");
        hashMap.put("requestId", dto.getRequestId());
        hashMap.put("clientId", dto.getClientId());
        hashMap.put("userName", string2);
        this.messagingTemplate.convertAndSend((Object)(string4 + "/ack/" + string), hashMap);
        this.executor.execute((Runnable)new a18(this, string, string5, oprMessage, dto, string2, string4));
    }

    static /* synthetic */ IGridJsService access$000(GridJsCoService x0) {
        return x0.gridJsService;
    }

    static /* synthetic */ OprMessageRepository access$100(GridJsCoService x0) {
        return x0.oprMessageRepo;
    }

    static /* synthetic */ SimpMessagingTemplate access$200(GridJsCoService x0) {
        return x0.messagingTemplate;
    }
}

