/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.gridjs;

import com.aspose.gridjs.Config;
import com.aspose.gridjs.GridInterruptMonitor;
import com.aspose.gridjs.GridJsCoService;
import com.aspose.gridjs.GridJsPermissionException;
import com.aspose.gridjs.IGridJsService;
import com.aspose.gridjs.a.b.o3j;
import com.aspose.gridjs.z5_;
import com.aspose.release.ObfuscationSpec;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
@ObfuscationSpec(value="2")
public abstract class GridJsControllerBase {
    protected IGridJsService _gridJsService;
    @Autowired(required=false)
    protected GridJsCoService _gridJsCoService;
    private static final Map<String, MediaType> MIME_TYPE_MAP = new HashMap<String, MediaType>();

    @Autowired
    public GridJsControllerBase(IGridJsService gridJsService) {
        this._gridJsService = gridJsService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/LazyLoadingStreamJson"})
    public void lazyLoadingStreamJson(@RequestParam(value="name", required=false) String sheetName, @RequestParam(value="uid", required=false) String uid, HttpServletResponse response) throws IOException {
        response.setContentType("application/json");
        response.setHeader("Content-Encoding", "gzip");
        GZIPOutputStream gZIPOutputStream = null;
        try {
            gZIPOutputStream = new GZIPOutputStream((OutputStream)response.getOutputStream());
            try {
                this._gridJsService.lazyLoadingStreamJson(gZIPOutputStream, sheetName, uid);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (gZIPOutputStream != null) {
                try {
                    gZIPOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    @PostMapping(value={"/UpdateCell"})
    public ResponseEntity<String> updateCell(HttpServletRequest request) {
        String string = request.getParameter("p");
        String string2 = request.getParameter("uid");
        try {
            String string3 = this._gridJsService.updateCell(string, string2);
            return new ResponseEntity((Object)string3, HttpStatus.OK);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new ResponseEntity((Object)z5_.d(exception.getMessage()), HttpStatus.OK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PostMapping(value={"/AddImage"})
    public ResponseEntity<String> addImage(@RequestParam(value="image", required=false) MultipartFile file, @RequestParam(value="uid") String uid, @RequestParam(value="p") String p, @RequestParam(value="control", required=false) String isControl) {
        String string = null;
        InputStream inputStream = null;
        try {
            if (this._gridJsCoService != null && Config.isCollaborative()) {
                this._gridJsCoService.checkAndSyncForCollaborative(uid);
            }
            if (isControl != null) {
                string = this._gridJsService.addImage(p, uid, null);
                return new ResponseEntity((Object)string, HttpStatus.OK);
            }
            if (file != null && !file.isEmpty()) {
                try {
                    inputStream = file.getInputStream();
                    string = this._gridJsService.addImage(p, uid, inputStream);
                    return new ResponseEntity((Object)string, HttpStatus.OK);
                }
                catch (IOException iOException) {
                    ResponseEntity responseEntity = new ResponseEntity((Object)z5_.d(iOException.getMessage()), HttpStatus.BAD_REQUEST);
                    return responseEntity;
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                }
            }
            string = this._gridJsService.addImage(p, uid, null);
            return new ResponseEntity((Object)string, HttpStatus.OK);
        }
        catch (GridJsPermissionException gridJsPermissionException) {
            String string2 = "{\"Error\": \"" + gridJsPermissionException.getMessage() + "\",\"type\":\"permission\"}";
            return ResponseEntity.status((int)403).body((Object)string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new ResponseEntity((Object)"Error occurred while uploading file", HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PostMapping(value={"/CopyImage"})
    public ResponseEntity<String> copyImage(HttpServletRequest request) {
        String string = request.getParameter("uid");
        String string2 = request.getParameter("p");
        try {
            if (this._gridJsCoService != null && Config.isCollaborative()) {
                this._gridJsCoService.checkAndSyncForCollaborative(string);
            }
            String string3 = this._gridJsService.copyImage(string2, string);
            return new ResponseEntity((Object)string3, HttpStatus.OK);
        }
        catch (GridJsPermissionException gridJsPermissionException) {
            String string4 = "{\"Error\": \"" + gridJsPermissionException.getMessage() + "\",\"type\":\"permission\"}";
            return ResponseEntity.status((int)403).body((Object)string4);
        }
        catch (Exception exception) {
            return new ResponseEntity((Object)z5_.d(exception.getMessage()), HttpStatus.OK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PostMapping(value={"/AddImageByURL"})
    public ResponseEntity<String> addImageByUrl(HttpServletRequest request) {
        String string = request.getParameter("uid");
        String string2 = request.getParameter("p");
        String string3 = request.getParameter("imageurl");
        String string4 = null;
        InputStream inputStream = null;
        try {
            if (this._gridJsCoService != null && Config.isCollaborative()) {
                this._gridJsCoService.checkAndSyncForCollaborative(string);
            }
            if (string3 == null) return new ResponseEntity((Object)z5_.d("image url is null"), HttpStatus.BAD_REQUEST);
            try {
                inputStream = o3j.b(string3);
                string4 = this._gridJsService.addImageByURL(string2, string, inputStream, string3);
                return new ResponseEntity((Object)string4, HttpStatus.OK);
            }
            catch (IOException iOException) {
                ResponseEntity responseEntity = new ResponseEntity((Object)z5_.d(iOException.getMessage()), HttpStatus.BAD_REQUEST);
                return responseEntity;
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException3) {
                        iOException3.printStackTrace();
                    }
                }
            }
        }
        catch (GridJsPermissionException gridJsPermissionException) {
            String string5 = "{\"Error\": \"" + gridJsPermissionException.getMessage() + "\",\"type\":\"permission\"}";
            return ResponseEntity.status((int)403).body((Object)string5);
        }
        catch (Exception exception) {
            return new ResponseEntity((Object)z5_.d(exception.getMessage()), HttpStatus.OK);
        }
    }

    @GetMapping(value={"/Image"})
    public ResponseEntity<InputStreamResource> getImage(HttpServletRequest request) {
        String string = request.getParameter("id");
        String string2 = request.getParameter("uid");
        try {
            InputStream inputStream = this._gridJsService.image(string2, string);
            if (inputStream == null) {
                return ResponseEntity.notFound().build();
            }
            return ResponseEntity.ok().contentType(MediaType.IMAGE_PNG).body((Object)new InputStreamResource(inputStream));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return ResponseEntity.notFound().build();
        }
    }

    @GetMapping(value={"/ImageUrl"})
    public ResponseEntity<String> getImageUrl(@RequestParam String id, @RequestParam String uid) {
        String string = null;
        try {
            string = this._gridJsService.imageUrl(Config.getBaseRouteName(), id, uid);
            return ResponseEntity.ok((Object)string);
        }
        catch (Exception exception) {
            return new ResponseEntity((Object)z5_.d(exception.getMessage()), HttpStatus.OK);
        }
    }

    @GetMapping(value={"/Ole"})
    public ResponseEntity<?> getOle(HttpServletRequest request) {
        int n = Integer.parseInt(request.getParameter("id"));
        String string = request.getParameter("uid");
        String string2 = request.getParameter("sheet");
        String[] stringArray = new String[1];
        try {
            byte[] byArray = this._gridJsService.ole(string, string2, n, stringArray);
            if (stringArray != null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(GridJsControllerBase.getMimeType(stringArray[0])).header("Content-Disposition", new String[]{"attachment; filename=\"" + stringArray[0] + "\""})).body((Object)byArray);
            }
            return ResponseEntity.notFound().build();
        }
        catch (Exception exception) {
            return new ResponseEntity((Object)z5_.d(exception.getMessage()), HttpStatus.OK);
        }
    }

    @GetMapping(value={"/GetFile"})
    public ResponseEntity<?> getFile(@RequestParam(value="id") String id) {
        String string = id;
        MediaType mediaType = GridJsControllerBase.getMimeType(string);
        String string2 = string.replace('/', '.');
        InputStreamResource inputStreamResource = null;
        try {
            inputStreamResource = new InputStreamResource(this._gridJsService.getFile(string));
        }
        catch (Exception exception) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Error retrieving file: " + exception.getMessage()));
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=" + string2})).contentType(mediaType).body((Object)inputStreamResource);
    }

    @PostMapping(value={"/Download"})
    public ResponseEntity<String> download(HttpServletRequest request) {
        String string = request.getParameter("p");
        String string2 = request.getParameter("uid");
        String string3 = request.getParameter("file");
        try {
            if (this._gridJsCoService != null && Config.isCollaborative()) {
                this._gridJsCoService.checkAndSyncForCollaborative(string2);
            }
            String string4 = this._gridJsService.download(string, string2, string3);
            string4 = "\"" + string4 + "\"";
            return new ResponseEntity((Object)string4, HttpStatus.OK);
        }
        catch (GridJsPermissionException gridJsPermissionException) {
            String string5 = "{\"Error\": \"" + gridJsPermissionException.getMessage() + "\",\"type\":\"permission\"}";
            return ResponseEntity.status((int)403).body((Object)string5);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new ResponseEntity((Object)z5_.d(exception.getMessage()), HttpStatus.OK);
        }
    }

    static MediaType getMimeType(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            return MediaType.APPLICATION_OCTET_STREAM;
        }
        String string = GridJsControllerBase.getFileExtension(fileName);
        MediaType mediaType = MIME_TYPE_MAP.get(string.toLowerCase());
        return mediaType != null ? mediaType : MediaType.APPLICATION_OCTET_STREAM;
    }

    private static String getFileExtension(String fileName) {
        int n = fileName.lastIndexOf(46);
        if (n == -1 || n == fileName.length() - 1) {
            return "";
        }
        return fileName.substring(n + 1);
    }

    private static void InterruptMonitor(GridInterruptMonitor monitor, int milliseconds) {
        try {
            Thread.sleep(milliseconds);
            monitor.interrupt();
        }
        catch (Exception exception) {
            System.out.println("Succeeded for load in give time.");
        }
    }

    static {
        MIME_TYPE_MAP.put("txt", MediaType.TEXT_PLAIN);
        MIME_TYPE_MAP.put("html", MediaType.TEXT_HTML);
        MIME_TYPE_MAP.put("xml", MediaType.APPLICATION_XML);
        MIME_TYPE_MAP.put("json", MediaType.APPLICATION_JSON);
        MIME_TYPE_MAP.put("png", MediaType.IMAGE_PNG);
        MIME_TYPE_MAP.put("jpg", MediaType.IMAGE_JPEG);
        MIME_TYPE_MAP.put("jpeg", MediaType.IMAGE_JPEG);
        MIME_TYPE_MAP.put("gif", MediaType.IMAGE_GIF);
        MIME_TYPE_MAP.put("pdf", MediaType.APPLICATION_PDF);
        MIME_TYPE_MAP.put("doc", MediaType.valueOf((String)"application/msword"));
        MIME_TYPE_MAP.put("dot", MediaType.valueOf((String)"application/msword"));
        MIME_TYPE_MAP.put("docx", MediaType.valueOf((String)"application/vnd.openxmlformats-officedocument.wordprocessingml.document"));
        MIME_TYPE_MAP.put("dotx", MediaType.valueOf((String)"application/vnd.openxmlformats-officedocument.wordprocessingml.template"));
        MIME_TYPE_MAP.put("xls", MediaType.valueOf((String)"application/vnd.ms-excel"));
        MIME_TYPE_MAP.put("xlt", MediaType.valueOf((String)"application/vnd.ms-excel"));
        MIME_TYPE_MAP.put("xlsx", MediaType.valueOf((String)"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"));
        MIME_TYPE_MAP.put("xltx", MediaType.valueOf((String)"application/vnd.openxmlformats-officedocument.spreadsheetml.template"));
        MIME_TYPE_MAP.put("ppt", MediaType.valueOf((String)"application/vnd.ms-powerpoint"));
        MIME_TYPE_MAP.put("pot", MediaType.valueOf((String)"application/vnd.ms-powerpoint"));
        MIME_TYPE_MAP.put("pptx", MediaType.valueOf((String)"application/vnd.openxmlformats-officedocument.presentationml.presentation"));
        MIME_TYPE_MAP.put("potx", MediaType.valueOf((String)"application/vnd.openxmlformats-officedocument.presentationml.template"));
        MIME_TYPE_MAP.put("zip", MediaType.valueOf((String)"application/zip"));
        MIME_TYPE_MAP.put("rar", MediaType.valueOf((String)"application/x-rar-compressed"));
        MIME_TYPE_MAP.put("gz", MediaType.valueOf((String)"application/gzip"));
    }
}

