/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.gridjs;

import com.aspose.cells.Workbook;
import com.aspose.gridjs.CoWorkUserProvider;
import com.aspose.gridjs.Config;
import com.aspose.gridjs.GridCellException;
import com.aspose.gridjs.GridInterruptMonitor;
import com.aspose.gridjs.GridJsOptions;
import com.aspose.gridjs.GridJsWorkbook;
import com.aspose.gridjs.IGridJsService;
import com.aspose.gridjs.b.a.d.t3u;
import com.aspose.gridjs.i1;
import com.aspose.gridjs.q7l;
import com.aspose.gridjs.w7v;
import com.aspose.gridjs.x1n;
import com.aspose.release.ObfuscationSpec;
import java.io.InputStream;
import java.io.OutputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ObfuscationSpec(value="2")
@Service
public class GridJsService
implements IGridJsService {
    private final GridJsOptions _gridJsOptions;
    @Autowired(required=false)
    private CoWorkUserProvider userProvider;
    private GridJsWorkbook wbj = new GridJsWorkbook();
    private boolean skipPermissionCheck = false;

    public GridJsService(GridJsOptions options) throws Exception {
        this._gridJsOptions = options;
        if (this._gridJsOptions.getPictureCacheDirectory() != null) {
            Config.setPictureCacheDirectory(this._gridJsOptions.getPictureCacheDirectory());
        }
        if (this._gridJsOptions.CacheImp != null) {
            GridJsWorkbook.CacheImp = this._gridJsOptions.CacheImp;
        } else {
            Config.setFileCacheDirectory(this._gridJsOptions.getFileCacheDirectory());
            GridJsWorkbook.CacheImp = new i1();
        }
        Config.setSaveHtmlAsZip(this._gridJsOptions.getSaveHtmlAsZip());
        Config.setSkipInvisibleShapes(this._gridJsOptions.getSkipInvisibleShapes());
        Config.setLazyLoading(this._gridJsOptions.getLazyLoading());
        Config.setSameImageDetecting(this._gridJsOptions.getSameImageDetecting());
        Config.setAutoOptimizeForLargeCells(this._gridJsOptions.getAutoOptimizeForLargeCells());
        Config.setIslimitShapeOrImage(this._gridJsOptions.getIslimitShapeOrImage());
        Config.setMaxShapeOrImageCount(this._gridJsOptions.getMaxShapeOrImageCount());
        Config.setMaxTotalShapeOrImageCount(this._gridJsOptions.getMaxTotalShapeOrImageCount());
        Config.setMaxShapeOrImageWidthOrHeight(this._gridJsOptions.getMaxShapeOrImageWidthOrHeight());
        Config.setMaxPdfSaveSeconds(this._gridJsOptions.getMaxPdfSaveSeconds());
        Config.setIgnoreEmptyContent(this._gridJsOptions.getIgnoreEmptyContent());
        Config.setUsePrintArea(this._gridJsOptions.getUsePrintArea());
        Config.setCollaborative(this._gridJsOptions.isCollaborative());
        Config.setCustomPdfSaveOptions(this._gridJsOptions.getCustomPdfSaveOptions());
        Config.setShowChartSheet(this._gridJsOptions.getShowChartSheet());
        Config.a(this._gridJsOptions.a());
        Config.setEmptySheetMaxRow(this._gridJsOptions.getEmptySheetMaxRow());
        Config.setEmptySheetMaxCol(this._gridJsOptions.getEmptySheetMaxCol());
        Config.setBaseRouteName(this._gridJsOptions.getBaseRouteName());
        Config.setMessageTopic(this._gridJsOptions.getMessageTopic());
        if (this._gridJsOptions.getFontFolders() != null) {
            Config.setFontFolders(this._gridJsOptions.getFontFolders(), true);
        }
    }

    void setSkipPermissionCheck(boolean v) {
        this.skipPermissionCheck = v;
    }

    private void checkPermission(int operationType, String operation) throws Exception {
        if (this.userProvider != null && !this.skipPermissionCheck) {
            int n = this.userProvider.getPermission();
            x1n.a(n, operationType, operation);
        }
    }

    private boolean hasPermission(int requiredPermission) {
        if (this.userProvider == null) {
            return true;
        }
        int n = this.userProvider.getPermission();
        return x1n.b(n, requiredPermission);
    }

    @Override
    public boolean checkInCacheForCollaborative(String uid) throws Exception {
        return this.wbj.checkInCacheForCollaborative(uid);
    }

    @Override
    public String updateCell(String p, String uid) throws Exception {
        return this.wbj.updateCell(p, uid);
    }

    @Override
    public StringBuilder detailFileJsonWithUid(String filePath, String uid) throws Exception {
        this.checkPermission(1, "DetailFileJsonWithUid");
        String string = t3u.a(filePath);
        StringBuilder stringBuilder = this.wbj.getJsonByUid(uid, string);
        if (stringBuilder == null) {
            Workbook workbook = new Workbook(filePath);
            this.wbj.importExcelFile(uid, workbook);
            return this.wbj.exportToJsonStringBuilder(string);
        }
        return stringBuilder;
    }

    @Override
    public StringBuilder detailFileJsonWithUid(Workbook wb, String filename, String uid) throws Exception {
        this.checkPermission(1, "DetailFileJsonWithUid");
        StringBuilder stringBuilder = this.wbj.getJsonByUid(uid, filename);
        if (stringBuilder == null) {
            this.wbj.importExcelFile(uid, wb);
            return this.wbj.exportToJsonStringBuilder(filename);
        }
        return stringBuilder;
    }

    @Override
    public void detailStreamJsonWithUid(OutputStream stream, String filePath, String uid) throws Exception {
        this.checkPermission(1, "DetailStreamJsonWithUid");
        String string = t3u.a(filePath);
        boolean bl = this.wbj.jsonToStreamByUid(stream, uid, string);
        if (!bl) {
            Workbook workbook = new Workbook(filePath);
            this.wbj.importExcelFile(uid, workbook);
            this.wbj.jsonToStream(stream, string);
        }
    }

    @Override
    public void detailStreamJsonWithUid(OutputStream stream, Workbook wb, String filename, String uid) throws Exception {
        this.checkPermission(1, "DetailStreamJsonWithUid");
        boolean bl = this.wbj.jsonToStreamByUid(stream, uid, filename);
        if (!bl) {
            this.wbj.importExcelFile(uid, wb);
            this.wbj.jsonToStream(stream, filename);
        }
    }

    @Override
    public void detailStreamJson(OutputStream stream, String filePath) throws Exception {
        this.checkPermission(1, "DetailStreamJson");
        String string = t3u.a(filePath);
        Workbook workbook = new Workbook(filePath);
        this.detailStreamJson(stream, workbook, string);
    }

    @Override
    public void detailStreamJson(OutputStream stream, Workbook wb, String filename) throws Exception {
        this.checkPermission(1, "DetailStreamJson");
        this.wbj.importExcelFile(wb);
        this.wbj.jsonToStream(stream, filename);
    }

    @Override
    public StringBuilder lazyLoadingJson(String sheetName, String uid) throws Exception {
        return this.wbj.lazyLoadingJson(uid, sheetName);
    }

    @Override
    public void lazyLoadingStreamJson(OutputStream stream, String sheetName, String uid) throws Exception {
        this.wbj.lazyLoadingStream(stream, uid, sheetName);
    }

    private String detailJson(String filePath) throws Exception {
        this.wbj.setWarningCallback(new q7l());
        String string = t3u.a(filePath);
        try {
            GridInterruptMonitor gridInterruptMonitor = new GridInterruptMonitor();
            this.wbj.setInterruptMonitorForLoad(gridInterruptMonitor, 50000);
            GridJsService.threadStartMonitor(gridInterruptMonitor, 90000);
            Workbook workbook = new Workbook(filePath);
            this.wbj.importExcelFile(workbook);
        }
        catch (Exception exception) {
            if (exception instanceof GridCellException) {
                return this.wbj.errorJson(((GridCellException)exception).getMessage() + ((GridCellException)exception).getCode());
            }
            return this.wbj.errorJson(exception.getMessage());
        }
        return this.wbj.exportToJson(string);
    }

    private String detailJson(Workbook wb, String filename) throws Exception {
        this.wbj.setWarningCallback(new q7l());
        try {
            GridInterruptMonitor gridInterruptMonitor = new GridInterruptMonitor();
            this.wbj.setInterruptMonitorForLoad(gridInterruptMonitor, 50000);
            GridJsService.threadStartMonitor(gridInterruptMonitor, 90000);
            this.wbj.importExcelFile(wb);
        }
        catch (Exception exception) {
            if (exception instanceof GridCellException) {
                return this.wbj.errorJson(((GridCellException)exception).getMessage() + ((GridCellException)exception).getCode());
            }
            return this.wbj.errorJson(exception.getMessage());
        }
        return this.wbj.exportToJson(filename);
    }

    @Override
    public String addImage(String p, String uid, InputStream filestream) throws Exception {
        this.checkPermission(7, "AddImage");
        return this.wbj.insertImage(uid, p, filestream, null);
    }

    @Override
    public String addImageByURL(String p, String uid, InputStream filestream, String imageurl) throws Exception {
        this.checkPermission(7, "AddImageByURL");
        return this.wbj.insertImage(uid, p, filestream, imageurl);
    }

    @Override
    public String copyImage(String p, String uid) throws Exception {
        this.checkPermission(8, "copyImage");
        return this.wbj.copyImageOrShape(uid, p);
    }

    @Override
    public String load(String uid, String filename) throws Exception {
        StringBuilder stringBuilder = null;
        try {
            stringBuilder = this.wbj.getJsonByUid(uid, filename);
        }
        catch (Exception exception) {
            if (exception instanceof GridCellException) {
                return this.wbj.errorJson(((GridCellException)exception).getMessage() + ((GridCellException)exception).getCode());
            }
            return this.wbj.errorJson(exception.getMessage());
        }
        if (stringBuilder == null) {
            return this.wbj.errorJson("cannot find the file");
        }
        return com.aspose.gridjs.b.a.t3u.a(stringBuilder);
    }

    @Override
    public InputStream image(String uid, String picid) throws Exception {
        return GridJsWorkbook.getImageStream(uid, picid);
    }

    @Override
    public byte[] ole(String uid, String sheet, int oleid, String[] filename) throws Exception {
        return this.wbj.getOle(uid, sheet, oleid, filename);
    }

    @Override
    public String imageUrl(String baseURL, String picid, String uid) {
        if (GridJsWorkbook.CacheImp != null) {
            return GridJsWorkbook.getImageUrl(uid, picid, ".");
        }
        String string = uid + "." + picid;
        return baseURL + "/GetZipFile?f=" + string;
    }

    @Override
    public InputStream getFile(String fileid) {
        if (GridJsWorkbook.CacheImp != null) {
            return GridJsWorkbook.CacheImp.loadStream(fileid);
        }
        return null;
    }

    @Override
    public String download(String p, String uid, String filename) throws Exception {
        block3: {
            this.checkPermission(13, "download");
            this.wbj.mergeExcelFileFromJson(uid, p);
            GridInterruptMonitor gridInterruptMonitor = new GridInterruptMonitor();
            this.wbj.setInterruptMonitorForSave(gridInterruptMonitor);
            GridJsService.threadStartMonitor(gridInterruptMonitor, 30000);
            try {
                this.wbj.saveToCacheWithFileName(uid, filename, null);
            }
            catch (Exception exception) {
                if (!(exception instanceof GridCellException)) break block3;
                return ((GridCellException)exception).getMessage() + ((GridCellException)exception).getCode();
            }
        }
        if (Config.getSaveHtmlAsZip() && filename.endsWith(".html")) {
            filename = filename + ".zip";
        }
        String string = null;
        string = GridJsWorkbook.CacheImp != null ? GridJsWorkbook.CacheImp.getFileUrl(uid + "/" + filename) : Config.getBaseRouteName() + "/GetFile?id=" + uid + "&filename=" + filename;
        return string;
    }

    private static void threadStartMonitor(GridInterruptMonitor m, int timeMilliSeconds) {
        w7v.a(m, (long)timeMilliSeconds);
    }

    private static void interruptMonitor(Object o) {
        Object[] objectArray = (Object[])o;
        try {
            Thread.sleep(((Integer)objectArray[1]).intValue());
            ((GridInterruptMonitor)objectArray[0]).interrupt();
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Succeeded for load in given time.");
        }
    }

    private static InputStream getStreamFromUrl(String url) {
        return w7v.d(url);
    }
}

