/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.gridjs;

import com.aspose.gridjs.GridJsService;
import com.aspose.gridjs.IGridJsService;
import com.aspose.gridjs.OprMessage;
import com.aspose.gridjs.OprMessageRepository;
import com.aspose.gridjs.a.b.o3j;
import com.aspose.gridjs.w7v;
import com.aspose.release.ObfuscationSpec;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;

@ObfuscationSpec(value="2")
@Service
@ConditionalOnProperty(prefix="gridjs", name={"iscollabrative"}, havingValue="true")
public class OprMessageService {
    @Autowired
    private OprMessageRepository oprMessageRepo;
    private int historyCount = 5000;

    public List<OprMessage> getFileHistory(String fileId, int limit) {
        return this.oprMessageRepo.findByFileIdOrderByCreatedOnAsc(fileId, PageRequest.of((int)0, (int)limit));
    }

    public List<OprMessage> getFileOperationsByType(String fileId, String operationType) {
        return this.oprMessageRepo.findByFileIdAndOperationTypeOrderByCreatedOnDesc(fileId, operationType);
    }

    public void syncHistory(IGridJsService gservice, String uniqueid) {
        ((GridJsService)gservice).setSkipPermissionCheck(true);
        List<OprMessage> list = this.getFileHistory(uniqueid, this.historyCount);
        for (OprMessage oprMessage : list) {
            String string = w7v.f(oprMessage.getContent());
            JsonObject jsonObject = JsonParser.parseString((String)string).getAsJsonObject();
            String string2 = jsonObject.get("op").getAsString();
            try {
                String string3;
                if ("insertimg".equals(string2)) {
                    String string4;
                    String string5;
                    string3 = jsonObject.get("name").getAsString();
                    JsonObject jsonObject2 = jsonObject.getAsJsonObject("datar");
                    int n = jsonObject2.get("row").getAsInt();
                    int n2 = jsonObject2.get("col").getAsInt();
                    String string6 = jsonObject2.get("type").getAsString();
                    if ("TextBox".equals(string6)) {
                        string5 = jsonObject2.get("text").getAsString();
                        string4 = "{\"ri\":" + n + ",\"ci\":" + n2 + ",\"name\":\"" + string3 + "\",\"type\":\"TextBox\",\"label\":\"" + string5 + "\"}";
                        gservice.addImage(string4, uniqueid, null);
                        continue;
                    }
                    if (jsonObject2.get("url") == null) continue;
                    string5 = jsonObject2.get("url").getAsString();
                    string4 = "{\"ri\":" + n + ",\"ci\":" + n2 + ",\"name\":\"" + string3 + "\"}";
                    int n4 = string5.indexOf("id=");
                    if (n4 != -1) {
                        String string7 = string5.substring(n4 + 3);
                        gservice.addImage(string4, uniqueid, gservice.getFile(string7));
                        continue;
                    }
                    gservice.addImage(string4, uniqueid, o3j.b(string5));
                    continue;
                }
                if ("copyimg".equals(string2)) {
                    string3 = jsonObject.get("p").toString();
                    gservice.copyImage(string3, uniqueid);
                    continue;
                }
                gservice.updateCell(string, uniqueid);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        ((GridJsService)gservice).setSkipPermissionCheck(false);
    }
}

