/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.drawing;

import com.aspose.drawing.Color;
import com.aspose.drawing.DrawingSettings;
import com.aspose.drawing.FontFamily;
import com.aspose.drawing.Graphics;
import com.aspose.drawing.Image;
import com.aspose.drawing.Pen;
import com.aspose.drawing.PointF;
import com.aspose.drawing.Rectangle;
import com.aspose.drawing.RectangleF;
import com.aspose.drawing.Size;
import com.aspose.drawing.SolidBrush;
import com.aspose.drawing.StringFormat;
import com.aspose.drawing.drawing2d.GraphicsPath;
import com.aspose.drawing.drawing2d.Matrix;
import com.aspose.drawing.e;
import com.aspose.drawing.i;
import com.aspose.drawing.imaging.BitmapData;
import com.aspose.drawing.imaging.ColorPalette;
import com.aspose.drawing.imaging.Encoder;
import com.aspose.drawing.imaging.EncoderParameter;
import com.aspose.drawing.imaging.EncoderParameters;
import com.aspose.drawing.imaging.FrameDimension;
import com.aspose.drawing.imaging.ImageFormat;
import com.aspose.drawing.imaging.Metafile;
import com.aspose.drawing.imaging.PixelFormat;
import com.aspose.drawing.imaging.PropertyItem;
import com.aspose.drawing.internal.Exceptions.ApplicationException;
import com.aspose.drawing.internal.Exceptions.ArgumentException;
import com.aspose.drawing.internal.Exceptions.ArgumentNullException;
import com.aspose.drawing.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.drawing.internal.Exceptions.InvalidOperationException;
import com.aspose.drawing.internal.Exceptions.NotImplementedException;
import com.aspose.drawing.internal.Exceptions.OutOfMemoryException;
import com.aspose.drawing.internal.Exceptions.Runtime.InteropServices.ExternalException;
import com.aspose.drawing.internal.b.p;
import com.aspose.drawing.internal.db.aw;
import com.aspose.drawing.internal.dn.bT;
import com.aspose.drawing.internal.dn.bi;
import com.aspose.drawing.internal.dn.bk;
import com.aspose.drawing.internal.dn.bs;
import com.aspose.drawing.internal.dn.cF;
import com.aspose.drawing.internal.dn.ci;
import com.aspose.drawing.internal.dn.cz;
import com.aspose.drawing.internal.dn.df;
import com.aspose.drawing.internal.dn.do;
import com.aspose.drawing.internal.dn.u;
import com.aspose.drawing.internal.hX.aC;
import com.aspose.drawing.internal.hX.aW;
import com.aspose.drawing.internal.hX.am;
import com.aspose.drawing.internal.hX.aq;
import com.aspose.drawing.internal.hX.ax;
import com.aspose.drawing.internal.hX.bD;
import com.aspose.drawing.internal.hg.c;
import com.aspose.drawing.internal.hg.f;
import com.aspose.drawing.internal.hg.g;
import com.aspose.drawing.internal.hg.h;
import com.aspose.drawing.internal.hg.l;
import com.aspose.drawing.internal.hg.n;
import com.aspose.drawing.internal.hg.o;
import com.aspose.drawing.internal.hg.r;
import com.aspose.drawing.internal.hi.aP;
import com.aspose.drawing.internal.hi.aU;
import com.aspose.drawing.internal.hi.bh;
import com.aspose.drawing.internal.hi.cB;
import com.aspose.drawing.internal.hi.eb;
import com.aspose.drawing.internal.hi.fK;
import com.aspose.drawing.internal.hi.fv;
import com.aspose.drawing.internal.hi.fw;
import com.aspose.drawing.internal.hi.t;
import com.aspose.drawing.internal.ig.k;
import com.aspose.drawing.internal.jt.d;
import com.aspose.drawing.j;
import com.aspose.drawing.system.AsyncCallback;
import com.aspose.drawing.system.EnumExtensions;
import com.aspose.drawing.system.Event;
import com.aspose.drawing.system.IAsyncResult;
import com.aspose.drawing.system.MulticastDelegate;
import com.aspose.drawing.system.collections.Generic.Dictionary;
import com.aspose.drawing.system.collections.Generic.IGenericEnumerator;
import com.aspose.drawing.system.collections.Generic.List;
import com.aspose.drawing.system.io.Stream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.UUID;

public class Bitmap
extends Image {
    private static final Color a = Color.getLightGray();
    private static final Dictionary<FrameDimension, Integer> b;
    private static GraphicsPath c;
    private final Rectangle d = new Rectangle();
    private ImageFormat e;
    private int f;
    private am[] g;
    private Dictionary<FrameDimension, Integer> h;
    private o i;
    private int[] j;
    private int k;
    private bk l;
    private bi m;
    private int n;
    private static a o;
    static final Event<a> onImageInitialized;
    private static b p;
    static final Event<b> onImageSaved;

    public Bitmap(int width, int height) {
        this.a(width, height);
    }

    public Bitmap(String filename) {
        this(filename, false);
    }

    public Bitmap(String filename, boolean useIcm) {
        if (!com.aspose.drawing.internal.hg.l.a()) {
            throw new ApplicationException("Image codecs provider is not initialized.");
        }
        if (useIcm) {
            if (DrawingSettings.getStrictMode()) {
                throw new NotImplementedException(do.a("Bitmap(string filename, bool useIcm)"));
            }
            do.a("Bitmap(string filename, bool useIcm)", "Ignored useIcm.");
        }
        try {
            this.a(com.aspose.drawing.internal.hg.l.a(filename, null), new df(filename));
        }
        catch (RuntimeException runtimeException) {
            try {
                this.a(new Metafile(filename));
                return;
            }
            catch (RuntimeException runtimeException2) {
                throw runtimeException;
            }
        }
    }

    public Bitmap(InputStream stream) {
        this(Stream.fromJava(stream));
    }

    Bitmap(Stream stream) {
        this(stream, false);
    }

    public Bitmap(InputStream stream, boolean useIcm) {
        this(Stream.fromJava(stream), useIcm);
    }

    Bitmap(Stream stream, boolean useIcm) {
        if (stream == null) {
            throw new ArgumentNullException("stream", "Stream should not be null.");
        }
        if (!com.aspose.drawing.internal.hg.l.a()) {
            do.b("Bitmap(Stream stream, bool useIcm)");
        }
        if (useIcm) {
            if (DrawingSettings.getStrictMode()) {
                throw new NotImplementedException(do.a("Bitmap(Stream stream, bool useIcm)"));
            }
            do.a("Bitmap(Stream stream, bool useIcm)", "Ignored useIcm.");
        }
        if (!stream.canSeek()) {
            stream = t.a(stream);
        }
        try {
            this.a(com.aspose.drawing.internal.hg.l.a(stream.toInputStream(), null), new df(stream));
        }
        catch (RuntimeException runtimeException) {
            try {
                this.a(new Metafile(stream.toInputStream()));
                return;
            }
            catch (RuntimeException runtimeException2) {
                throw runtimeException;
            }
        }
    }

    public Bitmap(int width, int height, int format) {
        this.a(width, height, format);
    }

    public Bitmap(int width, int height, int stride, int format, int[] data) {
        if (data == null) {
            throw new ArgumentNullException("data");
        }
        if (stride % 4 != 0) {
            throw new ArgumentException("stride must be a multiple of four.");
        }
        if (format != 925707 && format != 2498570 && format != 139273 && format != 137224 && format != 8207) {
            if (DrawingSettings.getStrictMode()) {
                do.b("Bitmap(int width, int height, int stride, PixelFormat format, int[] data)");
            } else {
                String string = aW.a("Created Format32bppPArgb bitmap instead of {0}.", new Object[]{EnumExtensions.toString(aw.class, format)});
                do.a("Bitmap(int width, int height, int stride, PixelFormat format, int[] data)", string);
            }
        }
        if (format == 137224) {
            this.i = com.aspose.drawing.internal.hg.o.a(new fK(width, height, stride / 4, data));
            this.f = 137224;
        } else if (format == 8207) {
            this.i = com.aspose.drawing.internal.hg.o.a(new aU(width, height, stride / 4, data));
            this.f = 8207;
        } else {
            this.i = com.aspose.drawing.internal.hg.o.a(new com.aspose.drawing.internal.hi.j(width, height, stride / 4, data, Bitmap.c(format)));
            this.f = format;
            this.setFlags_internalized(2);
        }
        this.e = ImageFormat.getMemoryBmp();
        this.g = new am[]{FrameDimension.getPage().a()};
        this.h = b;
        this.a((long)data.length * (long)com.aspose.drawing.internal.jt.d.a(9));
    }

    public Bitmap(Image original) {
        this.a(original);
    }

    public Bitmap(Image original, Size newSize) {
        this(original, newSize != null ? newSize.getWidth() : 0, newSize != null ? newSize.getHeight() : 0);
    }

    public Bitmap(Image original, int width, int height) {
        this.a(original, width, height);
    }

    @Override
    public int getWidth() {
        return this.i.d();
    }

    @Override
    public int getHeight() {
        return this.i.e();
    }

    @Override
    public ImageFormat getRawFormat() {
        return this.e;
    }

    @Override
    public int getPixelFormat() {
        return this.f;
    }

    @Override
    public ColorPalette getPalette() {
        t t2 = this.i.a();
        if (com.aspose.drawing.internal.jt.d.b((Object)t2, cB.class)) {
            cB cB2 = (cB)t2;
            ColorPalette colorPalette = bT.a(cB2.h());
            if (colorPalette == null) {
                colorPalette = new ColorPalette(0);
            }
            return colorPalette;
        }
        return new ColorPalette(0);
    }

    @Override
    public void setPalette(ColorPalette value) {
        eb eb2;
        cB cB2;
        if (com.aspose.drawing.internal.jt.d.b((Object)this.i.a(), cB.class)) {
            cB2 = (cB)this.i.a();
            eb2 = bT.a(value);
            if (eb2 == null) {
                eb2 = new eb();
                eb2.a(new bh[0]);
            }
        } else {
            throw new ArgumentException("Palette");
        }
        cB2.a(eb2);
    }

    @Override
    public UUID[] getFrameDimensionsList() {
        return this.a(this.a());
    }

    private UUID[] a(am[] amArray) {
        UUID[] uUIDArray = new UUID[amArray.length];
        for (int i2 = 0; i2 < amArray.length; ++i2) {
            uUIDArray[i2] = am.a(amArray[i2]);
        }
        return uUIDArray;
    }

    @Override
    public am[] a() {
        return this.g;
    }

    @Override
    public int[] getPropertyIdList() {
        List<fw> list = this.i.b();
        if (list.size() == 0) {
            return new int[0];
        }
        int[] nArray = new int[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            nArray[i2] = list.get_Item(i2).a();
        }
        return nArray;
    }

    @Override
    public PropertyItem[] getPropertyItems() {
        List<fw> list = this.i.b();
        if (list.size() == 0) {
            return new PropertyItem[0];
        }
        PropertyItem[] propertyItemArray = new PropertyItem[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            propertyItemArray[i2] = cF.a(list.get_Item(i2));
        }
        return propertyItemArray;
    }

    public final t b() {
        return this.i.a();
    }

    private int e() {
        if (this.f == 925707 || this.f == 2498570 || this.f == 139273) {
            return 925707;
        }
        return this.getPixelFormat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Bitmap deepClone(Rectangle rect, int format) {
        if (rect.getWidth() == 0 || rect.getHeight() == 0) {
            throw new ArgumentException("The height and width of rect must not be 0.");
        }
        Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        if (!rectangle.contains(rect)) {
            throw new OutOfMemoryException();
        }
        Bitmap bitmap = new Bitmap(rect.getWidth(), rect.getHeight(), format);
        bitmap.setFlags_internalized(this.getFlags());
        bitmap.setResolution(this.getHorizontalResolution(), this.getVerticalResolution());
        if (bitmap.e() == 65536) {
            bitmap.setPalette(this.getPalette());
        }
        BitmapData bitmapData = this.lockBits(rect, 1, format);
        try {
            BitmapData bitmapData2 = bitmap.lockBits(new Rectangle(0, 0, bitmap.getWidth(), bitmap.getHeight()), 2, format);
            try {
                System.arraycopy(bitmapData.getScan0(), 0, bitmapData2.getScan0(), 0, bitmapData.getScan0().length);
            }
            finally {
                bitmap.unlockBits(bitmapData2);
            }
        }
        finally {
            this.unlockBits(bitmapData);
        }
        return bitmap;
    }

    public final Bitmap deepClone(RectangleF rect, int format) {
        return this.deepClone(Rectangle.truncate(rect), format);
    }

    public final void setResolution(float xDpi, float yDpi) {
        this.a(xDpi, yDpi);
    }

    public final BitmapData lockBits(Rectangle rect, int flags, int format) {
        boolean bl2;
        if (rect.getLeft() < 0 || rect.getRight() > this.getWidth() || rect.getTop() < 0 || rect.getBottom() > this.getHeight()) {
            throw new ArgumentException("rect");
        }
        if (flags == 4) {
            throw new ArgumentException("Invalid ImageLockMode.");
        }
        if (this.j != null) {
            throw new InvalidOperationException("Unable to lock the bitmap, because it's already locked.");
        }
        if (this.e() != format) {
            if ((flags & 1) == 1 && !ci.a(this.e(), format)) {
                throw new NotImplementedException(do.a(aW.a("Bitmap.LockBits (from {0} to {1})", new Object[]{EnumExtensions.toString(aw.class, this.e()), EnumExtensions.toString(aw.class, format)})));
            }
            if ((flags & 2) == 2 && !ci.a(format, this.e())) {
                throw new NotImplementedException(do.a(aW.a("Bitmap.LockBits (from {0} to {1})", new Object[]{EnumExtensions.toString(aw.class, this.e()), EnumExtensions.toString(aw.class, format)})));
            }
        }
        BitmapData bitmapData = Bitmap.a(rect, format);
        boolean bl3 = bl2 = (flags & 1) == 1;
        if (!bl2) {
            Bitmap.a(bitmapData);
        } else {
            try {
                if (this.e() == format) {
                    this.a(bitmapData, rect, format);
                } else {
                    this.b(bitmapData, rect, format);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ArgumentException(illegalArgumentException.getMessage());
            }
        }
        this.j = bitmapData.getScan0();
        this.k = flags;
        rect.CloneTo(this.d);
        return bitmapData;
    }

    public final void unlockBits(BitmapData bitmapData) {
        if (this.j == null) {
            throw new InvalidOperationException("The bitmap was not locked.");
        }
        if (!Arrays.equals(this.j, bitmapData.getScan0())) {
            throw new ArgumentException("Invalid bitmapdata.");
        }
        if (!ci.a(bitmapData.getPixelFormat(), this.e())) {
            throw new NotImplementedException(do.a(aW.a("Bitmap.UnlockBits from ({0})", new Object[]{EnumExtensions.toString(aw.class, bitmapData.getPixelFormat())})));
        }
        if ((this.k & 2) == 2) {
            if (this.e() == bitmapData.getPixelFormat()) {
                this.b(bitmapData);
            } else {
                this.c(bitmapData);
            }
        }
        this.j = null;
    }

    public final Color getPixel(int x2, int y2) {
        if (x2 < 0 || x2 >= this.getWidth()) {
            throw new ArgumentOutOfRangeException("x", "Parameter must be positive and < Width");
        }
        if (y2 < 0 || y2 >= this.getHeight()) {
            throw new ArgumentOutOfRangeException("y", "Parameter must be positive and < Height");
        }
        bh bh2 = new bh();
        this.i.a(x2, y2, bh2);
        int n2 = this.e() == 925707 ? com.aspose.drawing.internal.b.p.b(this.getPixelFormat() == 139273 ? com.aspose.drawing.internal.b.p.c(bh2.f()) : bh2.f()) : bh2.f();
        return Color.fromArgb(n2);
    }

    public final void setPixel(int x2, int y2, Color color) {
        if ((this.getPixelFormat() & 0x10000) != 0) {
            throw new InvalidOperationException("Can't set pixel for Indexed pixel format");
        }
        if (x2 < 0 || x2 >= this.getWidth()) {
            throw new ArgumentOutOfRangeException("x", "Parameter must be positive and < Width");
        }
        if (y2 < 0 || y2 >= this.getHeight()) {
            throw new ArgumentOutOfRangeException("y", "Parameter must be positive and < Height");
        }
        bh bh2 = new bh((byte)color.getA(), (byte)color.getR(), (byte)color.getG(), (byte)color.getB());
        if (this.e() == 925707 && this.getPixelFormat() != 139273) {
            bh2.c(com.aspose.drawing.internal.b.p.a(bh2.f()));
            bh2.a(true);
        }
        this.i.b(x2, y2, bh2);
    }

    public final void readArgb32Pixels(int[] pixels) {
        this.i.a(pixels);
    }

    public final void writeArgb32Pixels(int[] pixels) {
        this.i.b(pixels);
    }

    public final void makeTransparent() {
        Color color = a.Clone();
        if (this.getHeight() > 0 && this.getWidth() > 0) {
            this.getPixel(0, this.getSize().getHeight() - 1).CloneTo(color);
        }
        if ((color.getA() & 0xFF) < 255) {
            return;
        }
        this.makeTransparent(color);
    }

    public final void makeTransparent(Color transparentColor) {
        if (DrawingSettings.getStrictMode()) {
            throw new NotImplementedException(do.a("Bitmap.MakeTransparent(Color transparentColor)"));
        }
        do.c("Bitmap.MakeTransparent(Color transparentColor)");
    }

    @Override
    public void rotateFlip(int rotateFlipType) {
        if (rotateFlipType == 0) {
            return;
        }
        PropertyItem[] propertyItemArray = this.getPropertyItems();
        switch (rotateFlipType) {
            case 1: {
                this.i = (o)this.i.a(0);
                break;
            }
            case 2: {
                this.i = (o)this.i.a(1);
                break;
            }
            case 3: {
                this.i = (o)this.i.a(2);
                break;
            }
            case 4: {
                this.i = (o)this.i.b(0);
                break;
            }
            case 5: {
                this.i = (o)this.i.a(0).b(0);
                break;
            }
            case 6: {
                this.i = (o)this.i.a(1).b(0);
                break;
            }
            case 7: {
                this.i = (o)this.i.a(2).b(0);
            }
        }
        this.e(rotateFlipType);
        this.a(rotateFlipType, propertyItemArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PropertyItem getPropertyItem(int propid) {
        List<fw> list = this.i.b();
        IGenericEnumerator iGenericEnumerator = list.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                fw fw2 = (fw)iGenericEnumerator.next();
                if (fw2.a() != propid) continue;
                PropertyItem propertyItem = cF.a(fw2);
                return propertyItem;
            }
        }
        finally {
            if (com.aspose.drawing.internal.jt.d.a(iGenericEnumerator, aq.class) != false) {
                ((aq)iGenericEnumerator).dispose();
            }
        }
        throw new ArgumentException(aW.a("Property not found ({0})", new Object[]{propid}));
    }

    @Override
    public void removePropertyItem(int propid) {
        List<fw> list = this.i.b();
        int n2 = -1;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (list.get_Item(i2).a() != propid) continue;
            n2 = i2;
            break;
        }
        if (n2 == -1) {
            throw new ArgumentException(aW.a("Property not found ({0})", new Object[]{propid}));
        }
        list.removeAt(n2);
    }

    @Override
    public void setPropertyItem(PropertyItem propitem) {
        List<fw> list = this.i.b();
        int n2 = -1;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (list.get_Item(i2).a() != propitem.getId()) continue;
            n2 = i2;
            break;
        }
        if (n2 != -1) {
            list.set_Item(n2, cF.a(propitem));
        } else {
            list.addItem(cF.a(propitem));
        }
    }

    public final Graphics c() {
        aP aP2 = new aP(this.b());
        return new Graphics(new u(this, aP2));
    }

    @Override
    public void a(df df2, int n2, EncoderParameters encoderParameters) {
        if (!this.b(df2, n2, encoderParameters)) {
            boolean bl2 = Bitmap.a(encoderParameters, Encoder.SAVE_FLAG, 19L);
            int n3 = Bitmap.d(this.f);
            f f2 = com.aspose.drawing.internal.hg.f.a(n2, encoderParameters != null ? encoderParameters.a() : null, this.getHorizontalResolution(), this.getVerticalResolution(), bl2, Bitmap.a(this), 0, n3);
            if (df2.a() != null) {
                com.aspose.drawing.internal.hg.l.a(this.b(), df2.a(), f2);
            }
            if (df2.b() != null) {
                com.aspose.drawing.internal.hg.l.a(this.b(), df2.b(), f2);
            }
            if (Bitmap.a(encoderParameters, Encoder.SAVE_FLAG, 18L)) {
                this.l = new bk(df2, n2);
                this.l.a(f2.i());
            } else {
                this.l = null;
            }
        }
        this.b((long)this.i.d() * (long)this.i.e() * (long)com.aspose.drawing.internal.jt.d.a(9));
    }

    @Override
    public void a(Image image, EncoderParameters encoderParameters) {
        if (this.l == null) {
            throw new ExternalException("Save() was not called before");
        }
        if (!com.aspose.drawing.internal.jt.d.b((Object)image, Bitmap.class)) {
            throw new ArgumentException();
        }
        boolean bl2 = Bitmap.a(encoderParameters, Encoder.SAVE_FLAG, 20L);
        if (bl2) {
            this.l = null;
            return;
        }
        boolean bl3 = Bitmap.a(encoderParameters, Encoder.SAVE_FLAG, 23L);
        boolean bl4 = Bitmap.a(encoderParameters, Encoder.SAVE_FLAG, 21L);
        if (!bl3 && !bl4) {
            throw new ArgumentException();
        }
        boolean bl5 = Bitmap.a(encoderParameters, Encoder.SAVE_FLAG, 19L);
        int n2 = this.l.b();
        int n3 = Bitmap.d(this.f);
        f f2 = com.aspose.drawing.internal.hg.f.a(n2, encoderParameters != null ? encoderParameters.a() : null, ((Bitmap)((Object)com.aspose.drawing.internal.jt.d.a(image, Bitmap.class))).getHorizontalResolution(), ((Bitmap)((Object)com.aspose.drawing.internal.jt.d.a(image, Bitmap.class))).getVerticalResolution(), bl5, Bitmap.a((Bitmap)((Object)com.aspose.drawing.internal.jt.d.a(image, Bitmap.class))), 1, n3);
        f2.a(this.l.c());
        if (this.l.a().b() != null) {
            com.aspose.drawing.internal.hg.l.a(((Bitmap)((Object)com.aspose.drawing.internal.jt.d.a(image, Bitmap.class))).b(), this.l.a().b(), f2);
        } else if (this.l.a().a() != null) {
            com.aspose.drawing.internal.hg.l.a(((Bitmap)((Object)com.aspose.drawing.internal.jt.d.a(image, Bitmap.class))).b(), this.l.a().a(), f2);
        } else {
            throw new ExternalException("Logic error in SaveAdd implementation");
        }
        this.l.a(f2.i());
        if (bl5) {
            this.l = null;
        }
    }

    @Override
    public int a(FrameDimension frameDimension) {
        int n2 = 0;
        Object[] objectArray = new Integer[]{n2};
        boolean bl2 = this.h.tryGetValue(frameDimension, objectArray);
        n2 = (Integer)objectArray[0];
        if (bl2) {
            return n2;
        }
        throw new ArgumentException(aW.a("Frame dimension {0} is not present in this bitmap.", new Object[]{frameDimension}));
    }

    @Override
    public int a(FrameDimension frameDimension, int n2) {
        if (this.m != null) {
            try {
                if (this.getFrameCount(frameDimension) > 0) {
                    com.aspose.drawing.internal.hg.b b2 = new com.aspose.drawing.internal.hg.b();
                    b2.a(new aC<Integer>(n2));
                    if (this.m.a().a() != null) {
                        this.a(com.aspose.drawing.internal.hg.l.a(this.m.a().a(), b2), this.m.a());
                    } else if (this.m.a().b() != null) {
                        this.a(com.aspose.drawing.internal.hg.l.a(this.m.a().b(), b2), this.m.a());
                    }
                }
            }
            catch (ArgumentException argumentException) {
                // empty catch block
            }
        }
        return 0;
    }

    @Override
    public Image a(int n2, int n3, Image.GetThumbnailImageAbort getThumbnailImageAbort, ax ax2) {
        if (n2 == 0 && n3 == 0) {
            n2 = 120;
            n3 = 120;
        }
        Bitmap bitmap = new Bitmap(n2, n3, 925707);
        Graphics graphics = Graphics.fromImage(bitmap);
        graphics.drawImage((Image)this, 0, 0, n2, n3);
        return bitmap;
    }

    private void a(Image image) {
        this.a(image, image.getWidth(), image.getHeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(Image image, int n2, int n3) {
        this.a(n2, n3);
        Graphics graphics = null;
        try {
            graphics = Graphics.fromImage(this);
            graphics.clear(Color.getTransparent());
            graphics.drawImage(image, 0, 0, n2, n3);
            this.setFlags_internalized(image.getFlags());
            this.e = image.getRawFormat();
            this.g = image.a();
            this.a(n2 * n3 * com.aspose.drawing.internal.jt.d.a(9));
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
            }
        }
    }

    private void a(int n2, int n3) {
        this.a(n2, n3, 2498570);
    }

    private void a(int n2, int n3, int n4) {
        int n5;
        switch (n4) {
            case 8207: 
            case 137224: 
            case 139273: 
            case 196865: 
            case 197634: 
            case 198659: 
            case 925707: 
            case 2498570: {
                break;
            }
            default: {
                if (DrawingSettings.getStrictMode()) {
                    do.b("Bitmap(int width, int height, PixelFormat format)");
                    break;
                }
                String string = String.format("Created Format32bppPArgb bitmap instead of %s.", PixelFormat.getName(PixelFormat.class, n4));
                do.a("Bitmap(int width, int height, PixelFormat format)", string);
                n4 = 925707;
            }
        }
        if (n4 == 925707 || n4 == 2498570 || n4 == 139273) {
            this.f = n4;
            this.i = com.aspose.drawing.internal.hg.o.a(new com.aspose.drawing.internal.hi.j(n2, n3, Bitmap.c(n4)));
            this.setFlags_internalized(2);
            n5 = n2 * n3 * com.aspose.drawing.internal.jt.d.a(9);
        } else if (n4 == 137224) {
            this.f = n4;
            this.i = com.aspose.drawing.internal.hg.o.a(new fK(n2, n3));
            n5 = com.aspose.drawing.internal.hi.cF.a(24, n2) * n3;
        } else if (n4 == 8207) {
            this.f = n4;
            this.i = com.aspose.drawing.internal.hg.o.a(new aU(n2, n3));
            n5 = n2 * n3 * com.aspose.drawing.internal.jt.d.a(9);
        } else {
            int n6;
            switch (n4) {
                case 196865: {
                    n6 = 1;
                    break;
                }
                case 197634: {
                    n6 = 4;
                    break;
                }
                default: {
                    n6 = 8;
                }
            }
            o o2 = com.aspose.drawing.internal.hg.o.a(new cB(n2, n3, n6));
            this.f = n4;
            this.i = o2;
            this.setFlags_internalized(2);
            n5 = ((cB)o2.a()).a() * o2.e();
        }
        this.e = ImageFormat.getMemoryBmp();
        this.g = new am[]{FrameDimension.getPage().a()};
        this.h = b;
        this.a(n5);
    }

    private static int[] a(Bitmap bitmap) {
        int[] nArray = new int[bitmap.getWidth() * bitmap.getHeight()];
        bitmap.readArgb32Pixels(nArray);
        if (bitmap.getWidth() < 32 || bitmap.getHeight() < 32 || bs.c() == com.aspose.drawing.internal.hb.b.b) {
            return nArray;
        }
        Bitmap bitmap2 = new Bitmap(bitmap.getWidth(), bitmap.getHeight(), bitmap.getWidth() * 4, 925707, nArray);
        Graphics graphics = Graphics.fromImage(bitmap2);
        boolean bl2 = bitmap.getPalette() != null && bitmap.getPalette().getEntries().length > 0;
        SolidBrush solidBrush = new SolidBrush(bl2 ? Bitmap.a(nArray, bitmap.getPalette()) : Color.fromArgb(180, 128, 128, 128));
        graphics.setSmoothingMode(bl2 ? 3 : 2);
        if (bitmap.getWidth() >= 200 && bitmap.getHeight() >= 200) {
            graphics.rotateTransform((float)com.aspose.drawing.internal.j.b.b(bD.e((double)bitmap.getHeight(), (double)bitmap.getWidth())));
            graphics.translateTransform(bitmap.getWidth() / 2, bitmap.getHeight() / 2, 1);
            StringFormat stringFormat = new StringFormat();
            stringFormat.setAlignment(1);
            stringFormat.setLineAlignment(1);
            GraphicsPath graphicsPath = new GraphicsPath();
            graphicsPath.addString("Evaluation only\r\nAspose.Drawing 2010-2025", new FontFamily("Open Sans"), 0, 18.0f, new PointF(), stringFormat);
            graphics.fillPath(solidBrush, graphicsPath);
        } else {
            float f2 = (float)bD.d(bitmap.getWidth(), bitmap.getHeight()) / 67.0f;
            graphics.scaleTransform(f2, f2);
            graphics.translateTransform(bitmap.getWidth() / 2, bitmap.getHeight() / 2, 1);
            graphics.drawPath(new Pen(solidBrush), Bitmap.f());
        }
        return nArray;
    }

    private static Color a(int[] nArray, ColorPalette colorPalette) {
        int n2 = 0;
        int n3 = Integer.MAX_VALUE;
        for (int i2 = 0; i2 < colorPalette.getEntries().length; ++i2) {
            int n4 = 0;
            int n5 = colorPalette.getEntries()[i2].toArgb();
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                if (nArray[i3] != n5) continue;
                ++n4;
            }
            if (n4 == 0) {
                return colorPalette.getEntries()[i2];
            }
            if (n4 >= n3) continue;
            n2 = i2;
            n3 = n4;
        }
        return colorPalette.getEntries()[n2];
    }

    private static GraphicsPath f() {
        if (c != null) {
            return c;
        }
        List<PointF> list = new List<PointF>();
        float f2 = 44.0f;
        float f3 = 18.0f;
        list.addItem(new PointF(f2, f3));
        list.addItem(new PointF(f2 - 2.0f, f3));
        list.addItem(new PointF(f2 - 21.0f, f3 - 2.0f));
        list.addItem(new PointF(f2 - 29.0f, f3 + 15.0f));
        list.addItem(new PointF((f2 += -29.0f) - 4.0f, (f3 += 15.0f) + 7.0f));
        list.addItem(new PointF(f2 - 4.0f, f3 + 17.0f));
        list.addItem(new PointF(f2 + 1.0f, f3 + 23.0f));
        list.addItem(new PointF((f2 += 1.0f) + 10.0f, (f3 += 23.0f) + 10.0f));
        list.addItem(new PointF(f2 + 21.0f, f3 + 2.0f));
        list.addItem(new PointF(f2 + 22.0f, f3 - 2.0f));
        list.addItem(new PointF((f2 += 22.0f) - 20.0f, (f3 += -2.0f) + 5.0f));
        list.addItem(new PointF(f2 - 24.0f, f3 - 29.0f));
        list.addItem(new PointF(f2 + 6.0f, f3 - 36.0f));
        GraphicsPath graphicsPath = new GraphicsPath();
        GraphicsPath graphicsPath2 = new GraphicsPath();
        graphicsPath2.addBezier((PointF)list.get_Item(0), (PointF)list.get_Item(1), (PointF)list.get_Item(2), (PointF)list.get_Item(3));
        PointF pointF = new PointF(((PointF)list.get_Item(3)).getX() - (((PointF)list.get_Item(2)).getX() - ((PointF)list.get_Item(3)).getX()) * 0.45f, ((PointF)list.get_Item(3)).getY() - (((PointF)list.get_Item(2)).getY() - ((PointF)list.get_Item(3)).getY()) * 0.45f);
        graphicsPath2.addBezier((PointF)list.get_Item(3), pointF, (PointF)list.get_Item(5), (PointF)list.get_Item(6));
        graphicsPath2.addBezier((PointF)list.get_Item(6), (PointF)list.get_Item(7), (PointF)list.get_Item(8), (PointF)list.get_Item(9));
        graphicsPath2.addBezier((PointF)list.get_Item(9), (PointF)list.get_Item(10), (PointF)list.get_Item(11), (PointF)list.get_Item(0));
        Matrix matrix = new Matrix();
        matrix.translate(-35.5f, -49.5f);
        graphicsPath2.transform(matrix);
        graphicsPath.addPath(graphicsPath2, false);
        GraphicsPath graphicsPath3 = (GraphicsPath)graphicsPath2.deepClone();
        Matrix matrix2 = new Matrix();
        matrix2.rotate(90.0f);
        graphicsPath3.transform(matrix2);
        graphicsPath.addPath(graphicsPath3, false);
        graphicsPath3 = (GraphicsPath)graphicsPath2.deepClone();
        Matrix matrix3 = new Matrix();
        matrix3.rotate(180.0f);
        graphicsPath3.transform(matrix3);
        graphicsPath.addPath(graphicsPath3, false);
        graphicsPath3 = (GraphicsPath)graphicsPath2.deepClone();
        Matrix matrix4 = new Matrix();
        matrix4.rotate(270.0f);
        graphicsPath3.transform(matrix4);
        graphicsPath.addPath(graphicsPath3, false);
        c = graphicsPath;
        return c;
    }

    private static int a(int n2) {
        switch (n2) {
            case 1: {
                return 196865;
            }
            case 4: {
                return 197634;
            }
        }
        return 198659;
    }

    private static int b(int n2) {
        switch (n2) {
            case 1: {
                return 139273;
            }
            case 2: {
                return 925707;
            }
            case 3: {
                return 2498570;
            }
        }
        throw new ArgumentOutOfRangeException("alphaType");
    }

    private static int c(int n2) {
        switch (n2) {
            case 2498570: {
                return 3;
            }
            case 139273: 
            case 925707: {
                return 2;
            }
        }
        throw new ArgumentOutOfRangeException("pixelFormat");
    }

    private static int a(t t2) {
        if (com.aspose.drawing.internal.jt.d.b((Object)t2, fK.class)) {
            return 137224;
        }
        if (com.aspose.drawing.internal.jt.d.b((Object)t2, com.aspose.drawing.internal.hi.j.class)) {
            return Bitmap.b(((com.aspose.drawing.internal.hi.j)t2).c());
        }
        if (com.aspose.drawing.internal.jt.d.b((Object)t2, cB.class)) {
            return Bitmap.a(((cB)t2).c());
        }
        if (com.aspose.drawing.internal.jt.d.b((Object)t2, aU.class)) {
            return 8207;
        }
        throw new ArgumentException("Unknown bitmap format.");
    }

    private static BitmapData a(Rectangle rectangle, int n2) {
        BitmapData bitmapData = new BitmapData();
        bitmapData.setWidth(rectangle.getWidth());
        bitmapData.setHeight(rectangle.getHeight());
        bitmapData.setStride(com.aspose.drawing.internal.hi.cF.a(cz.a(n2), rectangle.getWidth()));
        bitmapData.setPixelFormat(n2);
        bitmapData.setScan0(new int[bitmapData.getStride() * bitmapData.getHeight()]);
        return bitmapData;
    }

    private static void a(BitmapData bitmapData) {
        int[] nArray = bitmapData.getScan0();
        if (nArray != null) {
            Arrays.fill(nArray, 0);
        }
    }

    private static int b(int n2, int n3, int n4) {
        int n5;
        switch (n2) {
            case 196865: {
                n5 = com.aspose.drawing.internal.hi.cF.a(1, n3);
                break;
            }
            case 197634: {
                n5 = com.aspose.drawing.internal.hi.cF.a(4, n3);
                break;
            }
            case 198659: {
                n5 = com.aspose.drawing.internal.hi.cF.a(8, n3);
                break;
            }
            case 137224: {
                n5 = com.aspose.drawing.internal.hi.cF.a(24, n3);
                break;
            }
            case 8207: 
            case 139273: 
            case 925707: 
            case 2498570: {
                n5 = n3 * 4;
                break;
            }
            default: {
                throw new ArgumentException("Unknown bitmap format.");
            }
        }
        return n5 * n4;
    }

    private static ImageFormat a(h h2) {
        g g2;
        ImageFormat imageFormat = ImageFormat.getMemoryBmp();
        g g3 = g2 = h2 != null ? h2.b().find(new e()) : null;
        if (g2 != null) {
            switch ((Integer)g2.c()) {
                case 1: {
                    imageFormat = ImageFormat.getBmp();
                    break;
                }
                case 4: {
                    imageFormat = ImageFormat.getGif();
                    break;
                }
                case 2: {
                    imageFormat = ImageFormat.getJpeg();
                    break;
                }
                case 3: {
                    imageFormat = ImageFormat.getPng();
                    break;
                }
                case 5: {
                    imageFormat = ImageFormat.getTiff();
                }
            }
        }
        return imageFormat;
    }

    private static am b(h h2) {
        g g2;
        g g3 = g2 = h2 != null ? h2.b().find(new com.aspose.drawing.f()) : null;
        if (g2 != null && (Integer)g2.c() == 4) {
            return FrameDimension.getTime().a();
        }
        return FrameDimension.getPage().a();
    }

    private static int c(h h2) {
        g g3;
        g g4 = g3 = h2 != null ? (g)h2.a().stream().filter(g2 -> g2.b().equals(com.aspose.drawing.internal.hg.n.c)).findFirst().orElse(null) : null;
        if (g3 != null) {
            return com.aspose.drawing.internal.jt.d.d(g3.c(), Integer.TYPE);
        }
        return 1;
    }

    private static boolean a(EncoderParameters encoderParameters, Encoder encoder, long l2) {
        if (encoderParameters != null && encoderParameters.getParam() != null) {
            for (EncoderParameter encoderParameter : encoderParameters.getParam()) {
                if (encoderParameter == null || !am.a(encoderParameter.getEncoder().a(), encoder.a()) || encoderParameter.getNumberOfValues() != 1 || (long)encoderParameter.a() != l2) continue;
                return true;
            }
        }
        return false;
    }

    private static t a(c c2) {
        t t2;
        if (c2.m() != null && c2.k() <= 8) {
            g g2;
            int n2 = c2.k();
            cB cB2 = new cB(c2.g(), c2.h(), n2);
            cB2.a(c2.m());
            g g3 = g2 = c2.c() != null ? c2.c().b().find(new com.aspose.drawing.g()) : null;
            if (g2 != null) {
                bh bh2 = new bh();
                bh2.c(com.aspose.drawing.internal.jt.d.d(g2.c(), Integer.TYPE));
                cB2.a(bh2);
            }
            int n3 = Bitmap.a(n2);
            int[] nArray = c2.f();
            ax ax2 = com.aspose.drawing.internal.jl.c.a(nArray).f();
            ci ci2 = new ci(925707, n3, cB2.h(), cB2.d());
            ax ax3 = com.aspose.drawing.internal.is.f.a(com.aspose.drawing.internal.hi.cF.a(n2, cB2.d()));
            for (int i2 = 0; i2 < cB2.e(); ++i2) {
                ci2.a(new ax(ax2.b() + (long)i2 * (long)cB2.d() * 4L), ax3);
                cB2.b(0, i2, cB2.d(), ax3, 0);
            }
            com.aspose.drawing.internal.is.f.b(ax3);
            t2 = cB2;
        } else if (c2.k() == 24) {
            t2 = new fK(c2.g(), c2.h(), c2.f());
        } else {
            r r2 = Bitmap.c(c2);
            if (r2 == null) {
                if (c2.k() == 32 && Bitmap.a(c2.c()) == ImageFormat.getJpeg()) {
                    t2 = new aU(c2.g(), c2.h());
                    t2.b(c2.f());
                } else {
                    t2 = Bitmap.b(c2);
                }
            } else {
                t2 = Bitmap.a(c2, r2);
            }
        }
        return t2;
    }

    private static t b(c c2) {
        if (c2.l() == 2) {
            fv.a(c2.f(), c2.g(), c2.h());
        }
        return new com.aspose.drawing.internal.hi.j(c2.g(), c2.h(), c2.f(), c2.l());
    }

    private static t a(c c2, r r2) {
        t t2 = null;
        switch (r2.c()) {
            case 0: 
            case 1: 
            case 3: {
                if (r2.d() != 1 && r2.d() != 4 && r2.d() != 8) break;
                t2 = new cB(c2.g(), c2.h(), r2.d());
                t2.b(c2.f());
                break;
            }
            case 2: {
                if (r2.d() == 8) {
                    if (r2.e() <= 3) {
                        t2 = new fK(c2.g(), c2.h(), c2.f());
                        break;
                    }
                    t2 = new com.aspose.drawing.internal.hi.j(c2.g(), c2.h(), c2.f(), r2.b() ? 2 : 3);
                    break;
                }
                t2 = new fK(c2.g(), c2.h(), c2.f());
                break;
            }
            case 5: {
                if (r2.a()) {
                    t2 = new aU(c2.g(), c2.h());
                    t2.b(c2.f());
                    break;
                }
                t2 = new com.aspose.drawing.internal.hi.j(c2.g(), c2.h(), c2.f(), 3);
            }
        }
        return t2 != null ? t2 : Bitmap.b(c2);
    }

    private static int d(int n2) {
        switch (n2) {
            case 196865: {
                return 3;
            }
            case 198659: {
                return 4;
            }
            case 137224: {
                return 1;
            }
            case 8207: {
                return 2;
            }
        }
        return 0;
    }

    private static r c(c c2) {
        g g3 = c2.c() != null ? (g)c2.c().a().stream().filter(g2 -> g2.a().equals(com.aspose.drawing.internal.hg.n.h)).findFirst().orElse(null) : null;
        r r2 = null;
        if (g3 != null && g3.c() != null && g3.c() instanceof r) {
            r2 = (r)g3.c();
        }
        return r2;
    }

    private int d(c c2) {
        if (c2.m() != null && c2.k() <= 8) {
            return Bitmap.a(c2.k());
        }
        if (c2.k() == 24) {
            return 137224;
        }
        r r2 = Bitmap.c(c2);
        if (r2 != null) {
            switch (r2.c()) {
                case 0: 
                case 1: 
                case 3: {
                    if (r2.d() != 1 && r2.d() != 4 && r2.d() != 8) break;
                    return Bitmap.a(r2.d());
                }
                case 2: {
                    if (r2.d() == 8) {
                        if (r2.e() <= 3) {
                            return 137224;
                        }
                        return Bitmap.b(r2.b() ? 2 : 3);
                    }
                    return 137224;
                }
                case 5: {
                    if (r2.a()) {
                        return 8207;
                    }
                    return Bitmap.b(3);
                }
            }
        }
        if (c2.k() == 32 && Bitmap.a(c2.c()) == ImageFormat.getJpeg()) {
            return 8207;
        }
        return Bitmap.b(c2.l());
    }

    private void a(c c2, df df2) {
        if (c2.b() == null) {
            this.i = com.aspose.drawing.internal.hg.o.a(c2, new com.aspose.drawing.h(this));
            this.f = this.d(c2);
        } else {
            this.i = com.aspose.drawing.internal.hg.o.a(c2.b());
            this.f = Bitmap.a(this.i.a());
        }
        this.i.b().addRange(c2.e());
        this.e = Bitmap.a(c2.c());
        this.g = new am[]{Bitmap.b(c2.c())};
        if (this.e == ImageFormat.getPng() && this.f == 925707) {
            this.f = 2498570;
        }
        if (this.e == ImageFormat.getBmp() && this.f == 925707) {
            this.f = 2498570;
        }
        boolean bl2 = c2.i() > 0.0 && c2.j() > 0.0;
        this.setFlags_internalized(73744);
        if (bl2) {
            this.setFlags_internalized(this.getFlags() | 0x1000);
            this.setResolution((float)c2.i(), (float)c2.j());
        }
        Dictionary<FrameDimension, Integer> dictionary = new Dictionary<FrameDimension, Integer>();
        dictionary.addItem(new FrameDimension(am.a(this.g[0])), Bitmap.c(c2.c()));
        this.h = dictionary;
        this.m = new bi(df2);
        this.a(Bitmap.b(this.f, this.i.d(), this.i.e()));
    }

    private void a(BitmapData bitmapData, Rectangle rectangle, int n2) {
        if (com.aspose.drawing.internal.b.p.a(this.i.a(), this.getPixelFormat(), n2)) {
            p p2 = new p(this.i.a(), this.getPixelFormat(), n2, this.getPalette());
            for (int i2 = 0; i2 < rectangle.getHeight(); ++i2) {
                int n3 = bitmapData.getStride() * i2;
                p2.a(rectangle.getLeft(), rectangle.getTop() + i2, rectangle.getWidth(), com.aspose.drawing.internal.jl.c.a(bitmapData.getScan0(), n3).f());
            }
            return;
        }
        for (int i3 = 0; i3 < rectangle.getHeight(); ++i3) {
            int n4 = bitmapData.getStride() * i3;
            this.i.a(rectangle.getLeft(), rectangle.getTop() + i3, rectangle.getWidth(), com.aspose.drawing.internal.jl.c.a(bitmapData.getScan0()).f(), n4);
        }
    }

    private void b(BitmapData bitmapData, Rectangle rectangle, int n2) {
        if (com.aspose.drawing.internal.b.p.a(this.i.a(), this.getPixelFormat(), n2)) {
            p p2 = new p(this.i.a(), this.getPixelFormat(), n2, this.getPalette());
            for (int i2 = 0; i2 < rectangle.getHeight(); ++i2) {
                int n3 = i2 * bitmapData.getStride();
                ++this.n;
                p2.a(rectangle.getLeft(), rectangle.getTop() + i2, rectangle.getWidth(), com.aspose.drawing.internal.jl.c.a(bitmapData.getScan0(), n3).f());
            }
            return;
        }
        ci ci2 = new ci(this.e(), n2, this.getPalette(), rectangle.getWidth());
        ax ax2 = com.aspose.drawing.internal.is.f.a(com.aspose.drawing.internal.hi.cF.a(cz.a(this.e()), rectangle.getWidth()));
        for (int i3 = 0; i3 < rectangle.getHeight(); ++i3) {
            this.i.a(rectangle.getLeft(), rectangle.getTop() + i3, rectangle.getWidth(), ax2, 0);
            int n4 = i3 * bitmapData.getStride();
            ci2.a(ax2, com.aspose.drawing.internal.jl.c.a(bitmapData.getScan0(), n4).f());
        }
        com.aspose.drawing.internal.is.f.b(ax2);
    }

    private void b(BitmapData bitmapData) {
        if (com.aspose.drawing.internal.b.p.a(this.i.a(), this.getPixelFormat(), bitmapData.getPixelFormat())) {
            p p2 = new p(this.i.a(), this.getPixelFormat(), bitmapData.getPixelFormat(), this.getPalette());
            for (int i2 = 0; i2 < this.d.getHeight(); ++i2) {
                int n2 = bitmapData.getStride() * i2;
                p2.b(this.d.getLeft(), this.d.getTop() + i2, this.d.getWidth(), com.aspose.drawing.internal.jl.c.a(bitmapData.getScan0(), n2).f());
            }
            return;
        }
        for (int i3 = 0; i3 < this.d.getHeight(); ++i3) {
            int n3 = bitmapData.getStride() * i3;
            this.i.b(this.d.getLeft(), this.d.getTop() + i3, this.d.getWidth(), com.aspose.drawing.internal.jl.c.a(bitmapData.getScan0()).f(), n3);
        }
    }

    private void c(BitmapData bitmapData) {
        if (com.aspose.drawing.internal.b.p.a(this.i.a(), this.getPixelFormat(), bitmapData.getPixelFormat())) {
            p p2 = new p(this.i.a(), this.getPixelFormat(), bitmapData.getPixelFormat(), this.getPalette());
            for (int i2 = 0; i2 < this.d.getHeight(); ++i2) {
                int n2 = bitmapData.getStride() * i2;
                p2.b(this.d.getLeft(), this.d.getTop() + i2, this.d.getWidth(), com.aspose.drawing.internal.jl.c.a(bitmapData.getScan0(), n2).f());
            }
            return;
        }
        ci ci2 = new ci(bitmapData.getPixelFormat(), this.e(), this.getPalette(), this.d.getWidth());
        ax ax2 = com.aspose.drawing.internal.is.f.a(com.aspose.drawing.internal.hi.cF.a(cz.a(this.e()), this.d.getWidth()));
        for (int i3 = 0; i3 < this.d.getHeight(); ++i3) {
            int n3 = bitmapData.getStride() * i3;
            ci2.a(com.aspose.drawing.internal.jl.c.a(bitmapData.getScan0(), n3).f(), ax2);
            this.i.b(this.d.getLeft(), this.d.getTop() + i3, this.d.getWidth(), ax2, 0);
        }
        com.aspose.drawing.internal.is.f.b(ax2);
    }

    private boolean b(df df2, int n2, EncoderParameters encoderParameters) {
        byte[] byArray;
        df df3;
        df df4 = df3 = this.m != null ? this.m.a() : null;
        if (this.e != ImageFormat.getGif() || n2 != ImageFormat.getGif().d() || df3 == null || encoderParameters != null) {
            return false;
        }
        if (df3.b() != null) {
            df3.b().seek(0L, 0);
            byArray = new byte[(int)df3.b().getLength()];
            df3.b().read(byArray, 0, byArray.length);
        } else {
            byArray = com.aspose.drawing.internal.ig.k.i(df3.a());
        }
        if (df2.b() != null) {
            df2.b().write(byArray, 0, byArray.length);
        } else {
            com.aspose.drawing.internal.ig.k.a(df2.a(), byArray);
        }
        return true;
    }

    private void e(int n2) {
        if (n2 == 1 || n2 == 3 || n2 == 5 || n2 == 7) {
            this.setResolution(this.getVerticalResolution(), this.getHorizontalResolution());
        }
    }

    private void a(int n2, PropertyItem[] propertyItemArray) {
        if (n2 == 1 || n2 == 3 || n2 == 5 || n2 == 7) {
            block12: for (PropertyItem propertyItem : propertyItemArray) {
                switch (propertyItem.getId()) {
                    case 256: {
                        propertyItem.setId(257);
                        continue block12;
                    }
                    case 257: {
                        propertyItem.setId(256);
                        continue block12;
                    }
                    case 282: {
                        propertyItem.setId(283);
                        continue block12;
                    }
                    case 283: {
                        propertyItem.setId(282);
                        continue block12;
                    }
                    case 20481: {
                        propertyItem.setId(20482);
                        continue block12;
                    }
                    case 20482: {
                        propertyItem.setId(20481);
                        continue block12;
                    }
                    case 20483: {
                        propertyItem.setId(20484);
                        continue block12;
                    }
                    case 20484: {
                        propertyItem.setId(20483);
                        continue block12;
                    }
                    case 40962: {
                        propertyItem.setId(40963);
                        continue block12;
                    }
                    case 40963: {
                        propertyItem.setId(40962);
                    }
                }
            }
        }
        for (PropertyItem propertyItem : propertyItemArray) {
            this.setPropertyItem(propertyItem);
        }
    }

    private void a(long l2) {
        if (o != null) {
            o.a(l2);
        }
    }

    private void b(long l2) {
        if (p != null) {
            p.a(l2);
        }
    }

    static /* synthetic */ a access$002(a x0) {
        o = x0;
        return o;
    }

    static /* synthetic */ b access$202(b x0) {
        p = x0;
        return p;
    }

    static /* synthetic */ t access$400(c x0) {
        return Bitmap.a(x0);
    }

    static {
        onImageInitialized = new com.aspose.drawing.a();
        onImageSaved = new com.aspose.drawing.c();
        b = new Dictionary();
        b.addItem(FrameDimension.getPage(), 1);
        b.addItem(FrameDimension.getTime(), 1);
        b.addItem(FrameDimension.getResolution(), 1);
    }

    static abstract class b
    extends MulticastDelegate {
        b() {
        }

        public abstract void a(long var1);

        public final IAsyncResult a(long l2, AsyncCallback asyncCallback, Object object) {
            return com.aspose.drawing.internal.iR.a.a(new j(this, this, asyncCallback, object, l2));
        }

        public final void a(IAsyncResult iAsyncResult) {
            com.aspose.drawing.internal.iR.a.a(this, iAsyncResult);
        }
    }

    static abstract class a
    extends MulticastDelegate {
        a() {
        }

        public abstract void a(long var1);

        public final IAsyncResult a(long l2, AsyncCallback asyncCallback, Object object) {
            return com.aspose.drawing.internal.iR.a.a(new i(this, this, asyncCallback, object, l2));
        }

        public final void a(IAsyncResult iAsyncResult) {
            com.aspose.drawing.internal.iR.a.a(this, iAsyncResult);
        }
    }
}

