/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.drawing;

import com.aspose.drawing.PointF;
import com.aspose.drawing.Rectangle;
import com.aspose.drawing.SizeF;
import com.aspose.drawing.internal.db.aY;
import com.aspose.drawing.internal.hX.ar;
import com.aspose.drawing.internal.hX.bD;
import com.aspose.drawing.internal.jt.d;
import com.aspose.drawing.internal.jt.i;

public class RectangleF
extends i<RectangleF>
implements ar<RectangleF>,
Cloneable {
    private static RectangleF a = new RectangleF();
    private float b;
    private float c;
    private float d;
    private float e;

    public RectangleF() {
    }

    public RectangleF(PointF location, SizeF size) {
        this.b = location.getX();
        this.c = location.getY();
        this.d = size.getWidth();
        this.e = size.getHeight();
    }

    public RectangleF(float x2, float y2, float width, float height) {
        this.b = x2;
        this.c = y2;
        this.d = width;
        this.e = height;
    }

    public static RectangleF fromPoints(PointF point1, PointF point2) {
        float f2 = bD.b(point1.getX(), point2.getX());
        float f3 = bD.b(point1.getY(), point2.getY());
        float f4 = bD.a(point1.getX(), point2.getX());
        float f5 = bD.a(point1.getY(), point2.getY());
        return RectangleF.fromLTRB(f2, f3, f4, f5);
    }

    public static RectangleF to_RectangleF(Rectangle r2) {
        return new RectangleF(r2.getX(), r2.getY(), r2.getWidth(), r2.getHeight());
    }

    public static boolean op_Equality(RectangleF left, RectangleF right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        return left.getX() == right.getX() && left.getY() == right.getY() && left.getWidth() == right.getWidth() && left.getHeight() == right.getHeight();
    }

    public static boolean op_Inequality(RectangleF left, RectangleF right) {
        return !RectangleF.op_Equality(left, right);
    }

    public static RectangleF fromLTRB(float left, float top, float right, float bottom) {
        RectangleF rectangleF = new RectangleF();
        rectangleF.b = left;
        rectangleF.c = top;
        rectangleF.d = right - left;
        rectangleF.e = bottom - top;
        return rectangleF;
    }

    public static RectangleF inflate(RectangleF rect, float x2, float y2) {
        RectangleF rectangleF = rect.Clone();
        rectangleF.inflate(x2, y2);
        return rectangleF;
    }

    public static RectangleF intersect(RectangleF a2, RectangleF b2) {
        float f2 = bD.a(a2.getX(), b2.getX());
        float f3 = bD.b(a2.getX() + a2.getWidth(), b2.getX() + b2.getWidth());
        float f4 = bD.a(a2.getY(), b2.getY());
        float f5 = bD.b(a2.getY() + a2.getHeight(), b2.getY() + b2.getHeight());
        if (f3 >= f2 && f5 >= f4) {
            return new RectangleF(f2, f4, f3 - f2, f5 - f4);
        }
        return RectangleF.getEmpty();
    }

    public static RectangleF union(RectangleF a2, RectangleF b2) {
        float f2 = bD.b(a2.getX(), b2.getX());
        float f3 = bD.a(a2.getX() + a2.getWidth(), b2.getX() + b2.getWidth());
        float f4 = bD.b(a2.getY(), b2.getY());
        float f5 = bD.a(a2.getY() + a2.getHeight(), b2.getY() + b2.getHeight());
        return new RectangleF(f2, f4, f3 - f2, f5 - f4);
    }

    public static boolean isEquals(RectangleF obj1, RectangleF obj2) {
        return obj1.equals(obj2);
    }

    public static RectangleF getEmpty() {
        return a.Clone();
    }

    public final boolean isEmpty() {
        return this.getWidth() <= 0.0f || this.getHeight() <= 0.0f;
    }

    public final float getX() {
        return this.b;
    }

    public final void setX(float value) {
        this.b = value;
    }

    public final float getY() {
        return this.c;
    }

    public final void setY(float value) {
        this.c = value;
    }

    public final PointF getLocation() {
        return new PointF(this.getX(), this.getY());
    }

    public final void setLocation(PointF value) {
        this.setX(value.getX());
        this.setY(value.getY());
    }

    public final float getWidth() {
        return this.d;
    }

    public final void setWidth(float value) {
        this.d = value;
    }

    public final float getHeight() {
        return this.e;
    }

    public final void setHeight(float value) {
        this.e = value;
    }

    public final SizeF getSize() {
        return new SizeF(this.getWidth(), this.getHeight());
    }

    public final void setSize(SizeF value) {
        this.setWidth(value.getWidth());
        this.setHeight(value.getHeight());
    }

    public final float getLeft() {
        return this.b;
    }

    public final float getTop() {
        return this.c;
    }

    public final float getRight() {
        return this.b + this.d;
    }

    public final float getBottom() {
        return this.c + this.e;
    }

    public String toString() {
        return String.format("{X=%.1f,Y=%.1f,Width=%.1f,Height=%.1f}", Float.valueOf(this.getX()), Float.valueOf(this.getY()), Float.valueOf(this.getWidth()), Float.valueOf(this.getHeight()));
    }

    public final void inflate(float x2, float y2) {
        this.setX(this.getX() - x2);
        this.setY(this.getY() - y2);
        this.setWidth(this.getWidth() + 2.0f * x2);
        this.setHeight(this.getHeight() + 2.0f * y2);
    }

    public final void inflate(SizeF size) {
        this.inflate(size.getWidth(), size.getHeight());
    }

    public final void intersect(RectangleF rect) {
        RectangleF rectangleF = RectangleF.intersect(rect.Clone(), this.Clone()).Clone();
        this.setX(rectangleF.getX());
        this.setY(rectangleF.getY());
        this.setWidth(rectangleF.getWidth());
        this.setHeight(rectangleF.getHeight());
    }

    public final boolean intersectsWith(RectangleF rect) {
        return rect.getX() < this.getX() + this.getWidth() && this.getX() < rect.getX() + rect.getWidth() && rect.getY() < this.getY() + this.getHeight() && this.getY() < rect.getY() + rect.getHeight();
    }

    public final void offset(PointF pos) {
        this.offset(pos.getX(), pos.getY());
    }

    public final void offset(float x2, float y2) {
        this.setX(this.getX() + x2);
        this.setY(this.getY() + y2);
    }

    public final boolean contains(float x2, float y2) {
        if (this.getX() <= x2 && x2 < this.getX() + this.getWidth() && this.getY() <= y2) {
            return y2 < this.getY() + this.getHeight();
        }
        return false;
    }

    public final boolean contains(PointF pt) {
        return this.contains(pt.getX(), pt.getY());
    }

    public final boolean contains(RectangleF rect) {
        if (this.getX() <= rect.getX() && rect.getX() + rect.getWidth() <= this.getX() + this.getWidth() && this.getY() <= rect.getY()) {
            return rect.getY() + rect.getHeight() <= this.getY() + this.getHeight();
        }
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (!com.aspose.drawing.internal.jt.d.b(obj, RectangleF.class)) {
            return false;
        }
        RectangleF rectangleF = com.aspose.drawing.internal.jt.d.d(obj, RectangleF.class).Clone();
        return rectangleF.getX() == this.getX() && rectangleF.getY() == this.getY() && rectangleF.getWidth() == this.getWidth() && rectangleF.getHeight() == this.getHeight();
    }

    public int hashCode() {
        return (int)(com.aspose.drawing.internal.jt.d.f(this.getX()) ^ ((com.aspose.drawing.internal.jt.d.f(this.getY()) & 0xFFFFFFFFL) << 13 | (com.aspose.drawing.internal.jt.d.f(this.getY()) & 0xFFFFFFFFL) >> 19) ^ ((com.aspose.drawing.internal.jt.d.f(this.getWidth()) & 0xFFFFFFFFL) << 26 | (com.aspose.drawing.internal.jt.d.f(this.getWidth()) & 0xFFFFFFFFL) >> 6) ^ ((com.aspose.drawing.internal.jt.d.f(this.getHeight()) & 0xFFFFFFFFL) << 7 | (com.aspose.drawing.internal.jt.d.f(this.getHeight()) & 0xFFFFFFFFL) >> 25));
    }

    public final boolean equals(RectangleF other) {
        return RectangleF.op_Equality(this, other);
    }

    @Override
    public void CloneTo(RectangleF that) {
        that.b = this.b;
        that.c = this.c;
        that.d = this.d;
        that.e = this.e;
    }

    @Override
    public RectangleF Clone() {
        RectangleF rectangleF = new RectangleF();
        this.CloneTo(rectangleF);
        return rectangleF;
    }

    public Object clone() {
        return this.Clone();
    }

    public aY a() {
        aY aY2 = new aY();
        aY2.d(this.e);
        aY2.c(this.d);
        aY2.b(this.getY());
        aY2.a(this.getX());
        return aY2;
    }
}

