/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.drawing.drawing2d;

import com.aspose.drawing.Brush;
import com.aspose.drawing.Color;
import com.aspose.drawing.DrawingSettings;
import com.aspose.drawing.Point;
import com.aspose.drawing.PointF;
import com.aspose.drawing.Rectangle;
import com.aspose.drawing.RectangleF;
import com.aspose.drawing.SizeF;
import com.aspose.drawing.drawing2d.Blend;
import com.aspose.drawing.drawing2d.ColorBlend;
import com.aspose.drawing.drawing2d.Matrix;
import com.aspose.drawing.internal.Exceptions.ArgumentException;
import com.aspose.drawing.internal.Exceptions.IndexOutOfRangeException;
import com.aspose.drawing.internal.Exceptions.NotImplementedException;
import com.aspose.drawing.internal.Exceptions.NullReferenceException;
import com.aspose.drawing.internal.dn.do;
import com.aspose.drawing.internal.hX.bD;
import com.aspose.drawing.internal.hX.g;
import com.aspose.drawing.internal.j.b;
import com.aspose.drawing.internal.jt.d;

public final class LinearGradientBrush
extends Brush {
    private Color[] a = (Color[])com.aspose.drawing.internal.hX.g.a(com.aspose.drawing.internal.hX.g.a(com.aspose.drawing.internal.jt.d.a(Color.class), 2));
    private Matrix b = new Matrix();
    private ColorBlend c;
    private RectangleF d = new RectangleF();
    private boolean e;
    private Blend f;
    private int g = 0;

    public LinearGradientBrush(PointF point1, PointF point2, Color color1, Color color2) {
        if (LinearGradientBrush.b(point1, point2)) {
            throw new ArgumentException("Points of gradient are too close.");
        }
        color1.CloneTo(this.a[0]);
        color2.CloneTo(this.a[1]);
        this.d = RectangleF.fromLTRB(bD.b(point1.getX(), point2.getX()), bD.b(point1.getY(), point2.getY()), bD.a(point1.getX(), point2.getX()), bD.a(point1.getY(), point2.getY()));
        this.c(point1, point2);
    }

    public LinearGradientBrush(Point point1, Point point2, Color color1, Color color2) {
        this(Point.to_PointF(point1), Point.to_PointF(point2), color1, color2);
    }

    public LinearGradientBrush(RectangleF rect, Color color1, Color color2, int linearGradientMode) {
        this(rect.getLocation(), PointF.add(rect.getLocation(), rect.getSize()), color1, color2);
        if (rect.getWidth() == 0.0f || rect.getHeight() == 0.0f) {
            throw new ArgumentException("rect cannot have a width or height equal to 0.");
        }
        this.a(linearGradientMode);
    }

    public LinearGradientBrush(Rectangle rect, Color color1, Color color2, int linearGradientMode) {
        this(RectangleF.to_RectangleF(rect), color1, color2, linearGradientMode);
    }

    public LinearGradientBrush(RectangleF rect, Color color1, Color color2, float angle) {
        this(rect, color1, color2, angle, false);
    }

    public LinearGradientBrush(RectangleF rect, Color color1, Color color2, float angle, boolean isAngleScaleable) {
        this(rect.getLocation(), PointF.add(rect.getLocation(), rect.getSize()), color1, color2);
        if (rect.getWidth() == 0.0f || rect.getHeight() == 0.0f) {
            throw new ArgumentException("rect cannot have a width or height equal to 0.");
        }
        this.a(angle);
    }

    public LinearGradientBrush(Rectangle rect, Color color1, Color color2, float angle) {
        this(rect, color1, color2, angle, false);
    }

    public LinearGradientBrush(Rectangle rect, Color color1, Color color2, float angle, boolean isAngleScaleable) {
        this(RectangleF.to_RectangleF(rect), color1, color2, angle, isAngleScaleable);
    }

    private LinearGradientBrush() {
    }

    private LinearGradientBrush(LinearGradientBrush src) {
        this.b = src.b != null ? src.b : null;
        this.a = com.aspose.drawing.internal.jt.d.c((Object)src.a, Color[].class);
        this.d = src.getRectangle();
        if (src.getBlend() != null) {
            this.setBlend(new Blend());
            this.getBlend().setFactors(com.aspose.drawing.internal.jt.d.c((Object)(src.getBlend().getFactors() != null ? src.getBlend().getFactors() : null), float[].class));
            this.getBlend().setPositions(com.aspose.drawing.internal.jt.d.c((Object)(src.getBlend().getPositions() != null ? src.getBlend().getPositions() : null), float[].class));
        }
        if (src.getInterpolationColors() != null) {
            this.setInterpolationColors(new ColorBlend());
            this.getInterpolationColors().setColors(com.aspose.drawing.internal.jt.d.c((Object)(src.getInterpolationColors().getColors() != null ? src.getInterpolationColors().getColors() : null), Color[].class));
            this.getInterpolationColors().setPositions(com.aspose.drawing.internal.jt.d.c((Object)(src.getInterpolationColors().getPositions() != null ? src.getInterpolationColors().getPositions() : null), float[].class));
        }
        this.g = src.g;
    }

    public Color[] getLinearColors() {
        return new Color[]{this.a[0], this.a[1]};
    }

    public void setLinearColors(Color[] value) {
        if (value == null) {
            throw new NullReferenceException("value is null");
        }
        try {
            value[0].CloneTo(this.a[0]);
            value[1].CloneTo(this.a[1]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IndexOutOfRangeException(arrayIndexOutOfBoundsException.getMessage());
        }
    }

    public RectangleF getRectangle() {
        return this.d.Clone();
    }

    public boolean getGammaCorrection() {
        if (DrawingSettings.getStrictMode()) {
            throw new NotImplementedException(do.a("LinearGradientBrush.GammaCorrection"));
        }
        do.c("LinearGradientBrush.GammaCorrection");
        return false;
    }

    public void setGammaCorrection(boolean value) {
        if (DrawingSettings.getStrictMode()) {
            do.b("LinearGradientBrush.GammaCorrection");
        } else {
            do.c("LinearGradientBrush.GammaCorrection");
        }
    }

    public Blend getBlend() {
        return this.f;
    }

    public void setBlend(Blend value) {
        this.f = value;
    }

    public ColorBlend getInterpolationColors() {
        if (this.c == null) {
            throw new ArgumentException("Property must be set to a valid ColorBlend object to use interpolation colors. ColorBlend objects must be constructed with the same number of positions and color values. Positions must be between 0.0 and 1.0, 1.0 indicating the last element in the array.");
        }
        return this.c;
    }

    public void setInterpolationColors(ColorBlend value) {
        this.c = value;
    }

    public int getWrapMode() {
        return this.g;
    }

    public void setWrapMode(int value) {
        this.g = value;
    }

    public Matrix getTransform() {
        return this.b;
    }

    public void setTransform(Matrix value) {
        this.b.dispose();
        this.b = value.deepClone();
    }

    public boolean a() {
        return this.c != null;
    }

    public PointF b() {
        if (this.getRectangle().getWidth() > 0.0f) {
            return this.getRectangle().getLocation();
        }
        return PointF.op_Subtraction(LinearGradientBrush.a(this.getRectangle()), new SizeF(this.getRectangle().getHeight() / 2.0f, 0.0f));
    }

    public PointF c() {
        if (this.getRectangle().getWidth() > 0.0f) {
            return PointF.op_Addition(this.getRectangle().getLocation(), new SizeF(this.getRectangle().getWidth(), 0.0f));
        }
        return PointF.op_Addition(LinearGradientBrush.a(this.getRectangle()), new SizeF(this.getRectangle().getHeight() / 2.0f, 0.0f));
    }

    @Override
    public Object deepClone() {
        return new LinearGradientBrush(this);
    }

    public void setSigmaBellShape(float focus) {
        this.setSigmaBellShape(focus, 1.0f);
    }

    public void setSigmaBellShape(float focus, float scale) {
        this.setBlend(LinearGradientBrush.b(focus, scale));
    }

    public void setBlendTriangularShape(float focus) {
        this.setBlendTriangularShape(focus, 1.0f);
    }

    public void setBlendTriangularShape(float focus, float scale) {
        this.setBlend(LinearGradientBrush.a(focus, scale));
    }

    public void resetTransform() {
        this.b.reset();
    }

    public void multiplyTransform(Matrix matrix) {
        this.multiplyTransform(matrix, 0);
    }

    public void multiplyTransform(Matrix matrix, int order) {
        this.b.multiply(matrix, order);
    }

    public void translateTransform(float dx2, float dy2) {
        this.translateTransform(dx2, dy2, 0);
    }

    public void translateTransform(float dx2, float dy2, int order) {
        this.b.translate(dx2, dy2, order);
    }

    public void scaleTransform(float sx, float sy) {
        this.scaleTransform(sx, sy, 0);
    }

    public void scaleTransform(float sx, float sy, int order) {
        this.b.scale(sx, sy, order);
    }

    public void rotateTransform(float angle) {
        this.rotateTransform(angle, 0);
    }

    public void rotateTransform(float angle, int order) {
        this.b.rotate(angle, order);
    }

    public static Color a(Color color, Color color2, float f2) {
        return Color.fromArgb(LinearGradientBrush.a((byte)color.getA(), (byte)color2.getA(), f2) & 0xFF, LinearGradientBrush.a((byte)color.getR(), (byte)color2.getR(), f2) & 0xFF, LinearGradientBrush.a((byte)color.getG(), (byte)color2.getG(), f2) & 0xFF, LinearGradientBrush.a((byte)color.getB(), (byte)color2.getB(), f2) & 0xFF);
    }

    public static Blend a(float f2, float f3) {
        Blend blend = new Blend();
        blend.setFactors(new float[]{0.0f, f3, 0.0f});
        blend.setPositions(new float[]{0.0f, f2, 1.0f});
        return blend;
    }

    public static Blend b(float f2, float f3) {
        PointF pointF;
        float f4;
        int n2;
        Blend blend = new Blend(511);
        int n3 = blend.getPositions().length / 2;
        float f5 = 0.37f;
        float f6 = f2;
        PointF pointF2 = new PointF(0.0f, 0.0f);
        PointF pointF3 = new PointF(f2, f3);
        PointF pointF4 = new PointF(pointF2.getX() + f6 * f5, pointF2.getY());
        PointF pointF5 = new PointF(pointF3.getX() - f6 * f5, pointF3.getY());
        for (n2 = 0; n2 <= n3; ++n2) {
            f4 = (float)n2 / (float)n3;
            pointF = LinearGradientBrush.a(f4, pointF2, pointF4, pointF5, pointF3);
            blend.getPositions()[n2] = pointF.getX();
            blend.getFactors()[n2] = pointF.getY();
        }
        f6 = 1.0f - f2;
        pointF2 = new PointF(f2, f3);
        pointF3 = new PointF(1.0f, 0.0f);
        pointF4 = new PointF(pointF2.getX() + f6 * f5, pointF2.getY());
        pointF5 = new PointF(pointF3.getX() - f6 * f5, pointF3.getY());
        for (n2 = 1; n2 <= n3; ++n2) {
            f4 = (float)n2 / (float)n3;
            pointF = LinearGradientBrush.a(f4, pointF2, pointF4, pointF5, pointF3);
            blend.getPositions()[n2 + n3] = pointF.getX();
            blend.getFactors()[n2 + n3] = pointF.getY();
        }
        return blend;
    }

    private static byte a(int n2, int n3, float f2) {
        return com.aspose.drawing.internal.jt.d.b((float)(n2 & 0xFF) + (float)((n3 & 0xFF) - (n2 & 0xFF)) * f2);
    }

    private static PointF a(float f2, PointF pointF, PointF pointF2, PointF pointF3, PointF pointF4) {
        PointF pointF5 = LinearGradientBrush.a(pointF, (float)bD.f(1.0f - f2, 3.0));
        PointF pointF6 = LinearGradientBrush.a(pointF2, (float)(3.0 * bD.f(1.0f - f2, 2.0) * (double)f2));
        PointF pointF7 = LinearGradientBrush.a(pointF3, (float)((double)(3.0f * (1.0f - f2)) * bD.f(f2, 2.0)));
        PointF pointF8 = LinearGradientBrush.a(pointF4, (float)bD.f(f2, 3.0));
        return LinearGradientBrush.a(LinearGradientBrush.a(LinearGradientBrush.a(pointF5, pointF6), pointF7), pointF8);
    }

    private static PointF a(PointF pointF, float f2) {
        return new PointF(pointF.getX() * f2, pointF.getY() * f2);
    }

    private static PointF a(PointF pointF, PointF pointF2) {
        return new PointF(pointF.getX() + pointF2.getX(), pointF.getY() + pointF2.getY());
    }

    private static boolean b(PointF pointF, PointF pointF2) {
        return LinearGradientBrush.c(pointF.getX(), pointF2.getX()) && LinearGradientBrush.c(pointF.getY(), pointF2.getY());
    }

    private static boolean c(float f2, float f3) {
        return bD.a((f2 - f3) / (f3 == 0.0f ? 1.0f : f3)) < 1.1920929E-6f;
    }

    private static PointF a(RectangleF rectangleF) {
        return PointF.op_Addition(rectangleF.getLocation(), new SizeF(rectangleF.getWidth() / 2.0f, rectangleF.getHeight() / 2.0f));
    }

    private void c(PointF pointF, PointF pointF2) {
        double d2 = bD.e(pointF2.getY() - pointF.getY(), pointF2.getX() - pointF.getX());
        double d3 = this.getRectangle().getWidth() > 0.0f ? 1.0 / bD.a(bD.h(d2)) : 1.0;
        double d4 = (double)this.getRectangle().getHeight() * bD.a(bD.h(d2)) + (double)(this.getRectangle().getWidth() > 0.0f ? this.getRectangle().getWidth() : this.getRectangle().getHeight()) * bD.a(bD.g(d2));
        double d5 = this.getRectangle().getHeight() > 0.0f ? d4 / (double)this.getRectangle().getHeight() : 1.0;
        PointF pointF3 = LinearGradientBrush.a(this.getRectangle());
        Matrix matrix = new Matrix();
        matrix.translate(-pointF3.getX(), -pointF3.getY());
        matrix.scale((float)d3, (float)d5, 1);
        matrix.rotate((float)com.aspose.drawing.internal.j.b.b(d2), 1);
        matrix.translate(pointF3.getX(), pointF3.getY(), 1);
        this.b = matrix;
    }

    private void a(float f2) {
        double d2 = com.aspose.drawing.internal.j.b.a(f2);
        double d3 = (double)this.getRectangle().getWidth() * bD.a(bD.h(d2)) + (double)this.getRectangle().getHeight() * bD.a(bD.g(d2));
        double d4 = d3 / (double)this.getRectangle().getWidth();
        double d5 = (double)this.getRectangle().getHeight() * bD.a(bD.h(d2)) + (double)this.getRectangle().getWidth() * bD.a(bD.g(d2));
        double d6 = d5 / (double)this.getRectangle().getHeight();
        PointF pointF = LinearGradientBrush.a(this.getRectangle());
        Matrix matrix = new Matrix();
        matrix.translate(-pointF.getX(), -pointF.getY());
        matrix.scale((float)d4, (float)d6, 1);
        matrix.rotate((float)com.aspose.drawing.internal.j.b.b(d2), 1);
        matrix.translate(pointF.getX(), pointF.getY(), 1);
        this.b = matrix;
    }

    private void a(int n2) {
        double d2 = 0.0;
        switch (n2) {
            case 2: {
                d2 = 45.0;
                break;
            }
            case 1: {
                d2 = 90.0;
                break;
            }
            case 3: {
                d2 = 135.0;
            }
        }
        double d3 = 1.0;
        if (n2 == 2 || n2 == 3) {
            d3 = 2.0 * bD.g(com.aspose.drawing.internal.j.b.a(d2));
        }
        double d4 = this.getRectangle().getWidth() / this.getRectangle().getHeight();
        PointF pointF = LinearGradientBrush.a(this.getRectangle());
        Matrix matrix = new Matrix();
        matrix.translate(-pointF.getX(), -pointF.getY());
        matrix.scale(1.0f, (float)d4, 1);
        matrix.rotate((float)d2, 1);
        matrix.scale((float)d3, (float)(d3 / d4), 1);
        matrix.translate(pointF.getX(), pointF.getY(), 1);
        this.b = matrix;
    }
}

