/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.drawing.drawing2d;

import com.aspose.drawing.Point;
import com.aspose.drawing.PointF;
import com.aspose.drawing.Rectangle;
import com.aspose.drawing.RectangleF;
import com.aspose.drawing.internal.Exceptions.ArgumentException;
import com.aspose.drawing.internal.Exceptions.ArgumentNullException;
import com.aspose.drawing.internal.Exceptions.InvalidOperationException;
import com.aspose.drawing.internal.db.aN;
import com.aspose.drawing.internal.hX.aS;
import com.aspose.drawing.internal.hX.aq;
import com.aspose.drawing.internal.hX.bD;
import com.aspose.drawing.internal.hX.g;
import com.aspose.drawing.internal.hi.dd;
import com.aspose.drawing.internal.jt.d;

public final class Matrix
implements aq {
    public static final Matrix IdentityTransform = new Matrix();
    private dd a;

    public Matrix() {
        this.a = new dd();
    }

    public Matrix(float m11, float m12, float m21, float m22, float dx2, float dy2) {
        this.a = new dd();
        this.a.a(m11, m21, dx2, m12, m22, dy2, 0.0f, 0.0f, 1.0f);
    }

    public Matrix(Rectangle rect, Point[] plgpts) {
        this(RectangleF.to_RectangleF(rect), Matrix.a(plgpts));
    }

    public Matrix(RectangleF rect, PointF[] plgpts) {
        if (rect == null) {
            throw new ArgumentException("rect");
        }
        if (plgpts.length != 3) {
            throw new ArgumentException("Parameter is not valid.");
        }
        this.a = new dd();
        float f2 = (plgpts[1].getX() - plgpts[0].getX()) / rect.getWidth();
        float f3 = (plgpts[2].getY() - plgpts[0].getY()) / rect.getHeight();
        float f4 = (plgpts[2].getX() - plgpts[0].getX()) / rect.getHeight();
        float f5 = (plgpts[1].getY() - plgpts[0].getY()) / rect.getWidth();
        float f6 = plgpts[0].getX() - f2 * rect.getX() - f3 * rect.getY();
        float f7 = plgpts[0].getY() - f5 * rect.getX() - f4 * rect.getY();
        this.a.a(f2, f4, f6, f5, f3, f7, 0.0f, 0.0f, 1.0f);
    }

    Matrix(dd internalMatrix) {
        this.a = internalMatrix;
    }

    private Matrix(Matrix src) {
        this.a = new dd(src.a);
    }

    public static Matrix a(dd dd2) {
        return new Matrix(dd2);
    }

    public float[] getElements() {
        if (this.a.d()) {
            throw new InvalidOperationException("Unable to return elements of perspective matrix.");
        }
        float[] fArray = new float[]{this.a.g(), this.a.j(), this.a.i(), this.a.h(), this.a.e(), this.a.f()};
        return fArray;
    }

    public boolean isIdentity() {
        return this.a.b();
    }

    public boolean isInvertible() {
        return this.a.c(null);
    }

    public float getOffsetX() {
        return this.a.e();
    }

    public float getOffsetY() {
        return this.a.f();
    }

    public dd a() {
        return this.a;
    }

    public boolean b() {
        for (float f2 : this.getElements()) {
            if (!aS.b(f2) && !aS.c(f2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void dispose() {
    }

    public Matrix deepClone() {
        return new Matrix(this);
    }

    public void invert() {
        dd dd2 = new dd();
        if (this.a.c(dd2)) {
            this.a.d(dd2);
        }
    }

    public void translate(float offsetX, float offsetY) {
        this.translate(offsetX, offsetY, 0);
    }

    public void translate(float offsetX, float offsetY, int order) {
        dd dd2 = new dd();
        dd2.a(offsetX, offsetY);
        switch (order) {
            case 0: {
                this.a.a(dd2);
                break;
            }
            case 1: {
                this.a.b(dd2);
                break;
            }
            default: {
                throw new ArgumentException("Unknown MatrixOrder.");
            }
        }
    }

    public void transformVectors(PointF[] pts) {
        if (pts == null) {
            throw new ArgumentNullException("pts");
        }
        if (pts.length == 0) {
            throw new ArgumentException();
        }
        if (this.isIdentity()) {
            return;
        }
        for (int i2 = 0; i2 < pts.length; ++i2) {
            float f2 = pts[i2].getX();
            float f3 = pts[i2].getY();
            pts[i2].setX(this.a.g() * f2 + this.a.i() * f3);
            pts[i2].setY(this.a.j() * f2 + this.a.h() * f3);
        }
    }

    public void scale(float scaleX, float scaleY) {
        this.scale(scaleX, scaleY, 0);
    }

    public void scale(float scaleX, float scaleY, int order) {
        dd dd2 = new dd();
        dd2.b(scaleX, scaleY);
        switch (order) {
            case 0: {
                this.a.a(dd2);
                break;
            }
            case 1: {
                this.a.b(dd2);
                break;
            }
            default: {
                throw new ArgumentException("Unknown MatrixOrder.");
            }
        }
    }

    public void shear(float shearX, float shearY) {
        this.shear(shearX, shearY, 0);
    }

    public void shear(float shearX, float shearY, int order) {
        dd dd2 = new dd();
        dd2.d(shearX, shearY);
        switch (order) {
            case 0: {
                this.a.a(dd2);
                break;
            }
            case 1: {
                this.a.b(dd2);
                break;
            }
            default: {
                throw new ArgumentException("Unknown MatrixOrder.");
            }
        }
    }

    public void rotateAt(float angle, PointF point) {
        this.rotateAt(angle, point, 0);
    }

    public void rotateAt(float angle, PointF point, int order) {
        dd dd2 = new dd();
        dd2.a(angle, point.getX(), point.getY());
        switch (order) {
            case 0: {
                this.a.a(dd2);
                break;
            }
            case 1: {
                this.a.b(dd2);
                break;
            }
            default: {
                throw new ArgumentException("Unknown MatrixOrder.");
            }
        }
    }

    public void transformPoints(PointF[] pts) {
        if (pts == null) {
            throw new ArgumentNullException("pts");
        }
        if (pts.length == 0) {
            throw new ArgumentException();
        }
        if (this.isIdentity()) {
            return;
        }
        for (int i2 = 0; i2 < pts.length; ++i2) {
            float f2 = pts[i2].getX();
            float f3 = pts[i2].getY();
            pts[i2].setX(this.a.g() * f2 + this.a.i() * f3 + this.a.e());
            pts[i2].setY(this.a.j() * f2 + this.a.h() * f3 + this.a.f());
        }
    }

    public void transformPoints(Point[] pts) {
        if (pts == null) {
            throw new ArgumentNullException("pts");
        }
        if (pts.length == 0) {
            throw new ArgumentException();
        }
        if (this.isIdentity()) {
            return;
        }
        for (int i2 = 0; i2 < pts.length; ++i2) {
            int n2 = pts[i2].getX();
            int n3 = pts[i2].getY();
            float f2 = this.a.g() * (float)n2 + this.a.i() * (float)n3 + this.a.e();
            float f3 = this.a.j() * (float)n2 + this.a.h() * (float)n3 + this.a.f();
            pts[i2].setX(d.e(bD.a((double)f2, (short)1)));
            pts[i2].setY(d.e(bD.a((double)f3, (short)1)));
        }
    }

    public void multiply(Matrix matrix) {
        this.multiply(matrix, 0);
    }

    public void multiply(Matrix matrix, int order) {
        switch (order) {
            case 0: {
                this.a.a(matrix.a());
                break;
            }
            case 1: {
                this.a.b(matrix.a());
                break;
            }
            default: {
                throw new ArgumentException("Unknown MatrixOrder.");
            }
        }
    }

    public void rotate(float angle) {
        this.rotate(angle, 0);
    }

    public void rotate(float angle, int order) {
        this.rotateAt(angle, new PointF(0.0f, 0.0f), order);
    }

    public void reset() {
        this.a.m();
    }

    private static PointF[] a(Point[] pointArray) {
        if (pointArray == null) {
            throw new ArgumentNullException("points");
        }
        PointF[] pointFArray = (PointF[])g.a(g.a(d.a(PointF.class), pointArray.length));
        for (int i2 = 0; i2 < pointArray.length; ++i2) {
            Point.to_PointF(pointArray[i2]).CloneTo(pointFArray[i2]);
        }
        return pointFArray;
    }

    public void a(aN[] aNArray) {
        if (aNArray == null) {
            throw new ArgumentNullException("pts");
        }
        if (aNArray.length == 0) {
            throw new ArgumentException();
        }
        if (this.isIdentity()) {
            return;
        }
        for (int i2 = 0; i2 < aNArray.length; ++i2) {
            float f2 = aNArray[i2].c();
            float f3 = aNArray[i2].d();
            float f4 = this.a.g() * f2 + this.a.i() * f3 + this.a.e();
            float f5 = this.a.j() * f2 + this.a.h() * f3 + this.a.f();
            aNArray[i2].a(d.e(bD.a((double)f4, (short)1)));
            aNArray[i2].b(d.e(bD.a((double)f5, (short)1)));
        }
    }
}

