/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.drawing.drawing2d;

import com.aspose.drawing.Brush;
import com.aspose.drawing.Color;
import com.aspose.drawing.Point;
import com.aspose.drawing.PointF;
import com.aspose.drawing.RectangleF;
import com.aspose.drawing.drawing2d.Blend;
import com.aspose.drawing.drawing2d.ColorBlend;
import com.aspose.drawing.drawing2d.GraphicsPath;
import com.aspose.drawing.drawing2d.LinearGradientBrush;
import com.aspose.drawing.drawing2d.Matrix;
import com.aspose.drawing.drawing2d.d;
import com.aspose.drawing.internal.Exceptions.OutOfMemoryException;
import com.aspose.drawing.internal.hX.g;

public final class PathGradientBrush
extends Brush {
    private Matrix a = new Matrix();
    private Color b = new Color();
    private Color[] c;
    private PointF d = new PointF();
    private Blend e;
    private ColorBlend f;
    private PointF g = new PointF();
    private int h;
    private GraphicsPath i;

    public PathGradientBrush(PointF[] points) {
        this(points, 4);
    }

    public PathGradientBrush(PointF[] points, int wrapMode) {
        this(PathGradientBrush.a(points));
        this.setWrapMode(wrapMode);
    }

    public PathGradientBrush(Point[] points) {
        this(points, 4);
    }

    public PathGradientBrush(Point[] points, int wrapMode) {
        this(com.aspose.drawing.internal.hX.g.a(PointF.class, points, new d()), wrapMode);
    }

    public PathGradientBrush(GraphicsPath path) {
        RectangleF rectangleF = path.getBounds();
        if (rectangleF.getHeight() == 0.0f || rectangleF.getWidth() == 0.0f) {
            throw new OutOfMemoryException();
        }
        this.i = (GraphicsPath)path.deepClone();
        this.setWrapMode(4);
        this.b();
    }

    private PathGradientBrush(PathGradientBrush src) {
        this.a = src.a != null ? src.a.deepClone() : null;
        this.i = (GraphicsPath)src.a().deepClone();
        this.setCenterColor(src.getCenterColor());
        this.setSurroundColors(com.aspose.drawing.internal.jt.d.c(src.getSurroundColors() != null ? src.getSurroundColors().clone() : null, Color[].class));
        this.setCenterPoint(src.getCenterPoint());
        if (src.getBlend() != null) {
            this.setBlend(new Blend());
            this.getBlend().setFactors(com.aspose.drawing.internal.jt.d.c(src.getBlend().getFactors() != null ? src.getBlend().getFactors().clone() : null, float[].class));
            this.getBlend().setPositions(com.aspose.drawing.internal.jt.d.c(src.getBlend().getPositions() != null ? src.getBlend().getPositions().clone() : null, float[].class));
        }
        if (src.getInterpolationColors() != null) {
            this.setInterpolationColors(new ColorBlend());
            this.getInterpolationColors().setColors(com.aspose.drawing.internal.jt.d.c(src.getInterpolationColors().getColors() != null ? src.getInterpolationColors().getColors().clone() : null, Color[].class));
            this.getInterpolationColors().setPositions(com.aspose.drawing.internal.jt.d.c(src.getInterpolationColors().getPositions() != null ? src.getInterpolationColors().getPositions().clone() : null, float[].class));
        }
        this.setFocusScales(src.getFocusScales());
        this.setWrapMode(src.getWrapMode());
    }

    public Color getCenterColor() {
        return this.b.Clone();
    }

    public void setCenterColor(Color value) {
        this.b = value;
    }

    public Color[] getSurroundColors() {
        return this.c;
    }

    public void setSurroundColors(Color[] value) {
        this.c = value;
    }

    public PointF getCenterPoint() {
        return this.d.Clone();
    }

    public void setCenterPoint(PointF value) {
        this.d = value.Clone();
    }

    public RectangleF getRectangle() {
        return this.a().getBounds();
    }

    public Blend getBlend() {
        return this.e;
    }

    public void setBlend(Blend value) {
        this.e = value;
    }

    public ColorBlend getInterpolationColors() {
        return this.f;
    }

    public void setInterpolationColors(ColorBlend value) {
        this.f = value;
    }

    public Matrix getTransform() {
        return this.a.deepClone();
    }

    public void setTransform(Matrix value) {
        this.a.dispose();
        this.a = value.deepClone();
    }

    public PointF getFocusScales() {
        return this.g.Clone();
    }

    public void setFocusScales(PointF value) {
        this.g = value.Clone();
    }

    public int getWrapMode() {
        return this.h;
    }

    public void setWrapMode(int value) {
        this.h = value;
    }

    public GraphicsPath a() {
        return this.i;
    }

    @Override
    public Object deepClone() {
        return new PathGradientBrush(this);
    }

    public void setSigmaBellShape(float focus) {
        this.setSigmaBellShape(focus, 1.0f);
    }

    public void setSigmaBellShape(float focus, float scale) {
        this.setBlend(LinearGradientBrush.b(focus, scale));
    }

    public void setBlendTriangularShape(float focus) {
        this.setBlendTriangularShape(focus, 1.0f);
    }

    public void setBlendTriangularShape(float focus, float scale) {
        this.setBlend(LinearGradientBrush.a(focus, scale));
    }

    public void resetTransform() {
        this.a.reset();
    }

    public void multiplyTransform(Matrix matrix) {
        this.multiplyTransform(matrix, 0);
    }

    public void multiplyTransform(Matrix matrix, int order) {
        this.a.multiply(matrix, order);
    }

    public void translateTransform(float dx2, float dy2) {
        this.translateTransform(dx2, dy2, 0);
    }

    public void translateTransform(float dx2, float dy2, int order) {
        this.a.translate(dx2, dy2, order);
    }

    public void scaleTransform(float sx, float sy) {
        this.scaleTransform(sx, sy, 0);
    }

    public void scaleTransform(float sx, float sy, int order) {
        this.a.scale(sx, sy, order);
    }

    public void rotateTransform(float angle) {
        this.rotateTransform(angle, 0);
    }

    public void rotateTransform(float angle, int order) {
        this.a.rotate(angle, order);
    }

    private static GraphicsPath a(PointF[] pointFArray) {
        GraphicsPath graphicsPath = new GraphicsPath();
        graphicsPath.addLines(pointFArray);
        return graphicsPath;
    }

    private void b() {
        if (this.a().getPointCount() == 0) {
            return;
        }
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (PointF pointF : this.a().getPathPoints()) {
            f2 += pointF.getX();
            f3 += pointF.getY();
        }
        this.setCenterPoint(new PointF(f2 / (float)this.a().getPointCount(), f3 / (float)this.a().getPointCount()));
    }
}

