/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.drawing;

import com.aspose.drawing.FontFamily;
import com.aspose.drawing.Graphics;
import com.aspose.drawing.GraphicsUnit;
import com.aspose.drawing.internal.Exceptions.ArgumentException;
import com.aspose.drawing.internal.dn.do;
import com.aspose.drawing.internal.hX.aE;
import com.aspose.drawing.internal.hX.aS;
import com.aspose.drawing.internal.hX.aW;
import com.aspose.drawing.internal.hX.ac;
import com.aspose.drawing.internal.hX.aq;
import com.aspose.drawing.internal.hX.bD;
import com.aspose.drawing.internal.if.i;
import com.aspose.drawing.internal.jt.d;
import com.aspose.drawing.system.EnumExtensions;

public final class Font
implements aq {
    private float a;
    private byte b;
    private int c;
    private int d;
    private String e;
    private FontFamily f;
    private boolean g;
    private int h;

    public Font(Font prototype, int newStyle) {
        this(prototype.f, prototype.getSize(), newStyle, prototype.getUnit(), prototype.getGdiCharSet(), prototype.g);
    }

    public Font(FontFamily family, float emSize) {
        this(family, emSize, 0, 3);
    }

    public Font(FontFamily family, float emSize, int style) {
        this(family, emSize, style, 3);
    }

    public Font(FontFamily family, float emSize, int style, int unit) {
        this.f = family;
        this.a(family.getName(), emSize, style, unit, (byte)1, Font.a(family.getName()));
    }

    public Font(FontFamily family, float emSize, int style, int unit, byte gdiCharSet) {
        this.f = family;
        this.a(family.getName(), emSize, style, unit, gdiCharSet, Font.a(family.getName()));
    }

    public Font(FontFamily family, float emSize, int style, int unit, byte gdiCharSet, boolean gdiVerticalFont) {
        this.f = family;
        this.a(family.getName(), emSize, style, unit, gdiCharSet, gdiVerticalFont);
    }

    public Font(String familyName, float emSize) {
        this.a(familyName, emSize, 0, 3, (byte)1, Font.a(familyName));
    }

    public Font(String familyName, float emSize, int style) {
        this.a(familyName, emSize, style, 3, (byte)1, Font.a(familyName));
    }

    public Font(String familyName, float emSize, int style, int unit) {
        this.a(familyName, emSize, style, unit, (byte)1, Font.a(familyName));
    }

    public Font(String familyName, float emSize, int style, int unit, byte gdiCharSet) {
        this.a(familyName, emSize, style, unit, gdiCharSet, Font.a(familyName));
    }

    public Font(String familyName, float emSize, int style, int unit, byte gdiCharSet, boolean gdiVerticalFont) {
        this.a(familyName, emSize, style, unit, gdiCharSet, gdiVerticalFont);
    }

    public static float a(float f2, int n2, float f3) {
        return Font.c(f2, n2, f3) * f3 / 72.0f;
    }

    public static float b(float f2, int n2, float f3) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: {
                return f2;
            }
            case 3: {
                return f2 * 72.0f / f3;
            }
            case 4: {
                return f2 / f3;
            }
            case 5: {
                return f2 * 300.0f / f3;
            }
            case 6: {
                return f2 * 25.4f / f3;
            }
        }
        return 0.0f;
    }

    private static float c(float f2, int n2, float f3) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: {
                return f2 * 72.0f / f3;
            }
            case 3: {
                return f2;
            }
            case 4: {
                return f2 * 72.0f;
            }
            case 5: {
                return f2 * 72.0f / 300.0f;
            }
            case 6: {
                return f2 * 2.834646f;
            }
        }
        return 0.0f;
    }

    private static boolean a(String string) {
        return string != null && string.length() > 0 && string.charAt(0) == '@';
    }

    public FontFamily getFontFamily() {
        return this.f;
    }

    public boolean getBold() {
        return (this.getStyle() & 1) != 0;
    }

    public byte getGdiCharSet() {
        return this.b;
    }

    public boolean getGdiVerticalFont() {
        return this.g;
    }

    public boolean getItalic() {
        return (this.getStyle() & 2) != 0;
    }

    public String getName() {
        String string;
        String string2 = string = this.f != null ? this.f.getName() : this.e;
        if (string == null) {
            string = this.e;
        }
        return string;
    }

    public boolean getStrikeout() {
        return (this.getStyle() & 8) != 0;
    }

    public boolean getUnderline() {
        return (this.getStyle() & 4) != 0;
    }

    public int getStyle() {
        return this.c;
    }

    public float getSize() {
        return this.a;
    }

    public float getSizeInPoints() {
        return Font.c(this.a, this.d, 96.0f);
    }

    public int getUnit() {
        return this.d;
    }

    public int getHeight_Rename_Namesake() {
        return com.aspose.drawing.internal.jt.d.e(bD.b((double)this.getHeight()));
    }

    public boolean isSystemFont() {
        do.a("Font.IsSystemFont");
        return false;
    }

    public String getSystemFontName() {
        do.a("Font.SystemFontName");
        return aW.a;
    }

    public String getOriginalFontName() {
        return this.e;
    }

    public Font deepClone() {
        return new Font(this.e, this.a, this.c, this.d, this.b, this.g);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        Font font = (Font)((Object)com.aspose.drawing.internal.jt.d.a(obj, Font.class));
        if (font == null) {
            return false;
        }
        return font.getFontFamily().equals(this.getFontFamily()) && font.getGdiVerticalFont() == this.getGdiVerticalFont() && font.getGdiCharSet() == this.getGdiCharSet() && font.getStyle() == this.getStyle() && font.getSize() == this.getSize() && font.getUnit() == this.getUnit();
    }

    public int hashCode() {
        return (int)((((long)this.c & 0xFFFFFFFFL) << 13 | ((long)this.c & 0xFFFFFFFFL) >> 19) ^ (((long)this.d & 0xFFFFFFFFL) << 26 | ((long)this.d & 0xFFFFFFFFL) >> 6) ^ ((com.aspose.drawing.internal.jt.d.f(this.a) & 0xFFFFFFFFL) << 7 | (com.aspose.drawing.internal.jt.d.f(this.a) & 0xFFFFFFFFL) >> 25));
    }

    public int getHeight() {
        return this.getHeight(96.0f);
    }

    public float getHeight(Graphics graphics) {
        float f2 = this.getHeight(graphics.getDpiY());
        return Font.b(f2, graphics.getPageUnit(), graphics.getDpiY());
    }

    public int getHeight(float dpi) {
        int n2 = this.f.getEmHeight(this.getStyle());
        int n3 = this.f.getLineSpacing(this.getStyle());
        float f2 = Font.a(this.getSize(), this.getUnit(), dpi);
        return (int)Math.ceil((float)n3 * f2 / (float)n2);
    }

    @Override
    public void dispose() {
    }

    public String toString() {
        return aW.a(i.h(), "[{0}: Name={1}, Size={2}, Units={3}, GdiCharSet={4}, GdiVerticalFont={5}]", aE.b(this).u(), this.getFontFamily().getName(), Float.valueOf(this.a), this.d, this.b, this.g);
    }

    private void a(String string, float f2, int n2, int n3, byte by2, boolean bl2) {
        if (f2 < 0.0f || aS.c(f2) || f2 > Float.MAX_VALUE) {
            throw new ArgumentException(aW.a("Value of '{0}' is not valid for 'emSize'. 'emSize' should be greater than 0 and less than or equal to System.Single.MaxValue.", new Object[]{aS.f(f2)}), "emSize");
        }
        if (n3 == 1 || n3 < 0 || n3 > 6) {
            throw new ArgumentException(aW.a("Value of '{0}' is not valid for 'unit'", new Object[]{EnumExtensions.toString(GraphicsUnit.class, n3)}), "unit");
        }
        this.e = string;
        this.a = f2;
        this.c = n2;
        this.b = by2;
        this.d = n3;
        this.g = bl2;
        if (this.f == null) {
            try {
                this.f = new FontFamily(string);
            }
            catch (ArgumentException argumentException) {
                try {
                    this.f = new FontFamily(ac.i().a() == 2 ? "Microsoft Sans Serif" : "FreeSans");
                }
                catch (ArgumentException argumentException2) {
                    this.f = new FontFamily("Open Sans");
                }
            }
        }
    }

    public int getCharacterSet() {
        return this.h;
    }
}

