/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.drawing;

import com.aspose.drawing.Point;
import com.aspose.drawing.RectangleF;
import com.aspose.drawing.Size;
import com.aspose.drawing.internal.hX.aW;
import com.aspose.drawing.internal.hX.ar;
import com.aspose.drawing.internal.hX.av;
import com.aspose.drawing.internal.hX.bD;
import com.aspose.drawing.internal.jt.d;
import com.aspose.drawing.internal.jt.i;

public class Rectangle
extends i<Rectangle>
implements ar<Rectangle>,
Cloneable {
    private static final Rectangle a = (Rectangle)com.aspose.drawing.internal.jt.d.c(Rectangle.class);
    private int b;
    private int c;
    private int d;
    private int e;

    public Rectangle() {
    }

    public Rectangle(int x2, int y2, int width, int height) {
        this.b = x2;
        this.c = y2;
        this.d = x2 + width;
        this.e = y2 + height;
    }

    public Rectangle(Point location, Size size) {
        this(location.getX(), location.getY(), size.getWidth(), size.getHeight());
    }

    public static Rectangle fromLTRB(int left, int top, int right, int bottom) {
        return new Rectangle(left, top, right - left, bottom - top);
    }

    public static Rectangle intersect(Rectangle a2, Rectangle b2) {
        int n2 = bD.b(a2.getX(), b2.getX());
        int n3 = bD.d(a2.getX() + a2.getWidth(), b2.getX() + b2.getWidth());
        int n4 = bD.b(a2.getY(), b2.getY());
        int n5 = bD.d(a2.getY() + a2.getHeight(), b2.getY() + b2.getHeight());
        if (n3 >= n2 && n5 >= n4) {
            return new Rectangle(n2, n4, n3 - n2, n5 - n4);
        }
        return Rectangle.getEmpty();
    }

    public static boolean op_Equality(Rectangle left, Rectangle right) {
        if (left.getX() == right.getX() && left.getY() == right.getY() && left.getWidth() == right.getWidth()) {
            return left.getHeight() == right.getHeight();
        }
        return false;
    }

    public static boolean op_Inequality(Rectangle left, Rectangle right) {
        return !Rectangle.op_Equality(left, right);
    }

    public static Rectangle ceiling(RectangleF value) {
        return new Rectangle(com.aspose.drawing.internal.jt.d.e(bD.b((double)value.getX())), com.aspose.drawing.internal.jt.d.e(bD.b((double)value.getY())), com.aspose.drawing.internal.jt.d.e(bD.b((double)value.getWidth())), com.aspose.drawing.internal.jt.d.e(bD.b((double)value.getHeight())));
    }

    public static Rectangle truncate(RectangleF value) {
        return new Rectangle(com.aspose.drawing.internal.jt.d.e(value.getX()), com.aspose.drawing.internal.jt.d.e(value.getY()), com.aspose.drawing.internal.jt.d.e(value.getWidth()), com.aspose.drawing.internal.jt.d.e(value.getHeight()));
    }

    public static Rectangle round(RectangleF value) {
        return new Rectangle(com.aspose.drawing.internal.jt.d.e(bD.d(value.getX())), com.aspose.drawing.internal.jt.d.e(bD.d(value.getY())), com.aspose.drawing.internal.jt.d.e(bD.d(value.getWidth())), com.aspose.drawing.internal.jt.d.e(bD.d(value.getHeight())));
    }

    public static Rectangle union(Rectangle a2, Rectangle b2) {
        int n2 = bD.d(a2.getX(), b2.getX());
        int n3 = bD.b(a2.getX() + a2.getWidth(), b2.getX() + b2.getWidth());
        int n4 = bD.d(a2.getY(), b2.getY());
        int n5 = bD.b(a2.getY() + a2.getHeight(), b2.getY() + b2.getHeight());
        return new Rectangle(n2, n4, n3 - n2, n5 - n4);
    }

    public static Rectangle inflate(Rectangle rect, int x2, int y2) {
        Rectangle rectangle = rect.Clone();
        rectangle.inflate(x2, y2);
        return rectangle;
    }

    public static boolean isEquals(Rectangle obj1, Rectangle obj2) {
        return obj1.equals(obj2);
    }

    public static Rectangle fromPoints(Point point1, Point point2) {
        int n2 = bD.d(point1.getX(), point2.getX());
        int n3 = bD.d(point1.getY(), point2.getY());
        int n4 = bD.b(point1.getX(), point2.getX());
        int n5 = bD.b(point1.getY(), point2.getY());
        return Rectangle.fromLTRB(n2, n3, n4, n5);
    }

    public static Rectangle getEmpty() {
        return a.Clone();
    }

    public final int getX() {
        return this.b;
    }

    public final void setX(int value) {
        this.d = value + this.getWidth();
        this.b = value;
    }

    public final int getY() {
        return this.c;
    }

    public final void setY(int value) {
        this.e = value + this.getHeight();
        this.c = value;
    }

    public final Point getLocation() {
        return new Point(this.getX(), this.getY());
    }

    public final void setLocation(Point value) {
        this.setX(value.getX());
        this.setY(value.getY());
    }

    public final int getWidth() {
        return this.d - this.b;
    }

    public final void setWidth(int value) {
        this.d = this.b + value;
    }

    public final int getHeight() {
        return this.e - this.c;
    }

    public final void setHeight(int value) {
        this.e = this.c + value;
    }

    public final Size getSize() {
        return new Size(this.getWidth(), this.getHeight());
    }

    public final void setSize(Size value) {
        this.setWidth(value.getWidth());
        this.setHeight(value.getHeight());
    }

    public final int getLeft() {
        return this.b;
    }

    public final int getTop() {
        return this.c;
    }

    public final int getRight() {
        return this.d;
    }

    public final int getBottom() {
        return this.e;
    }

    public final boolean isEmpty() {
        return this.getX() == 0 && this.getY() == 0 && this.getWidth() == 0 && this.getHeight() == 0;
    }

    @Override
    public boolean equals(Object obj) {
        return com.aspose.drawing.internal.jt.d.b(obj, Rectangle.class) && this.equals(com.aspose.drawing.internal.jt.d.d(obj, Rectangle.class));
    }

    public int hashCode() {
        return this.getX() ^ (this.getY() << 13 | (int)(((long)this.getY() & 0xFFFFFFFFL) >> 19)) ^ (this.getWidth() << 26 | (int)(((long)this.getWidth() & 0xFFFFFFFFL) >> 6)) ^ (this.getHeight() << 7 | (int)(((long)this.getHeight() & 0xFFFFFFFFL) >> 25));
    }

    public String toString() {
        return aW.a("{X=", av.b(this.getX()), ",Y=", av.b(this.getY()), ",Width=", av.b(this.getWidth()), ",Height=", av.b(this.getHeight()), "}");
    }

    public final void intersect(Rectangle rect) {
        Rectangle rectangle = Rectangle.intersect(rect.Clone(), this.Clone()).Clone();
        this.setX(rectangle.getX());
        this.setY(rectangle.getY());
        this.setWidth(rectangle.getWidth());
        this.setHeight(rectangle.getHeight());
    }

    public final void inflate(int width, int height) {
        this.setX(this.getX() - width);
        this.setY(this.getY() - height);
        this.setWidth(this.getWidth() + 2 * width);
        this.setHeight(this.getHeight() + 2 * height);
    }

    public final void inflate(Size size) {
        this.inflate(size.getWidth(), size.getHeight());
    }

    public final boolean contains(int x2, int y2) {
        if (this.getX() <= x2 && x2 < this.getX() + this.getWidth() && this.getY() <= y2) {
            return y2 < this.getY() + this.getHeight();
        }
        return false;
    }

    public final boolean contains(Point pt) {
        return this.contains(pt.getX(), pt.getY());
    }

    public final boolean contains(Rectangle rect) {
        return this.getX() <= rect.getX() && rect.getX() + rect.getWidth() <= this.getX() + this.getWidth() && this.getY() <= rect.getY() && rect.getY() + rect.getHeight() <= this.getY() + this.getHeight();
    }

    public final boolean intersectsWith(Rectangle rect) {
        return rect.getX() < this.getX() + this.getWidth() && this.getX() < rect.getX() + rect.getWidth() && rect.getY() < this.getY() + this.getHeight() && this.getY() < rect.getY() + rect.getHeight();
    }

    public final void offset(int x2, int y2) {
        this.b += x2;
        this.d += x2;
        this.c += y2;
        this.e += y2;
    }

    public final void offset(Point pos) {
        this.offset(pos.getX(), pos.getY());
    }

    public final boolean equals(Rectangle other) {
        if (other == null) {
            return false;
        }
        return Rectangle.op_Equality(this, other);
    }

    @Override
    public void CloneTo(Rectangle that) {
        that.b = this.b;
        that.c = this.c;
        that.d = this.d;
        that.e = this.e;
    }

    @Override
    public Rectangle Clone() {
        Rectangle rectangle = new Rectangle();
        this.CloneTo(rectangle);
        return rectangle;
    }

    public Object clone() {
        return this.Clone();
    }

    public boolean a() {
        return this.getHeight() > 0 && this.getWidth() > 0 && (this.getX() + this.getWidth() > 0 || this.getY() + this.getHeight() > 0);
    }

    public void normalize() {
        if (this.getWidth() < 0) {
            this.setX(this.getX() + this.getWidth());
            this.setWidth(-this.getWidth());
        }
        if (this.getHeight() < 0) {
            this.setY(this.getY() + this.getHeight());
            this.setHeight(-this.getHeight());
        }
    }
}

