/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.drawing.drawing2d;

import com.aspose.drawing.Font;
import com.aspose.drawing.FontFamily;
import com.aspose.drawing.Graphics;
import com.aspose.drawing.Pen;
import com.aspose.drawing.Point;
import com.aspose.drawing.PointF;
import com.aspose.drawing.Rectangle;
import com.aspose.drawing.RectangleF;
import com.aspose.drawing.StringFormat;
import com.aspose.drawing.drawing2d.Matrix;
import com.aspose.drawing.drawing2d.PathData;
import com.aspose.drawing.drawing2d.a;
import com.aspose.drawing.internal.Exceptions.ArgumentException;
import com.aspose.drawing.internal.Exceptions.ArgumentNullException;
import com.aspose.drawing.internal.Exceptions.InvalidOperationException;
import com.aspose.drawing.internal.Exceptions.NotImplementedException;
import com.aspose.drawing.internal.db.x;
import com.aspose.drawing.internal.dn.U;
import com.aspose.drawing.internal.dn.au;
import com.aspose.drawing.internal.dn.bO;
import com.aspose.drawing.internal.dn.do;
import com.aspose.drawing.internal.hX.aq;
import com.aspose.drawing.internal.hX.bD;
import com.aspose.drawing.internal.hX.g;
import com.aspose.drawing.internal.hi.aR;
import com.aspose.drawing.internal.hi.dV;
import com.aspose.drawing.internal.hi.ef;
import com.aspose.drawing.internal.hi.fD;
import com.aspose.drawing.internal.hi.fp;
import com.aspose.drawing.internal.jt.d;
import com.aspose.drawing.system.collections.Generic.List;

public class GraphicsPath
implements aq {
    private final List<x> a = new List();
    private ef b;
    private boolean c;

    public GraphicsPath() {
        this.b = new ef();
        this.b.a(1);
        this.c = true;
    }

    public GraphicsPath(int fillMode) {
        this.b = new ef();
        this.b.a(GraphicsPath.a(fillMode));
        this.c = true;
    }

    public GraphicsPath(PointF[] pts, byte[] types) {
        this(pts, types, 0);
    }

    public GraphicsPath(Point[] pts, byte[] types) {
        this(pts, types, 0);
    }

    public GraphicsPath(PointF[] pts, byte[] types, int fillMode) {
        if (pts == null || types == null) {
            throw new ArgumentNullException();
        }
        if (pts.length != types.length) {
            throw new ArgumentException("Length mismatch");
        }
        this.b = new ef();
        this.b.a(GraphicsPath.a(fillMode));
        au.a(this.b, pts, types);
    }

    public GraphicsPath(Point[] pts, byte[] types, int fillMode) {
        if (pts == null || types == null) {
            throw new ArgumentNullException();
        }
        if (pts.length != types.length) {
            throw new ArgumentException("Length mismatch");
        }
        this.b = new ef();
        this.b.a(GraphicsPath.a(fillMode));
        au.a(this.b, pts, types);
    }

    GraphicsPath(ef internalPath) {
        this.b = internalPath;
        this.c = true;
    }

    public static GraphicsPath a(ef ef2) {
        return new GraphicsPath(ef2);
    }

    public final int getFillMode() {
        switch (this.b.e()) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
        }
        throw new InvalidOperationException("Unsupported FillMode.");
    }

    public final void setFillMode(int value) {
        this.b.a(GraphicsPath.a(value));
    }

    public final PathData getPathData() {
        PathData pathData = new PathData();
        pathData.setPoints(this.b.i() == 0 ? (PointF[])g.a(g.a(d.a(PointF.class), 0)) : this.getPathPoints());
        pathData.setTypes(this.b.i() == 0 ? new byte[]{} : this.getPathTypes());
        return pathData;
    }

    public final int getPointCount() {
        return this.b.i() + au.a(this.b, 2);
    }

    public final byte[] getPathTypes() {
        if (this.b.i() == 0) {
            throw new ArgumentException();
        }
        byte[] byArray = new byte[this.getPointCount()];
        int n2 = 0;
        ef.e e2 = new ef.e(this.b);
        int n3 = e2.a();
        while (n3 != 6) {
            switch (n3) {
                case 0: {
                    byArray[n2++] = 0;
                    break;
                }
                case 1: {
                    byArray[n2++] = 1;
                    break;
                }
                case 3: {
                    throw new ArgumentException();
                }
                case 2: 
                case 4: {
                    byArray[n2++] = 3;
                    byArray[n2++] = 3;
                    byArray[n2++] = 3;
                    break;
                }
                case 5: {
                    if (n2 <= 0) break;
                    byArray[n2 - 1] = (byte)(byArray[n2 - 1] & 0xFF | 0x80);
                }
            }
            n3 = e2.a();
        }
        return byArray;
    }

    public final PointF[] getPathPoints() {
        PointF[] pointFArray;
        if (this.b.i() == 0) {
            throw new ArgumentException();
        }
        fp[] fpArray = this.b.j();
        int n2 = fpArray.length;
        int n3 = au.a(this.b, 2);
        if (n3 == 0) {
            pointFArray = new PointF[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                pointFArray[i2] = U.a(fpArray[i2].h());
            }
        } else {
            pointFArray = (PointF[])g.a(g.a(d.a(PointF.class), n2 += n3));
            int n4 = 0;
            int n5 = 0;
            ef.e e2 = new ef.e(this.b);
            int n6 = e2.a();
            while (n6 != 6) {
                switch (n6) {
                    case 0: 
                    case 1: {
                        U.a(fpArray[n4++]).CloneTo(pointFArray[n5++]);
                        break;
                    }
                    case 3: {
                        throw new ArgumentException();
                    }
                    case 2: {
                        PointF[] pointFArray2 = au.a(new PointF[]{pointFArray[n5 - 1], U.a(fpArray[n4++]), U.a(fpArray[n4++])});
                        pointFArray2[1].CloneTo(pointFArray[n5++]);
                        pointFArray2[2].CloneTo(pointFArray[n5++]);
                        pointFArray2[3].CloneTo(pointFArray[n5++]);
                        break;
                    }
                    case 4: {
                        U.a(fpArray[n4++]).CloneTo(pointFArray[n5++]);
                        U.a(fpArray[n4++]).CloneTo(pointFArray[n5++]);
                        U.a(fpArray[n4++]).CloneTo(pointFArray[n5++]);
                    }
                }
                n6 = e2.a();
            }
        }
        return pointFArray;
    }

    public final ef a() {
        return this.b;
    }

    @Override
    public final void dispose() {
    }

    public final Object deepClone() {
        GraphicsPath graphicsPath = new GraphicsPath();
        graphicsPath.b.b(this.b);
        return graphicsPath;
    }

    public final void addArc(RectangleF rect, float startAngle, float sweepAngle) {
        this.b.a(U.a(rect), startAngle, sweepAngle, this.c, false);
        this.c = false;
    }

    public final void addArc(float x2, float y2, float width, float height, float startAngle, float sweepAngle) {
        this.addArc(new RectangleF(x2, y2, width, height), startAngle, sweepAngle);
    }

    public final void addBezier(PointF pt1, PointF pt2, PointF pt3, PointF pt4) {
        this.addBezier(pt1.getX(), pt1.getY(), pt2.getX(), pt2.getY(), pt3.getX(), pt3.getY(), pt4.getX(), pt4.getY());
    }

    public final void addBezier(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        if (this.c) {
            this.b.a(x1, y1);
        } else {
            this.b.b(x1, y1);
        }
        this.b.a(x2, y2, x3, y3, x4, y4);
        this.c = false;
    }

    public final void addBeziers(Point[] points) {
        if (points == null) {
            throw new ArgumentNullException("points");
        }
        PointF[] pointFArray = (PointF[])g.a(g.a(d.a(PointF.class), points.length));
        for (int i2 = 0; i2 < points.length; ++i2) {
            Point.to_PointF(points[i2]).CloneTo(pointFArray[i2]);
        }
        this.addBeziers(pointFArray);
    }

    public final void addBeziers(PointF[] points) {
        if (points == null) {
            throw new ArgumentNullException("points");
        }
        if (points.length < 4 || (points.length - 4) % 3 != 0) {
            throw new ArgumentException("Parameter is not valid.");
        }
        PointF pointF = points[0];
        for (int i2 = 1; i2 < points.length; i2 += 3) {
            this.addBezier(pointF, points[i2], points[i2 + 1], points[i2 + 2]);
            points[i2 + 2].CloneTo(pointF);
        }
    }

    public final void addClosedCurve(PointF[] points) {
        this.addClosedCurve(points, 0.5f);
    }

    public final void addClosedCurve(PointF[] points, float tension) {
        aR.b(this.b, U.a(points), tension);
        this.c = true;
    }

    public final void addCurve(Point[] points) {
        if (points == null) {
            throw new ArgumentNullException("points");
        }
        PointF[] pointFArray = (PointF[])g.a(g.a(d.a(PointF.class), points.length));
        for (int i2 = 0; i2 < points.length; ++i2) {
            Point.to_PointF(points[i2]).CloneTo(pointFArray[i2]);
        }
        this.addCurve(pointFArray);
    }

    public final void addCurve(PointF[] points) {
        this.addCurve(points, 0.5f);
    }

    public final void addCurve(PointF[] points, float tension) {
        aR.a(this.b, U.a(points), tension, this.c);
        this.c = false;
    }

    public final void addCurve(PointF[] points, int offset, int numberOfSegments, float tension) {
        if (points == null) {
            throw new ArgumentNullException("points");
        }
        if (points.length < 2 || offset < 0 || numberOfSegments <= 0 || offset + numberOfSegments >= points.length) {
            throw new ArgumentException("Parameter is not valid.");
        }
        fp[] fpArray = U.a(points);
        aR.a(this.b, fpArray, offset, numberOfSegments, tension);
    }

    public final void addEllipse(RectangleF rect) {
        this.b.b(U.a(rect));
        this.c = true;
    }

    public final void addEllipse(float x2, float y2, float width, float height) {
        this.addEllipse(new RectangleF(x2, y2, width, height));
    }

    public final void addLine(PointF pt1, PointF pt2) {
        this.addLine(pt1.getX(), pt1.getY(), pt2.getX(), pt2.getY());
    }

    public final void addLine(float x1, float y1, float x2, float y2) {
        if (this.c) {
            this.b.a(x1, y1);
        } else {
            fp fp2 = new fp();
            fp[] fpArray = new fp[]{fp2};
            boolean bl2 = !this.b.a(fpArray) || fpArray[0].a != x1 || fpArray[0].b != y1;
            fpArray[0].e(fp2);
            if (bl2) {
                this.b.b(x1, y1);
            }
        }
        this.b.b(x2, y2);
        this.c = false;
    }

    public final void addLines(PointF[] points) {
        if (points == null) {
            throw new ArgumentNullException("points");
        }
        if (points.length == 0) {
            throw new ArgumentException("Value does not fall within the expected range.", "points");
        }
        PointF pointF = points[0];
        if (this.c) {
            this.b.a(pointF.getX(), pointF.getY());
        } else {
            this.b.b(pointF.getX(), pointF.getY());
        }
        for (int i2 = 1; i2 < points.length; ++i2) {
            PointF pointF2 = points[i2];
            this.b.b(pointF2.getX(), pointF2.getY());
        }
        this.c = false;
    }

    public final void addLines(Point[] points) {
        if (points == null) {
            throw new ArgumentNullException("points");
        }
        PointF[] pointFArray = (PointF[])g.a(g.a(d.a(PointF.class), points.length));
        for (int i2 = 0; i2 < points.length; ++i2) {
            Point.to_PointF(points[i2]).CloneTo(pointFArray[i2]);
        }
        this.addLines(pointFArray);
    }

    public final void addPath(GraphicsPath addingPath, boolean connect) {
        int n2 = connect ? 1 : 0;
        this.b.a(addingPath.a(), n2);
        this.c = false;
    }

    public final void addPie(Rectangle rect, float startAngle, float sweepAngle) {
        this.addPie(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), startAngle, sweepAngle);
    }

    public final void addPie(float x2, float y2, float width, float height, float startAngle, float sweepAngle) {
        fD fD2 = new fD(x2, y2, x2 + width, y2 + height);
        this.b.a(fD2, startAngle, sweepAngle, true, false);
        this.b.b(fD2.a(), fD2.b());
        this.b.o();
        this.c = true;
    }

    public final void addPolygon(PointF[] points) {
        if (points == null) {
            throw new ArgumentNullException("points");
        }
        if (points.length < 2) {
            return;
        }
        this.b.a(points[0].getX(), points[0].getY());
        for (int i2 = 1; i2 < points.length; ++i2) {
            this.b.b(points[i2].getX(), points[i2].getY());
        }
        this.b.o();
        this.c = true;
    }

    public final void addPolygon(Point[] points) {
        if (points == null) {
            throw new ArgumentNullException("points");
        }
        PointF[] pointFArray = (PointF[])g.a(g.a(d.a(PointF.class), points.length));
        for (int i2 = 0; i2 < points.length; ++i2) {
            Point.to_PointF(points[i2]).CloneTo(pointFArray[i2]);
        }
        this.addPolygon(pointFArray);
    }

    public final void addRectangle(Rectangle rect) {
        this.b.b(rect.getLeft(), rect.getTop(), rect.getRight(), rect.getBottom());
    }

    public final void addRectangle(RectangleF rect) {
        this.b.b(rect.getLeft(), rect.getTop(), rect.getRight(), rect.getBottom());
    }

    public final void addRectangles(RectangleF[] rects) {
        if (rects == null) {
            throw new ArgumentNullException("rects");
        }
        for (RectangleF rectangleF : rects) {
            this.addRectangle(rectangleF);
        }
    }

    public final void addRectangles(Rectangle[] rects) {
        if (rects == null) {
            throw new ArgumentNullException("rects");
        }
        for (Rectangle rectangle : rects) {
            this.addRectangle(rectangle);
        }
    }

    public final void addString(String s2, FontFamily family, int style, float emSize, Point origin, StringFormat format) {
        this.addString(s2, family, style, emSize, Point.to_PointF(origin), format);
    }

    public final void addString(String s2, FontFamily family, int style, float emSize, PointF origin, StringFormat format) {
        this.addString(s2, family, style, emSize, new RectangleF(origin.getX(), origin.getY(), 0.0f, 0.0f), format);
    }

    public final void addString(String s2, FontFamily family, int style, float emSize, Rectangle layoutRect, StringFormat format) {
        this.addString(s2, family, style, emSize, RectangleF.to_RectangleF(layoutRect), format);
    }

    public final void addString(String s2, FontFamily family, int style, float emSize, RectangleF layoutRect, StringFormat format) {
        if (format == null) {
            format = StringFormat.getGenericDefault();
        }
        dV dV2 = new dV();
        bO.a(format, 2, 96.0f, dV2);
        bO.a(s2, new Font(family, emSize, style, 2), 2, 96.0f, dV2);
        dV2.c(false);
        dV2.o().a(true);
        this.b.c(dV2.a(s2, dV2.a(U.a(layoutRect), null, null)));
    }

    public final void startFigure() {
        this.c = true;
    }

    public final void closeFigure() {
        this.b.o();
        this.c = true;
    }

    public final void transform(Matrix matrix) {
        ef ef2 = new ef();
        this.b.a(matrix.a(), ef2);
        this.b = ef2;
    }

    public final RectangleF getBounds() {
        return this.getBounds(null);
    }

    public final RectangleF getBounds(Matrix matrix) {
        return this.getBounds(matrix, null);
    }

    public final RectangleF getBounds(Matrix matrix, Pen pen) {
        Object object;
        if (pen == null) {
            if (matrix == null) {
                fD fD2 = this.b.p();
                return new RectangleF(fD2.b, fD2.c, fD2.c(), fD2.d());
            }
            GraphicsPath graphicsPath = new GraphicsPath(this.b);
            graphicsPath.transform(matrix);
            fD fD3 = graphicsPath.b.p();
            return new RectangleF(fD3.b, fD3.c, fD3.c(), fD3.d());
        }
        dV dV2 = new dV();
        bO.a(pen, dV2);
        Object object2 = new ef();
        dV2.a(this.b, (ef)object2);
        if (matrix != null) {
            object = new ef();
            ((ef)object2).a(matrix.a(), (ef)object);
            object2 = object;
        }
        object = ((ef)object2).p();
        return new RectangleF(((fD)object).b, ((fD)object).c, ((fD)object).c(), ((fD)object).d());
    }

    public final PointF getLastPoint() {
        fp fp2 = new fp();
        fp[] fpArray = new fp[]{fp2};
        this.b.a(fpArray);
        fpArray[0].e(fp2);
        return new PointF(fp2.a, fp2.b);
    }

    public final void flatten() {
        this.flatten(null);
    }

    public final void flatten(Matrix matrix) {
        this.flatten(matrix, 0.25f);
    }

    public final void flatten(Matrix matrix, float flatness) {
        if (matrix != null) {
            this.transform(matrix);
        }
        List<fp> list = new List<fp>(g.a(this.b.j()));
        ef ef2 = new ef();
        int n2 = 0;
        block8: for (int i2 = 0; i2 < this.b.g(); ++i2) {
            int n3 = this.b.h()[i2];
            switch (n3) {
                case 0: {
                    ef2.a(list.get_Item(n2));
                    ++n2;
                    continue block8;
                }
                case 1: {
                    ef2.b(list.get_Item(n2));
                    ++n2;
                    continue block8;
                }
                case 2: 
                case 4: {
                    int n4 = n3 == 2 ? 2 : 3;
                    int n5 = n4 + 1;
                    fp[] fpArray = (fp[])g.a(g.a(d.a(fp.class), n5));
                    list.copyTo(n2 - 1, (fp[])fpArray, 0, n5);
                    n2 += n4;
                    this.a(flatness, ef2, n3, fpArray);
                    continue block8;
                }
                case 3: {
                    throw new NotImplementedException();
                }
                case 5: {
                    ef2.o();
                    continue block8;
                }
                case 6: {
                    continue block8;
                }
                default: {
                    throw new InvalidOperationException("Unexpected verb.");
                }
            }
        }
        this.b.b(ef2);
    }

    public final void widen(Pen pen) {
        this.widen(pen, null);
    }

    public final void widen(Pen pen, Matrix matrix) {
        this.widen(pen, matrix, 0.25f);
    }

    public final void widen(Pen pen, Matrix matrix, float flatness) {
        if (matrix != null) {
            this.transform(matrix);
        }
        dV dV2 = new dV();
        bO.a(pen, dV2);
        ef ef2 = new ef();
        dV2.a(this.b, ef2);
        this.b.b(ef2);
    }

    public final void closeAllFigures() {
        this.b.r();
        this.startFigure();
    }

    public final void reset() {
        this.b.m();
    }

    public final void reverse() {
        ef ef2 = new ef();
        ef2.e(this.b);
        this.b = ef2;
    }

    public final void setMarkers() {
        do.b("GraphicsPath.SetMarkers()");
    }

    public final boolean isOutlineVisible(PointF point, Pen pen) {
        GraphicsPath graphicsPath = (GraphicsPath)this.deepClone();
        graphicsPath.widen(pen);
        return graphicsPath.isVisible(point);
    }

    public final boolean isVisible(float x2, float y2) {
        return this.b.d(x2, y2);
    }

    public final boolean isVisible(float x2, float y2, Graphics graphics) {
        return this.b.d(x2, y2);
    }

    public final boolean isVisible(int x2, int y2) {
        return this.b.d(x2, y2);
    }

    public final boolean isVisible(int x2, int y2, Graphics graphics) {
        return this.b.d(x2, y2);
    }

    public final boolean isVisible(Point point) {
        return this.b.d(point.getX(), point.getY());
    }

    public final boolean isVisible(Point point, Graphics graphics) {
        return this.b.d(point.getX(), point.getY());
    }

    public final boolean isVisible(PointF point) {
        return this.b.d(point.getX(), point.getY());
    }

    public final boolean isVisible(PointF point, Graphics graphics) {
        return this.b.d(point.getX(), point.getY());
    }

    public final void warp(PointF[] destPoints, RectangleF srcRect) {
        this.warp(destPoints, srcRect, null);
    }

    public final void warp(PointF[] destPoints, RectangleF srcRect, Matrix matrix) {
        this.warp(destPoints, srcRect, matrix, 0);
    }

    public final void warp(PointF[] destPoints, RectangleF srcRect, Matrix matrix, int warpMode) {
        this.warp(destPoints, srcRect, matrix, warpMode, 0.25f);
    }

    public final void warp(PointF[] destPoints, RectangleF srcRect, Matrix matrix, int warpMode, float flatness) {
        do.b("GraphicsPath.Warp(PointF[] destPoints, RectangleF srcRect, Matrix matrix, WarpMode warpMode, float flatness)");
        throw new NotImplementedException();
    }

    public static int a(int n2) {
        switch (n2) {
            case 1: {
                return 0;
            }
            case 0: {
                return 1;
            }
        }
        throw new ArgumentException("Unknown FillMode.");
    }

    private double a(float f2, ef ef2) {
        double d2;
        double d3 = 500.0;
        fD fD2 = ef2.p();
        double d4 = bD.s(fD2.c() * fD2.c() + fD2.d() * fD2.d());
        double d5 = d4 / 500.0;
        if (d5 < 0.3) {
            d5 = Math.sqrt(d5);
        }
        if (f2 < 1.0f) {
            f2 = bD.a(1.0E-6f, f2);
            d2 = bD.f(1.03 - (double)f2, 11.0) * 16.0 * bD.f(d5, 1.1) + 0.3 * bD.f(d5 * 1.8, 1.1);
        } else {
            f2 = bD.b(f2, 100.0f);
            d2 = bD.f(101.0 - (double)f2, 6.0) * 7.0E-13 * bD.f(d5, 1.1) + 0.01 * bD.f(d5 * 1.8, 1.1);
        }
        return d2;
    }

    private void a(float f2, ef ef2, int n2, fp[] fpArray) {
        ef ef3 = new ef();
        ef3.a(fpArray[0]);
        switch (n2) {
            case 2: {
                ef3.b(fpArray[1], fpArray[2]);
                break;
            }
            case 4: {
                ef3.a(fpArray[1], fpArray[2], fpArray[3]);
                break;
            }
            default: {
                throw new InvalidOperationException("Unexpected verb.");
            }
        }
        double d2 = this.a(f2, ef3);
        ef3.a(d2);
        fp[] fpArray2 = ef3.j();
        for (int i2 = 1; i2 < fpArray2.length; ++i2) {
            ef2.b(fpArray2[i2]);
        }
    }

    public void a(x x2) {
        if (x2 == null) {
            throw new ArgumentNullException("figure");
        }
        this.a.addItem(x2);
    }

    public x[] getFigures() {
        return this.a.toArray((x[])new x[0]);
    }

    public RectangleF b() {
        return this.getBounds(null, null);
    }

    static {
        d.a(Point.class, new a());
    }
}

