/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.email;

import com.aspose.email.EmlLoadOptions;
import com.aspose.email.FolderInfo;
import com.aspose.email.MailMessage;
import com.aspose.email.MapiConversionOptions;
import com.aspose.email.MapiMessage;
import com.aspose.email.MboxLoadOptions;
import com.aspose.email.MboxStorageReader;
import com.aspose.email.MboxToPstConversionOptions;
import com.aspose.email.MboxrdStorageReader;
import com.aspose.email.PersonalStorage;
import com.aspose.email.internal.b.zax;
import com.aspose.email.internal.ht.za;
import com.aspose.email.system.AsyncCallback;
import com.aspose.email.system.IAsyncResult;
import com.aspose.email.system.MulticastDelegate;
import com.aspose.email.system.exceptions.ArgumentException;
import com.aspose.email.system.exceptions.ArgumentNullException;
import com.aspose.email.system.io.FileStream;
import com.aspose.email.system.io.Stream;
import com.aspose.email.zald;
import com.aspose.email.zbnn;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MailStorageConverter {
    private static EmlLoadOptions a = new EmlLoadOptions();

    public static EmlLoadOptions getMboxMessageOptions() {
        return a;
    }

    public static void setMboxMessageOptions(EmlLoadOptions value) {
        a = value;
    }

    public static PersonalStorage mboxToPst(String mboxFileName, String pstFileName) {
        return MailStorageConverter.mboxToPst(mboxFileName, pstFileName, new MboxToPstConversionOptions());
    }

    public static PersonalStorage mboxToPst(String mboxFileName, String pstFileName, MailHandler mailHandler) {
        if (zax.a(mboxFileName)) {
            throw new ArgumentException(zbnn.a(new byte[]{-96, -43, 4, 119, -24, -58, -92, 51, 8, -83, -32, -75, -74, 112, 50, 124, -23, -42, -47, 69, -51, -43, 14, 47, -90, -43, -95, 51, 77, -30, -4, -12, -66, 120, 98, 107, -15}), zbnn.a(new byte[]{-128, -43, 4, 119, -114, -55, -95, 58, 35, -20, -29, -79}));
        }
        return MailStorageConverter.a(new FileStream(mboxFileName, 3, 1), pstFileName, mailHandler);
    }

    public static PersonalStorage mboxToPst(InputStream mboxrdDataStream, String pstFileName) {
        return MailStorageConverter.a(Stream.fromJava(mboxrdDataStream), pstFileName);
    }

    static PersonalStorage a(Stream stream, String string) {
        return MailStorageConverter.a(stream, string, null);
    }

    public static PersonalStorage mboxToPst(InputStream mboxrdDataStream, String pstFileName, MailHandler mailHandler) {
        return MailStorageConverter.a(Stream.fromJava(mboxrdDataStream), pstFileName, mailHandler);
    }

    static PersonalStorage a(Stream stream, String string, MailHandler mailHandler) {
        if (zax.a(string)) {
            throw new ArgumentException(zbnn.a(new byte[]{-67, -60, 31, 47, -82, -55, -95, 58, 77, -29, -17, -71, -66, 53, 113, 126, -26, -97, -126, 17, -113, -46, 75, 97, -67, -52, -95, 127, 2, -1, -82, -79, -74, 101, 102, 102}), zbnn.a(new byte[]{-99, -60, 31, 73, -95, -52, -88, 17, 12, -32, -21}));
        }
        return MailStorageConverter.mboxToPst(stream, (Stream)new FileStream(string, 2, 3), mailHandler);
    }

    public static PersonalStorage mboxToPst(String mboxFileName, OutputStream pstDataStream) {
        return MailStorageConverter.mboxToPst(mboxFileName, pstDataStream, null);
    }

    public static PersonalStorage mboxToPst(String mboxFileName, Stream pstDataStream) {
        return MailStorageConverter.mboxToPst(mboxFileName, pstDataStream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PersonalStorage mboxToPst(String mboxFileName, OutputStream pstDataStream, MailHandler mailHandler) {
        PersonalStorage personalStorage;
        FileInputStream fileInputStream = new FileInputStream(mboxFileName);
        try {
            personalStorage = MailStorageConverter.mboxToPst((InputStream)fileInputStream, pstDataStream, mailHandler);
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)fileInputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }
        ((InputStream)fileInputStream).close();
        return personalStorage;
    }

    public static PersonalStorage mboxToPst(String mboxFileName, Stream pstDataStream, MailHandler mailHandler) {
        if (zax.a(mboxFileName)) {
            throw new ArgumentException(zbnn.a(new byte[]{-96, -43, 4, 119, -24, -58, -92, 51, 8, -83, -32, -75, -74, 112, 50, 124, -23, -42, -47, 69, -51, -43, 14, 47, -90, -43, -95, 51, 77, -30, -4, -12, -66, 120, 98, 107, -15}), zbnn.a(new byte[]{-128, -43, 4, 119, -114, -55, -95, 58, 35, -20, -29, -79}));
        }
        return MailStorageConverter.mboxToPst((Stream)new FileStream(mboxFileName, 3, 1), pstDataStream, mailHandler);
    }

    public static PersonalStorage mboxToPst(InputStream mboxrdDataStream, OutputStream pstDataStream) {
        return MailStorageConverter.mboxToPst(mboxrdDataStream, pstDataStream, new MboxToPstConversionOptions());
    }

    public static PersonalStorage mboxToPst(Stream mboxrdDataStream, Stream pstDataStream) {
        return MailStorageConverter.mboxToPst(mboxrdDataStream, pstDataStream, new MboxToPstConversionOptions());
    }

    public static PersonalStorage mboxToPst(InputStream mboxrdDataStream, OutputStream pstDataStream, MailHandler mailHandler) {
        MboxToPstConversionOptions mboxToPstConversionOptions = new MboxToPstConversionOptions();
        mboxToPstConversionOptions.setMessageHandler(mailHandler);
        return MailStorageConverter.mboxToPst(mboxrdDataStream, pstDataStream, mboxToPstConversionOptions);
    }

    public static PersonalStorage mboxToPst(Stream mboxrdDataStream, Stream pstDataStream, MailHandler mailHandler) {
        MboxToPstConversionOptions mboxToPstConversionOptions = new MboxToPstConversionOptions();
        mboxToPstConversionOptions.setMessageHandler(mailHandler);
        return MailStorageConverter.mboxToPst(mboxrdDataStream, pstDataStream, mboxToPstConversionOptions);
    }

    public static void mboxToPst(MboxStorageReader mboxStorageReader, PersonalStorage pst, String pstFolderName, MailHandler mailHandler) {
        MboxToPstConversionOptions mboxToPstConversionOptions = new MboxToPstConversionOptions();
        mboxToPstConversionOptions.setMessageHandler(mailHandler);
        MailStorageConverter.mboxToPst(mboxStorageReader, pst, pstFolderName, mboxToPstConversionOptions);
    }

    public static PersonalStorage mboxToPst(String mboxFileName, String pstFileName, MboxToPstConversionOptions options) {
        if (zax.a(mboxFileName)) {
            throw new ArgumentException(zbnn.a(new byte[]{-96, -43, 4, 119, -24, -58, -92, 51, 8, -83, -32, -75, -74, 112, 50, 124, -23, -42, -47, 69, -51, -43, 14, 47, -90, -43, -95, 51, 77, -30, -4, -12, -66, 120, 98, 107, -15}), zbnn.a(new byte[]{-128, -43, 4, 119, -114, -55, -95, 58, 35, -20, -29, -79}));
        }
        if (zax.a(pstFileName)) {
            throw new ArgumentException(zbnn.a(new byte[]{-67, -60, 31, 47, -82, -55, -95, 58, 77, -29, -17, -71, -66, 53, 113, 126, -26, -97, -126, 17, -113, -46, 75, 97, -67, -52, -95, 127, 2, -1, -82, -79, -74, 101, 102, 102}), zbnn.a(new byte[]{-99, -60, 31, 73, -95, -52, -88, 17, 12, -32, -21}));
        }
        return MailStorageConverter.mboxToPst((Stream)new FileStream(mboxFileName, 3, 1), (Stream)new FileStream(pstFileName, 2, 3), options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PersonalStorage mboxToPst(InputStream mboxrdDataStream, OutputStream pstDataStream, MboxToPstConversionOptions options) {
        if (mboxrdDataStream == null) {
            throw new ArgumentNullException(zbnn.a(new byte[]{-128, -43, 4, 119, -70, -60, -119, 62, 25, -20, -35, -96, -87, 112, 115, 114}));
        }
        if (pstDataStream == null) {
            throw new ArgumentNullException(zbnn.a(new byte[]{-99, -60, 31, 75, -87, -44, -84, 12, 25, -1, -21, -75, -74}));
        }
        PersonalStorage personalStorage = PersonalStorage.create(pstDataStream, 0);
        MboxLoadOptions mboxLoadOptions = new MboxLoadOptions();
        mboxLoadOptions.setLeaveOpen(false);
        MboxrdStorageReader mboxrdStorageReader = new MboxrdStorageReader(mboxrdDataStream, mboxLoadOptions);
        try {
            MailStorageConverter.mboxToPst((MboxStorageReader)mboxrdStorageReader, personalStorage, zbnn.a(new byte[]{-92, -39, 9, 96, -80}), options);
        }
        finally {
            if (mboxrdStorageReader != null) {
                mboxrdStorageReader.dispose();
            }
        }
        return personalStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PersonalStorage mboxToPst(Stream mboxrdDataStream, Stream pstDataStream, MboxToPstConversionOptions options) {
        if (mboxrdDataStream == null) {
            throw new ArgumentNullException(zbnn.a(new byte[]{-128, -43, 4, 119, -70, -60, -119, 62, 25, -20, -35, -96, -87, 112, 115, 114}));
        }
        if (pstDataStream == null) {
            throw new ArgumentNullException(zbnn.a(new byte[]{-99, -60, 31, 75, -87, -44, -84, 12, 25, -1, -21, -75, -74}));
        }
        PersonalStorage personalStorage = PersonalStorage.a(pstDataStream, 0);
        MboxLoadOptions mboxLoadOptions = new MboxLoadOptions();
        mboxLoadOptions.setLeaveOpen(false);
        MboxrdStorageReader mboxrdStorageReader = new MboxrdStorageReader(mboxrdDataStream, mboxLoadOptions);
        try {
            MailStorageConverter.mboxToPst((MboxStorageReader)mboxrdStorageReader, personalStorage, zbnn.a(new byte[]{-92, -39, 9, 96, -80}), options);
        }
        finally {
            if (mboxrdStorageReader != null) {
                mboxrdStorageReader.dispose();
            }
        }
        return personalStorage;
    }

    public static void mboxToPst(MboxStorageReader mboxStorageReader, PersonalStorage pst, String pstFolderName, MboxToPstConversionOptions options) {
        MailMessage mailMessage;
        if (mboxStorageReader == null) {
            throw new ArgumentNullException(zbnn.a(new byte[]{-128, -43, 4, 119, -101, -44, -94, 45, 12, -22, -21, -122, -66, 116, 118, 122, -6}));
        }
        if (pst == null) {
            throw new ArgumentNullException(zbnn.a(new byte[]{-99, -60, 31}));
        }
        FolderInfo folderInfo = pst.getRootFolder().getSubFolder(pstFolderName);
        if (folderInfo == null) {
            folderInfo = pst.getRootFolder().addSubFolder(pstFolderName);
        }
        while ((mailMessage = mboxStorageReader.readNextMessage(MailStorageConverter.getMboxMessageOptions())) != null) {
            if (options.getMessageHandler() != null) {
                options.getMessageHandler().invoke(mailMessage);
            }
            MapiConversionOptions mapiConversionOptions = MapiConversionOptions.getUnicodeFormat();
            mapiConversionOptions.setRemoveSignature(options != null ? options.getRemoveSignature() : false);
            folderInfo.addMessage(MapiMessage.fromMailMessage(mailMessage, mapiConversionOptions));
        }
    }

    public static abstract class MailHandler
    extends MulticastDelegate {
        public abstract void invoke(MailMessage var1);

        public final IAsyncResult beginInvoke(MailMessage message, AsyncCallback callback, Object state) {
            return za.a(new zald(this, this, callback, state, message));
        }

        public final void endInvoke(IAsyncResult result) {
            za.a(this, result);
        }
    }
}

