/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.email.system.collections.generic;

import com.aspose.email.internal.b.zai;
import com.aspose.email.internal.b.zak;
import com.aspose.email.internal.b.zau;
import com.aspose.email.internal.b.zbj;
import com.aspose.email.system.Action;
import com.aspose.email.system.Array;
import com.aspose.email.system.Comparison;
import com.aspose.email.system.Converter;
import com.aspose.email.system.IDisposable;
import com.aspose.email.system.Predicate;
import com.aspose.email.system.Struct;
import com.aspose.email.system.collections.generic.IGenericEnumerable;
import com.aspose.email.system.collections.generic.IGenericEnumerator;
import com.aspose.email.system.collections.generic.IGenericList;
import com.aspose.email.system.collections.generic.zd;
import com.aspose.email.system.collections.generic.ze;
import com.aspose.email.system.exceptions.ArgumentException;
import com.aspose.email.system.exceptions.ArgumentNullException;
import com.aspose.email.system.exceptions.ArgumentOutOfRangeException;
import com.aspose.email.system.exceptions.InvalidOperationException;
import com.aspose.email.system.exceptions.NotImplementedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

@zau
public class List<T>
implements IGenericList<T>,
java.util.List<T> {
    private Object[] b;
    private int c;
    private int d;
    @zai
    private final Object e = new Object();
    static Object[] a = new Object[0];

    public List() {
        this.b = a;
    }

    public List(IGenericEnumerable<T> collection) {
        this((Iterable<T>)collection);
    }

    public List(Iterable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.b = a;
        this.a(collection);
    }

    public List(int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: capacity");
        }
        this.b = new Object[capacity];
    }

    public List(T[] data) {
        this.c = data.length;
        this.b = Arrays.copyOf(data, this.c);
    }

    private List(T[] data, int size) {
        this.b = data;
        this.c = size;
    }

    public static List<Byte> fromPrimitiveArray(byte[] data) {
        return List.a(data);
    }

    public static List<Short> fromPrimitiveArray(short[] data) {
        return List.a(data);
    }

    public static List<Integer> fromPrimitiveArray(int[] data) {
        return List.a(data);
    }

    public static List<Long> fromPrimitiveArray(long[] data) {
        return List.a(data);
    }

    public static List<Float> fromPrimitiveArray(float[] data) {
        return List.a(data);
    }

    public static List<Double> fromPrimitiveArray(double[] data) {
        return List.a(data);
    }

    public static List<Boolean> fromPrimitiveArray(boolean[] data) {
        return List.a(data);
    }

    public static List<Character> fromPrimitiveArray(char[] data) {
        return List.a(data);
    }

    private static <T, TAr> List<T> a(TAr TAr) {
        if (TAr == null) {
            throw new ArgumentNullException("data can`t be null");
        }
        int n = java.lang.reflect.Array.getLength(TAr);
        List<Object> list = new List<Object>(n);
        for (int i = 0; i < n; ++i) {
            list.addItem(java.lang.reflect.Array.get(TAr, i));
        }
        return list;
    }

    protected int getVersion() {
        return this.d;
    }

    @Override
    public void addItem(T item) {
        if (this.c == this.b.length) {
            this.a(1);
        }
        this.b[this.c++] = item;
        ++this.d;
    }

    private void a(int n) {
        int n2 = this.c + n;
        if (n2 > this.b.length) {
            this.setCapacity(Math.max(Math.max(this.getCapacity() * 2, 4), n2));
        }
    }

    private void a(int n, int n2) {
        if (n < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: count");
        }
        if (((long)n & 0xFFFFFFFFL) + ((long)n2 & 0xFFFFFFFFL) > ((long)this.c & 0xFFFFFFFFL)) {
            throw new ArgumentException("index and count exceed length of list");
        }
    }

    private void a(Iterable<T> iterable) {
        for (T t : iterable) {
            this.addItem(t);
        }
    }

    public void addRange(Iterable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.a(new List<T>(collection));
        ++this.d;
    }

    public void addRange(T[] collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        for (T t : collection) {
            this.addItem(t);
        }
        ++this.d;
    }

    public com.aspose.email.internal.e.zb<T> asReadOnly() {
        return new com.aspose.email.internal.e.zb(this);
    }

    public int binarySearch(T item) {
        return zbj.a(this.b, 0, this.c, item);
    }

    public int binarySearch(T item, Comparator<T> comparer) {
        return zbj.a(this.b, 0, this.c, item, comparer);
    }

    public int binarySearch(int index, int count, T item, Comparator<T> comparer) {
        this.a(index, count);
        return zbj.a(this.b, index, count, item, comparer);
    }

    @Override
    public void clear() {
        Array.clear(this.b, 0, this.b.length);
        this.c = 0;
        ++this.d;
    }

    public <TOutput> List<TOutput> convertAll(Converter<T, TOutput> converter) {
        if (converter == null) {
            throw new ArgumentNullException("converter");
        }
        List<T> list = new List<T>(this.c);
        for (int i = 0; i < this.c; ++i) {
            list.b[i] = converter.invoke(this.b[i]);
        }
        list.c = this.c;
        return list;
    }

    public void copyTo(T[] array) {
        Array.copy(this.b, 0, array, 0, this.c);
    }

    @Override
    public void copyToTArray(T[] array, int arrayIndex) {
        Array.copy(this.b, 0, array, arrayIndex, this.c);
    }

    public void copyTo(int index, T[] array, int arrayIndex, int count) {
        this.a(index, count);
        Array.copy(this.b, index, array, arrayIndex, count);
    }

    public boolean exists(Predicate<T> match) {
        List.a(match);
        return this.a(0, this.c, match) != -1;
    }

    public T find(Predicate<T> match) {
        List.a(match);
        int n = this.a(0, this.c, match);
        return (T)(n != -1 ? this.b[n] : null);
    }

    static <T> void a(Predicate<T> predicate) {
        if (predicate == null) {
            throw new ArgumentNullException("match");
        }
    }

    public List<T> findAll(Predicate<T> match) {
        List.a(match);
        return this.b(match);
    }

    private List<T> b(Predicate<T> predicate) {
        List<Object> list = new List<Object>();
        for (int i = 0; i < this.c; ++i) {
            if (!predicate.invoke(this.b[i])) continue;
            list.addItem(this.b[i]);
        }
        return list;
    }

    public int findIndex(Predicate<T> match) {
        List.a(match);
        return this.a(0, this.c, match);
    }

    public int findIndex(int startIndex, Predicate<T> match) {
        List.a(match);
        this.c(startIndex);
        return this.a(startIndex, this.c - startIndex, match);
    }

    public int findIndex(int startIndex, int count, Predicate<T> match) {
        List.a(match);
        this.a(startIndex, count);
        return this.a(startIndex, count, match);
    }

    private int a(int n, int n2, Predicate<T> predicate) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            if (!predicate.invoke(this.b[i])) continue;
            return i;
        }
        return -1;
    }

    public T findLast(Predicate<T> match) {
        List.a(match);
        int n = this.b(0, this.c, match);
        if (n == -1) {
            return null;
        }
        return this.get_Item(n);
    }

    public int findLastIndex(Predicate<T> match) {
        List.a(match);
        return this.b(0, this.c, match);
    }

    public int findLastIndex(int startIndex, Predicate<T> match) {
        List.a(match);
        this.c(startIndex);
        return this.b(0, startIndex + 1, match);
    }

    public int findLastIndex(int startIndex, int count, Predicate<T> match) {
        List.a(match);
        int n = startIndex - count + 1;
        this.a(n, count);
        return this.b(n, count, match);
    }

    private int b(int n, int n2, Predicate<T> predicate) {
        int n3 = n + n2;
        while (n3 != n) {
            if (!predicate.invoke(this.b[--n3])) continue;
            return n3;
        }
        return -1;
    }

    @Override
    public void forEach(Action<T> action) {
        if (action == null) {
            throw new ArgumentNullException("action");
        }
        for (int i = 0; i < this.c; ++i) {
            action.invoke(this.b[i]);
        }
    }

    @Override
    public Enumerator<T> iterator() {
        return new Enumerator(this);
    }

    @Deprecated
    public EnumeratorJava<T> iteratorJava() {
        return new EnumeratorJava(this);
    }

    public List<T> getRange(int index, int count) {
        this.a(index, count);
        Object[] objectArray = new Object[count];
        Array.copy(this.b, index, objectArray, 0, count);
        return new List<Object>(objectArray, count);
    }

    @Override
    public int indexOfItem(T item) {
        return Array.indexOf(this.b, item, 0, this.c);
    }

    public int indexOf(T item, int index) {
        this.c(index);
        return Array.indexOf(this.b, item, index, this.c - index);
    }

    public int indexOf(T item, int index, int count) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: count");
        }
        if (((long)index & 0xFFFFFFFFL) + ((long)count & 0xFFFFFFFFL) > ((long)this.c & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index and count exceed length of list");
        }
        return Array.indexOf(this.b, item, index, count);
    }

    private void b(int n, int n2) {
        if (n2 < 0) {
            n -= n2;
        }
        if (n < this.c) {
            Array.copy(this.b, n, this.b, n + n2, this.c - n);
        }
        this.c += n2;
        if (n2 < 0) {
            Array.clear(this.b, this.c, -n2);
        }
    }

    private void c(int n) {
        if (n < 0 || ((long)n & 0xFFFFFFFFL) > ((long)this.c & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
    }

    @Override
    public void insertItem(int index, T item) {
        this.c(index);
        if (this.c == this.b.length) {
            this.a(1);
        }
        this.b(index, 1);
        this.b[index] = item;
        ++this.d;
    }

    void b(int n) {
        Object[] objectArray = new Object[this.c];
        this.copyToTArray(objectArray, 0);
        this.a(this.c);
        this.b(n, objectArray.length);
        Array.copy(objectArray, 0, this.b, n, objectArray.length);
    }

    public void insertRange(int index, Iterable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.c(index);
        if (collection == this) {
            this.b(index);
        } else {
            this.a(index, collection);
        }
        ++this.d;
    }

    private void a(int n, Iterable<T> iterable) {
        for (T t : iterable) {
            this.insertItem(n++, t);
        }
    }

    @Override
    public int lastIndexOf(Object item) {
        if (this.c == 0) {
            return -1;
        }
        return zbj.a(this.b, item, this.c - 1, this.c);
    }

    public int lastIndexOf(T item, int index) {
        this.c(index);
        return zbj.a(this.b, item, index, index + 1);
    }

    public int lastIndexOf(T item, int index, int count) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index", index, "index is negative");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", count, "count is negative");
        }
        if (index - count + 1 < 0) {
            throw new ArgumentOutOfRangeException("cound", count, "count is too large");
        }
        return zbj.a(this.b, item, index, count);
    }

    @Override
    public boolean removeItem(T item) {
        int n = this.indexOfItem(item);
        if (n != -1) {
            this.removeAt(n);
        }
        return n != -1;
    }

    public int removeAll(Predicate<T> match) {
        List.a(match);
        int n = 0;
        int n2 = 0;
        for (n = 0; n < this.c && !match.invoke(this.b[n]); ++n) {
        }
        if (n == this.c) {
            return 0;
        }
        ++this.d;
        for (n2 = n + 1; n2 < this.c; ++n2) {
            if (match.invoke(this.b[n2])) continue;
            this.b[n++] = this.b[n2];
        }
        if (n2 - n > 0) {
            Array.clear(this.b, n, n2 - n);
        }
        this.c = n;
        return n2 - n;
    }

    @Override
    public void removeAt(int index) {
        if (index < 0 || ((long)index & 0xFFFFFFFFL) >= ((long)this.c & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        this.b(index, -1);
        Array.clear(this.b, this.c, 1);
        ++this.d;
    }

    public void removeRange(int index, int count) {
        this.a(index, count);
        if (count > 0) {
            this.b(index, -count);
            Array.clear(this.b, this.c, count);
            ++this.d;
        }
    }

    public void reverse() {
        zbj.a(this.b, 0, this.c);
        ++this.d;
    }

    public void reverse(int index, int count) {
        this.a(index, count);
        zbj.a(this.b, index, count);
        ++this.d;
    }

    public void sort() {
        Arrays.sort(this.b, 0, this.c);
        ++this.d;
    }

    @Override
    public void sort(Comparator<? super T> comparer) {
        Arrays.sort(this.b, 0, this.c, comparer);
        ++this.d;
    }

    @Override
    public void sort(Comparison<T> comparison) {
        if (comparison == null) {
            throw new ArgumentNullException("comparison");
        }
        Arrays.sort(this.b, 0, this.c, new zbj.za<T>(comparison));
        ++this.d;
    }

    public void sort(int index, int count, Comparator<T> comparer) {
        this.a(index, count);
        Arrays.sort(this.b, index, index + count, comparer);
        ++this.d;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.c) {
            return Arrays.copyOf(this.b, this.c, a.getClass());
        }
        System.arraycopy(this.b, 0, a, 0, this.c);
        if (a.length > this.c) {
            a[this.c] = null;
        }
        return a;
    }

    public void trimExcess() {
        this.setCapacity(this.c);
    }

    public boolean trueForAll(Predicate<T> match) {
        List.a(match);
        for (int i = 0; i < this.c; ++i) {
            if (match.invoke(this.b[i])) continue;
            return false;
        }
        return true;
    }

    public int getCapacity() {
        return this.b.length;
    }

    public void setCapacity(int value) {
        if (((long)value & 0xFFFFFFFFL) < ((long)this.c & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException();
        }
        this.b = Arrays.copyOf(this.b, value);
    }

    @Override
    public int size() {
        return this.c;
    }

    @Override
    public T get_Item(int index) {
        if (((long)index & 0xFFFFFFFFL) >= ((long)this.c & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        return (T)this.b[index];
    }

    @Override
    public void set_Item(int index, T value) {
        this.c(index);
        if ((long)index == (long)this.c) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        this.b[index] = value;
        ++this.d;
    }

    public void copyTo(Array array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.getRank() > 1 || array.getLowerBound(0) != 0) {
            throw new ArgumentException("Array must be zero based and single dimentional\r\nParameter name: array");
        }
        Array.copy(Array.boxing(this.b), 0, array, arrayIndex, this.c);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public boolean isSynchronized() {
        return false;
    }

    public Object getSyncRoot() {
        return this.e;
    }

    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.c == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            for (int i = 0; i < this.c; ++i) {
                if (this.b[i] != null) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < this.c; ++i) {
            if (!this.b[i].equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsItem(T item) {
        if (item == null) {
            for (int i = 0; i < this.c; ++i) {
                if (this.b[i] != null) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < this.c; ++i) {
            if (!this.b[i].equals(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.c];
        System.arraycopy(this.b, 0, objectArray, 0, this.c);
        return objectArray;
    }

    @Override
    public boolean add(T t) {
        int n = this.c;
        this.addItem(t);
        return n != this.c;
    }

    @Override
    public boolean remove(Object o) {
        int n = this.c;
        this.removeItem(o);
        return n != this.c;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object obj : c) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        int n = 0;
        int n2 = this.size();
        for (T t : c) {
            this.insertItem(n++, t);
        }
        return n2 != this.size();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        int n = index;
        int n2 = this.size();
        for (T t : c) {
            this.insertItem(n++, t);
        }
        return n2 != this.size();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        int n = this.size();
        for (Object obj : c) {
            this.remove(obj);
        }
        return n != this.size();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Object[] objectArray;
        int n = this.size();
        for (Object object : objectArray = this.toArray()) {
            if (c.contains(object)) continue;
            this.remove(object);
        }
        return n != this.size();
    }

    @Override
    public T get(int index) {
        return this.get_Item(index);
    }

    @Override
    public T set(int index, T element) {
        T t = this.get_Item(index);
        this.set_Item(index, element);
        return t;
    }

    @Override
    public void add(int index, T element) {
        this.insertItem(index, element);
    }

    @Override
    public T remove(int index) {
        T t = this.get_Item(index);
        this.removeAt(index);
        return t;
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            for (int i = 0; i < this.c; ++i) {
                if (this.b[i] != null) continue;
                return i;
            }
            return -1;
        }
        for (int i = 0; i < this.c; ++i) {
            if (!o.equals(this.b[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator listIterator() {
        return new zc(0);
    }

    @Override
    public ListIterator listIterator(int index) {
        return new zc(index);
    }

    @Override
    public java.util.List<T> subList(int fromIndex, int toIndex) {
        int n = toIndex - fromIndex;
        List<T> list = this.getRange(fromIndex, n);
        return list;
    }

    public static <T> List<T> fromJava(java.util.List<T> list) {
        if (list == null) {
            return null;
        }
        return new zb<T>(list);
    }

    public static <T> java.util.List<T> toJava(List<T> list) {
        return list;
    }

    /* synthetic */ List(Object[] x0, int x1, zd x2) {
        this(x0, x1);
    }

    static class zb<T>
    extends List<T> {
        private final java.util.List<T> b;
        private int c;

        public zb() {
            this.b = new ArrayList<T>();
        }

        public zb(java.util.List<T> list) {
            super(list.size());
            for (T t : list) {
                super.addItem(t);
            }
            this.b = list;
        }

        @Override
        protected int getVersion() {
            return this.c;
        }

        @Override
        public void addRange(Iterable<T> collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            this.a(collection);
            ++this.c;
        }

        @Override
        public void addRange(T[] collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            for (T t : collection) {
                this.addItem(t);
            }
            ++this.c;
        }

        @Override
        public com.aspose.email.internal.e.zb<T> asReadOnly() {
            return new com.aspose.email.internal.e.zb(this);
        }

        @Override
        public int binarySearch(T item) {
            return zbj.a(this.b.toArray(), 0, this.b.size(), item);
        }

        @Override
        public int binarySearch(T item, Comparator<T> comparer) {
            return zbj.a(this.b.toArray(), 0, this.b.size(), item, comparer);
        }

        @Override
        public int binarySearch(int index, int count, T item, Comparator<T> comparer) {
            this.a(index, count);
            return zbj.a(this.b.toArray(), index, count, item, comparer);
        }

        @Override
        private void a(int n, int n2) {
            if (n < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            if (n2 < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: count");
            }
            if (((long)n & 0xFFFFFFFFL) + ((long)n2 & 0xFFFFFFFFL) > ((long)this.b.size() & 0xFFFFFFFFL)) {
                throw new ArgumentException("index and count exceed length of list");
            }
        }

        @Override
        public <TOutput> List<TOutput> convertAll(Converter<T, TOutput> converter) {
            if (converter == null) {
                throw new ArgumentNullException("converter");
            }
            int n = this.b.size();
            List list = new List(n);
            for (int i = 0; i < n; ++i) {
                list.b[i] = converter.invoke(this.get_Item(i));
            }
            list.c = n;
            return list;
        }

        @Override
        public void copyTo(T[] array) {
            Array.copy(this.b.toArray(), 0, array, 0, this.b.size());
        }

        @Override
        public void copyToTArray(T[] array, int arrayIndex) {
            Array.copy(this.b.toArray(), 0, array, arrayIndex, this.b.size());
        }

        @Override
        public void copyTo(int index, T[] array, int arrayIndex, int count) {
            this.a(index, count);
            Array.copy(this.b.toArray(), index, array, arrayIndex, count);
        }

        @Override
        public boolean exists(Predicate<T> match) {
            zb.b(match);
            return this.a(0, this.b.size(), match) != -1;
        }

        @Override
        private int a(int n, int n2, Predicate<T> predicate) {
            int n3 = n + n2;
            for (int i = n; i < n3; ++i) {
                if (!predicate.invoke(this.b.get(i))) continue;
                return i;
            }
            return -1;
        }

        static <T> void b(Predicate<T> predicate) {
            if (predicate == null) {
                throw new ArgumentNullException("match");
            }
        }

        @Override
        public T find(Predicate<T> match) {
            zb.b(match);
            int n = this.a(0, this.b.size(), match);
            return n != -1 ? (T)this.b.get(n) : null;
        }

        @Override
        public List<T> findAll(Predicate<T> match) {
            zb.b(match);
            return this.c(match);
        }

        private List<T> c(Predicate<T> predicate) {
            List<T> list = new List<T>();
            int n = this.size();
            for (int i = 0; i < n; ++i) {
                if (!predicate.invoke(this.b.get(i))) continue;
                list.addItem(this.b.get(i));
            }
            return list;
        }

        @Override
        public int findIndex(Predicate<T> match) {
            zb.b(match);
            return this.a(0, this.b.size(), match);
        }

        @Override
        public int findIndex(int startIndex, Predicate<T> match) {
            zb.b(match);
            this.a(startIndex);
            return this.a(startIndex, this.b.size() - startIndex, match);
        }

        @Override
        private void a(int n) {
            if (n < 0 || ((long)n & 0xFFFFFFFFL) > ((long)this.b.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
        }

        @Override
        public int findIndex(int startIndex, int count, Predicate<T> match) {
            zb.b(match);
            this.a(startIndex, count);
            return this.a(startIndex, count, match);
        }

        @Override
        public T findLast(Predicate<T> match) {
            zb.b(match);
            int n = this.b(0, this.b.size(), match);
            if (n == -1) {
                return null;
            }
            return this.get_Item(n);
        }

        @Override
        private int b(int n, int n2, Predicate<T> predicate) {
            int n3 = n + n2;
            while (n3 != n) {
                if (!predicate.invoke(this.b.get(--n3))) continue;
                return n3;
            }
            return -1;
        }

        @Override
        public int findLastIndex(Predicate<T> match) {
            zb.b(match);
            return this.b(0, this.b.size(), match);
        }

        @Override
        public int findLastIndex(int startIndex, Predicate<T> match) {
            zb.b(match);
            this.a(startIndex);
            return this.b(0, startIndex + 1, match);
        }

        @Override
        public int findLastIndex(int startIndex, int count, Predicate<T> match) {
            zb.b(match);
            int n = startIndex - count + 1;
            this.a(n, count);
            return this.b(n, count, match);
        }

        @Override
        public void forEach(Action<T> action) {
            if (action == null) {
                throw new ArgumentNullException("action");
            }
            int n = this.b.size();
            for (int i = 0; i < n; ++i) {
                action.invoke(this.b.get(i));
            }
        }

        @Override
        public Enumerator<T> iterator() {
            return new Enumerator(this);
        }

        @Override
        public List<T> getRange(int index, int count) {
            this.a(index, count);
            Object[] objectArray = new Object[count];
            Array.copy(this.b.toArray(), index, objectArray, 0, count);
            return new List(objectArray, count, null);
        }

        @Override
        public int indexOfItem(T item) {
            return this.b.indexOf(item);
        }

        @Override
        public int indexOf(T item, int index) {
            this.a(index);
            return Array.indexOf(this.b.toArray(), item, index, this.b.size() - index);
        }

        @Override
        public int indexOf(T item, int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: count");
            }
            if (((long)index & 0xFFFFFFFFL) + ((long)count & 0xFFFFFFFFL) > ((long)this.b.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index and count exceed length of list");
            }
            return Array.indexOf(this.b.toArray(), item, index, count);
        }

        @Override
        public int lastIndexOf(Object item) {
            if (this.b.size() == 0) {
                return -1;
            }
            return zbj.a(this.b.toArray(), item, this.b.size() - 1, this.b.size());
        }

        @Override
        public int lastIndexOf(T item, int index) {
            this.a(index);
            return zbj.a(this.b.toArray(), item, index, index + 1);
        }

        @Override
        public int lastIndexOf(T item, int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "index is negative");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "count is negative");
            }
            if (index - count + 1 < 0) {
                throw new ArgumentOutOfRangeException("cound", count, "count is too large");
            }
            return zbj.a(this.b.toArray(), item, index, count);
        }

        @Override
        public boolean removeItem(T item) {
            int n = this.indexOfItem(item);
            if (n != -1) {
                this.removeAt(n);
            }
            return n != -1;
        }

        @Override
        public <T1> T1[] toArray(T1[] a) {
            return this.b.toArray(a);
        }

        @Override
        public void trimExcess() {
            this.setCapacity(this.b.size());
        }

        @Override
        public boolean trueForAll(Predicate<T> match) {
            zb.b(match);
            int n = this.b.size();
            for (int i = 0; i < n; ++i) {
                if (match.invoke(this.b.get(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        public int getCapacity() {
            return this.b.size();
        }

        @Override
        public void setCapacity(int value) {
            if (((long)value & 0xFFFFFFFFL) < ((long)this.b.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException();
            }
            int n = value - this.b.size();
            for (int i = 0; i < n; ++i) {
                this.b.add(null);
            }
        }

        @Override
        public int size() {
            return this.b.size();
        }

        @Override
        public T get_Item(int index) {
            return this.b.get(index);
        }

        @Override
        public void copyTo(Array array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (array.getRank() > 1 || array.getLowerBound(0) != 0) {
                throw new ArgumentException("Array must be zero based and single dimentional\r\nParameter name: array");
            }
            Array.copy(Array.boxing(this.b.toArray()), 0, array, arrayIndex, this.b.size());
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object getSyncRoot() {
            return this;
        }

        @Override
        public boolean isFixedSize() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public boolean contains(Object o) {
            int n = this.b.size();
            if (o == null) {
                for (int i = 0; i < n; ++i) {
                    if (this.get(i) != null) continue;
                    return true;
                }
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (!this.get(i).equals(o)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsItem(T item) {
            int n = this.b.size();
            if (item == null) {
                for (int i = 0; i < n; ++i) {
                    if (this.b.get(i) != null) continue;
                    return true;
                }
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (!this.b.get(i).equals(item)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object[] toArray() {
            return this.b.toArray();
        }

        @Override
        public boolean add(T t) {
            ++this.c;
            return this.b.add(t);
        }

        @Override
        public boolean remove(Object o) {
            ++this.c;
            return this.b.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.b.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            ++this.c;
            return this.b.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            ++this.c;
            return this.b.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            ++this.c;
            return this.b.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            ++this.c;
            return this.b.retainAll(c);
        }

        @Override
        public T get(int index) {
            return this.b.get(index);
        }

        @Override
        public T set(int index, T element) {
            ++this.c;
            return this.b.set(index, element);
        }

        @Override
        public void add(int index, T element) {
            ++this.c;
            this.b.add(index, element);
        }

        @Override
        public T remove(int index) {
            ++this.c;
            return this.b.remove(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.b.indexOf(o);
        }

        @Override
        public ListIterator listIterator() {
            return this.b.listIterator();
        }

        @Override
        public ListIterator listIterator(int index) {
            return this.b.listIterator(index);
        }

        @Override
        public java.util.List<T> subList(int fromIndex, int toIndex) {
            return this.b.subList(fromIndex, toIndex);
        }

        @Override
        public void addItem(T item) {
            this.b.add(item);
            ++this.c;
        }

        @Override
        public void clear() {
            this.b.clear();
            ++this.c;
        }

        @Override
        public void insertItem(int index, T item) {
            this.b.add(index, item);
            ++this.c;
        }

        @Override
        public void insertRange(int index, Iterable<T> collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            if (index < 0 || ((long)index & 0xFFFFFFFFL) > ((long)this.b.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            int n = index;
            if (collection == this) {
                Object[] objectArray = new Object[this.size()];
                this.copyTo(objectArray);
                for (Object object : objectArray) {
                    this.b.add(n++, object);
                }
            } else {
                for (T t : collection) {
                    this.b.add(n++, t);
                }
            }
            ++this.c;
        }

        @Override
        public int removeAll(Predicate<T> match) {
            zb.b(match);
            int n = 0;
            int n2 = 0;
            int n3 = this.b.size();
            for (n = 0; n < n3 && !match.invoke(this.b.get(n)); ++n) {
            }
            if (n == n3) {
                return 0;
            }
            ++this.c;
            for (n2 = n + 1; n2 < n3; ++n2) {
                if (match.invoke(this.b.get(n2))) continue;
                this.b.set(n++, this.b.get(n2));
            }
            if (n2 - n > 0) {
                for (int i = 0; i < n2 - n; ++i) {
                    this.b.remove(this.b.size() - 1);
                }
            }
            return n2 - n;
        }

        @Override
        public void removeAt(int index) {
            if (index < 0 || ((long)index & 0xFFFFFFFFL) >= ((long)this.b.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            this.b.remove(index);
            ++this.c;
        }

        @Override
        public void removeRange(int index, int count) {
            this.a(index, count);
            if (count > 0) {
                for (int i = 0; i < count; ++i) {
                    this.b.remove(index);
                }
                ++this.c;
            }
        }

        @Override
        public void reverse() {
            this.reverse(0, this.size());
        }

        @Override
        public void reverse(int index, int count) {
            this.a(index, count);
            int n = index;
            for (int i = index + count - 1; n < i; ++n, --i) {
                T t = this.b.get(n);
                this.b.set(n, this.b.get(i));
                this.b.set(i, t);
            }
            ++this.c;
        }

        @Override
        public void sort() {
            Collections.sort(this.b, null);
            ++this.c;
        }

        @Override
        public void sort(Comparator<? super T> comparer) {
            Collections.sort(this.b, comparer);
            ++this.c;
        }

        @Override
        public void sort(Comparison<T> tComparison) {
            if (tComparison == null) {
                throw new ArgumentNullException("comparison");
            }
            Collections.sort(this.b, new ze(this, tComparison));
            ++this.c;
        }

        @Override
        public void sort(int index, int count, Comparator<T> comparer) {
            this.a(index, count);
            java.util.List<T> list = this.b.subList(index, count);
            Collections.sort(list, comparer);
            for (int i = 0; i < count; ++i) {
                this.b.set(index + i, list.get(i));
            }
            ++this.c;
        }

        @Override
        public void set_Item(int index, T value) {
            this.a(index);
            if ((long)index == (long)this.b.size()) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            this.b.set(index, value);
            ++this.c;
        }

        @Override
        private void a(Iterable<T> iterable) {
            for (T t : iterable) {
                this.addItem(t);
            }
        }
    }

    @Deprecated
    @zau
    public static class EnumeratorJava<T>
    extends Struct<EnumeratorJava<T>>
    implements IDisposable,
    IGenericEnumerator<T> {
        private List<T> b = new List();
        private int c;
        private int d;
        private T e;

        public EnumeratorJava() {
        }

        EnumeratorJava(List<T> l) {
            this();
            this.b = l;
            this.d = l.getVersion();
        }

        @Override
        public void dispose() {
        }

        private void a() {
            if (this.d != this.b.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
        }

        @Override
        public T next() {
            if (this.c < 0 || this.c >= this.b.size() + 1) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished.");
            }
            if (this.d != this.b.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
            this.e = this.b.get_Item(this.c++);
            return this.e;
        }

        @Override
        public boolean hasNext() {
            if (this.d == this.b.getVersion()) {
                if (this.c < 0) {
                    return false;
                }
                return this.c < this.b.size();
            }
            throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
        }

        @Override
        public void reset() {
            this.a();
            this.c = 0;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(EnumeratorJava<T> that) {
            that.b = this.b;
            that.c = this.c;
            that.d = this.d;
            that.e = this.e;
        }

        @Override
        public EnumeratorJava<T> Clone() {
            EnumeratorJava<T> enumeratorJava = new EnumeratorJava<T>();
            this.CloneTo(enumeratorJava);
            return enumeratorJava;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean a(EnumeratorJava enumeratorJava) {
            return zak.a(enumeratorJava.b, this.b) && enumeratorJava.c == this.c && enumeratorJava.d == this.d && zak.a(enumeratorJava.e, this.e);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (zak.b(null, obj)) {
                return false;
            }
            if (zak.b(this, obj)) {
                return true;
            }
            if (!(obj instanceof EnumeratorJava)) {
                return false;
            }
            return this.a((EnumeratorJava)obj);
        }

        public static boolean equals(EnumeratorJava obj1, EnumeratorJava obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.b != null ? this.b.hashCode() : 0;
            n = 31 * n + this.c;
            n = 31 * n + this.d;
            n = 31 * n + (this.e != null ? this.e.hashCode() : 0);
            return n;
        }
    }

    @zau
    public static class Enumerator<T>
    extends Struct<Enumerator<T>>
    implements IDisposable,
    IGenericEnumerator<T> {
        private List<T> b = new List();
        private int c;
        private int d;
        private T e;

        public Enumerator() {
        }

        Enumerator(List<T> l) {
            this();
            this.b = l;
            this.d = l.getVersion();
        }

        @Override
        public void dispose() {
        }

        private void a() {
            if (this.d != this.b.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
        }

        @Override
        public boolean hasNext() {
            if (this.d == this.b.getVersion()) {
                if (this.c < 0) {
                    return false;
                }
                if (this.c < this.b.size()) {
                    this.e = this.b.get_Item(this.c++);
                    return true;
                }
            } else {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
            if (this.e != null) {
                this.e = com.aspose.email.internal.ky.zb.c(this.e.getClass());
            }
            return false;
        }

        @Override
        public void reset() {
            this.a();
            this.c = 0;
        }

        @Override
        public T next() {
            if (this.c < 0 || this.c >= this.b.size() + 1) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished.");
            }
            return this.e;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(Enumerator<T> that) {
            that.b = this.b;
            that.c = this.c;
            that.d = this.d;
            that.e = this.e;
        }

        @Override
        public Enumerator<T> Clone() {
            Enumerator<T> enumerator = new Enumerator<T>();
            this.CloneTo(enumerator);
            return enumerator;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean a(Enumerator enumerator) {
            return zak.a(enumerator.b, this.b) && enumerator.c == this.c && enumerator.d == this.d && zak.a(enumerator.e, this.e);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (zak.b(null, obj)) {
                return false;
            }
            if (zak.b(this, obj)) {
                return true;
            }
            if (!(obj instanceof Enumerator)) {
                return false;
            }
            return this.a((Enumerator)obj);
        }

        public static boolean equals(Enumerator obj1, Enumerator obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.b != null ? this.b.hashCode() : 0;
            n = 31 * n + this.c;
            n = 31 * n + this.d;
            n = 31 * n + (this.e != null ? this.e.hashCode() : 0);
            return n;
        }
    }

    private class zc
    extends za<T>
    implements ListIterator<T> {
        zc(int n) {
            super(null);
            this.a = n;
        }

        @Override
        public boolean hasPrevious() {
            return this.a != 0;
        }

        @Override
        public int nextIndex() {
            return this.a;
        }

        @Override
        public int previousIndex() {
            return this.a - 1;
        }

        @Override
        public T previous() {
            int n = this.a - 1;
            if (n < 0) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = List.this.b;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.a = n;
            this.b = n;
            return objectArray[this.b];
        }

        @Override
        public void set(T e) {
            if (this.b < 0) {
                throw new IllegalStateException();
            }
            try {
                List.this.set(this.b, e);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(T e) {
            try {
                int n = this.a;
                List.this.add(n, e);
                this.a = n + 1;
                this.b = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class za<T>
    implements Iterator<T> {
        int a;
        int b = -1;

        private za() {
        }

        @Override
        public boolean hasNext() {
            return this.a != List.this.c;
        }

        @Override
        public T next() {
            int n = this.a;
            if (n >= List.this.c) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = List.this.b;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.a = n + 1;
            this.b = n;
            return (T)objectArray[this.b];
        }

        @Override
        public void remove() {
            if (this.b < 0) {
                throw new IllegalStateException();
            }
            try {
                List.this.remove(this.b);
                this.a = this.b;
                this.b = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        /* synthetic */ za(zd zd2) {
            this();
        }
    }
}

