/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.email;

import com.aspose.email.EmlLoadOptions;
import com.aspose.email.FolderInfo;
import com.aspose.email.MailMessage;
import com.aspose.email.MapiConversionOptions;
import com.aspose.email.MapiMessage;
import com.aspose.email.MboxLoadOptions;
import com.aspose.email.MboxStorageReader;
import com.aspose.email.MboxToPstConversionOptions;
import com.aspose.email.MboxrdStorageReader;
import com.aspose.email.PersonalStorage;
import com.aspose.email.internal.b.zax;
import com.aspose.email.internal.ht.za;
import com.aspose.email.system.AsyncCallback;
import com.aspose.email.system.IAsyncResult;
import com.aspose.email.system.MulticastDelegate;
import com.aspose.email.system.exceptions.ArgumentException;
import com.aspose.email.system.exceptions.ArgumentNullException;
import com.aspose.email.system.io.FileStream;
import com.aspose.email.system.io.Stream;
import com.aspose.email.zald;
import com.aspose.email.zbnn;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MailStorageConverter {
    private static EmlLoadOptions a = new EmlLoadOptions();

    public static EmlLoadOptions getMboxMessageOptions() {
        return a;
    }

    public static void setMboxMessageOptions(EmlLoadOptions value) {
        a = value;
    }

    public static PersonalStorage mboxToPst(String mboxFileName, String pstFileName) {
        return MailStorageConverter.mboxToPst(mboxFileName, pstFileName, new MboxToPstConversionOptions());
    }

    public static PersonalStorage mboxToPst(String mboxFileName, String pstFileName, MailHandler mailHandler) {
        if (zax.a(mboxFileName)) {
            throw new ArgumentException(zbnn.a(new byte[]{43, 19, -16, -31, 52, 123, 20, -66, -118, 66, 95, 81, 41, 91, 30, -90, -8, -29, 50, 117, 70, 19, -6, -71, 122, 104, 17, -66, -49, 13, 67, 16, 33, 83, 78, -79, -32}), zbnn.a(new byte[]{11, 19, -16, -31, 82, 116, 17, -73, -95, 3, 92, 85}));
        }
        return MailStorageConverter.a(new FileStream(mboxFileName, 3, 1), pstFileName, mailHandler);
    }

    public static PersonalStorage mboxToPst(InputStream mboxrdDataStream, String pstFileName) {
        return MailStorageConverter.a(Stream.fromJava(mboxrdDataStream), pstFileName);
    }

    static PersonalStorage a(Stream stream, String string) {
        return MailStorageConverter.a(stream, string, null);
    }

    public static PersonalStorage mboxToPst(InputStream mboxrdDataStream, String pstFileName, MailHandler mailHandler) {
        return MailStorageConverter.a(Stream.fromJava(mboxrdDataStream), pstFileName, mailHandler);
    }

    static PersonalStorage a(Stream stream, String string, MailHandler mailHandler) {
        if (zax.a(string)) {
            throw new ArgumentException(zbnn.a(new byte[]{54, 2, -21, -71, 114, 116, 17, -73, -49, 12, 80, 93, 33, 30, 93, -92, -9, -86, 97, 33, 4, 20, -65, -9, 97, 113, 17, -14, -128, 16, 17, 85, 41, 78, 74, -68}), zbnn.a(new byte[]{22, 2, -21, -33, 125, 113, 24, -100, -114, 15, 84}));
        }
        return MailStorageConverter.mboxToPst(stream, (Stream)new FileStream(string, 2, 3), mailHandler);
    }

    public static PersonalStorage mboxToPst(String mboxFileName, OutputStream pstDataStream) {
        return MailStorageConverter.mboxToPst(mboxFileName, pstDataStream, null);
    }

    public static PersonalStorage mboxToPst(String mboxFileName, Stream pstDataStream) {
        return MailStorageConverter.mboxToPst(mboxFileName, pstDataStream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PersonalStorage mboxToPst(String mboxFileName, OutputStream pstDataStream, MailHandler mailHandler) {
        PersonalStorage personalStorage;
        FileInputStream fileInputStream = new FileInputStream(mboxFileName);
        try {
            personalStorage = MailStorageConverter.mboxToPst((InputStream)fileInputStream, pstDataStream, mailHandler);
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)fileInputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }
        ((InputStream)fileInputStream).close();
        return personalStorage;
    }

    public static PersonalStorage mboxToPst(String mboxFileName, Stream pstDataStream, MailHandler mailHandler) {
        if (zax.a(mboxFileName)) {
            throw new ArgumentException(zbnn.a(new byte[]{43, 19, -16, -31, 52, 123, 20, -66, -118, 66, 95, 81, 41, 91, 30, -90, -8, -29, 50, 117, 70, 19, -6, -71, 122, 104, 17, -66, -49, 13, 67, 16, 33, 83, 78, -79, -32}), zbnn.a(new byte[]{11, 19, -16, -31, 82, 116, 17, -73, -95, 3, 92, 85}));
        }
        return MailStorageConverter.mboxToPst((Stream)new FileStream(mboxFileName, 3, 1), pstDataStream, mailHandler);
    }

    public static PersonalStorage mboxToPst(InputStream mboxrdDataStream, OutputStream pstDataStream) {
        return MailStorageConverter.mboxToPst(mboxrdDataStream, pstDataStream, new MboxToPstConversionOptions());
    }

    public static PersonalStorage mboxToPst(Stream mboxrdDataStream, Stream pstDataStream) {
        return MailStorageConverter.mboxToPst(mboxrdDataStream, pstDataStream, new MboxToPstConversionOptions());
    }

    public static PersonalStorage mboxToPst(InputStream mboxrdDataStream, OutputStream pstDataStream, MailHandler mailHandler) {
        MboxToPstConversionOptions mboxToPstConversionOptions = new MboxToPstConversionOptions();
        mboxToPstConversionOptions.setMessageHandler(mailHandler);
        return MailStorageConverter.mboxToPst(mboxrdDataStream, pstDataStream, mboxToPstConversionOptions);
    }

    public static PersonalStorage mboxToPst(Stream mboxrdDataStream, Stream pstDataStream, MailHandler mailHandler) {
        MboxToPstConversionOptions mboxToPstConversionOptions = new MboxToPstConversionOptions();
        mboxToPstConversionOptions.setMessageHandler(mailHandler);
        return MailStorageConverter.mboxToPst(mboxrdDataStream, pstDataStream, mboxToPstConversionOptions);
    }

    public static void mboxToPst(MboxStorageReader mboxStorageReader, PersonalStorage pst, String pstFolderName, MailHandler mailHandler) {
        MboxToPstConversionOptions mboxToPstConversionOptions = new MboxToPstConversionOptions();
        mboxToPstConversionOptions.setMessageHandler(mailHandler);
        MailStorageConverter.mboxToPst(mboxStorageReader, pst, pstFolderName, mboxToPstConversionOptions);
    }

    public static PersonalStorage mboxToPst(String mboxFileName, String pstFileName, MboxToPstConversionOptions options) {
        if (zax.a(mboxFileName)) {
            throw new ArgumentException(zbnn.a(new byte[]{43, 19, -16, -31, 52, 123, 20, -66, -118, 66, 95, 81, 41, 91, 30, -90, -8, -29, 50, 117, 70, 19, -6, -71, 122, 104, 17, -66, -49, 13, 67, 16, 33, 83, 78, -79, -32}), zbnn.a(new byte[]{11, 19, -16, -31, 82, 116, 17, -73, -95, 3, 92, 85}));
        }
        if (zax.a(pstFileName)) {
            throw new ArgumentException(zbnn.a(new byte[]{54, 2, -21, -71, 114, 116, 17, -73, -49, 12, 80, 93, 33, 30, 93, -92, -9, -86, 97, 33, 4, 20, -65, -9, 97, 113, 17, -14, -128, 16, 17, 85, 41, 78, 74, -68}), zbnn.a(new byte[]{22, 2, -21, -33, 125, 113, 24, -100, -114, 15, 84}));
        }
        return MailStorageConverter.mboxToPst((Stream)new FileStream(mboxFileName, 3, 1), (Stream)new FileStream(pstFileName, 2, 3), options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PersonalStorage mboxToPst(InputStream mboxrdDataStream, OutputStream pstDataStream, MboxToPstConversionOptions options) {
        if (mboxrdDataStream == null) {
            throw new ArgumentNullException(zbnn.a(new byte[]{11, 19, -16, -31, 102, 121, 57, -77, -101, 3, 98, 68, 54, 91, 95, -88}));
        }
        if (pstDataStream == null) {
            throw new ArgumentNullException(zbnn.a(new byte[]{22, 2, -21, -35, 117, 105, 28, -127, -101, 16, 84, 81, 41}));
        }
        PersonalStorage personalStorage = PersonalStorage.create(pstDataStream, 0);
        MboxLoadOptions mboxLoadOptions = new MboxLoadOptions();
        mboxLoadOptions.setLeaveOpen(false);
        MboxrdStorageReader mboxrdStorageReader = new MboxrdStorageReader(mboxrdDataStream, mboxLoadOptions);
        try {
            MailStorageConverter.mboxToPst((MboxStorageReader)mboxrdStorageReader, personalStorage, zbnn.a(new byte[]{47, 31, -3, -10, 108}), options);
        }
        finally {
            if (mboxrdStorageReader != null) {
                mboxrdStorageReader.dispose();
            }
        }
        return personalStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PersonalStorage mboxToPst(Stream mboxrdDataStream, Stream pstDataStream, MboxToPstConversionOptions options) {
        if (mboxrdDataStream == null) {
            throw new ArgumentNullException(zbnn.a(new byte[]{11, 19, -16, -31, 102, 121, 57, -77, -101, 3, 98, 68, 54, 91, 95, -88}));
        }
        if (pstDataStream == null) {
            throw new ArgumentNullException(zbnn.a(new byte[]{22, 2, -21, -35, 117, 105, 28, -127, -101, 16, 84, 81, 41}));
        }
        PersonalStorage personalStorage = PersonalStorage.a(pstDataStream, 0);
        MboxLoadOptions mboxLoadOptions = new MboxLoadOptions();
        mboxLoadOptions.setLeaveOpen(false);
        MboxrdStorageReader mboxrdStorageReader = new MboxrdStorageReader(mboxrdDataStream, mboxLoadOptions);
        try {
            MailStorageConverter.mboxToPst((MboxStorageReader)mboxrdStorageReader, personalStorage, zbnn.a(new byte[]{47, 31, -3, -10, 108}), options);
        }
        finally {
            if (mboxrdStorageReader != null) {
                mboxrdStorageReader.dispose();
            }
        }
        return personalStorage;
    }

    public static void mboxToPst(MboxStorageReader mboxStorageReader, PersonalStorage pst, String pstFolderName, MboxToPstConversionOptions options) {
        MailMessage mailMessage;
        if (mboxStorageReader == null) {
            throw new ArgumentNullException(zbnn.a(new byte[]{11, 19, -16, -31, 71, 105, 18, -96, -114, 5, 84, 98, 33, 95, 90, -96, -21}));
        }
        if (pst == null) {
            throw new ArgumentNullException(zbnn.a(new byte[]{22, 2, -21}));
        }
        FolderInfo folderInfo = pst.getRootFolder().getSubFolder(pstFolderName);
        if (folderInfo == null) {
            folderInfo = pst.getRootFolder().addSubFolder(pstFolderName);
        }
        while ((mailMessage = mboxStorageReader.readNextMessage(MailStorageConverter.getMboxMessageOptions())) != null) {
            if (options.getMessageHandler() != null) {
                options.getMessageHandler().invoke(mailMessage);
            }
            MapiConversionOptions mapiConversionOptions = MapiConversionOptions.getUnicodeFormat();
            mapiConversionOptions.setRemoveSignature(options != null ? options.getRemoveSignature() : false);
            folderInfo.addMessage(MapiMessage.fromMailMessage(mailMessage, mapiConversionOptions));
        }
    }

    public static abstract class MailHandler
    extends MulticastDelegate {
        public abstract void invoke(MailMessage var1);

        public final IAsyncResult beginInvoke(MailMessage message, AsyncCallback callback, Object state) {
            return za.a(new zald(this, this, callback, state, message));
        }

        public final void endInvoke(IAsyncResult result) {
            za.a(this, result);
        }
    }
}

