/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.email;

import com.aspose.email.PalCryptographyBC;
import com.aspose.email.zbnn;
import com.aspose.email.zdp;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;

public class SmimeKey {
    private final PrivateKey a;
    private final X509Certificate[] b;
    private List<String> c;

    public SmimeKey(PrivateKey privateKey, X509Certificate ... certificateChain) {
        this.a = privateKey;
        this.b = certificateChain;
    }

    public SmimeKey(X509Certificate ... certificateChain) {
        this.a = null;
        this.b = certificateChain;
    }

    public static SmimeKey loadPrivateKey(InputStream stream) {
        try {
            Object object;
            StringBuilder stringBuilder = new StringBuilder();
            Object object2 = new BufferedReader(new InputStreamReader(stream));
            Object object3 = null;
            try {
                while ((object = ((BufferedReader)object2).readLine()) != null) {
                    if (((String)object).startsWith(zbnn.a(new byte[]{75, 92, -78, -76, 57}))) continue;
                    stringBuilder.append(((String)object).trim());
                }
            }
            catch (Throwable throwable) {
                object3 = throwable;
                throw throwable;
            }
            finally {
                if (object2 != null) {
                    if (object3 != null) {
                        try {
                            ((BufferedReader)object2).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object3).addSuppressed(throwable);
                        }
                    } else {
                        ((BufferedReader)object2).close();
                    }
                }
            }
            object2 = zdp.a(stringBuilder.toString());
            object3 = new PKCS8EncodedKeySpec((byte[])object2);
            object = KeyFactory.getInstance(zbnn.a(new byte[]{52, 34, -34}));
            PrivateKey privateKey = ((KeyFactory)object).generatePrivate((KeySpec)object3);
            return new SmimeKey(privateKey, new X509Certificate[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SmimeKey loadPrivateKey(String keyPath) {
        try (FileInputStream fileInputStream = new FileInputStream(keyPath);){
            SmimeKey smimeKey = SmimeKey.loadPrivateKey(fileInputStream);
            return smimeKey;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static SmimeKey loadCertificate(InputStream stream) {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance(zbnn.a(new byte[]{62, 95, -86, -87, 45}));
            return new SmimeKey((X509Certificate)certificateFactory.generateCertificate(stream));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SmimeKey loadCertificate(String crtPath) {
        try (FileInputStream fileInputStream = new FileInputStream(crtPath);){
            SmimeKey smimeKey = SmimeKey.loadCertificate(fileInputStream);
            return smimeKey;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static SmimeKey loadPFX(String pfxPath, char[] password) {
        return SmimeKey.loadPFX(pfxPath, null, password);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SmimeKey loadPFX(String pfxPath, String alias, char[] password) {
        try (FileInputStream fileInputStream = new FileInputStream(pfxPath);){
            SmimeKey smimeKey = SmimeKey.loadPFX(fileInputStream, alias, password);
            return smimeKey;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static SmimeKey loadPFX(InputStream stream, char[] password) {
        return SmimeKey.loadPFX(stream, null, password);
    }

    public static SmimeKey loadPFX(InputStream stream, String alias, char[] password) {
        try {
            KeyStore keyStore = KeyStore.getInstance(zbnn.a(new byte[]{54, 58, -36, -54, 37, 47}), PalCryptographyBC.b());
            keyStore.load(stream, password);
            if (alias == null || alias.isEmpty()) {
                SmimeKey smimeKey = SmimeKey.a(keyStore, password);
                return smimeKey;
            }
            SmimeKey smimeKey = SmimeKey.a(keyStore, alias, password);
            return smimeKey;
        }
        catch (Exception exception) {
            throw new RuntimeException(zbnn.a(new byte[]{37, 30, -22, -11, 112, 115, 90, -90, -49, 11, 95, 89, 48, 87, 95, -87, -16, -9, 112, 33, 45, 20, -26, -54, 96, 114, 15, -73}), exception);
        }
        finally {
            SmimeKey.a(password);
        }
    }

    private static SmimeKey a(KeyStore keyStore, char[] cArray) {
        X509Certificate x509Certificate = null;
        PrivateKey privateKey = null;
        try {
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                if (!keyStore.isKeyEntry(string)) continue;
                KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(string, new KeyStore.PasswordProtection(cArray));
                privateKey = privateKeyEntry.getPrivateKey();
                Certificate certificate = keyStore.getCertificate(string);
                if (!(certificate instanceof X509Certificate)) continue;
                x509Certificate = (X509Certificate)certificate;
                break;
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(zbnn.a(new byte[]{37, 30, -22, -11, 112, 115, 90, -90, -49, 16, 84, 83, 43, 72, 91, -73, -71, -34, 120, 104, 11, 20, -44, -4, 109, 61, 27, -96, -128, 15, 17, 123, 33, 71, 109, -79, -10, -1, 112}), exception);
        }
        if (x509Certificate == null) {
            throw new RuntimeException(zbnn.a(new byte[]{40, 30, -65, -6, 113, 111, 9, -69, -119, 11, 82, 81, 48, 91, 30, -93, -10, -8, 123, 101, 70, 24, -15, -71, 127, 120, 4, -95, -101, 13, 67, 85}));
        }
        return new SmimeKey(privateKey, x509Certificate);
    }

    private static SmimeKey a(KeyStore keyStore, String string, char[] cArray) {
        try {
            if (SmimeKey.a(keyStore, string)) {
                PrivateKey privateKey = (PrivateKey)keyStore.getKey(string, cArray);
                Certificate[] certificateArray = keyStore.getCertificateChain(string);
                return new SmimeKey(privateKey, SmimeKey.a(certificateArray));
            }
            return null;
        }
        catch (Exception exception) {
            throw new RuntimeException(zbnn.a(new byte[]{37, 30, -22, -11, 112, 115, 90, -90, -49, 16, 84, 83, 43, 72, 91, -73, -71, -34, 120, 104, 11, 20, -44, -4, 109, 61, 27, -96, -128, 15, 17, 123, 33, 71, 109, -79, -10, -1, 112}), exception);
        }
    }

    private static X509Certificate[] a(Certificate[] certificateArray) {
        X509Certificate[] x509CertificateArray = new X509Certificate[certificateArray.length];
        int n = certificateArray.length;
        for (int i = 0; i < n; ++i) {
            x509CertificateArray[i] = (X509Certificate)certificateArray[i];
        }
        return x509CertificateArray;
    }

    private static boolean a(KeyStore keyStore, String string) {
        try {
            return keyStore.isKeyEntry(string);
        }
        catch (Exception exception) {
            throw new RuntimeException(zbnn.a(new byte[]{37, 30, -22, -11, 112, 115, 90, -90, -49, 16, 84, 83, 43, 72, 91, -73, -71, -20, 121, 104, 7, 2, -6, -22, 52, 123, 15, -67, -126, 66, 122, 85, 61, 109, 74, -86, -21, -24}), exception);
        }
    }

    private static void a(char[] cArray) {
        if (null != cArray) {
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                cArray[i] = '\u0000';
            }
        }
    }

    public PrivateKey getPrivateKey() {
        return this.a;
    }

    public X509Certificate getCertificate() {
        return this.b[0];
    }

    public X509Certificate[] getCertificateChain() {
        return this.b != null ? (X509Certificate[])this.b.clone() : null;
    }

    public List<String> getAssociatedAddresses() {
        if (this.c == null) {
            this.a();
        }
        return this.c;
    }

    private void a() {
        Principal principal;
        ArrayList<String> arrayList = new ArrayList<String>();
        X509Certificate x509Certificate = this.getCertificate();
        if (null != x509Certificate && null != (principal = x509Certificate.getSubjectDN())) {
            String string = principal.getName();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (!string2.startsWith("E=")) continue;
                arrayList.add(string2.substring(2));
            }
        }
        this.c = Collections.unmodifiableList(arrayList);
    }
}

