/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.email.system.collections;

import com.aspose.email.internal.b.zak;
import com.aspose.email.internal.b.zau;
import com.aspose.email.internal.b.zax;
import com.aspose.email.internal.b.zz;
import com.aspose.email.system.Array;
import com.aspose.email.system.Enum;
import com.aspose.email.system.Struct;
import com.aspose.email.system.collections.DictionaryEntry;
import com.aspose.email.system.collections.ICollection;
import com.aspose.email.system.collections.IDictionary;
import com.aspose.email.system.collections.IDictionaryEnumerator;
import com.aspose.email.system.collections.IEnumerator;
import com.aspose.email.system.collections.IList;
import com.aspose.email.system.exceptions.ArgumentException;
import com.aspose.email.system.exceptions.ArgumentNullException;
import com.aspose.email.system.exceptions.ArgumentOutOfRangeException;
import com.aspose.email.system.exceptions.InvalidOperationException;
import com.aspose.email.system.exceptions.NotSupportedException;
import java.util.Comparator;

@zau
public class SortedList
implements zz,
IDictionary {
    private final Object a = new Object();
    private Slot[] b;
    private Comparator c;
    private int d;
    private int e;
    private int f;

    public SortedList() {
        this(null, 16);
    }

    public SortedList(int initialCapacity) {
        this(null, initialCapacity);
    }

    public SortedList(Comparator comparer, int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity");
        }
        this.f = capacity == 0 ? 0 : 16;
        this.c = comparer;
        this.b(capacity, true);
    }

    public SortedList(Comparator comparer) {
        this.c = comparer;
        this.b(16, true);
    }

    public SortedList(IDictionary d) {
        this(d, null);
    }

    public SortedList(IDictionary d, Comparator comparer) {
        if (d == null) {
            throw new ArgumentNullException("dictionary");
        }
        this.b(d.size(), true);
        this.c = comparer;
        IDictionaryEnumerator iDictionaryEnumerator = d.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Override
    public int size() {
        return this.d;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this.a;
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ICollection getKeys() {
        return new zd(this);
    }

    @Override
    public ICollection getValues() {
        return new ze(this);
    }

    @Override
    public Object get_Item(Object key) {
        if (key == null) {
            throw new ArgumentNullException();
        }
        return this.a(key);
    }

    @Override
    public void set_Item(Object key, Object value) {
        if (key == null) {
            throw new ArgumentNullException();
        }
        if (this.isReadOnly()) {
            throw new NotSupportedException("SortedList is Read Only.");
        }
        if (this.b(key) < 0 && this.isFixedSize()) {
            throw new NotSupportedException("Key not found and SortedList is fixed size.");
        }
        this.a(key, value, true);
    }

    public int getCapacity() {
        return this.b.length;
    }

    public void setCapacity(int value) {
        int n = this.b.length;
        if (this.d > value) {
            throw new ArgumentOutOfRangeException("capacity too small");
        }
        if (value == 0) {
            Slot[] slotArray = SortedList.a(this.f);
            SortedList.a(this.b, 0, slotArray, 0, this.d);
            this.b = slotArray;
        } else if (value > this.d) {
            Slot[] slotArray = SortedList.a(value);
            SortedList.a(this.b, 0, slotArray, 0, this.d);
            this.b = slotArray;
        } else if (value > n) {
            Slot[] slotArray = SortedList.a(value);
            SortedList.a(this.b, 0, slotArray, 0, n);
            this.b = slotArray;
        }
    }

    @Override
    public IDictionaryEnumerator iterator() {
        return new za(this, 2);
    }

    @Deprecated
    public IDictionaryEnumerator iteratorJava() {
        return new zb(this, 2);
    }

    @Override
    public void addItem(Object key, Object value) {
        this.a(key, value, false);
    }

    @Override
    public void clear() {
        this.f = 16;
        this.b = SortedList.a(this.f);
        this.d = 0;
        ++this.e;
    }

    @Override
    public boolean contains(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        try {
            return this.b(key) >= 0;
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void removeItem(Object key) {
        int n = this.indexOfKey(key);
        if (n >= 0) {
            this.removeAt(n);
        }
    }

    @Override
    public void copyTo(Array array, int arrayIndex) {
        if (null == array) {
            throw new ArgumentNullException();
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException();
        }
        if (array.getRank() > 1) {
            throw new ArgumentException("array is multi-dimensional");
        }
        if (arrayIndex >= array.getLength()) {
            throw new ArgumentNullException("arrayIndex is greater than or equal to array.Length");
        }
        if (this.size() > array.getLength() - arrayIndex) {
            throw new ArgumentNullException("Not enough space in array from arrayIndex to end of array");
        }
        IDictionaryEnumerator iDictionaryEnumerator = this.iterator();
        int n = arrayIndex;
        while (iDictionaryEnumerator.hasNext()) {
            array.setValue((Object)iDictionaryEnumerator.getEntry().Clone(), n++);
        }
    }

    @Override
    public Object deepClone() {
        SortedList sortedList = new SortedList(this, this.c);
        sortedList.e = this.e;
        return sortedList;
    }

    public IList getKeyList() {
        return new zd(this);
    }

    public IList getValueList() {
        return new ze(this);
    }

    public void removeAt(int index) {
        Slot[] slotArray = this.b;
        int n = this.size();
        if (index >= 0 && index < n) {
            if (index != n - 1) {
                SortedList.a(slotArray, index + 1, slotArray, index, n - 1 - index);
            } else {
                slotArray[index].a = null;
                slotArray[index].b = null;
            }
            --this.d;
            ++this.e;
        } else {
            throw new ArgumentOutOfRangeException("index out of range");
        }
    }

    public int indexOfKey(Object key) {
        int n;
        if (null == key) {
            throw new ArgumentNullException();
        }
        try {
            n = this.b(key);
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidOperationException();
        }
        return n | n >> 31;
    }

    public int indexOfValue(Object value) {
        if (this.d == 0) {
            return -1;
        }
        for (int i = 0; i < this.d; ++i) {
            Slot slot = this.b[i].Clone();
            if (!zak.a(value, slot.b)) continue;
            return i;
        }
        return -1;
    }

    public boolean containsKey(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        try {
            return this.contains(key);
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalStateException();
        }
    }

    public boolean containsValue(Object value) {
        return this.indexOfValue(value) >= 0;
    }

    public Object getByIndex(int index) {
        if (index >= 0 && index < this.size()) {
            return this.b[index].b;
        }
        throw new ArgumentOutOfRangeException("index out of range");
    }

    public void setByIndex(int index, Object value) {
        if (index < 0 || index >= this.size()) {
            throw new ArgumentOutOfRangeException("index out of range");
        }
        this.b[index].b = value;
    }

    public Object getKey(int index) {
        if (index >= 0 && index < this.size()) {
            return this.b[index].a;
        }
        throw new ArgumentOutOfRangeException("index out of range");
    }

    public static SortedList sync(SortedList list) {
        if (list == null) {
            throw new ArgumentNullException("Base list is null.");
        }
        return new zf(list);
    }

    public void trimToSize() {
        if (this.size() == 0) {
            this.a(this.f, false);
        } else {
            this.a(this.size(), true);
        }
    }

    private void a(int n, boolean bl) {
        Slot[] slotArray = this.b;
        Slot[] slotArray2 = SortedList.a(n);
        if (bl) {
            SortedList.a(slotArray, 0, slotArray2, 0, n);
        }
        this.b = slotArray2;
    }

    private void a(int n, int n2) {
        boolean bl;
        Slot[] slotArray = this.b;
        Slot[] slotArray2 = null;
        int n3 = this.getCapacity();
        boolean bl2 = bl = n2 >= 0 && n2 < this.size();
        if (n > n3) {
            slotArray2 = SortedList.a(n << 1);
        }
        if (slotArray2 != null) {
            if (bl) {
                int n4 = n2;
                if (n4 > 0) {
                    SortedList.a(slotArray, 0, slotArray2, 0, n4);
                }
                if ((n4 = this.size() - n2) > 0) {
                    SortedList.a(slotArray, n2, slotArray2, n2 + 1, n4);
                }
            } else {
                SortedList.a(slotArray, 0, slotArray2, 0, this.size());
            }
            this.b = slotArray2;
        } else if (bl) {
            SortedList.a(slotArray, n2, slotArray, n2 + 1, this.size() - n2);
        }
    }

    private void a(Object object, Object object2, boolean bl) {
        int n;
        if (object == null) {
            throw new ArgumentNullException("null key");
        }
        Slot[] slotArray = this.b;
        try {
            n = this.b(object);
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidOperationException();
        }
        if (n >= 0) {
            if (!bl) {
                String string = zax.a("Key '{0}' already exists in list.", new Object[]{object});
                throw new ArgumentException(string);
            }
            slotArray[n].b = object2;
            ++this.e;
            return;
        }
        if ((n ^= 0xFFFFFFFF) > this.getCapacity() + 1) {
            throw new RuntimeException(zax.a(new Object[]{"SortedList::internal error (", object, ", ", object2, ") at [", n, "]"}));
        }
        this.a(this.size() + 1, n);
        slotArray = this.b;
        slotArray[n].a = object;
        slotArray[n].b = object2;
        ++this.d;
        ++this.e;
    }

    private Object a(Object object) {
        int n = this.b(object);
        if (n >= 0) {
            return this.b[n].b;
        }
        return null;
    }

    private void b(int n, boolean bl) {
        if (!bl && n < this.f) {
            n = this.f;
        }
        this.b = SortedList.a(n);
        this.d = 0;
        this.e = 0;
    }

    private void a(Array array, int n, int n2) {
        if (array == null) {
            throw new ArgumentNullException("arr");
        }
        if (n < 0 || n + this.size() > array.getLength()) {
            throw new ArgumentOutOfRangeException("i");
        }
        za za2 = new za(this, n2);
        while (za2.hasNext()) {
            array.setValue(za2.next(), n++);
        }
    }

    private int b(Object object) {
        Slot[] slotArray = this.b;
        int n = this.size();
        if (n == 0) {
            return -1;
        }
        Comparator comparator = this.c == null ? com.aspose.email.internal.c.ze.a : this.c;
        int n2 = 0;
        int n3 = n - 1;
        while (n2 <= n3) {
            int n4 = n2 + n3 >> 1;
            int n5 = comparator.compare(slotArray[n4].a, object);
            if (n5 == 0) {
                return n4;
            }
            if (n5 < 0) {
                n2 = n4 + 1;
                continue;
            }
            n3 = n4 - 1;
        }
        return ~n2;
    }

    static Slot[] a(int n) {
        Slot[] slotArray = new Slot[n];
        for (int i = 0; i < n; ++i) {
            slotArray[i] = new Slot();
        }
        return slotArray;
    }

    private static boolean a(int n, int n2, int n3) {
        return n < n2 && n + n3 > n2 || n2 < n && n2 + n3 > n;
    }

    static void a(Slot[] slotArray, int n, Slot[] slotArray2, int n2, int n3) {
        Slot[] slotArray3;
        if (slotArray == slotArray2 && SortedList.a(n, n2, n3)) {
            slotArray3 = new Slot[n3];
            System.arraycopy(slotArray, n, slotArray3, 0, n3);
            n = 0;
        } else {
            slotArray3 = slotArray;
        }
        for (int i = 0; i < n3; ++i) {
            slotArray2[n2 + i] = slotArray3[n + i].Clone();
        }
    }

    private static class zf
    extends SortedList {
        private SortedList a;

        public zf(SortedList sortedList) {
            if (sortedList == null) {
                throw new ArgumentNullException();
            }
            this.a = sortedList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getCapacity() {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                return this.a.getCapacity();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCapacity(int value) {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                this.a.setCapacity(value);
            }
        }

        @Override
        public int size() {
            return this.a.size();
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.a.getSyncRoot();
        }

        @Override
        public boolean isFixedSize() {
            return this.a.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.a.isReadOnly();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getKeys() {
            ICollection iCollection;
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                iCollection = this.a.getKeys();
            }
            return iCollection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getValues() {
            ICollection iCollection;
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                iCollection = this.a.getValues();
            }
            return iCollection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(Object key) {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                return this.a.a(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(Object key, Object value) {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                this.a.a(key, value, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(Array array, int arrayIndex) {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                this.a.copyTo(array, arrayIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addItem(Object key, Object value) {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                this.a.a(key, value, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                this.a.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object key) {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                return this.a.b(key) >= 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IDictionaryEnumerator iterator() {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                return this.a.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public IDictionaryEnumerator iteratorJava() {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                return this.a.iteratorJava();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object key) {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                this.a.removeItem(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object key) {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                return this.a.contains(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object value) {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                return this.a.containsValue(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                return this.a.deepClone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getByIndex(int index) {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                return this.a.getByIndex(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getKey(int index) {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                return this.a.getKey(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IList getKeyList() {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                return new zd(this.a);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IList getValueList() {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                return new ze(this.a);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                this.a.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOfKey(Object key) {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                return this.a.indexOfKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOfValue(Object val) {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                return this.a.indexOfValue(val);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setByIndex(int index, Object value) {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                this.a.setByIndex(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                this.a.trimToSize();
            }
        }
    }

    @zau
    private static class ze
    implements IList {
        private SortedList a;

        public ze(SortedList sortedList) {
            if (sortedList == null) {
                throw new ArgumentNullException();
            }
            this.a = sortedList;
        }

        @Override
        public int size() {
            return this.a.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.a.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.a.getSyncRoot();
        }

        @Override
        public void copyTo(Array array, int arrayIndex) {
            this.a.a(array, arrayIndex, 1);
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public Object get_Item(int index) {
            return this.a.getByIndex(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException("This operation is not supported on GetValueList return");
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException("IList::Add not supported");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("IList::Clear not supported");
        }

        @Override
        public boolean contains(Object value) {
            return this.a.containsValue(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.a.indexOfValue(value);
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException("IList::Insert not supported");
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException("IList::Remove not supported");
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException("IList::RemoveAt not supported");
        }

        @Override
        public IEnumerator iterator() {
            return new za(this.a, 1);
        }
    }

    @zau
    private static class zd
    implements IList {
        private SortedList a;

        public zd(SortedList sortedList) {
            if (sortedList == null) {
                throw new ArgumentNullException();
            }
            this.a = sortedList;
        }

        @Override
        public int size() {
            return this.a.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.a.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.a.getSyncRoot();
        }

        @Override
        public void copyTo(Array array, int arrayIndex) {
            this.a.a(array, arrayIndex, 0);
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public Object get_Item(int index) {
            return this.a.getKey(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException("attempt to modify a key");
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException("IList::Add not supported");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("IList::Clear not supported");
        }

        @Override
        public boolean contains(Object key) {
            return this.a.contains(key);
        }

        @Override
        public int indexOf(Object key) {
            return this.a.indexOfKey(key);
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException("IList::Insert not supported");
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException("IList::Remove not supported");
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException("IList::RemoveAt not supported");
        }

        @Override
        public IEnumerator iterator() {
            return new za(this.a, 0);
        }
    }

    @Deprecated
    private static final class zb
    implements zz,
    IDictionaryEnumerator {
        private SortedList a;
        private Object b;
        private Object c;
        private int d;
        private int e;
        private int f;
        private int g;
        private boolean h = false;
        private static String i = "SortedList.EnumeratorJava: snapshot out of sync.";

        public zb(SortedList sortedList, int n) {
            this.a = sortedList;
            this.d = sortedList.e;
            this.f = sortedList.size();
            this.g = n;
            this.reset();
        }

        @Override
        public void reset() {
            if (this.a.e != this.d || this.h) {
                throw new IllegalStateException(i);
            }
            this.e = -1;
            this.b = null;
            this.c = null;
        }

        @Override
        public boolean hasNext() {
            if (this.a.e != this.d || this.h) {
                throw new InvalidOperationException(i);
            }
            return ++this.e < this.f;
        }

        @Override
        public DictionaryEntry getEntry() {
            if (this.h || this.e >= this.f || this.e == -1) {
                throw new IllegalStateException(i);
            }
            return new DictionaryEntry(this.b, this.c);
        }

        @Override
        public Object getKey() {
            if (this.h || this.e >= this.f || this.e == -1) {
                throw new IllegalStateException(i);
            }
            return this.b;
        }

        @Override
        public Object getValue() {
            if (this.h || this.e >= this.f || this.e == -1) {
                throw new IllegalStateException(i);
            }
            return this.c;
        }

        @Override
        public Object next() {
            if (this.a.e != this.d || this.h) {
                throw new InvalidOperationException(i);
            }
            if (this.h || this.e >= this.f || this.e == -1) {
                if (this.e >= this.f) {
                    this.b = null;
                    this.c = null;
                }
                throw new IllegalStateException(i);
            }
            Slot[] slotArray = this.a.b;
            Slot slot = slotArray[this.e].Clone();
            this.b = slot.a;
            this.c = slot.b;
            switch (this.g) {
                case 0: {
                    return this.b;
                }
                case 1: {
                    return this.c;
                }
                case 2: {
                    return this.getEntry();
                }
            }
            throw new NotSupportedException(zax.a(new String[]{Enum.getName(zc.class, this.g), " is not a supported mode."}));
        }

        @Override
        public Object deepClone() {
            zb zb2 = new zb(this.a, this.g);
            zb2.d = this.d;
            zb2.e = this.e;
            zb2.f = this.f;
            zb2.b = this.b;
            zb2.c = this.c;
            zb2.h = this.h;
            return zb2;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class za
    implements zz,
    IDictionaryEnumerator {
        private final SortedList a;
        private Object b;
        private Object c;
        private int d;
        private int e;
        private int f;
        private final int g;
        private boolean h = false;

        public za(SortedList sortedList, int n) {
            this.a = sortedList;
            this.d = sortedList.e;
            this.f = sortedList.size();
            this.g = n;
            this.reset();
        }

        @Override
        public void reset() {
            if (this.a.e != this.d || this.h) {
                throw new IllegalStateException("SortedList.Enumerator: snapshot out of sync.");
            }
            this.e = -1;
            this.b = null;
            this.c = null;
        }

        @Override
        public boolean hasNext() {
            if (this.a.e != this.d || this.h) {
                throw new InvalidOperationException("SortedList.Enumerator: snapshot out of sync.");
            }
            Slot[] slotArray = this.a.b;
            if (++this.e < this.f) {
                Slot slot = slotArray[this.e].Clone();
                this.b = slot.a;
                this.c = slot.b;
                return true;
            }
            this.b = null;
            this.c = null;
            return false;
        }

        @Override
        public DictionaryEntry getEntry() {
            if (this.h || this.e >= this.f || this.e == -1) {
                throw new IllegalStateException("SortedList.Enumerator: snapshot out of sync.");
            }
            return new DictionaryEntry(this.b, this.c);
        }

        @Override
        public Object getKey() {
            if (this.h || this.e >= this.f || this.e == -1) {
                throw new IllegalStateException("SortedList.Enumerator: snapshot out of sync.");
            }
            return this.b;
        }

        @Override
        public Object getValue() {
            if (this.h || this.e >= this.f || this.e == -1) {
                throw new IllegalStateException("SortedList.Enumerator: snapshot out of sync.");
            }
            return this.c;
        }

        @Override
        public Object next() {
            if (this.h || this.e >= this.f || this.e == -1) {
                throw new IllegalStateException("SortedList.Enumerator: snapshot out of sync.");
            }
            switch (this.g) {
                case 0: {
                    return this.b;
                }
                case 1: {
                    return this.c;
                }
                case 2: {
                    return this.getEntry();
                }
            }
            throw new NotSupportedException(zax.a(new String[]{Enum.getName(zc.class, this.g), " is not a supported mode."}));
        }

        @Override
        public Object deepClone() {
            za za2 = new za(this.a, this.g);
            za2.d = this.d;
            za2.e = this.e;
            za2.f = this.f;
            za2.b = this.b;
            za2.c = this.c;
            za2.h = this.h;
            return za2;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class zc
    extends Enum {
        private zc() {
        }

        static {
            Enum.register(new com.aspose.email.system.collections.zb(zc.class, Integer.class));
        }
    }

    @zau
    public static class Slot
    extends Struct<Slot> {
        Object a;
        Object b;

        @Override
        public void CloneTo(Slot that) {
            that.a = this.a;
            that.b = this.b;
        }

        @Override
        public Slot Clone() {
            Slot slot = new Slot();
            this.CloneTo(slot);
            return slot;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean a(Slot slot) {
            return zak.a(slot.a, this.a) && zak.a(slot.b, this.b);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (zak.b(null, obj)) {
                return false;
            }
            if (zak.b(this, obj)) {
                return true;
            }
            if (!(obj instanceof Slot)) {
                return false;
            }
            return this.a((Slot)obj);
        }

        public static boolean equals(Slot obj1, Slot obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.a != null ? this.a.hashCode() : 0;
            n = 31 * n + (this.b != null ? this.b.hashCode() : 0);
            return n;
        }
    }
}

