/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.email.system.security.cryptography;

import com.aspose.email.internal.b.zaf;
import com.aspose.email.internal.b.zax;
import com.aspose.email.internal.hv.zb;
import com.aspose.email.internal.hv.zg;
import com.aspose.email.internal.hv.zn;
import com.aspose.email.internal.hv.zo;
import com.aspose.email.internal.ky.ze;
import com.aspose.email.system.EnumExtensions;
import com.aspose.email.system.exceptions.ArgumentException;
import com.aspose.email.system.exceptions.ArgumentNullException;
import com.aspose.email.system.exceptions.CryptographicException;
import com.aspose.email.system.security.cryptography.X509Certificate2;
import com.aspose.email.system.security.cryptography.X509Certificate2Collection;

public final class X509Store {
    private String a;
    private int b;
    private X509Certificate2Collection c;
    private int d;
    private zn e;
    private static final ze f = new ze("Root");

    public X509Store() {
        this("My", 1);
    }

    public X509Store(String storeName) {
        this(storeName, 1);
    }

    public X509Store(short storeName) {
        this(storeName, 1);
    }

    public X509Store(int storeLocation) {
        this("My", storeLocation);
    }

    public X509Store(short storeName, int storeLocation) {
        if (storeName < 1 || storeName > 8) {
            throw new ArgumentException("storeName");
        }
        if (storeLocation < 1 || storeLocation > 2) {
            throw new ArgumentException("storeLocation");
        }
        switch (storeName) {
            case 3: {
                this.a = "CA";
                break;
            }
            default: {
                this.a = EnumExtensions.toString(com.aspose.email.internal.aa.zb.class, storeName);
            }
        }
        this.b = storeLocation;
    }

    public X509Store(String storeName, int storeLocation) {
        if (storeLocation < 1 || storeLocation > 2) {
            throw new ArgumentException("storeLocation");
        }
        this.a = storeName;
        this.b = storeLocation;
    }

    public X509Certificate2Collection getCertificates() {
        if (this.c == null) {
            this.c = new X509Certificate2Collection();
        } else if (this.e == null) {
            this.c.clear();
        }
        return this.c;
    }

    public int getLocation() {
        return this.b;
    }

    public String getName() {
        return this.a;
    }

    private zo a() {
        if (this.b == 1) {
            return zg.c();
        }
        return zg.d();
    }

    private boolean b() {
        return this.e != null;
    }

    private boolean c() {
        return (this.d & 1) == 0;
    }

    public zn getStore() {
        return this.e;
    }

    public zaf getStoreHandle() {
        return zaf.a;
    }

    public void add(X509Certificate2 certificate) {
        if (certificate == null) {
            throw new ArgumentNullException("certificate");
        }
        if (!this.b()) {
            throw new CryptographicException(zax.a("Store isn't opened.", new Object[0]));
        }
        if (this.c()) {
            throw new CryptographicException(zax.a("Store is read-only.", new Object[0]));
        }
        if (!this.b(certificate)) {
            try {
                if (certificate.getInternalCertificate() == null) {
                    throw new CryptographicException("Input data cannot be coded as a valid certificate.");
                }
                this.e.a(certificate.getInternalCertificate());
            }
            finally {
                this.getCertificates().add(certificate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRange(X509Certificate2Collection certificates) {
        if (certificates == null) {
            throw new ArgumentNullException("certificates");
        }
        if (certificates.size() == 0) {
            return;
        }
        if (!this.b()) {
            throw new CryptographicException(zax.a("Store isn't opened.", new Object[0]));
        }
        if (this.c()) {
            throw new CryptographicException(zax.a("Store is read-only.", new Object[0]));
        }
        for (X509Certificate2 x509Certificate2 : certificates) {
            if (this.b(x509Certificate2)) continue;
            try {
                if (x509Certificate2.getInternalCertificate() == null) {
                    throw new CryptographicException("Input data cannot be coded as a valid certificate.");
                }
                this.e.a(x509Certificate2.getInternalCertificate());
            }
            finally {
                this.getCertificates().add(x509Certificate2);
            }
        }
    }

    public void close() {
        this.e = null;
        if (this.c != null) {
            this.c.clear();
        }
    }

    public void open(int flags) {
        String string;
        if (zax.a(this.a)) {
            throw new CryptographicException(zax.a("Invalid store name (null or empty).", new Object[0]));
        }
        switch (f.a(this.a)) {
            case 0: {
                string = "Trust";
                break;
            }
            default: {
                string = this.a;
            }
        }
        boolean bl = (flags & 4) != 4;
        this.e = this.a().a(string, bl);
        if (this.e == null) {
            throw new CryptographicException(zax.a("Store {0} doesn't exists.", new Object[]{this.a}));
        }
        this.d = flags;
        for (zb zb2 : this.e.a()) {
            X509Certificate2 x509Certificate2 = new X509Certificate2(zb2.i());
            x509Certificate2.setPrivateKey(zb2.h());
            this.getCertificates().add(x509Certificate2);
        }
    }

    public void remove(X509Certificate2 certificate) {
        if (certificate == null) {
            throw new ArgumentNullException("certificate");
        }
        if (!this.b()) {
            throw new CryptographicException(zax.a("Store isn't opened.", new Object[0]));
        }
        if (!this.a(certificate)) {
            return;
        }
        if (this.c()) {
            throw new CryptographicException(zax.a("Store is read-only.", new Object[0]));
        }
        try {
            this.e.b(new zb(certificate.getRawData()));
        }
        finally {
            this.getCertificates().remove(certificate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRange(X509Certificate2Collection certificates) {
        if (certificates == null) {
            throw new ArgumentNullException("certificates");
        }
        if (certificates.size() == 0) {
            return;
        }
        if (!this.b()) {
            throw new CryptographicException(zax.a("Store isn't opened.", new Object[0]));
        }
        boolean bl = false;
        for (X509Certificate2 x509Certificate2 : certificates) {
            if (!this.a(x509Certificate2)) continue;
            bl = true;
        }
        if (!bl) {
            return;
        }
        if (this.c()) {
            throw new CryptographicException(zax.a("Store is read-only.", new Object[0]));
        }
        try {
            for (X509Certificate2 x509Certificate2 : certificates) {
                this.e.b(new zb(x509Certificate2.getRawData()));
            }
        }
        finally {
            this.getCertificates().removeRange(certificates);
        }
    }

    private boolean a(X509Certificate2 x509Certificate2) {
        if (this.e == null || this.c == null || x509Certificate2 == null) {
            return false;
        }
        for (X509Certificate2 x509Certificate22 : this.c) {
            if (!x509Certificate2.equals(x509Certificate22)) continue;
            return true;
        }
        return false;
    }

    private boolean b(X509Certificate2 x509Certificate2) {
        if (this.e == null || this.c == null || x509Certificate2 == null) {
            return false;
        }
        X509Certificate2 x509Certificate22 = null;
        for (X509Certificate2 x509Certificate23 : this.c) {
            if (!x509Certificate2.equals(x509Certificate23)) continue;
            if (x509Certificate2.hasPrivateKey() == x509Certificate23.hasPrivateKey()) {
                return true;
            }
            x509Certificate22 = x509Certificate23;
        }
        if (x509Certificate22 != null) {
            this.remove(x509Certificate22);
        }
        return false;
    }
}

