/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.email.system.threading;

import com.aspose.email.internal.b.zaf;
import com.aspose.email.system.IDisposable;
import com.aspose.email.system.TimeSpan;
import com.aspose.email.system.exceptions.ArgumentNullException;
import com.aspose.email.system.exceptions.ArgumentOutOfRangeException;
import com.aspose.email.system.exceptions.InvalidOperationException;
import com.aspose.email.system.exceptions.ThreadInterruptedException;
import com.aspose.email.system.threading.EventWaitHandle;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class WaitHandle
implements IDisposable {
    protected final Object syncObj = new Object();
    protected boolean isReady = false;
    protected int eventResetMode = 0;
    private CountDownLatch a = new CountDownLatch(1);
    protected static final zaf InvalidHandle = new zaf(-1L);
    public static final int WaitTimeout = 258;
    private boolean b = false;

    protected WaitHandle() {
    }

    CountDownLatch b() {
        return this.a;
    }

    void a(CountDownLatch countDownLatch) {
        this.a = countDownLatch;
    }

    public void close() {
        this.dispose();
    }

    @Override
    public void dispose() {
        this.b = true;
    }

    public static boolean signalAndWait(WaitHandle toSignal, WaitHandle toWaitOn) {
        return WaitHandle.signalAndWait(toSignal, toWaitOn, -1, false);
    }

    public static boolean signalAndWait(WaitHandle toSignal, WaitHandle toWaitOn, TimeSpan timeout, boolean exitContext) {
        long l = (long)timeout.getTotalMilliseconds();
        if (-1L > l || Integer.MAX_VALUE < l) {
            throw new ArgumentOutOfRangeException("timeout", "Number must be either non-negative and less than or equal to Int32.MaxValue or -1.");
        }
        return WaitHandle.signalAndWait(toSignal, toWaitOn, (int)l, exitContext);
    }

    public static boolean signalAndWait(WaitHandle toSignal, WaitHandle toWaitOn, int timeout, boolean exitContext) {
        if (toSignal == null) {
            throw new ArgumentNullException("toSignal");
        }
        if (toWaitOn == null) {
            throw new ArgumentNullException("toWaitOn");
        }
        if (-1 > timeout) {
            throw new ArgumentOutOfRangeException("millisecondsTimeout", "Number must be either non-negative and less than or equal to Int32.MaxValue or -1.");
        }
        ((EventWaitHandle)toSignal).set();
        return toWaitOn.waitOne(timeout, exitContext);
    }

    public static boolean waitAll(WaitHandle[] waitHandles) {
        return WaitHandle.waitAll(waitHandles, -1, true);
    }

    public static boolean waitAll(WaitHandle[] waitHandles, int timeout) {
        return WaitHandle.waitAll(waitHandles, timeout, true);
    }

    public static boolean waitAll(WaitHandle[] waitHandles, TimeSpan timeout) {
        return WaitHandle.waitAll(waitHandles, timeout, true);
    }

    public static boolean waitAll(WaitHandle[] waitHandles, TimeSpan timeout, boolean exitContext) {
        long l = (long)timeout.getTotalMilliseconds();
        if (-1L > l || Integer.MAX_VALUE < l) {
            throw new ArgumentOutOfRangeException("timeout", "Number must be either non-negative and less than or equal to Int32.MaxValue or -1.");
        }
        return WaitHandle.waitAll(waitHandles, (int)l, exitContext);
    }

    public static boolean waitAll(WaitHandle[] waitHandles, int timeout, boolean exitContext) {
        boolean bl;
        if (waitHandles == null) {
            throw new ArgumentNullException("waitHandles");
        }
        for (int i = 0; i < waitHandles.length; ++i) {
            if (waitHandles[i] != null) continue;
            throw new ArgumentNullException("waitHandle");
        }
        if (-1L > (long)timeout || Integer.MAX_VALUE < (long)timeout) {
            throw new ArgumentOutOfRangeException("timeout", "Number must be either non-negative and less than or equal to Int32.MaxValue or -1.");
        }
        CountDownLatch countDownLatch = new CountDownLatch(waitHandles.length);
        for (bl = false; bl < waitHandles.length; bl += 1) {
            if (waitHandles[bl].b().getCount() == 1L) {
                waitHandles[bl].a(countDownLatch);
                continue;
            }
            countDownLatch.countDown();
            waitHandles[bl].a(countDownLatch);
        }
        try {
            if (timeout == -1) {
                countDownLatch.await();
            } else if (timeout == 0) {
                countDownLatch.await(1L, TimeUnit.NANOSECONDS);
            } else {
                countDownLatch.await(timeout, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new InvalidOperationException(interruptedException.getMessage());
        }
        boolean bl2 = bl = countDownLatch.getCount() == 0L;
        if (bl) {
            for (int i = 0; i < waitHandles.length; ++i) {
                waitHandles[i].a();
            }
        }
        return bl;
    }

    public static int waitAny(WaitHandle[] waitHandles) {
        return WaitHandle.waitAny(waitHandles, -1, true);
    }

    public static int waitAny(WaitHandle[] waitHandles, int timeout) {
        return WaitHandle.waitAny(waitHandles, timeout, true);
    }

    public static int waitAny(WaitHandle[] waitHandles, TimeSpan timeout) {
        return WaitHandle.waitAny(waitHandles, timeout, true);
    }

    public static int waitAny(WaitHandle[] waitHandles, TimeSpan timeout, boolean exitContext) {
        long l = (long)timeout.getTotalMilliseconds();
        return WaitHandle.waitAny(waitHandles, (int)l, exitContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int waitAny(WaitHandle[] waitHandles, int timeout, boolean exitContext) {
        int n;
        if (waitHandles == null) {
            throw new ArgumentNullException("waitHandles");
        }
        for (int i = 0; i < waitHandles.length; ++i) {
            if (waitHandles[i] != null) continue;
            throw new ArgumentNullException("waitHandle");
        }
        if (-1L > (long)timeout || Integer.MAX_VALUE < (long)timeout) {
            throw new ArgumentOutOfRangeException("timeout", "Number must be either non-negative and less than or equal to Int32.MaxValue or -1.");
        }
        CountDownLatch countDownLatch = new CountDownLatch(1);
        for (n = 0; n < waitHandles.length; ++n) {
            if (waitHandles[n].b().getCount() == 0L) {
                waitHandles[n].a();
                return n;
            }
            waitHandles[n].a(countDownLatch);
        }
        try {
            if (timeout == -1) {
                countDownLatch.await();
            } else if (timeout == 0) {
                countDownLatch.await(1L, TimeUnit.NANOSECONDS);
            } else {
                countDownLatch.await(timeout, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new InvalidOperationException(interruptedException.getMessage());
        }
        for (n = 0; n < waitHandles.length; ++n) {
            Object object = waitHandles[n].syncObj;
            synchronized (object) {
                if (waitHandles[n].isReady) {
                    waitHandles[n].a();
                    return n;
                }
                continue;
            }
        }
        return 258;
    }

    public boolean waitOne() {
        return this.waitOne(-1, false);
    }

    public boolean waitOne(int timeout) {
        return this.waitOne(timeout, false);
    }

    public boolean waitOne(TimeSpan timeout) {
        return this.waitOne(timeout, false);
    }

    public boolean waitOne(TimeSpan timeout, boolean exitContext) {
        long l = (long)timeout.getTotalMilliseconds();
        if (-1L > l || Integer.MAX_VALUE < l) {
            throw new ArgumentOutOfRangeException("timeout", "Number must be either non-negative and less than or equal to Int32.MaxValue or -1.");
        }
        return this.waitOne((int)l, exitContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitOne(int timeout, boolean exitContext) {
        if (timeout < -1) {
            throw new ArgumentOutOfRangeException("timeout");
        }
        Object object = this.syncObj;
        synchronized (object) {
            boolean bl = false;
            if (!this.isReady) {
                try {
                    if (timeout == -1) {
                        this.syncObj.wait();
                        this.a();
                        return true;
                    }
                    this.syncObj.wait(timeout == 0 ? 1L : (long)timeout);
                    bl = this.isReady;
                    this.a();
                    return bl;
                }
                catch (InterruptedException interruptedException) {
                    throw new ThreadInterruptedException(interruptedException.getMessage());
                }
            }
            this.a();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a() {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.eventResetMode == 0 && this.isReady) {
                this.isReady = false;
                this.a(new CountDownLatch(1));
            }
        }
    }
}

